Ext.ux.suncode.GlobalGridDefWindow = function( config ) {
  var viewSize = Ext.getBody().getViewSize();
  var viewWidth = viewSize.width;
  var mainPanel = Ext.getCmp( 'main_panel' );
  var winTitle = getTranslation( 'Tabela dynamiczna' );

  config = Ext.apply( {
    AV: mainPanel.getAdvancedView()
  }, config );

  config = Ext.apply( {
    modal: true,
    shadow: false,
    hideBorders: true,
    closable: true,
    width: viewWidth * 0.95,
    autoHeight: true,
    title: winTitle,
    tbar: new Ext.Toolbar( {
      buttons: [ {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        cancel: false,
        handler: this.closeWindow,
        scope: this
      } ]
    } ),
    items: [ new Ext.ux.suncode.GridDefPanel( config ) ]
  }, config );

  Ext.ux.suncode.GlobalGridDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GlobalGridDefWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.GlobalGridDefWindow.superclass.initComponent.call( this );
  },
  saveForm: function() {
    this.gridDefPanel.saveGlobalTable();
  },
  closeWindow: function() {
    this.close();
  }
} );

Ext.ux.suncode.GridDefPanel = function( config ) {
    var viewSize = Ext.getBody().getViewSize();
    var height = viewSize.height * 0.9 - 2 * calculateVersionBarHeight();
    var globalDefinition = config.globalDefinition;
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var processNode = null;
    var titleTranslation = '';
    var titleItemValue = '';
    var editableItemValue = true;
    var collapsibleItemValue = true;
    var columns = new Array();
    var actions = new Array();
    var groupers = new Array();
    var DTButtons = new Array();
    var dtButtonsFillPosition = -1;
    var formActions = new Array();
    var eventActions = new Array();
    var localLabel = addTooltipToField( getTranslation( 'Lokalna' ), getTranslation( 'Jeżeli opcja jest nieaktywna' ) + ',<br>'
        + getTranslation( 'to dane z tabeli są przechowywane na serwerze' ) + '<br>'
        + getTranslation( 'Możliwość użycia domyślnego ustawienia systemu' ), null, true );
    var statefulLabel = addTooltipToField( getTranslation( 'Zapamiętuj stan' ), getTranslation( 'Zapamiętywanie szerokości kolumn' ) );
    var autoHeightLabel = addTooltipToField( getTranslation( 'Dopasuj do zawartości' ), getTranslation( 'Dopasowuje wysokość tabeli do zawartości' ) );
    var autoHeightMinLabel = addTooltipToField( getTranslation( 'Minimalna wysokość' ), getTranslation( 'Wartość w pikselach' ) );
    var autoHeightMaxLabel = addTooltipToField( getTranslation( 'Maksymalna wysokość' ), getTranslation( 'Wartość w pikselach' ) );
    var hideRowNumber = false;
    var readonlyColumnHeader = '';
    var hiddenColumnHeader = '';
    var mainPanel = Ext.getCmp( 'main_panel' );
    var compatibilityMode = mainPanel.getCompatibilityMode();
    var defItems = new Array();
    var columnsPanelToolbarItems = new Array();
    columnsPanelToolbarItems.push( {
      xtype: 'panel',
      layout: 'form',
      border: false,
      width: 300,
      labelWidth: 100,
      style: {
        marginTop: '5px'
      },
      items: [ {
        xtype: 'compositefield',
        fieldLabel: getTranslation( 'Nazwa' ),
        ref: 'nameFilter',
        getFilterValue: function() {
          return this.items.first().getValue();
        },
        setFilterValue: function( value ) {
          var filter = this.items.first();
          filter.setValue( value );
        },
        items: [ {
          xtype: 'textfield',
          emptyText: getTranslation( 'Szukaj' ) + '...',
          flex: 1,
          cls: 'x-Module-field-leftAlign',
          listeners: {
            scope: this,
            afterrender: this.onColumnNameFilterAfterRender
          }
        }, {
          xtype: 'button',
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'clear' ),
          tooltip: getTranslation( 'Wyczyść filtr' ),
          flex: 0,
          handler: this.clearColumnNameFilter,
          scope: this
        } ]
      } ]
    } );
    columnsPanelToolbarItems.push( '->' );

    if ( globalDefinition ) {
      var table = config.table;
      processNode = config.processNode;
      var processDefId = processNode.attributes.processDefId;
      var idItemValue = table ? table.id : '';
      var idChanged = !Ext.isEmpty( table );
      titleItemValue = table ? table.name : '';
      columns = table ? table.columns : new Array();
      actions = table ? table.actions : new Array();
      groupers = table ? table.groupers : new Array();
      DTButtons = table ? deepObjectCopy( table.DTButtons ) : new Array();
      dtButtonsFillPosition = ( table && !Ext.isEmpty( table.dtButtonsFillPosition ) ) ? table.dtButtonsFillPosition : -1;
      formActions = table ? table.formActions : new Array();
      eventActions = table ? table.eventActions : new Array();
      var titleTranslationCache = new Object();
      var titleKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(';
      var titleInitialId = null;
      var clicksToEdit = 2;
      var showDeleteConfirmation = false;
      if ( table ) {
        var translations = table.translations;
        var titleTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + table.id +')';
        titleInitialId = table.id;
        if ( !Ext.isEmpty( translations[titleTranslationKey] ) ) {
          var tableTranslations = translations[titleTranslationKey];
          titleTranslationCache = {
            key: titleTranslationKey,
            translations: tableTranslations
          };
          var xpdlTranslationLanguage = Ext.ux.suncode.I18NService.getXpdlTranslationLanguage();
          var translationForXpdlLanguage = tableTranslations[xpdlTranslationLanguage];
          titleTranslation = evaluateXpdlTranslation( translationForXpdlLanguage, titleItemValue );
        } else {
          titleTranslationCache = new Object();
          titleTranslation = titleItemValue;
        }
        clicksToEdit = table.clicksToEdit;
        showDeleteConfirmation = table.showDeleteConfirmation;
        hideRowNumber = table.hideRowNumber;
      }
      var specification = table ? Ext.ux.suncode.DocumentationService.getTableSpecification( processNode, table.id ) : new Object();

      defItems.push( this.buildIdItem( config.AV, idItemValue, idChanged ) );
      defItems.push( this.buildTitleItem( titleItemValue, titleKeyPrefix, titleTranslationCache, titleInitialId ) );
      defItems.push( this.buildClicksToEditItem( clicksToEdit ) );
      defItems.push( this.buildShowDeleteConfirmationItem( showDeleteConfirmation ) );
      defItems.push( this.buildHideRowNumberItem( hideRowNumber ) );
      defItems.push( this.buildActionsItem( config.AV, compatibilityMode, actions ) );
      defItems.push( this.buildFormActionsItem() );
      defItems.push( this.buildEventActionsItem() );
      defItems.push( this.buildGroupersItem( config.AV ) );
      defItems.push( this.buildColumnChooserItem( processNode, true ) );
      defItems.push( this.buildSpecificationItem( processNode, specification ) );

      readonlyColumnHeader = getTranslation( 'Ustawienie domyślnie' )
          + '<br>' + getTranslation( 'Tylko do odczytu' );
      hiddenColumnHeader = getTranslation( 'Ustawienie domyślnie' )
          + '<br>' + getTranslation( 'Ukryta' );

      columnsPanelToolbarItems.push( {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń kolumny' ),
        handler: this.removeColumns,
        scope: this
      } );
    } else {
      var activityNode = config.activityNode;
      processNode = activityNode.parentNode;
      var processDefId = processNode.attributes.processDefId;
      var activityDefId = activityNode.attributes.activityDefId;
      var component = config.component;
      var objectDef = component.definition.objectDef;
      var idItemValue = objectDef.varId;
      var idChanged = component.idAssigned;
      titleItemValue = objectDef.name;
      titleTranslation = getXpdlVariableSetTitleTranslation( packageId, processDefId, activityDefId, idItemValue, titleItemValue );
      var localItemValue = objectDef.local;
      editableItemValue = objectDef.editable;
      collapsibleItemValue = objectDef.collapsible;
      var autoHeightItemValue = objectDef.autoHeight;
      hideRowNumber = objectDef.hideRowNumber;
      columns = objectDef.columns;
      actions = objectDef.actions;
      groupers = objectDef.groupers;
      DTButtons = deepObjectCopy( objectDef.DTButtons );
      dtButtonsFillPosition = !Ext.isEmpty( objectDef.dtButtonsFillPosition ) ? objectDef.dtButtonsFillPosition : -1;
      formActions = objectDef.formActions;
      eventActions = objectDef.eventActions;
      var table = processNode.findTable( idItemValue );

      if ( Ext.isEmpty( table ) ) {
        var titleKeyPrefix = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET(';
        var titleTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId +
            ')_VARIABLESET(' + idItemValue +')';
        var titleTranslationCache = !Ext.isEmpty( objectDef.translations[titleTranslationKey] ) ? {
          key: titleTranslationKey,
          translations: objectDef.translations[titleTranslationKey]
        } : new Object();
        var clicksToEdit = objectDef.clicksToEdit;
        var showDeleteConfirmation = objectDef.showDeleteConfirmation;
        hideRowNumber = objectDef.hideRowNumber;

        defItems.push( this.buildIdItem( config.AV, idItemValue, idChanged ) );
        defItems.push( this.buildTitleItem( titleItemValue, titleKeyPrefix, titleTranslationCache, idItemValue ) );
        defItems.push( this.buildClicksToEditItem( clicksToEdit ) );
        defItems.push( this.buildShowDeleteConfirmationItem( showDeleteConfirmation ) );
        defItems.push( this.buildHideRowNumberItem( hideRowNumber ) );
      } else {
        defItems.push( new Ext.form.DisplayField( {
          fieldLabel: getTranslation( 'Identyfikator' ),
          anchor: '100%',
          value: idItemValue
        } ) );
        defItems.push( new Ext.form.DisplayField( {
          fieldLabel: getTranslation( 'Tytuł' ),
          anchor: '100%',
          value: titleItemValue
        } ) );
      }

      defItems.push( new Ext.ux.suncode.DTLocalChooser( {
        fieldLabel: localLabel,
        anchor: '100%',
        hidden: !compatibilityMode.showVariableSetLocal( localItemValue ),
        value: localItemValue
      } ) );
      defItems.push( {
        xtype: 'checkbox',
        fieldLabel: getTranslation( 'Edytowalna' ),
        anchor: '100%',
        ref: 'editableItem',
        checked: editableItemValue,
        inputValue: 'true',
        listeners: {
          scope: this,
          check: this.changeEditability
        }
      } );
      defItems.push( {
        xtype: 'checkbox',
        fieldLabel: getTranslation( 'Zwijalna' ),
        anchor: '100%',
        ref: 'collapsibleItem',
        checked: collapsibleItemValue,
        inputValue: 'true',
        listeners: {
          scope: this,
          check: this.changeCollapsible
        }
      } );
      defItems.push( {
        xtype: 'checkbox',
        fieldLabel: statefulLabel,
        ref: 'statefulItem',
        checked: objectDef.stateful,
        inputValue: 'true'
      } );
      defItems.push( {
        xtype: 'checkbox',
        fieldLabel: autoHeightLabel,
        ref: 'autoHeightItem',
        checked: autoHeightItemValue,
        inputValue: 'true',
        listeners: {
          scope: this,
          check: this.changeAutoHeight
        }
      } );
      defItems.push( {
        xtype: 'numberfield',
        fieldLabel: autoHeightMinLabel,
        anchor: '96%',
        hidden: !autoHeightItemValue,
        allowDecimals: false,
        allowNegative: false,
        minValue: Ext.ux.suncode.Constants.DT_MAX_HEIGHT,
        minText: getTranslation( 'Minimalna wartość dla tego pola to' ) + ' {0}',
        ref: 'autoHeightMinItem',
        value: objectDef.autoHeightMin
      } );
      defItems.push( {
        xtype: 'numberfield',
        fieldLabel: autoHeightMaxLabel,
        anchor: '96%',
        hidden: !autoHeightItemValue,
        allowDecimals: false,
        allowNegative: false,
        ref: 'autoHeightMaxItem',
        value: objectDef.autoHeightMax
      } );

      if ( Ext.isEmpty( table ) ) {
        defItems.push( this.buildActionsItem( config.AV, compatibilityMode, actions ) );
      }

      defItems.push( this.buildFormActionsItem() );
      defItems.push( this.buildEventActionsItem() );

      if ( Ext.isEmpty( table ) ) {
        defItems.push( this.buildGroupersItem( config.AV ) );
        defItems.push( this.buildColumnChooserItem( processNode, false ) );
      }

      defItems.push( {
        xtype: 'fieldset',
        title: getTranslation( 'Czcionka' ),
        layout: 'form',
        ref: 'fontDef',
        anchor: '98%',
        labelWidth: 200,
        items: [ {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Rozmiar czcionki nagłówka' ),
          ref: 'headerFontSizeItem',
          anchor: '100%',
          emptyText: getTranslation( 'Domyślny' ),
          allowDecimals: false,
          allowNegative: false,
          value: objectDef.headerFontSize
        }, {
          xtype: 'numberfield',
          fieldLabel: getTranslation( 'Rozmiar czcionki komórki' ),
          ref: 'cellFontSizeItem',
          anchor: '100%',
          emptyText: getTranslation( 'Domyślny' ),
          allowDecimals: false,
          allowNegative: false,
          value: objectDef.cellFontSize
        } ],
        listeners: {
          afterrender: function( c ) {
            c.removeClass( 'x-fieldset-noborder' );
          }
        }
      } );

      if ( Ext.isEmpty( table ) ) {
        var specification = Ext.ux.suncode.DocumentationService.getFormVariableSpecification( activityNode, idItemValue );
        defItems.push( this.buildSpecificationItem( processNode, specification ) );
      }

      readonlyColumnHeader = getTranslation( 'Tylko do odczytu' );
      hiddenColumnHeader = getTranslation( 'Ukryta' );

      if ( !Ext.isEmpty( table ) ) {
        columnsPanelToolbarItems.push( {
          xtype: 'button',
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'change' ),
          tooltip: getTranslation( 'Przywróć ustawienia domyślne' ),
          handler: this.restoreColumnsDefaultSettings,
          scope: this
        } );
      } else {
        columnsPanelToolbarItems.push( {
          xtype: 'button',
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'change' ),
          tooltip: getTranslation( 'Zmień widoczność kolumn' ),
          handler: this.changeColumnsVisibility,
          scope: this
        } );
        columnsPanelToolbarItems.push( {
          xtype: 'button',
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'delete' ),
          tooltip: getTranslation( 'Usuń kolumny' ),
          handler: this.removeColumns,
          scope: this
        } );
      }
    }

    var previewColumns = new Array();
    previewColumns.push( new Ext.grid.RowNumberer( {
      hidden: hideRowNumber
    } ) );
    var previewButtons = new Array();
    previewButtons.push( {
        xtype: 'button',
        cls: 'x-btn-text-icon',
        iconCls: 'dvnt-icon-plus-circle',
        icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/add.png',
        text: getTranslation( 'Dodaj wiersz' ),
        tooltip: getTranslation( 'Dodaje jeden pusty wiersz' )
    } );
    previewButtons.push( {
        xtype: 'button',
        cls: 'x-btn-text-icon',
        iconCls: 'dvnt-icon-minus-circle',
        icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/delete.png',
        text: getTranslation( 'Usuń wiersz' ),
        tooltip: getTranslation( 'Usuwa aktualnie wybrany wiersz' ),
        disabled: true
    } );
    previewButtons.push( {
        xtype: 'button',
        cls: 'x-btn-text-icon',
        iconCls: 'dvnt-icon-copy',
        icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/page_copy.png',
        text: getTranslation( 'Kopiuj wiersz' ),
        tooltip: getTranslation( 'Kopiuje aktualnie wybrany wiersz i dodaje go' ),
        disabled: true
    } );

    var columnsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'varId',
                type: 'string'
            }, {
                name: 'varName',
                type: 'string'
            }, {
                name: 'readonly',
                type: 'string'
            }, {
                name: 'hidden',
                type: 'string'
            }, {
                name: 'differentReadonly',
                type: 'boolean'
            }, {
                name: 'differentHidden',
                type: 'boolean'
            } ] )
        } )
    } );

    var buttonsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'buttonId',
                type: 'string'
            }, {
                name: 'name',
                type: 'string'
            }, {
                name: 'icon',
                type: 'string'
            }, {
                name: 'globalId',
                type: 'string'
            }, {
                name: 'isFill',
                type: 'boolean'
            } ] )
        } )
    } );

    var c = columnsStore.recordType;
    Ext.each( columns, function( col, index, cols ) {
      var variable = processNode.findVariable( col.varId );
      var header = '';

      if ( !Ext.isEmpty( variable ) ) {
        header = '<center>' + this.getHeader( variable ) + '</center>';
      } else {
        header = '<center>' + col.varId + '</center>';
      }

      previewColumns.push( {
        id: variable.id,
        header: header,
        dataIndex: variable.id,
        hidden: col.hidden,
        customWidth: variable.dtSize ? variable.dtSize : undefined
      } );

      columnsStore.add( new c( {
        varId: col.varId,
        varName: col.varId,
        readonly: col.readonly,
        hidden: col.hidden,
        differentReadonly: col.differentReadonly,
        differentHidden: col.differentHidden
      } ) );
    }, this );
    columnsStore.commitChanges();

    var b = buttonsStore.recordType;
    Ext.each( DTButtons, function( btn, index, btns ) {
        var btnCls = this.getDTButtonCls( btn ) + ' dvnt-pwe-dt-button '
            + Ext.ux.suncode.UtilService.resolveDtButtonColorCls( btn.color );
        var btnNameTranslation = '';
        var btnTranslations = btn.translations;

        if ( globalDefinition ) {
          var table = config.table;
          var btnNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + table.id
              + ')_DTBUTTON(' + btn.buttonId + ')';

          if ( !Ext.isEmpty( table ) && !Ext.isEmpty( btnTranslations[btnNameTranslationKey] ) ) {
            var btnNameTranslations = btnTranslations[btnNameTranslationKey];
            var xpdlTranslationLanguage = Ext.ux.suncode.I18NService.getXpdlTranslationLanguage();
            var translationForXpdlLanguage = btnNameTranslations[xpdlTranslationLanguage];
            btnNameTranslation = evaluateXpdlTranslation( translationForXpdlLanguage, btn.name );
          } else {
            btnNameTranslation = btn.name;
          }
        } else {
          btnNameTranslation = btn.name;
        }

        previewButtons.push( {
            xtype: 'button',
            id: btn.buttonId,
            cls: btnCls,
            iconCls: Ext.ux.suncode.UtilService.resolveIconCls( btn.icon ),
            text: btnNameTranslation,
            tooltip: btn.tooltip,
            disabled: btn.disabled,
            buttonId: btn.buttonId
        } );

        buttonsStore.add( new b( {
            buttonId: btn.buttonId,
            name: btnNameTranslation,
            icon: btn.icon,
            globalId: btn.globalId
        } ) );
    }, this );
    if ( dtButtonsFillPosition != -1 ) {
      previewButtons.splice( dtButtonsFillPosition + 3, 0, {
        xtype: 'tbfill',
        isFill: true
      } );
      buttonsStore.insert( dtButtonsFillPosition, new b( {
        isFill: true,
        name: '->'
      } ) );
    }
    buttonsStore.commitChanges();

    var tools = new Array();
    tools.push( {
      id: 'refresh',
      qtip: getTranslation( 'Przywróć domyślne ustawienia tabeli' )
    } );
    tools.push( {
      id: 'maximize',
      qtip: getTranslation( 'Maksymalizuj tabelę' )
    } );
    if ( collapsibleItemValue ) {
      tools.push( {
        id: 'toggle',
        qtip: getTranslation( 'Zwiń/Rozwiń tabelę' )
      } );
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
      variables: processNode.attributes.variables
    } );

    config = Ext.apply( {
        id: 'form_grid_definition_panel',
        border: false,
        height: height,
        layout: 'border',
        ref: 'gridDefPanel',
        actions: actions,
        groupers: groupers,
        DTButtons: DTButtons,
        formActions: formActions,
        eventActions: eventActions,
        items: [ {
            xtype: 'panel',
            labelWidth: 200,
            frame: false,
            bodyCssClass: 'x-Module-container-padding',
            margins: '5 0 0 5',
            autoScroll: true,
            width: 550,
            region: 'west',
            ref: 'defPanel',
            layout: 'form',
            layoutConfig: {
                trackLabels: true
            },
            items: defItems
        }, {
            xtype: 'grid',
            hideBorders: true,
            frame: false,
            region: 'center',
            margins: '5 0 0 5',
            bodyStyle: 'border-radius: 0 0 8px 8px;',
            ref: 'columnsPanel',
            columnLines: true,
            enableDragDrop: true,
            ddGroup: 'dd_columns',
            ddScope: this,
            enableColumnResize: false,
            store: columnsStore,
            autoScroll: true,
            colModel: new Ext.grid.ColumnModel( {
                stopChangeColumnsOrder: false,
                defaults: {
                    sortable: false,
                    menuDisabled: true,
                    css: 'vertical-align:middle;'
                },
                columns: [ {
                  id: 'varId',
                  header: getTranslation( 'Identyfikator kolumny' ),
                  dataIndex: 'varId',
                  align: 'left',
                  hidden: !config.AV,
                  hideable: config.AV
                }, {
                  id: 'varName',
                  header: getTranslation( 'Nazwa kolumny' ),
                  dataIndex: 'varName',
                  align: 'left',
                  editor: allVariablesChooser,
                  renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
                }, {
                  id: 'readonly',
                  header: readonlyColumnHeader,
                  dataIndex: 'readonly',
                  align: 'center',
                  width: 60,
                  renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    var renderedValue = tickCrossValue( value, metaData, record, rowIndex, colIndex, store );

                    if ( !globalDefinition && !record.get( 'differentReadonly' ) ) {
                      renderedValue += '<img src=\"' + getPluginImgPath( 'global' ) + '\" width="6" height="6">';
                    }

                    return renderedValue;
                  }
                }, {
                  id: 'hidden',
                  header: hiddenColumnHeader,
                  dataIndex: 'hidden',
                  align: 'center',
                  width: 60,
                  renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    var renderedValue = tickCrossValue( value, metaData, record, rowIndex, colIndex, store );

                    if ( !globalDefinition && !record.get( 'differentHidden' ) ) {
                      renderedValue += '<img src=\"' + getPluginImgPath( 'global' ) + '\" width="6" height="6">';
                    }

                    return renderedValue;
                  }
                } ]
            } ),
            sm: new Ext.grid.RowSelectionModel( {
              singleSelect: true,
              listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                  sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'varName' ) + '</b>';
                }
              }
            } ),
            view: new Ext.grid.GridView( {
                forceFit: true
            } ),
            tbar: new Ext.Toolbar( {
                cls: 'x-Module-toolbarVerticalAlignTop',
                items: columnsPanelToolbarItems
            } ),
            listeners: {
                scope: this,
                render: function( grid ) {
                    new Ext.dd.DropTarget( grid.getEl(), {
                        ddGroup: 'dd_columns',
                        copy: false,
                        grid: grid,
                        notifyOver: notifyOverGrid,
                        notifyDrop: function( dd, e, data ) {
                            notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                              dd.grid.ddScope.onMoveColumn( sindex, dindex );
                            } );
                        }
                    } );
                },
                cellclick: function( grid, rowIndex, columnIndex, e ) {
                    var store = grid.getStore();
                    var colId = grid.getColumnModel().getColumnId( columnIndex );

                    if ( colId == 'hidden' ) {
                        var rec = store.getAt( rowIndex );
                        //if ( !this.isGlobalDefinition() ) {
                          rec.set( 'differentHidden', true );
                        //}
                        this.changeColumnVisibility( rec );
                        store.commitChanges();
                        this.refreshChanges( this.gridPanel );
                    } else if ( colId == 'readonly' ) {
                        var rec = store.getAt( rowIndex );
                        var currentValue = rec.get( 'readonly' );
                        rec.set( 'readonly', !currentValue );
                        if ( !this.isGlobalDefinition() ) {
                          rec.set( 'differentReadonly', true );
                        }
                        rec.commit();
                    }
                }
            }
        }, {
            xtype: 'grid',
            hideBorders: true,
            frame: false,
            width: 250,
            region: 'east',
            margins: '5 5 0 5',
            bodyStyle: 'border-radius: 0 0 8px 8px;',
            ref: 'buttonsPanel',
            columnLines: true,
            enableDragDrop: true,
            ddGroup: 'dd_dtbuttons',
            ddScope: this,
            enableColumnResize: false,
            store: buttonsStore,
            autoScroll: true,
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: [ {
                    id: 'name',
                    header: getTranslation( 'Nazwa przycisku' ),
                    dataIndex: 'name',
                    align: 'left'
                }, {
                    id: 'icon',
                    header: getTranslation( 'Ikona' ),
                    dataIndex: 'icon',
                    align: 'center',
                    width: 40,
                    renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                        if ( !Ext.isEmpty( value ) ) {
                            return '<span class="' + Ext.ux.suncode.UtilService.resolveIconCls( value )
                                + '">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
                        } else {
                            return '';
                        }
                    }
                }, {
                    id: 'buttonId',
                    dataIndex: 'buttonId',
                    hidden: true
                }, {
                    id: 'isFill',
                    dataIndex: 'isFill',
                    hidden: true
                } ]
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true,
                listeners: {
                    beforerowselect: function( sm, i, ke, row ) {
                        sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
                    }
                }
            } ),
            view: new Ext.grid.GridView( {
                forceFit: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj przycisk' ),
                    handler: this.addDTButton,
                    scope: this
                }, {
                  xtype: 'button',
                  cls: 'x-btn-icon',
                  icon: getPluginImgPath( 'tbfill' ),
                  tooltip: getTranslation( 'Dodaj wypełnienie' ),
                  handler: this.addFill,
                  scope: this
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'edit' ),
                    tooltip: getTranslation( 'Edytuj przycisk' ),
                    handler: this.editDTButton,
                    scope: this
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: this.removeFromBottomToolbar,
                    scope: this
                } ]
            } ),
            listeners: {
                scope: this,
                render: function( grid ) {
                    new Ext.dd.DropTarget( grid.getEl(), {
                        ddGroup: 'dd_dtbuttons',
                        copy: false,
                        grid: grid,
                        notifyOver: notifyOverGrid,
                        notifyDrop: function( dd, e, data ) {
                            notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                              dd.grid.ddScope.onMoveDTButton( sindex, dindex );
                            } );
                        }
                    } );
                },
                afterlayout: {
                    fn: function( p ) {
                        if ( !editableItemValue ) {
                            p.disable();
                        }
                    },
                    single: true
                },
                rowdblclick: function( grid, rowIndex, e ) {
                    this.editDTButton();
                }
            }
        }, {
            xtype: 'grid',
            cls: 'variable-set-grid',
            title: titleTranslation,
            region: 'south',
            margins: '5 5 5 5',
            height: 335,
            frame: false,
            ref: 'gridPanel',
            header: true,
            store: new Ext.data.Store( {} ),
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: previewColumns,
                listeners: {
                    scope: this,
                    columnmoved: this.changeColumnsOrder
                }
            } ),
            view: new Ext.grid.GridView( {
                autoFill: true
            } ),
            columnLines: true,
            enableColumnResize: false,
            tools: tools,
            bbar: new Ext.Toolbar( {
                hidden: !editableItemValue,
                items: previewButtons
            } ),
            listeners: {
                scope: this,
                afterrender: function( g ) {
                    if ( columns.length > 0 ) {
                        this.refreshChanges( this.gridPanel );
                    }
                }
            }
        } ]
    }, config );

    Ext.ux.suncode.GridDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GridDefPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.GridDefPanel.superclass.initComponent.call( this );
    },
    buildIdItem: function( advancedView, value, idChanged ) {
      return new Ext.ux.suncode.IdField( {
        anchor: '96%',
        fieldLabel: getTranslation( 'Identyfikator' ),
        value: value,
        ref: 'idItem',
        allowBlank: true,
        hidden: !advancedView,
        idChanged: idChanged,
        afterSetIdFunction: function( oldId, newId ) {
          this.editFormActionsBindTo();
          this.updateDtButtonsTranslationsKeys( oldId, newId );
        },
        afterSetIdScope: this
      } );
    },
    buildTitleItem: function( value, keyPrefix, cache, initialId ) {
      return new Ext.ux.suncode.I18NTranslatedField( {
        fieldLabel: getTranslation( 'Tytuł' ),
        anchor: '97%',
        ref: 'titleItem',
        field: {
          xtype: 'textfield',
          value: value,
          listeners: {
            scope: this,
            blur: this.onSetTitle,
            specialkey: this.onSetTitle
          }
        },
        getIdFieldFunction: function() {
          return this.defPanel.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ),
        windowTitle: getTranslation( 'Tłumaczenia tytułu tabeli dynamicznej' ),
        keyPrefix: keyPrefix,
        keyPostfix: ')',
        saveToCache: true,
        cache: cache,
        initialId: initialId
      } );
    },
    buildClicksToEditItem: function( value ) {
      return new Ext.ux.suncode.ClicksToEditChooser( {
        anchor: '97%',
        ref: 'clicksToEditItem',
        value: value
      } );
    },
    buildShowDeleteConfirmationItem: function( value ) {
      return new Ext.form.Checkbox( {
        fieldLabel: getTranslation( 'Potwierdzaj usunięcie wierszy' ),
        ref: 'showDeleteConfirmationItem',
        checked: value,
        inputValue: 'true'
      } );
    },
    buildHideRowNumberItem: function( value ) {
      return new Ext.form.Checkbox( {
        fieldLabel: getTranslation( 'Ukryj numer wiersza' ),
        ref: 'hideRowNumberItem',
        checked: value,
        inputValue: 'true',
        listeners: {
          scope: this,
          check: this.changeHideRowNumber
        }
      } );
    },
    buildGroupersItem: function( advancedView ) {
      return {
        xtype: 'compositefield',
        ref: 'groupersContainer',
        fieldLabel: getTranslation( 'Grupowanie' ),
        anchor: '100%',
        hidden: !advancedView,
        items: [ {
          xtype: 'button',
          isFormField: true,
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'dt_grouping' ),
          tooltip: getTranslation( 'Zarządzaj grupowaniem tabeli dynamicznej' ),
          handler: this.manageGrouping,
          scope: this
        } ]
      };
    },
    buildActionsItem: function( advancedView, compatibilityMode, actions ) {
      var actionsLabel = addTooltipToField( getTranslation( 'Akcje' ), getTranslation( 'Akcje na zdarzeniach (np. zapis, edycja)' ), null, true );

      return {
        xtype: 'compositefield',
        ref: 'actionsContainer',
        fieldLabel: actionsLabel,
        anchor: '100%',
        hidden: ( !advancedView || !compatibilityMode.showVariableSetActions( actions ) ),
        items: [ {
          xtype: 'button',
          isFormField: true,
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'table_action' ),
          tooltip: getTranslation( 'Zarządzaj akcjami tabeli dynamicznej' ),
          handler: this.manageActions,
          scope: this
        } ]
      };
    },
    buildFormActionsItem: function() {
      return {
        xtype: 'compositefield',
        ref: 'formActionsContainer',
        fieldLabel: getTranslation( 'Akcje formularza' ),
        anchor: '100%',
        items: [ {
          xtype: 'button',
          isFormField: true,
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'action' ),
          tooltip: getTranslation( 'Zarządzaj akcjami formularza tabeli dynamicznej' ),
          handler: this.manageFormActions,
          scope: this
        } ]
      };
    },
    buildEventActionsItem: function() {
      return {
        xtype: 'compositefield',
        ref: 'formActionsContainer',
        fieldLabel: getTranslation( 'Zdarzenia' ),
        anchor: '100%',
        items: [ {
          xtype: 'button',
          isFormField: true,
          cls: 'x-btn-icon',
          icon: getPluginImgPath( 'event' ),
          tooltip: getTranslation( 'Zarządzaj zdarzeniami tabeli dynamicznej' ),
          handler: this.manageEventActions,
          scope: this
        } ]
      };
    },
    buildColumnChooserItem: function( processNode, globalDefinition ) {
        return {
          xtype: 'fieldset',
          title: getTranslation( 'Definicja kolumny' ),
          layout: 'form',
          ref: 'colDef',
          anchor: '98%',
          labelWidth: 200,
          items: [ {
            xtype: 'compositefield',
            ref: 'vChooserContainer',
            fieldLabel: getTranslation( 'Kolumna' ),
            items: [ new Ext.ux.suncode.VariableSetAvailableColumnChooser( {
              globalDefinition: globalDefinition,
              processNode: processNode
            } ), {
              xtype: 'button',
              cls: 'x-btn-icon',
              icon: getPluginImgPath( 'variable_add' ),
              tooltip: getTranslation( 'Dodaj zmienną procesu' ),
              flex: 0,
              handler: this.addProcessVariable,
              scope: this
            }, {
              xtype: 'button',
              cls: 'x-btn-icon',
              icon: getPluginImgPath( 'edit' ),
              tooltip: getTranslation( 'Edytuj zmienną procesu' ),
              flex: 0,
              handler: this.editProcessVariable,
              scope: this
            }, {
              xtype: 'button',
              cls: 'x-btn-icon',
              icon: getPluginImgPath( 'table_add' ),
              tooltip: getTranslation( 'Dodaj kolumnę' ),
              flex: 0,
              handler: this.addColumn,
              scope: this
            } ]
          } ],
          listeners: {
            afterrender: function( c ) {
              c.removeClass( 'x-fieldset-noborder' );
            }
          }
        };
    },
    buildSpecificationItem: function( processNode, specification ) {
      return new Ext.ux.suncode.SpecificationDescriptionArea( {
        anchor: '98%',
        processNode: processNode,
        description: specification.description
      } );
    },
    onColumnNameFilterAfterRender: function( filter ) {
      filter.getEl().on( 'keyup', function() {
        this.applyColumnNameFilter( filter.getValue() );
      }, this, {
        buffer: 500
      } );
    },
    applyColumnNameFilter: function( value ) {
      this.doFilterColumns( value );
    },
    clearColumnNameFilter: function() {
      var filtersPanel = this.getColumnFiltersPanel();
      var nameFilter = filtersPanel.nameFilter;
      nameFilter.setFilterValue( '' );
      this.doFilterColumns( '' );
    },
    getColumnFiltersPanel: function() {
      var tbar = this.columnsPanel.getTopToolbar();

      return tbar.items.first();
    },
    doFilterColumns: function( name ) {
      var colModel = this.columnsPanel.getColumnModel();
      var varNameColumnIndex = colModel.getIndexById( 'varName' );
      var varNameRenderer = colModel.getRenderer( varNameColumnIndex );
      var nameRegex = new RegExp( Ext.escapeRe( name ), 'i' );
      var store = this.columnsPanel.getStore();

      store.filterBy( function( record, id ) {
        var columnId = record.get( 'varId' );
        var columnName = varNameRenderer.apply( this, [ columnId ]);

        return ( nameRegex.test( columnId ) || nameRegex.test( columnName ) );
      } );
    },
    addProcessVariable: function() {
        var processNode = this.getProcessNode();
        var vChooser = this.defPanel.colDef.vChooserContainer.items.first();
        var record = vChooser.getStore().recordType;

        var win = new Ext.ux.suncode.VariableDefWindow( {
            processNode: processNode,
            saveTo: vChooser,
            varRecord: record,
            setToObj: vChooser,
            forbiddenTypes: [ 'RADIOBUTTON', 'BOOLEAN', 'DATETIME' ],
            forcedPlacement: 'table'
        } );
        win.show();
    },
    editProcessVariable: function() {
        var vChooser = this.defPanel.colDef.vChooserContainer.items.first();
        var varId = vChooser.getValue();

        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }

        var processNode = this.getProcessNode();
        var variable = processNode.findVariable( varId );

        if ( !Ext.ux.suncode.IntegrationComponentService.validateVariableEdit( variable ) ) {
          showWarn( getTranslation( 'Komponent dynamicznej listy o identyfikatorze' )
              + ' ' + variable.definition.id + ' ' + getTranslation( 'nie istnieje' ) + '.' );
          return;
        }

        var win = new Ext.ux.suncode.VariableDefWindow( {
            forcedType: variable.type,
            forcedId: true,
            forcedPlacement: 'table',
            variable: variable,
            processNode: processNode
        } );
        win.show();
    },
    addColumn: function() {
        var vChooser = this.defPanel.colDef.vChooserContainer.items.first();
        var varId = vChooser.getValue();

        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }

        var processNode = this.getProcessNode();
        var variable = processNode.findVariable( varId );

        var columnModel = this.columnsPanel.getColumnModel();
        var colIndex = columnModel.getIndexById( 'varName' );
        var editorStore = columnModel.getCellEditor( colIndex, 0 ).field.getStore();

        if ( editorStore.findExact( 'varName', varId ) == -1 ) {
          var varRecord = editorStore.recordType;
          editorStore.add( new varRecord( variable ) );
          editorStore.commitChanges();
        }

        var store = this.columnsPanel.getStore();
        var r = store.recordType;
        var rec = new r( {
            varId: varId,
            varName: varId,
            readonly: variable.readonly,
            hidden: variable.dtHidden,
            differentReadonly: false,
            differentHidden: false
        } );
        store.add( rec );
        store.commitChanges();
        
        this.addColToGridPreview( variable );
        this.clearColumnDef();
        this.removeAvailableColumn( varId );
    },
    isGlobalDefinition: function() {
      return this.initialConfig.globalDefinition;
    },
    getProcessNode: function() {
      if ( this.isGlobalDefinition() ) {
        return this.initialConfig.processNode;
      } else {
        var activityNode = this.initialConfig.activityNode;

        return activityNode.parentNode;
      }
    },
    removeAvailableColumn: function( varId ){
    	var vChooser = this.defPanel.colDef.vChooserContainer.items.first();
    	var store = vChooser.getStore();
    	var index = store.find('id', varId);
    	
    	if ( index != -1 ) {
    		store.removeAt( index );
    		store.commitChanges();
    	}
    },
    addAvailableColumn: function( varId ) {
        var processNode = this.getProcessNode();
        var variable = processNode.findVariable( varId );
        
        if ( !Ext.isEmpty( variable ) ) {
        	var vChooser = this.defPanel.colDef.vChooserContainer.items.first();
        	var store = vChooser.getStore();
        	var r = store.recordType;
            var rec = new r( {
            	id: varId,
        		name: variable.name,
        		descr: variable.descr
            } );
        	
        	store.add( rec );
        	store.commitChanges();
        	store.sort('name', 'ASC');
        }
    },
    addColToGridPreview: function( variable ) {
        var colModel = this.gridPanel.getColumnModel();
        var columns = colModel.config;
        var header = '<center>' + this.getHeader( variable ) + '</center>';

        var colDef = {
            id: variable.id,
            header: header,
            dataIndex: variable.id,
            hidden: variable.dtHidden,
            menuDisabled: variable.dtMenuDisabled,
            sortable: variable.dtSortable
        };

        if ( variable.dtSize > 0 ) {
            colDef = Ext.apply( {
                width: variable.dtSize,
                customWidth: variable.dtSize
            }, colDef );
        }

        columns.push( colDef );

        colModel.setConfig( columns );
        this.refreshChanges( this.gridPanel );
    },
    getDTButtonCls: function( dtBtnObj ) {
        if ( !Ext.isEmpty( dtBtnObj.name ) && !Ext.isEmpty( dtBtnObj.icon ) ) {
            return 'x-btn-text-icon';
        } else if ( !Ext.isEmpty( dtBtnObj.name ) ) {
            return 'x-btn-text';
        } else {
            return 'x-btn-icon';
        }
    },
    addDTButtonToPreview: function( dtBtnObj ) {
      var toolbar = this.gridPanel.getBottomToolbar();
      toolbar.add( {
        id: dtBtnObj.buttonId,
        xtype: 'button',
        cls: this.getDTButtonCls( dtBtnObj ) + ' dvnt-pwe-dt-button '
            + Ext.ux.suncode.UtilService.resolveDtButtonColorCls( dtBtnObj.color ),
        iconCls: Ext.ux.suncode.UtilService.resolveIconCls( dtBtnObj.icon ),
        text: dtBtnObj.name,
        tooltip: dtBtnObj.tooltip,
        disabled: dtBtnObj.disabled,
        buttonId: dtBtnObj.buttonId
      } );
      toolbar.doLayout();
    },
    updateDTButtonOnPreview: function( id, dtBtnObj ) {
      var cls = this.getDTButtonCls( dtBtnObj ) + ' dvnt-pwe-dt-button '
          + Ext.ux.suncode.UtilService.resolveDtButtonColorCls( dtBtnObj.color );

      var btn = this.getDTButtonFromPreview( id );
      btn.setIconClass( Ext.ux.suncode.UtilService.resolveIconCls( dtBtnObj.icon ) );
      btn.setText( dtBtnObj.name );
      btn.setTooltip( dtBtnObj.tooltip );
      btn.setDisabled( dtBtnObj.disabled );
      btn.buttonId = dtBtnObj.buttonId;
    },
    removeDTButtonFromPreview: function( id ) {
        var toolbar = this.gridPanel.getBottomToolbar();
        var btn = this.getDTButtonFromPreview( id );
        toolbar.remove( btn );
        toolbar.doLayout();

        if ( this.isGlobalDefinition() ) {
          var processNode = this.initialConfig.processNode;
          Ext.ux.suncode.DocumentationService.deleteTableButtonSpecification( processNode, id );
        } else {
          var activityNode = this.initialConfig.activityNode;
          Ext.ux.suncode.DocumentationService.deleteDtButtonSpecification( activityNode, id );
        }
    },
    removeFillFromPreview: function() {
      var toolbar = this.gridPanel.getBottomToolbar();
      var items = toolbar.items.items;

      for ( var i = 0; i < items.length; i++ ) {
        var item = items[i];
        if ( item.isFill ) {
          toolbar.remove( item );
          toolbar.doLayout();
        }
      }
    },
    getDTButtonFromPreview: function( id ) {
        var items = this.gridPanel.getBottomToolbar().items.items;

        for ( var i = 0; i < items.length; i++ ) {
            var item = items[i];
            if ( item.buttonId == id ) {
                return item;
            }
        }
        return null;
    },
    removeColFromGridPreview: function( varId ) {
        var colModel = this.gridPanel.getColumnModel();
        var columns = colModel.config;

        for ( var i = 0; i < columns.length; i++ ) {
            if ( columns[i].id == varId ) {
                columns.splice( i, 1 );
                break;
            }
        }

        colModel.setConfig( columns );
        this.refreshChanges( this.gridPanel );
    },
    clearColumnDef: function() {
        this.defPanel.colDef.vChooserContainer.items.first().setValue( '' );
    },
    getSelectedCols: function() {
        var cols = this.columnsPanel.getSelectionModel().getSelections();
        if ( cols.length == 0 ) {
            showWarn( getTranslation( 'Wybierz kolumnę.' ) );
            return null;
        }
        return cols;
    },
    removeColumns: function() {
        var cols = this.getSelectedCols();
        if ( !cols ) {
            return;
        }

        var store = this.columnsPanel.getStore();
        
        Ext.each( cols, function( col, index, cols ) {
        	var columnId = col.get( 'varId' );

            if ( !this.isGlobalDefinition() && !this.validateColumnRemovalOnForm( columnId ) ) {
              return false;
            }

            store.remove( col );
            this.removeColFromGridPreview( columnId );
            this.removeGrouper( columnId );
            this.addAvailableColumn( columnId );
        }, this );

        store.commitChanges();
    },
    validateColumnRemovalOnForm: function( variableId ) {
    	var drawingPanel = Ext.getCmp( 'drawing_panel' );
    	var processNode = this.initialConfig.activityNode.parentNode;
    	var component = this.initialConfig.component;
        var objectDef = component.definition.objectDef;
        var variable = processNode.findVariable( variableId );
        var formActionsUsingVariable = drawingPanel.getFormActionsUsingVariable( processNode, variableId, objectDef.varId );
        formActionsUsingVariable = formActionsUsingVariable.concat( drawingPanel.getObjectIntegrationComponentsUsingVariable(
    			this.formActions, variableId, getTranslation( 'Akcja formularza na aktualnie edytowanej tabeli dynamicznej' ),
            Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION) );
        
        if ( this.DTButtons ) {
        	Ext.each( this.DTButtons, function( dtButton, index, dtButtons ) {
        		formActionsUsingVariable = formActionsUsingVariable.concat( drawingPanel.getObjectIntegrationComponentsUsingVariable(
        				dtButton.formActions, variableId,
            			getTranslation( 'Akcja formularza na przycisku aktualnie edytowanej tabeli dynamicznej' )
            				+ ': ' + dtButton.name, Ext.ux.suncode.IntegrationComponentService.COMPONENT_TYPES.FORM_ACTION ) );
        	} );
        }
        
        if ( !Ext.isEmpty( formActionsUsingVariable ) ) {
        	var varName = variable.name;
        	var warning = getTranslation( 'Zmienna' ) + ' <b>' + varName + '</b> '
				    + getTranslation( 'jest wykorzystywana w komponentach' ) + '.';
        	var title = getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + varName;
        	Ext.ux.suncode.IntegrationComponentService.showComponentsUsingVariableWarning( warning, {
              windowTitle: title,
            	utilization: formActionsUsingVariable,
            	showCustomDescription: true,
              showVariableUtilizationActions: true,
              enableRemoveAll: true,
            	preventSave: true,
            	processNode: processNode,
            	variableId: variableId
            } );
        	return false;
        } else {
        	return true;
        }
    },
    changeColumnsVisibility: function() {
        var store = this.columnsPanel.getStore();

        if ( store.getCount() > 0 ) {
            store.each( function( rec ) {
                this.changeColumnVisibility( rec );
            }, this );

            store.commitChanges();
            this.refreshChanges( this.gridPanel );
        }
    },
    changeColumnVisibility: function( rec ) {
        var cm = this.gridPanel.getColumnModel();
        var varId = rec.get( 'varId' );
        var colIndex = cm.getIndexById( varId );

        if ( cm.isHidden( colIndex ) ) {
            cm.setHidden( colIndex, false );
            rec.set( 'hidden', false );
        } else {
            cm.setHidden( colIndex, true );
            rec.set( 'hidden', true );
        }
    },
    restoreColumnsDefaultSettings: function() {
      var processNode = this.getProcessNode();
      var component = this.initialConfig.component;
      var objectDef = component.definition.objectDef;
      var tableId = objectDef.varId;
      var table = processNode.findTable( tableId );
      var store = this.columnsPanel.getStore();

      if ( !Ext.isEmpty( table ) && store.getCount() > 0 ) {
        store.each( function( rec ) {
          var globalColumn = this.getColumnDefinitionFromTable( table, rec.get( 'varId' ) );

          if ( !Ext.isEmpty( globalColumn ) ) {
            this.restoreColumnDefaultSettings( rec, globalColumn );
          }
        }, this );

        store.commitChanges();
        this.refreshChanges( this.gridPanel );
      }
    },
    getColumnDefinitionFromTable: function( table, columnId ) {
      var column = null;

      Ext.each( table.columns, function( col, index, cols ) {
        if ( col.varId === columnId ) {
          column = col;
          return false;
        }
      } );

      return column;
    },
    restoreColumnDefaultSettings: function( rec, globalColumn ) {
      rec.set( 'readonly', globalColumn.readonly );
      rec.set( 'hidden', globalColumn.hidden );
      rec.set( 'differentReadonly', false );
      rec.set( 'differentHidden', false );
    },
    changeColumnsOrder: function( cm, oldIndex, newIndex ) {
        if ( cm.stopChangeColumnsOrder ) {
            cm.stopChangeColumnsOrder = false;
            return;
        }

        var store = this.columnsPanel.getStore();
        var rec = store.getAt( oldIndex - 1 );
        store.removeAt( oldIndex - 1 );
        store.insert( newIndex - 1, [ rec ] );
        store.commitChanges();
    },
    onMoveColumn: function( sindex, dindex ) {
        if ( sindex == dindex ) {
            return;
        }

        var colModel = this.gridPanel.getColumnModel();
        colModel.stopChangeColumnsOrder = true;
        colModel.moveColumn( sindex + 1, dindex + 1 );
        this.refreshChanges( this.gridPanel );
    },
    refreshChanges: function( gridPanel ) {
        if ( gridPanel.rendered ) {
            var gridView = gridPanel.getView();

            try {
                gridView.forceFit = true;
                gridView.fitColumns( false );
                gridView.refresh( true );

                var cm = gridPanel.getColumnModel();
                var w = gridView.grid.getGridEl().getWidth( true ) - gridView.getScrollOffset() - cm.getColumnWidth( 0 );
                var colCount = cm.getColumnCount( false );
                var widthDivisor = cm.getColumnCount( true ) - 1;

                for ( var i = 1; i < colCount; i++ ) {
                    var col = cm.getColumnById( cm.getColumnId( i ) );
                    var isVisible = !cm.isHidden( i );
                    var customWidth = col.customWidth;

                    if ( isVisible && customWidth ) {
                        widthDivisor--;
                        w -= customWidth;
                    }
                }

                var colWidth = w / widthDivisor;

                for ( var i = 1; i < colCount; i++ ) {
                    var col = cm.getColumnById( cm.getColumnId( i ) );
                    var isVisible = !cm.isHidden( i );
                    var customWidth = col.customWidth;

                    if ( isVisible && !customWidth ) {
                        cm.setColumnWidth( i, colWidth );
                    } else if ( isVisible ) {
                        cm.setColumnWidth( i, customWidth );
                    }
                }
            }
            finally {
                gridView.forceFit = false;
            }
        }
    },
    onSetTitle: function( field, e ) {
        if ( e && e.getKey() != e.ENTER ) {
            return;
        }

        var newTitle = field.getValue();
        var globalDefinition = this.initialConfig.globalDefinition;

        if ( globalDefinition && Ext.isEmpty( this.initialConfig.table )
          || !( globalDefinition || this.initialConfig.component.idAssigned ) ) {
          var oldVarId = this.defPanel.idItem.getValue();
          var newVarId = generateId( newTitle );

          this.defPanel.idItem.setValue( newVarId );
          this.editFormActionsBindTo();
          this.updateDtButtonsTranslationsKeys( oldVarId, newVarId );
        }

        this.gridPanel.setTitle( newTitle );
    },
    changeEditability: function( box, checked ) {
        var grid = this.gridPanel;

        if ( checked ) {
            grid.getBottomToolbar().show();
            grid.doLayout();
            this.buttonsPanel.enable();
        } else {
            grid.getBottomToolbar().hide();
            grid.doLayout();
            this.buttonsPanel.disable();
        }
    },
    changeCollapsible: function( checkbox, collapsible ) {
        var toggleTool = this.gridPanel.tools.toggle;

        if ( collapsible ) {
            toggleTool.show();
        } else {
            toggleTool.hide();
        }
    },
    changeAutoHeight: function( checkbox, autoHeight ) {
        var autoHeightMinItem = this.defPanel.autoHeightMinItem;
        var autoHeightMaxItem = this.defPanel.autoHeightMaxItem;

        if ( autoHeight ) {
            autoHeightMinItem.show();
            autoHeightMaxItem.show();
        } else {
            autoHeightMinItem.hide();
            autoHeightMaxItem.hide();
            autoHeightMinItem.setValue( '' );
            autoHeightMaxItem.setValue( '' );
        }
    },
    changeHideRowNumber: function( checkbox, hideRowNumber ) {
      this.gridPanel.getColumnModel().setHidden( 0, hideRowNumber );
    },
    manageActions: function() {
        var win = new Ext.ux.suncode.DTActionsWindow( {
            actions: this.actions
        } );
        win.show();
    },
    setActions: function( actions ) {
        this.actions = actions;
    },
    manageGrouping: function() {
        var columnsStore = this.columnsPanel.getStore();

        var win = new Ext.ux.suncode.DTGroupingWindow( {
            groupers: this.groupers,
            columns: columnsStore.getRange(),
            processNode: this.getProcessNode()
        } );
        win.show();
    },
    setGroupers: function( groupers ) {
        this.groupers = groupers;
    },
    removeGrouper: function( columnId ) {
        var groupers = this.groupers;

        for ( var i = 0; i < groupers.length; i++ ) {
            var grouper = groupers[i];
            if ( grouper.columnId == columnId ) {
                groupers.splice( i, 1 );
            }
        }
    },
    getVarId: function() {
      var idItem = this.defPanel.idItem;

      if ( !Ext.isEmpty( idItem ) ) {
        return idItem.getValue();
      } else {
        var component = this.initialConfig.component;
        var objectDef = component.definition.objectDef;

        return objectDef.varId;
      }
    },
    addDTButton: function() {
        var varId = this.getVarId();

        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ) );
            return;
        }
        
        var buttonsPanel = this.buttonsPanel;
        var record = buttonsPanel.getStore().recordType;

        var win = new Ext.ux.suncode.DTButtonDefinitionWindow( {
            globalDefinition: this.isGlobalDefinition(),
            saveTo: buttonsPanel,
            varRecord: record,
            availableVariables: this.initialConfig.availableVariables,
            missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
            validateIntegrationComponentFieldFunction: this.initialConfig.validateIntegrationComponentFieldFunction,
            validateIntegrationComponentFieldScope: this.initialConfig.validateIntegrationComponentFieldScope,
            validateIntegrationComponentRowFunction: this.initialConfig.validateIntegrationComponentRowFunction,
            validateIntegrationComponentRowScope: this.initialConfig.validateIntegrationComponentRowScope,
            pasteIntegrationComponentsValidation: this.initialConfig.pasteIntegrationComponentsValidation,
            AV: this.initialConfig.AV,
            processNode: this.getProcessNode(),
            activityNode: this.initialConfig.activityNode,
            variableSetId: varId,
            validateIdFunction: this.validateDtButtonId,
            validateIdScope: this,
            addFunction: this.onAddDTButton,
            addScope: this,
            updateFunction: this.onUpdateDTButton,
            updateScope: this
        } );
        win.show();
    },
    editDTButton: function() {
        var varId = this.getVarId();

        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ) );
            return;
        }
        
        var btn = this.getSelectedButton();
        if ( !btn ) {
            return;
        }

        if ( btn.get( 'isFill' ) ) {
          showWarn( getTranslation( 'Wypełnienie nie może być edytowane.' ) );
          return;
        }

        var btnId = btn.get( 'buttonId' );
        var DTButtons = this.DTButtons;
        var DTButton = null;
        for ( var i = 0; i < DTButtons.length; i++ ) {
            if ( btnId == DTButtons[i].buttonId ) {
                DTButton = DTButtons[i];
                break;
            }
        }

        var win = new Ext.ux.suncode.DTButtonDefinitionWindow( {
            globalDefinition: this.isGlobalDefinition(),
            DTButton: DTButton,
            saveTo: this.buttonsPanel,
            varRecord: btn,
            availableVariables: this.initialConfig.availableVariables,
            missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
            validateIntegrationComponentFieldFunction: this.initialConfig.validateIntegrationComponentFieldFunction,
            validateIntegrationComponentFieldScope: this.initialConfig.validateIntegrationComponentFieldScope,
            validateIntegrationComponentRowFunction: this.initialConfig.validateIntegrationComponentRowFunction,
            validateIntegrationComponentRowScope: this.initialConfig.validateIntegrationComponentRowScope,
            pasteIntegrationComponentsValidation: this.initialConfig.pasteIntegrationComponentsValidation,
            AV: this.initialConfig.AV,
            processNode: this.getProcessNode(),
            activityNode: this.initialConfig.activityNode,
            variableSetId: varId,
            validateIdFunction: this.validateDtButtonId,
            validateIdScope: this,
            addFunction: this.onAddDTButton,
            addScope: this,
            updateFunction: this.onUpdateDTButton,
            updateScope: this
        } );
        win.show();
    },
    removeFromBottomToolbar: function() {
        var btn = this.getSelectedButton();
        if ( !btn ) {
            return;
        }

        if ( !this.isGlobalDefinition() && !Ext.isEmpty( btn.get( 'globalId' ) ) ) {
          showWarn( getTranslation( 'Globalny przycisk nie może być usunięty.' ) );
          return;
        }

        if ( btn.get( 'isFill' ) ) {
          this.removeFillFromPreview();
        } else {
          this.onRemoveDTButton( btn.get( 'buttonId' ) );
        }

        removeRowAndMarkNext( this.buttonsPanel, btn );
    },
    getSelectedButton: function() {
        var btn = this.buttonsPanel.getSelectionModel().getSelected();
        if ( !btn ) {
            showWarn( getTranslation( 'Wybierz przycisk.' ) );
            return null;
        }
        return btn;
    },
    validateDtButtonId: function( buttonId ) {
        var DTButtons = this.DTButtons;
        for ( var i = 0; i < DTButtons.length; i++ ) {
            if ( buttonId == DTButtons[i].buttonId ) {
                return false;
            }
        }
        return true;
    },
    onAddDTButton: function( dtBtnObj ) {
        this.DTButtons.push( dtBtnObj );
        this.addDTButtonToPreview( dtBtnObj );
    },
    onUpdateDTButton: function( oldButtonId, dtBtnObj ) {
        var DTButtons = this.DTButtons;
        for ( var i = 0; i < DTButtons.length; i++ ) {
            if ( oldButtonId == DTButtons[i].buttonId ) {
                DTButtons[i] = dtBtnObj;
                break;
            }
        }

        this.updateDTButtonOnPreview( oldButtonId, dtBtnObj );
    },
    onRemoveDTButton: function( buttonId ) {
        var DTButtons = this.DTButtons;
        for ( var i = 0; i < DTButtons.length; i++ ) {
            if ( buttonId == DTButtons[i].buttonId ) {
                DTButtons.splice( i, 1 );
                break;
            }
        }

        this.removeDTButtonFromPreview( buttonId );
    },
    onMoveDTButton: function( sindex, dindex ) {
        if ( sindex == dindex ) {
            return;
        }

        var newDtButtons = new Array();
        var buttonsPanel = this.buttonsPanel;
        var store = buttonsPanel.getStore();

        store.each( function( r ) {
          if ( !r.get( 'isFill' ) ) {
            var buttonId = r.get( 'buttonId' );

            for( var i = 0; i < this.DTButtons.length; i++ ) {
              var dtButton = this.DTButtons[i];

              if ( dtButton.buttonId == buttonId ) {
                newDtButtons.push( deepObjectCopy( dtButton) );
                break;
              }
            }
          }
        }, this );

        this.DTButtons = [].concat( newDtButtons );

        var toolbar = this.gridPanel.getBottomToolbar();
        var btn = toolbar.remove( toolbar.items.items[sindex + 3], false );
        toolbar.insert( dindex + 3, btn );
        toolbar.doLayout();
    },
    addFill: function() {
      var buttonsPanel = this.buttonsPanel;
      var store = buttonsPanel.getStore();
      var fillIndex = store.find( 'isFill', true );

      if ( fillIndex != -1 ) {
        showWarn( getTranslation( 'Wypełnienie zostało już dodane.' ) );
        return null;
      }

      var record = store.recordType;
      store.add( new record( {
        isFill: true,
        name: '->'
      } ) );
      store.commitChanges();

      var toolbar = this.gridPanel.getBottomToolbar();
      toolbar.add( {
        xtype: 'tbfill',
        isFill: true
      } );
      toolbar.doLayout();
    },
    getTableId: function() {
      var idItem = this.defPanel.idItem;

      if ( !Ext.isEmpty( idItem ) ) {
        return idItem.getValue();
      } else {
        var component = this.initialConfig.component;
        var objectDef = component.definition.objectDef;

        return objectDef.varId;
      }
    },
    manageFormActions: function() {
      var bindToValue = this.getTableId();

      var processNode = this.getProcessNode();
      var mainPanel = Ext.getCmp( 'main_panel' );
      var categories = mainPanel.getFormActionsIntegrationComponentCategories();
      var integrationComponentDestination = Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION;
      var filteredCategories = Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
          categories, integrationComponentDestination, false );

      var win = new Ext.ux.suncode.IntegrationComponentWindow( {
        title: getTranslation( 'Akcje formularza tabeli dynamicznej' ),
        iconCls: 'x-Module-formActionsWindow',
        allCategories: categories,
        filteredCategories: filteredCategories,
        integrationComponentDestination: integrationComponentDestination,
        components: this.formActions,
        processNode: processNode,
        enableCopyPasteMenu: true,
        parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
        globalDefinition: this.isGlobalDefinition(),
        availableVariables: this.initialConfig.availableVariables,
        getBindToFunction: function( cmp ) {
          var destination = Ext.ux.suncode.IntegrationComponentService.getDestination(
              cmp, integrationComponentDestination, false );

          return !Ext.isEmpty( destination ) ? {
            id: destination.bindTo,
            value: bindToValue
          } : null;
        },
        getBindToScope: this,
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( cmps ) {
          Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( cmps );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
            if ( Ext.isFunction( func ) ) {
              var cmps = new Array();

              if ( !Ext.isEmpty( formActions ) ) {
                var service = Ext.ux.suncode.IntegrationComponentService;

                Ext.each( formActions, function( cmp, index, allComponents ) {
                  var componentDef = service.getIntegrationComponent( categories, cmp.id );

                  if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, integrationComponentDestination ) ) {
                    cmps.push( cmp );
                  }
                } );
              }

              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ cmps ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
        missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
        validateRowFunction: this.initialConfig.validateIntegrationComponentRowFunction,
        validateRowScope: this.initialConfig.validateIntegrationComponentRowScope,
        pasteComponentsValidation: this.initialConfig.pasteIntegrationComponentsValidation,
        saveFunction: function( components ) {
          this.formActions = components;
        },
        saveScope: this,
        modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
          var formActionUpdate = {
            customDescription: extraConfig.customDescription,
            condition: condition,
            inactive: extraConfig.inactive,
            modificationDate: extraConfig.modificationDate,
            parameters: values
          };

          Ext.each( this.formActions, function( formAction, index, formActions ) {
            if ( formAction.globalId == globalId ) {
              Ext.apply( formAction, formActionUpdate );
            }
          } );

          processNode.updateTableFormAction( bindToValue, globalId, formActionUpdate );
        },
        modifyGlobalDefinitionScope: this
      } );
      win.show();
    },
    manageEventActions: function() {
      var processNode = this.getProcessNode();
      var mainPanel = Ext.getCmp( 'main_panel' );
      var eventTypes = mainPanel.getEventTypesForVariableSet();
      var eventActionsCategories = mainPanel.getEventActionsCategories();

      var win = new Ext.ux.suncode.IntegrationComponentWindow( {
        title: getTranslation( 'Zdarzenia tabeli dynamicznej' ),
        iconCls: 'x-Module-eventsWindow',
        eventMode: true,
        eventTypes: eventTypes,
        allCategories: eventActionsCategories,
        filteredCategories: eventActionsCategories,
        components: this.eventActions,
        processNode: processNode,
        enableCopyPasteMenu: true,
        parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
        globalDefinition: this.isGlobalDefinition(),
        availableVariables: this.initialConfig.availableVariables,
        getComponentRegistrationFunction: function( id ) {
          return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( components ) {
          Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( components );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
            if ( Ext.isFunction( func ) ) {
              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ eventActions ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
        missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
        missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
        validateRowFunction: this.initialConfig.validateIntegrationComponentRowFunction,
        validateRowScope: this.initialConfig.validateIntegrationComponentRowScope,
        pasteComponentsValidation: this.initialConfig.pasteIntegrationComponentsValidation,
        saveFunction: function( components ) {
          this.eventActions = components;
        },
        saveScope: this,
        modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
          var tableId = this.getTableId();
          var eventActionUpdate = {
            customDescription: extraConfig.customDescription,
            condition: condition,
            inactive: extraConfig.inactive,
            modificationDate: extraConfig.modificationDate,
            parameters: values
          };

          Ext.each( this.eventActions, function( eventAction, index, eventActions ) {
            if ( eventAction.globalId == globalId ) {
              Ext.apply( eventAction, eventActionUpdate );
            }
          } );

          processNode.updateTableEventAction( tableId, globalId, eventActionUpdate );
        },
        modifyGlobalDefinitionScope: this
      } );
      win.show();
    },
    editFormActionsBindTo: function() {
        var formActions = this.formActions;

        if ( !Ext.isEmpty( formActions ) ) {
            var bindToValue = this.defPanel.idItem.getValue();
            var variableSetDestination = Ext.ux.suncode.IntegrationComponentService.VARIABLE_SET_DESTINATION;
            var mainPanel = Ext.getCmp( 'main_panel' );
            var categories = Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination( mainPanel
                            .getFormActionsIntegrationComponentCategories(), variableSetDestination, false );

            Ext.each( formActions, function( action, index, actions ) {
                var componentId = action.id;
                var component = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories, componentId );
                var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, variableSetDestination );

                if ( !Ext.isEmpty( destination.bindTo ) ) {
                    var parameters = action.parameters;

                    Ext.iterate( parameters, function( id, value, object ) {
                        if ( id == destination.bindTo ) {
                            value.value = bindToValue;
                        }
                    } );
                }
            } );
        }
    },
    updateDtButtonsTranslationsKeys: function( oldId, newId ) {
    	var regex = Ext.ux.suncode.I18NService.buildVariableSetIdPlaceholder( oldId );
    	var replacement = Ext.ux.suncode.I18NService.buildVariableSetIdPlaceholder( newId );
    	
    	Ext.each( this.DTButtons, function( dtButton, index, dtButtons ) {
    		if ( !Ext.isEmpty( dtButton.translations ) ) {
    			Ext.iterate( dtButton.translations, function( key, packageTranslation, object ) {
    				var newKey = key.replaceAll( regex, replacement );

    				if ( newKey !== key ) {
    					object[newKey] = packageTranslation;
    					delete object[key];
    				}
    			} );
    		}
    	} );
    },
    getHeader: function( variable ) {
        var label = variable.name;

        if ( !Ext.isEmpty( variable.descr ) ) {
            label += ' <img src="' + getPluginImgPath( 'tooltip' ) + '"/>';
        }

        if ( variable.requirement ) {
            label += ' <span class="x-Module-required-field-label">*</span>';
        }

        return label;
    },
    saveGlobalTable: function() {
      var processNode = this.initialConfig.processNode;
      var table = this.initialConfig.table;
      var varId = this.defPanel.idItem.getValue();

      if ( Ext.isEmpty( varId ) ) {
        showWarn( getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ) );
        return;
      }

      if ( !table && processNode.findTable( varId ) ) {
        showWarn( getTranslation( 'Tabela już istnieje.' ) );
        return;
      } else if ( table && table.id != varId && processNode.findTable( varId ) ) {
        showWarn( getTranslation( 'Tabela już istnieje.' ) );
        return;
      }

      var localTableIds = processNode.getLocalTableIds();
      if ( localTableIds.indexOf( varId ) != -1 ) {
        showWarn( getTranslation( 'Istnieje już lokalna tabela o podanym identyfikatorze.' ) );
        return;
      }

      var tableDef = this.readDef( varId );
      if ( !tableDef ) {
        return;
      }

      tableDef = Ext.apply( tableDef, {
        id: varId,
        name: this.defPanel.titleItem.getValue(),
        clicksToEdit: this.defPanel.clicksToEditItem.getValue(),
        showDeleteConfirmation: this.defPanel.showDeleteConfirmationItem.getValue(),
        hideRowNumber: this.defPanel.hideRowNumberItem.getValue(),
        translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.defPanel.titleItem ] )
      } );

      var beforeSaveFunction = this.initialConfig.beforeSaveFunction;

      if ( Ext.isFunction( beforeSaveFunction ) ) {
        var beforeSaveScope = !Ext.isEmpty( this.initialConfig.beforeSaveScope ) ? this.initialConfig.beforeSaveScope : window;

        if ( beforeSaveFunction.apply( beforeSaveScope, [ tableDef ] ) === false ) {
          return;
        }
      }

      var saveToObj = this.initialConfig.saveTo;
      var varRecord = this.initialConfig.varRecord;
      var table = this.initialConfig.table;
      var currentDate = new Date().format( 'Y-m-d H:i:s' );

      if ( saveToObj && varRecord ) {
        if ( table ) {
          varRecord.set( 'id', tableDef.id );
          varRecord.set( 'name', tableDef.name );
          varRecord.set( 'modificationDate', currentDate );
          varRecord.commit();
        } else {
          var store = saveToObj.getStore();
          store.add( new varRecord( {
            id: tableDef.id,
            name: tableDef.name,
            creationDate: currentDate,
            modificationDate: currentDate
          } ) );
          store.commitChanges();
          saveToObj.updateTitle();
        }
      }

      var specification = this.readSpecification();

      if ( table ) {
        var validationResult = processNode.validateUpdateTable( table.id, tableDef.columns );
        if ( !validationResult.valid ) {
          showWarn( validationResult.errorMessage );
          return;
        }

        tableDef = Ext.apply( {
          creationDate: table.creationDate,
          modificationDate: currentDate
        }, tableDef );
        processNode.updateTable( table.id, tableDef );
        Ext.ux.suncode.DocumentationService.editTableSpecification( processNode, table.id, tableDef.id, specification );
      } else {
        tableDef = Ext.apply( {
          creationDate: currentDate,
          modificationDate: currentDate
        }, tableDef );
        processNode.addTable( tableDef );
        Ext.ux.suncode.DocumentationService.addTableSpecification( processNode, tableDef.id, specification );
      }

      var afterSaveFunction = this.initialConfig.afterSaveFunction;

      if ( Ext.isFunction( afterSaveFunction ) ) {
        var afterSaveScope = !Ext.isEmpty( this.initialConfig.afterSaveScope ) ? this.initialConfig.afterSaveScope : window;
        afterSaveFunction.apply( afterSaveScope, [ tableDef ] );
      }

      if ( processNode.hasChildNodes() ) {
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var processDefId = processNode.attributes.processDefId;
        var titleTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + varId +')';
        var localTableTitleTranslations = deepObjectCopy( tableDef.translations[titleTranslationKey] );

        var localDtButtonsTranslations = new Array();

        Ext.each( tableDef.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
          var buttonId = dtButton.buttonId;
          var dtButtonNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + varId
              + ')_DTBUTTON(' + buttonId + ')';
          var dtButtonTooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + varId
              + ')_DTBUTTON(' + buttonId + ')_DESC';
          var localDtButtonNameTranslations = deepObjectCopy( dtButton.translations[dtButtonNameTranslationKey] );
          var localDtButtonTooltipTranslations = deepObjectCopy( dtButton.translations[dtButtonTooltipTranslationKey] );

          localDtButtonsTranslations.push( {
            buttonId: buttonId,
            nameTranslations: localDtButtonNameTranslations,
            tooltipTranslations: localDtButtonTooltipTranslations
          } );
        } );

        Ext.ux.suncode.I18NService.updateLocalVariableSetTranslations( processNode, varId, localTableTitleTranslations, localDtButtonsTranslations );
      }

      this.ownerCt.closeWindow();
    },
    transformToGlobal: function() {
      Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: getTranslation( 'Czy chcesz przetransformować tą tabelę w tabelę globalną?' ),
        buttons: {
          yes: getTranslation( 'Tak' ),
          no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
          if ( buttonId == 'yes' ) {
            this.executeTransformToGlobal();
          }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
      } );
    },
    executeTransformToGlobal: function() {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var packageId = packageNode.attributes.packageId;
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var processDefId = processNode.attributes.processDefId;
      var activityDefId = activityNode.attributes.activityDefId;
      var varId = this.defPanel.idItem.getValue();

      if ( Ext.isEmpty( varId ) ) {
        showWarn( getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ) );
        return;
      } else if ( !this.isAutoHeightValid() ) {
        return;
      }

      if ( processNode.findTable( varId ) ) {
        showWarn( getTranslation( 'Tabela już istnieje.' ) );
        return;
      }

      var tableDef = this.readDef( varId );
      if ( !tableDef ) {
        return;
      }

      var columnsDuplicationValidationResult = processNode.validateTableColumnsDuplication( tableDef.columns );
      if ( !columnsDuplicationValidationResult.valid ) {
        showWarn( columnsDuplicationValidationResult.errorMessage );
        return;
      }

      var dtButtonsDuplicationValidationResult = processNode.validateTableDtButtonsDuplication( activityDefId, tableDef.DTButtons );
      if ( !dtButtonsDuplicationValidationResult.valid ) {
        showWarn( dtButtonsDuplicationValidationResult.errorMessage );
        return;
      }

      var uniquenessValidationResult = processNode.validateTableUniqueness( activityNode.attributes.activityDefId, varId );
      if ( !uniquenessValidationResult.valid ) {
        showWarn( uniquenessValidationResult.errorMessage );
        return;
      }

      var currentDate = new Date().format( 'Y-m-d H:i:s' );

      tableDef = Ext.apply( tableDef, {
        id: varId,
        name: this.defPanel.titleItem.getValue(),
        clicksToEdit: 2,
        showDeleteConfirmation: false,
        hideRowNumber: false,
        translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.defPanel.titleItem ] ),
        creationDate: currentDate,
        modificationDate: currentDate
      } );

      Ext.each( tableDef.DTButtons, function( dtButton, dtButtonIndex, dtButtons ) {
        Ext.apply( dtButton, {
          globalId: generateGlobalId()
        } );

        Ext.each( dtButton.formActions, function( formAction, formActionIndex, formActions ) {
          Ext.apply( formAction, {
            globalId: generateGlobalId()
          } );
        } );

        var oldNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + dtButton.buttonId + ')';
        var oldTooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId
            + ')_VARIABLESET(' + varId + ')_DTBUTTON(' + dtButton.buttonId + ')_DESC';
        var nameTranslation = dtButton.translations[oldNameTranslationKey];
        var tooltipTranslation = dtButton.translations[oldTooltipTranslationKey];

        if ( !Ext.isEmpty( nameTranslation ) ) {
          var newNameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + varId
              + ')_DTBUTTON(' + dtButton.buttonId + ')';

          dtButton.translations[newNameTranslationKey] = nameTranslation;
          delete dtButton.translations[oldNameTranslationKey];
        }

        if ( !Ext.isEmpty( tooltipTranslation ) ) {
          var newTooltipTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + varId
              + ')_DTBUTTON(' + dtButton.buttonId + ')_DESC';

          dtButton.translations[newTooltipTranslationKey] = tooltipTranslation;
          delete dtButton.translations[oldTooltipTranslationKey];
        }
      } );

      Ext.each( tableDef.formActions, function( formAction, index, formActions ) {
        Ext.apply( formAction, {
          globalId: generateGlobalId()
        } );
      } );

      var specification = this.readSpecification();
      processNode.addTable( tableDef );
      Ext.ux.suncode.DocumentationService.addTableSpecification( processNode, tableDef.id, specification );

      var component = this.initialConfig.component;
      var varDef = new Object();
      varDef = Ext.apply( varDef, tableDef );
      delete varDef.id;
      delete varDef.creationDate;
      delete varDef.modificationDate;
      varDef = Ext.apply( varDef, {
        varId: varId,
        type: component.type,
        editable: this.defPanel.editableItem.getValue(),
        local: this.defPanel.localItem.getValue(),
        collapsible: this.defPanel.collapsibleItem.getValue(),
        stateful: this.defPanel.statefulItem.getValue(),
        autoHeight: this.defPanel.autoHeightItem.getValue(),
        autoHeightMin: this.defPanel.autoHeightMinItem.getValue(),
        autoHeightMax: this.defPanel.autoHeightMaxItem.getValue(),
        headerFontSize: this.defPanel.fontDef.headerFontSizeItem.getValue(),
        cellFontSize: this.defPanel.fontDef.cellFontSizeItem.getValue(),
        genre: 'VARIABLE_SET'
      } );

      this.editOnForm( varDef );
      this.ownerCt.closeDefWindow();
    },
    editGridVariable: function() {
        var activityNode = this.initialConfig.activityNode;
        var component = this.initialConfig.component;
        var objectDef = component.definition.objectDef;
        var idItem = this.defPanel.idItem;
        var varDef = null;

        if ( Ext.isEmpty( idItem ) ) {
          var varId = objectDef.varId;
          varDef = this.readDef( varId );
          if ( !varDef ) {
            return;
          } else if ( !this.isAutoHeightValid() ) {
            return;
          }

          varDef = Ext.apply( varDef, {
            varId: varId,
            name: objectDef.name,
            clicksToEdit: objectDef.clicksToEdit,
            showDeleteConfirmation: objectDef.showDeleteConfirmation,
            hideRowNumber: objectDef.hideRowNumber,
            type: component.type,
            editable: this.defPanel.editableItem.getValue(),
            local: this.defPanel.localItem.getValue(),
            collapsible: this.defPanel.collapsibleItem.getValue(),
            stateful: this.defPanel.statefulItem.getValue(),
            autoHeight: this.defPanel.autoHeightItem.getValue(),
            autoHeightMin: this.defPanel.autoHeightMinItem.getValue(),
            autoHeightMax: this.defPanel.autoHeightMaxItem.getValue(),
            headerFontSize: this.defPanel.fontDef.headerFontSizeItem.getValue(),
            cellFontSize: this.defPanel.fontDef.cellFontSizeItem.getValue(),
            translations: objectDef.translations,
            genre: 'VARIABLE_SET'
          } );
        } else {
          varDef = this.readOldDef();
          if ( !varDef ) {
            return;
          }

          Ext.ux.suncode.DocumentationService.editFormVariableSpecification( activityNode, varDef.varId, varDef.varId, varDef.specification );
        }

        this.editOnForm( varDef );
        this.ownerCt.closeDefWindow();
    },
    readDef: function( varId ) {
        var varDef = new Object();

        if ( !this.isVisibleColumnAdded() ) {
            showWarn( getTranslation( 'Dodaj przynajmniej jedną widoczną kolumnę do tabeli dynamicznej.' ) );
            return null;
        }

        var columns = this.readColumns();
        var columnIds = new Array();
        for ( var i = 0; i < columns.length; i++ ) {
          var column = columns[i];
          var columnId = column.varId;

          if ( columnId == varId ) {
            showWarn( getTranslation( 'Identyfikator tabeli jest identyczny z identyfikatorem kolumny.' ) );
            return null;
          }

          columnIds.push( columnId );
        }

        for ( var i = 0; i < this.DTButtons.length; i++ ) {
          var dtButton = this.DTButtons[i];
          var dtButtonId = dtButton.buttonId;

          if ( dtButtonId == varId ) {
            showWarn( getTranslation( 'Identyfikator tabeli jest identyczny z identyfikatorem przycisku.' ) );
            return null;
          }

          if ( columnIds.indexOf( dtButtonId ) != -1 ) {
            showWarn( getTranslation( 'Identyfikator kolumny jest identyczny z identyfikatorem przycisku.' ) );
            return null;
          }

          dtButton.vsId = varId;
        }

        varDef = Ext.apply( {
            columns: columns,
            actions: this.actions,
            groupers: this.groupers,
            DTButtons: this.DTButtons,
            formActions: this.formActions,
            eventActions: this.eventActions
        }, varDef );

        var dtButtonsFillPosition = this.getDtButtonsFillPosition();

        if ( dtButtonsFillPosition != -1 ) {
            varDef = Ext.apply( {
                dtButtonsFillPosition: dtButtonsFillPosition
            }, varDef );
        }

        return varDef;
    },
    readOldDef: function() {
      var varDef = new Object();
      var varId = this.defPanel.idItem.getValue();
      var processNode = this.getProcessNode();

      if ( Ext.isEmpty( varId ) ) {
        showWarn( getTranslation( 'Podaj identyfikator tabeli dynamicznej.' ) );
        return;
      } else if ( this.checkDuplication( varId ) ) {
        showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
        return;
      } else if ( processNode.findTable( varId ) ) {
        showWarn( getTranslation( 'Istnieje już globalna tabela o podanym identyfikatorze.' ) );
        return;
      } else if ( !this.isVisibleColumnAdded() ) {
        showWarn( getTranslation( 'Dodaj przynajmniej jedną widoczną kolumnę do tabeli dynamicznej.' ) );
        return;
      } else if ( !this.isAutoHeightValid() ) {
        return;
      }

      Ext.each( this.DTButtons, function( dtb, idx, dtbs ) {
        dtb.vsId = varId;
      } );

      varDef = Ext.apply( {
        varId: varId,
        name: this.defPanel.titleItem.getValue(),
        type: this.initialConfig.component.type,
        clicksToEdit: this.defPanel.clicksToEditItem.getValue(),
        showDeleteConfirmation: this.defPanel.showDeleteConfirmationItem.getValue(),
        hideRowNumber: this.defPanel.hideRowNumberItem.getValue(),
        columns: this.readColumns(),
        editable: this.defPanel.editableItem.getValue(),
        local: this.defPanel.localItem.getValue(),
        collapsible: this.defPanel.collapsibleItem.getValue(),
        stateful: this.defPanel.statefulItem.getValue(),
        autoHeight: this.defPanel.autoHeightItem.getValue(),
        autoHeightMin: this.defPanel.autoHeightMinItem.getValue(),
        autoHeightMax: this.defPanel.autoHeightMaxItem.getValue(),
        headerFontSize: this.defPanel.fontDef.headerFontSizeItem.getValue(),
        cellFontSize: this.defPanel.fontDef.cellFontSizeItem.getValue(),
        actions: this.actions,
        groupers: this.groupers,
        DTButtons: this.DTButtons,
        formActions: this.formActions,
        eventActions: this.eventActions,
        genre: 'VARIABLE_SET',
        translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.defPanel.titleItem ] ),
        specification: this.readSpecification()
      }, varDef );

      return varDef;
    },
    readColumns: function() {
      var columns = new Array();
      var columnsStore = this.columnsPanel.getStore();

      columnsStore.each( function( column ) {
        columns.push( {
          varId: column.get( 'varId' ),
          readonly: column.get( 'readonly' ),
          hidden: column.get( 'hidden' ),
          differentReadonly: column.get( 'differentReadonly' ),
          differentHidden: column.get( 'differentHidden' )
        } );
      } );

      return columns;
    },
    getDtButtonsFillPosition: function() {
      var buttonsPanel = this.buttonsPanel;
      var store = buttonsPanel.getStore();

      return store.find( 'isFill', true );
    },
    checkDuplication: function( varId ) {
      var component = this.initialConfig.component;

      if ( component.idAssigned && component.definition.objectDef.varId == varId ) {
        return isDuplicated;
      } else {
        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        var isDuplicated = false;

        drawingPanel.items.each( function( item ) {
          item.items.each( function( subitem ) {
            var definition = subitem.definition;
            var objectDef = definition.objectDef;

            switch ( objectDef.genre ) {
              case 'VARIABLE':
                if ( subitem.idAssigned && objectDef.varId == varId ) {
                  isDuplicated = true;
                  return false;
                }
                break;
              case 'VARIABLE_SET':
                if ( subitem.idAssigned ) {
                  if ( objectDef.varId == varId ) {
                    isDuplicated = true;
                    return false;
                  } else if ( component.idAssigned && component.definition.objectDef.varId == objectDef.varId ) {
                    var columnsStore = this.columnsPanel.getStore();

                    if ( columnsStore.getCount() > 0 ) {
                      columnsStore.each( function( column ) {
                        var columnVarId = column.get( 'varId' );

                        if ( columnVarId == varId ) {
                          isDuplicated = true;
                          return false;
                        }
                      } );
                    }
                  } else {
                    var columns = objectDef.columns;

                    for ( var i = 0; i < columns.length; i++ ) {
                      var column = columns[i];

                      if ( column.varId == varId ) {
                        isDuplicated = true;
                        return false;
                      }
                    }

                    var dtButtons = objectDef.DTButtons;

                    for ( var i = 0; i < dtButtons.length; i++ ) {
                      var dtButton = dtButtons[i];

                      if ( dtButton.buttonId == varId ) {
                        isDuplicated = true;
                        return false;
                      }
                    }
                  }
                }
                break;
              case 'LABEL':
                if ( subitem.idAssigned && objectDef.id == varId ) {
                  isDuplicated = true;
                  return false;
                }
                break;
              case 'HTTP_LINK':
              case 'ACTION_ACCEPT_BUTTON':
              case 'GENERATE_PDF_BUTTON':
              case 'ADD_FILE_BUTTON':
              case 'BARCODE_PRINT':
                if ( subitem.idAssigned &&
                    ( objectDef.actionName == varId || objectDef.actionName + '_button' == varId ) ) {
                  isDuplicated = true;
                  return false;
                }
                break;
              default:
                break;
            }
          }, this );

          if ( isDuplicated ) {
            return false;
          }
        }, this );

        return isDuplicated;
      }
    },
    isVisibleColumnAdded: function() {
        var columnsStore = this.columnsPanel.getStore();

        if ( columnsStore.getCount() > 0 ) {
            var added = false;

            columnsStore.each( function( column ) {
                var hidden = column.get( 'hidden' );

                if ( !hidden ) {
                    added = true;
                    return false;
                }
            } );

            return added;
        } else {
            return false;
        }
    },
    isAutoHeightValid: function() {
        var autoHeight = this.defPanel.autoHeightItem.getValue();

        if ( autoHeight ) {
            var autoHeightMin = this.defPanel.autoHeightMinItem.getValue();
            var autoHeightMax = this.defPanel.autoHeightMaxItem.getValue();

            if ( Ext.isEmpty( autoHeightMin ) ) {
                showWarn( getTranslation( 'Podaj minimalną wysokość.' ) );
                return false;
            } else if ( Ext.isEmpty( autoHeightMax ) ) {
                showWarn( getTranslation( 'Podaj maksymalną wysokość.' ) );
                return false;
            } else if ( autoHeightMin < Ext.ux.suncode.Constants.DT_MAX_HEIGHT ) {
                showWarn( getTranslation( 'Minimalna wysokość musi być większa od' + ' ' + Ext.ux.suncode.Constants.DT_MAX_HEIGHT + '.' ) );
                return false;
            } else if ( autoHeightMin > autoHeightMax ) {
                showWarn( getTranslation( 'Minimalna wysokość nie może być większa od maksymalnej wysokości.' ) );
                return false;
            }
        }

        return true;
    },
    editOnForm: function( varDef ) {
      var component = this.initialConfig.component;
      var objectDef = component.definition.objectDef;
      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var processVariablesCopy = [].concat( processNode.attributes.variables );

      var item = new Object();
      item = Ext.apply( {
        id: varDef.varId,
        type: component.type,
        headerFontSize: varDef.headerFontSize,
        cellFontSize: varDef.cellFontSize
      }, item );

      var newComponent = {
        processVariables: processVariablesCopy,
        item: item
      };

      var drawingPanel = Ext.getCmp( 'drawing_panel' );
      var variablesTree = drawingPanel.ownerCt.variablesTree;
      var previousVarIds = this.getColumnVarIds( objectDef.columns );
      var currentVarIds = this.getColumnVarIds( varDef.columns );

      Ext.each( previousVarIds, function( varId, index, varIds ) {
        if ( currentVarIds.indexOf( varId ) == -1 ) {
          var variable = processNode.findVariable( varId );
          variablesTree.markAsUnused( variable );
        }
      } );

      Ext.each( currentVarIds, function( varId, index, varIds ) {
        if ( previousVarIds.indexOf( varId ) == -1 ) {
          var variable = processNode.findVariable( varId );
          variablesTree.markAsUsed( variable );
        }
      } );

      var componentContainer = component.ownerCt;
      var index = componentContainer.items.indexOf( component );
      componentContainer.suspendEvents();
      componentContainer.remove( component );
      componentContainer.resumeEvents();
      componentContainer.insert( index, drawingPanel.createFormVariable( newComponent, false, false, false, true, varDef ) );
      componentContainer.doLayout();
      componentContainer.ownerCt.doLayout();
    },
    getColumnVarIds: function( columns ) {
    	var ids = new Array();
    	
    	if ( !Ext.isEmpty( columns ) ) {
    		Ext.each( columns, function( column, index, allColumns ) {
    			ids.push( column.varId );
    		} );
    	}
    	
    	return ids;
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.defPanel.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );