Ext.ux.suncode.VariableDefWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var variable = config.variable;
    var winTitle = !Ext.isEmpty( variable ) ? getTranslation( 'Definicja zmiennej procesu' ) + ' ' + variable.name :
    	getTranslation( 'Kreator zmiennej procesu' );
    var buttons = new Array();
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this,
        ref: 'saveBtn'
    } );
    if ( !Ext.isEmpty( variable ) ) {
    	buttons.push( {
    		cls: 'x-btn-icon',
            icon: getPluginImgPath( 'utilization' ),
            tooltip: getTranslation( 'Pokaż wykorzystanie' ),
            handler: this.showUtilization,
            scope: this,
            ref: 'showUtilizationBtn'
        } );
    }
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this,
        ref: 'closeBtn'
    } );

    config = Ext.apply( {
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: [ new Ext.ux.suncode.VariableDefPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } )
    }, config );

    Ext.ux.suncode.VariableDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.VariableDefWindow.superclass.initComponent.call( this );

        this.on( 'resize', this.onWindowResize ,this );
        this.on( 'show', windowUp, this );
    },
    onWindowResize: function( win, width, height  ) {
      var varDefPanel = this.varDefPanel;

      if ( !Ext.isEmpty( varDefPanel.parametersItem ) ) {
        var parametersItem = varDefPanel.parametersItem;
        parametersItem.recalculateTableWidths();
      }
    },
    onBodyResize: function() {
        var viewHeight = Ext.getBody().getViewSize().height;
        var winHeight = this.getHeight();

        if ( winHeight > viewHeight * 0.9 ) {
            this.setHeight( viewHeight * 0.9 );
            this.doLayout();
        }

        this.syncShadow();
    },
    saveForm: function() {
        this.varDefPanel.saveForm();
    },
    showUtilization: function() {
    	this.varDefPanel.showUtilization();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.VariableDefPanel = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();
	  var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var variable = config.variable;
    var forcedPlacement = config.forcedPlacement;
    var typeLabel = addTooltipToField( getTranslation( 'Typ' ), null, 'ProcessVariablesTypes' );
    var descrLabel = addTooltipToField( getTranslation( 'Opis' ), getTranslation( 'Wyświetlany w podpowiedzi obok nazwy zmiennej na formularzu' ) );
    var requirementLabel = addTooltipToField( getTranslation( 'Wymagalność' ),
                    getTranslation( 'Określa konieczność podania wartości pola przed akceptacją zadania' ) );
    var readOnlyLabel = addTooltipToField( getTranslation( 'Tylko do odczytu' ), getTranslation( 'Określa możliwość edycji wartości pola' ) );
    var dtHiddenLabel = addTooltipToField( getTranslation( 'Ukryta' ), getTranslation( 'Określa, czy kolumna jest ukryta' ) );
    var dtSizeLabel = addTooltipToField( getTranslation( 'Szerokość kolumny' ),
                    getTranslation( 'Szerokość w pikselach, dla 0 - standardowa szerokość' ) );
    var dtMinSizeLabel = addTooltipToField( getTranslation( 'Minimalna szerokość kolumny' ),
                    getTranslation( 'Szerokość w pikselach, dla 0 - standardowa szerokość' ) );
    var dtMenuDisabledLabel = addTooltipToField( getTranslation( 'Blokada menu' ),
                    getTranslation( 'Informuje czy rozwijane menu kolumny jest wyłączone' ) );
    var dtAlignLabel = addTooltipToField( getTranslation( 'Wyrównanie' ), getTranslation( 'Wyrównanie zawartości kolumny' ) + '<br>'
                    + getTranslation( 'wartość domyślna: Wyśrodkowanie, dla wartości liczbowych: Wyrównanie do prawej' ) );
    var dtAllowDecimalsLabel = addTooltipToField( getTranslation( 'Zezwól na dziesiętne' ),
                    getTranslation( 'Określa, czy kolumna może posiadać wartości dziesiętne' ) );
    var dtSortableLabel = addTooltipToField( getTranslation( 'Sortowalna' ), getTranslation( 'Określa możliwość sortowania wartości w kolumnie' ) );
    var dtGroupableLabel = addTooltipToField( getTranslation( 'Grupowalna' ), getTranslation( 'Określa możliwość grupowania wartości w kolumnie' ) );
    var dtParamsLabel = addTooltipToField( getTranslation( 'Parametry w tabeli dynamicznej' ), null, 'ProcessVariablesDTParams' );
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
    var eventTypes = mainPanel.getEventTypesForVariable();
    var eventActionsCategories = mainPanel.getEventActionsCategories();
    var specification = variable ? Ext.ux.suncode.DocumentationService.getVariableSpecification( processNode, variable.id ) : new Object();

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        border: false,
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'varDefPanel',
        loadVarDef: true,
        layoutConfig: {
            trackLabels: true
        },
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Identyfikator' ),
            ref: 'idItem',
            allowBlank: true,
            value: variable ? variable.id : '',
            readOnly: config.forcedId,
            hidden: !config.AV,
            idMaxLength: Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH,
            idChanged: !Ext.isEmpty( variable ),
            afterSetIdFunction: function( oldId, newId ) {
                var newName = this.nameItem.getValue();
                this.updateDCConf( oldId, newId, newName );
            },
            afterSetIdScope: this
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa' ),
        	ref: 'nameItem',
        	field: {
                xtype: 'textfield',
                value: variable ? variable.name : '',
                readOnly: config.forcedId,
                listeners: {
                    scope: this,
                    blur: function( field ) {
                        var newName = field.getValue();
                        var oldVarId = this.idItem.getValue();

                        if ( !variable ) {
                            var varId = generateId( newName, Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH );
                            this.idItem.setValue( varId );
                            this.updateDCConf( oldVarId, varId, newName );
                        } else {
                        	this.updateDCConf( oldVarId, oldVarId, newName );
                        }
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.idItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę zmiennej procesu.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy zmiennej procesu' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(',
            keyPostfix: ')',
            saveToCache: Ext.isEmpty( variable ),
            initialId: variable ? variable.id : null
        } ), new Ext.ux.suncode.TypesChooser( {
            utilization: 'extended',
            label: typeLabel,
            typeItemValue: !Ext.isEmpty( config.forcedType ) ? config.forcedType : variable ? variable.type : '',
            readOnly: !Ext.isEmpty( config.forcedType ),
            forbiddenTypes: config.forbiddenTypes,
            listeners: {
                scope: this,
                beforeselect: function( combo, record, index ) {
                    var type = record.get( 'type' );

                    if ( type == 'DATA_CHOOSER' && Ext.isEmpty( this.nameItem.getValue() ) ) {
                        combo.collapse();
                        showWarn( getTranslation( 'Podaj nazwę zmiennej procesu.' ) );
                        return false;
                    }

                    var forbiddenTypes = [ 'RADIOBUTTON', 'BOOLEAN', 'DATETIME' ];

                    if ( !Ext.isEmpty( variable ) && variable.placement === 'table' && forbiddenTypes.indexOf( type ) != -1 ) {
                      combo.collapse();
                      showWarn( getTranslation( 'Wybrany typ zmiennej nie może znajdować się w tabeli.' ) );
                      return false;
                    }
                },
                select: function( combo, record, index ) {
                	this.buildTypeDependantItems( combo.getValue() );
                }
            }
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: descrLabel,
        	ref: 'descrItem',
        	field: {
                xtype: 'textarea',
                inputType: 'text',
                value: variable ? variable.descr : ''
            },
            getIdFieldFunction: function() {
            	return this.idItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę zmiennej procesu.' ),
            windowTitle: getTranslation( 'Tłumaczenia opisu zmiennej procesu' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(',
            keyPostfix: ')_DESC',
            saveToCache: Ext.isEmpty( variable ),
            initialId: variable ? variable.id : null,
            multilineTranslationFields: true
        } ), {
            xtype: 'checkbox',
            fieldLabel: requirementLabel,
            ref: 'requirementItem',
            checked: variable ? variable.requirement : '',
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: readOnlyLabel,
            ref: 'readonlyItem',
            checked: variable ? variable.readonly : '',
            inputValue: 'true'
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Data utworzenia' ),
            anchor: '100%',
            value: variable ? variable.creationDate : ''
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Data modyfikacji' ),
            anchor: '100%',
            value: variable ? variable.modificationDate : ''
        }, {
          xtype: 'panel',
          layout: 'accordion',
          layoutConfig: {
            animate: animationsOn,
            fill: false
          },
          style: {
            marginBottom: '5px'
          },
          bodyStyle: {
            border: 0
          },
          items: [ new Ext.ux.suncode.IntegrationComponentTable( {
            ref: '../formActionsTable',
            anchor: '100%',
            title: getTranslation( 'Akcje formularza' ),
            height: 250,
            hidden: !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table',
            collapsed: true,
            eventMode: false,
            components: variable ? variable.formActions : new Array(),
            allCategories: formActionsCategories,
            filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
                formActionsCategories, Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION, false ),
            processNode: processNode,
            enableCopyPasteMenu: true,
            conditionalExecutionEnabled: true,
            inactiveEnabled: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
            globalDefinition: true,
            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
            getBindToFunction: function( cmp ) {
              var destination = Ext.ux.suncode.IntegrationComponentService.getDestination(
                  cmp, Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION, false );

              return !Ext.isEmpty( destination ) ? {
                id: destination.bindTo,
                value: this.idItem.getValue()
              } : null;
            },
            getBindToScope: this,
            getComponentRegistrationFunction: function( id ) {
              return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( cmps ) {
              Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( cmps );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                if ( Ext.isFunction( func ) ) {
                  var cmps = new Array();

                  if ( !Ext.isEmpty( formActions ) ) {
                    var service = Ext.ux.suncode.IntegrationComponentService;

                    Ext.each( formActions, function( cmp, index, allComponents ) {
                      var componentDef = service.getIntegrationComponent( formActionsCategories, cmp.id );

                      if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.VARIABLE_DESTINATION ) ) {
                        cmps.push( cmp );
                      }
                    } );
                  }

                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ cmps ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
            destinationType: Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION
          } ), new Ext.ux.suncode.IntegrationComponentTable( {
            ref: '../eventActionsTable',
            anchor: '100%',
            title: getTranslation( 'Zdarzenia' ),
            height: 250,
            hidden: !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table',
            collapsed: true,
            eventMode: true,
            components: variable ? variable.eventActions : new Array(),
            eventTypes: eventTypes,
            allCategories: eventActionsCategories,
            filteredCategories: eventActionsCategories,
            processNode: processNode,
            enableCopyPasteMenu: true,
            conditionalExecutionEnabled: true,
            inactiveEnabled: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
            globalDefinition: true,
            getComponentRegistrationFunction: function( id ) {
              return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( cmps ) {
              Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( cmps );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
                if ( Ext.isFunction( func ) ) {
                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ eventActions ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType
          } ) ]
        }, new Ext.ux.suncode.SpecificationDescriptionArea( {
            processNode: processNode,
            description: specification.description
        } ), {
            xtype: 'panel',
            layout: 'form',
            layoutConfig: {
                trackLabels: true
            },
            frame: false,
            bodyCssClass: 'x-Module-container-padding',
            title: dtParamsLabel,
            iconCls: 'x-Module-dtParamsPanel',
            collapsible: true,
            collapsed: true,
            titleCollapse: true,
            animCollapse: Ext.getCmp( 'main_panel' ).getAnimationsOn(),
            ref: 'dtParamsPanel',
            hidden: true,
            items: [ {
                xtype: 'checkbox',
                fieldLabel: dtHiddenLabel,
                ref: 'dtHiddenItem',
                checked: variable ? variable.dtHidden : false,
                inputValue: 'true'
            }, {
                xtype: 'numberfield',
                fieldLabel: dtSizeLabel,
                allowDecimals: false,
                allowNegative: false,
                anchor: '95%',
                ref: 'dtSizeItem',
                value: variable ? variable.dtSize : 0
            }, {
                xtype: 'numberfield',
                fieldLabel: dtMinSizeLabel,
                allowDecimals: false,
                allowNegative: false,
                anchor: '95%',
                ref: 'dtMinSizeItem',
                value: variable ? variable.dtMinSize : 0
            }, {
                xtype: 'checkbox',
                fieldLabel: dtMenuDisabledLabel,
                ref: 'dtMenuDisabledItem',
                checked: variable ? variable.dtMenuDisabled : true,
                inputValue: 'true'
            }, new Ext.ux.suncode.AlignmentsChooser( {
                AV: config.AV,
                anchor: '95%',
                ref: 'dtAlignItem',
                label: dtAlignLabel,
                value: variable ? variable.dtAlign : ''
            } ), new Ext.ux.suncode.DecimalSeparatorsChooser( {
                groupName: 'numeric',
                anchor: '95%',
                value: variable ? variable.dtDecimalSeparator : ''
            } ), {
                xtype: 'checkbox',
                groupName: 'numeric',
                fieldLabel: dtAllowDecimalsLabel,
                ref: 'dtAllowDecimalsItem',
                checked: variable ? variable.dtAllowDecimals : true,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: dtSortableLabel,
                ref: 'dtSortableItem',
                checked: variable ? variable.dtSortable : false,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: dtGroupableLabel,
                ref: 'dtGroupableItem',
                checked: variable ? variable.dtGroupable : true,
                inputValue: 'true'
            } ],
            listeners: {
                scope: this,
                collapse: this.onDtParamsPanelToggle,
                expand: this.onDtParamsPanelToggle
            }
        } ]
    }, config );

    Ext.ux.suncode.VariableDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.VariableDefPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
    	var variable = this.initialConfig.variable;
    	var forcedType = this.initialConfig.forcedType;
    	var type = !Ext.isEmpty( forcedType ) ? forcedType : variable ? variable.type : '';
    	
        this.buildTypeDependantItems( type );
    },
    buildTypeDependantItems: function( type ) {
    	var dcAlignLabel = addTooltipToField( getTranslation( 'Wyrównanie' ), getTranslation( 'Wyrównanie poziome' ) + '<br>'
                + getTranslation( 'wartość domyślna: Wyśrodkowanie dla listy, Wyrównanie do lewej dla okna' ) );
    	this.removeAdditionals( this.typeItem );
        var insertPos = getInsertPos( this, this.typeItem );
        var systemDecimalSeparator = Ext.getCmp( 'main_panel' ).getSystemDecimalSeparator();
        var processNode = this.initialConfig.processNode;
        var variable = this.initialConfig.variable;
        var forcedPlacement = !Ext.isEmpty( this.initialConfig.forcedPlacement )
        	? this.initialConfig.forcedPlacement : variable ? variable.placement : '';
        var advancedView = this.initialConfig.AV;
        var mainPanel = Ext.getCmp( 'main_panel' );
    	var compatibilityMode = mainPanel.getCompatibilityMode();

        switch ( type ) {
            case 'STRING':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ExtendedType( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'TEXTAREA':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.RememberSize( {
                  AV: advancedView,
                  loadVarDef: this.loadVarDef,
                  variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'INTEGER':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
            		this.dtParamsPanel.dtDecimalSeparatorItem.hide();
                this.dtParamsPanel.dtAllowDecimalsItem.hide();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormatPreview( {
                    format: ( variable && this.loadVarDef ) ? variable.format : '0,000',
                    thousandSeparator: ( variable && this.loadVarDef ) ? variable.thousandSeparator : '',
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormat( {
                    format: ( variable && this.loadVarDef ) ? variable.format : '0,000'
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ThousandSeparator( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forbiddenSeparator: systemDecimalSeparator,
                    listeners: {
                    	scope: this,
                    	select: function() {
                    		this.updateNumberFormat( type );
                    	}
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.NumberInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    decimals: false,
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: function( combo, record, index ) {
                    		var chosenPlacement = combo.getValue();
                    		
                    		switch ( chosenPlacement ) {
                    			case 'table':
                    				this.dtParamsPanel.show();
                    				this.dtParamsPanel.dtDecimalSeparatorItem.hide();
                            this.dtParamsPanel.dtAllowDecimalsItem.hide();
                            this.formActionsTable.hide();
                            this.eventActionsTable.hide();
                    				break;
                    			default:
                    				this.dtParamsPanel.hide();
                            this.formActionsTable.show();
                            this.eventActionsTable.show();
                    				break;
                    		}
                    	}
                    }
                } ) );
                break;
            case 'FLOAT':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
            		this.dtParamsPanel.dtDecimalSeparatorItem.show();
                this.dtParamsPanel.dtAllowDecimalsItem.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormatPreview( {
                    format: ( variable && this.loadVarDef ) ? variable.format : '0,000.00',
                    thousandSeparator: ( variable && this.loadVarDef ) ? variable.thousandSeparator : '',
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormat( {
                    format: ( variable && this.loadVarDef ) ? variable.format : '0,000.00'
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.DisplayedDecimalPrecision( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    enableKeyEvents: true,
                    listeners: {
                    	scope: this,
                    	keyup: function() {
                    		this.updateNumberFormat( type );
                    	}
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.DecimalPrecision( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ThousandSeparator( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forbiddenSeparator: systemDecimalSeparator,
                    listeners: {
                    	scope: this,
                    	select: function() {
                    		this.updateNumberFormat( type );
                    	}
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.NumberInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    decimals: true,
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: function( combo, record, index ) {
                    		var chosenPlacement = combo.getValue();
                    		
                    		switch ( chosenPlacement ) {
                    			case 'table':
                    				this.dtParamsPanel.show();
                    				this.dtParamsPanel.dtDecimalSeparatorItem.show();
                            this.dtParamsPanel.dtAllowDecimalsItem.show();
                            this.formActionsTable.hide();
                            this.eventActionsTable.hide();
                    				break;
                    			default:
                    				this.dtParamsPanel.hide();
                            this.formActionsTable.show();
                            this.eventActionsTable.show();
                    				break;
                    		}
                    	}
                    }
                } ) );
                break;
            case 'DATE':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableDateFormatChooser( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'DATETIME':
                this.dtParamsPanel.hide();
                if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                    this.formActionsTable.hide();
                    this.eventActionsTable.hide();
                  } else {
                    this.formActionsTable.show();
                    this.eventActionsTable.show();
                  }
                }
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type
                } ) );
                break;
            case 'BOOLEAN':
                this.dtParamsPanel.hide();
                if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                    this.formActionsTable.hide();
                    this.eventActionsTable.hide();
                  } else {
                    this.formActionsTable.show();
                    this.eventActionsTable.show();
                  }
                }
                this.insert( insertPos, new Ext.ux.suncode.BooleanInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                break;
            case 'AMOUNT':
                if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.showDtPanelItemsByGroupName( 'numeric' );
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                    this.dtParamsPanel.show();
                    this.formActionsTable.hide();
                    this.eventActionsTable.hide();
                  } else {
                    this.dtParamsPanel.hide();
                    this.formActionsTable.show();
                    this.eventActionsTable.show();
                  }
                }
                this.insert( insertPos, new Ext.ux.suncode.Regex( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormatPreview( {
                    format: ( variable && this.loadVarDef ) ? variable.format : '0,000.00',
                    thousandSeparator: ( variable && this.loadVarDef ) ? variable.thousandSeparator : '',
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariableNumberFormat( {
                	format: ( variable && this.loadVarDef ) ? variable.format : '0,000.00'
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.DecimalPrecision( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ThousandSeparator( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forbiddenSeparator: systemDecimalSeparator,
                    listeners: {
                    	scope: this,
                    	select: function() {
                    		this.updateNumberFormat( type );
                    	}
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.NumberInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    decimals: true,
                    decimalSeparator: systemDecimalSeparator
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: function( combo, record, index ) {
                    		var chosenPlacement = combo.getValue();
                    		
                    		switch ( chosenPlacement ) {
                    			case 'table':
                    				this.dtParamsPanel.show();
                    				this.dtParamsPanel.dtDecimalSeparatorItem.show();
                            this.dtParamsPanel.dtAllowDecimalsItem.show();
                            this.formActionsTable.hide();
                            this.eventActionsTable.hide();
                    				break;
                    			default:
                    				this.dtParamsPanel.hide();
                            this.formActionsTable.show();
                            this.eventActionsTable.show();
                    				break;
                    		}
                    	}
                    }
                } ) );
                break;
            case 'CHECKBOX':
                if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                    this.dtParamsPanel.show();
                    this.formActionsTable.hide();
                    this.eventActionsTable.hide();
                  } else {
                    this.dtParamsPanel.hide();
                    this.formActionsTable.show();
                    this.eventActionsTable.show();
                  }
                }
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type,
                    hideTrigger: true
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.CheckboxChoice( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                  AV: advancedView,
                  loadVarDef: this.loadVarDef,
                  variable: variable,
                  forcedPlacement: forcedPlacement,
                  listeners: {
                    scope: this,
                    select: this.onPlacementSelect
                  }
                } ) );
                break;
            case 'RADIOBUTTON':
              this.dtParamsPanel.hide();
              if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
              } else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
              }
              this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                AV: advancedView,
                loadVarDef: this.loadVarDef,
                variable: variable,
                type: type,
                hideTrigger: true
              } ) );
              this.insert( insertPos, new Ext.ux.suncode.ValuesList( {
                AV: advancedView,
                loadVarDef: this.loadVarDef,
                variable: variable,
                valueEditor: new Ext.form.TextField()
              } ) );
              break;
            case 'LISTBOX':
            case 'LISTBOX_EDIT':
            case 'LISTBOX_NO_FILTER':
            case 'LISTBOX_EDIT_NO_FILTER':
            case 'LISTBOX_NO_LAZY':
            case 'LISTBOX_NO_FILTER_NO_LAZY':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                var listboxVariablesChooser = new Ext.ux.suncode.ListboxVariablesChooser( {
                    processNode: processNode
                } );
                this.insert( insertPos, new Ext.ux.suncode.AlignmentsChooser( {
                    AV: advancedView,
                    ref: 'dcAlignItem',
                    label: dcAlignLabel,
                    value: variable ? variable.dcAlign : ''
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type,
                    hideTrigger: true
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ValuesList( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    valueEditor: listboxVariablesChooser,
                    valueRenderer: Ext.util.Format.ComboBoxRenderer( listboxVariablesChooser )
                } ) );
                this.insert( insertPos, {
                    xtype: 'checkbox',
                    fieldLabel: addTooltipToField( getTranslation( 'Zainicjowana' ), null, null, true ),
                    ref: 'initializedListboxItem',
                    hidden: !compatibilityMode.showListboxVariableInitializedOption( type ),
                    checked: type === 'LISTBOX_NO_LAZY' || type === 'LISTBOX_NO_FILTER_NO_LAZY',
                    disabled: type === 'LISTBOX_EDIT' || type === 'LISTBOX_EDIT_NO_FILTER',
                    inputValue: 'true',
                    additional: true
                } );
                this.insert( insertPos, {
                    xtype: 'checkbox',
                    fieldLabel: getTranslation( 'Filtrowana' ),
                    ref: 'filteredListboxItem',
                    checked: type === 'LISTBOX'
                    	|| type === 'LISTBOX_EDIT'
                    	|| type === 'LISTBOX_NO_LAZY',
                    inputValue: 'true',
                    additional: true
                } );
                this.insert( insertPos, {
                    xtype: 'checkbox',
                    fieldLabel: getTranslation( 'Edytowalna' ),
                    ref: 'editableListboxItem',
                    checked: type === 'LISTBOX_EDIT' || type === 'LISTBOX_EDIT_NO_FILTER',
                    inputValue: 'true',
                    additional: true,
                    listeners: {
                    	scope: this,
                    	check: function( field, checked ) {
                    		var initializedListboxItem = this.initializedListboxItem;
                    		
                    		if ( checked ) {
                    			initializedListboxItem.setValue( false );
                    			initializedListboxItem.disable();
                    		} else {
                    			initializedListboxItem.enable();
                    		}
                    	}
                    }
                } );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'DATA_CHOOSER':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                var standardDataChooser = null;
                var componentDef = null;
                var categories = Ext.getCmp( 'main_panel' ).getDataChoosersIntegrationComponentCategories();
                if ( variable ) {
                    standardDataChooser = Ext.getCmp( 'main_panel' ).getStandardDataChooserByClasspath( variable.classpath );
                }
                if ( this.loadVarDef && variable && !Ext.isEmpty( variable.definition.id ) ) {
                	componentDef = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponent( categories,
                			variable.definition.id );
                }
                this.insert( insertPos, new Ext.ux.suncode.AutoMappingPanel( {
                    AV: advancedView,
                    ref: 'autoMappingPanel',
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.AlignmentsChooser( {
                    AV: advancedView,
                    ref: 'dcAlignItem',
                    label: dcAlignLabel,
                    value: variable ? variable.dcAlign : '',
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ExtendedType( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.StringDateInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    type: type
                } ) );
                if ( ( this.loadVarDef && ( !variable || Ext.isEmpty( variable.definition.id ) ) )
                		|| !this.loadVarDef ) {
                	this.insert( insertPos, new Ext.ux.suncode.CustomKeys( {
                        AV: advancedView,
                        loadVarDef: this.loadVarDef,
                        variable: variable,
                        processNode: processNode,
                        standardDataChooser: standardDataChooser
                    } ) );
                }
                var mappingsTable = new Ext.ux.suncode.Mappings( {
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    processNode: processNode,
                    variableDefPanel: this,
                    standardDataChooser: standardDataChooser,
                    integrationComponentDefinition: componentDef
                } );
                this.insert( insertPos, mappingsTable );
                if ( this.loadVarDef && variable && !Ext.isEmpty( variable.definition.id ) ) {
                	if ( !Ext.isEmpty( componentDef ) ) {
                		var componentReg = Ext.ux.suncode.IntegrationComponentService.
                			getDataChooserRegistration( variable.definition.id );
                		
                    	var customForm = new Object();
                        customForm = Ext.apply( {
                            fields: deepObjectCopy( componentDef.parameters ),
                            values: variable.definition.parameters,
                            buildForm: !Ext.isEmpty( componentReg ) ? componentReg.buildForm : null,
                            validateForm: !Ext.isEmpty( componentReg ) ? componentReg.validateForm : null,
                            apiVersion: !Ext.isEmpty( componentReg ) ? componentReg.apiVersion : null
                        }, customForm );
                        
                    	this.insert( insertPos, new Ext.form.TextField( {
                            ref: 'integrationComponentIdItem',
                            hidden: true,
                            value: variable.definition.id,
                            additional: true
                        } ) );
                        this.insert( insertPos, new Ext.ux.suncode.CustomForm( {
                    		title: getTranslation( 'Parametry' ),
                            ref: 'parametersItem',
                            border: true,
                            style: {
                                marginBottom: '5px'
                            },
                            customDescriptionEnabled: true,
                            customForm: customForm,
                            processNode: processNode,
                            information: {
                            	deprecated: componentDef.deprecated,
                            	deprecatedMessage: getTranslation( 'Komponent jest przestarzały' ),
                              deprecationDescription: componentDef.deprecationDescription,
                        		  replacement: componentDef.replacement,
                        		  replacementMessage: getTranslation( 'Zastąpiony nowym komponentem' ),
                              nameValue: componentDef.name,
                              descriptionValue: componentDef.description,
                              documentationLink: componentDef.documentationLink
                            },
                            customDescription: variable.definition.customDescription,
                            inactive: variable.definition.inactive,
                            contextVariables: componentDef.contextVariables,
                            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                            customFormConfig: Ext.getCmp( 'main_panel' ).getCustomFormConfig(),
                            dataChooserMappingsTable: mappingsTable,
                            tableVariableAllowed: ( !Ext.isEmpty( variable ) && variable.placement === 'table' ),
                            additional: true,
                            isDataChooserInTableFunction: this.isDataChooserInTable,
                            isDataChooserInTableScope: this,
                            columnCheckboxEnabled: ( !Ext.isEmpty( variable ) && variable.placement === 'table' ),
                        } ) );
                	}
                }
                if ( ( this.loadVarDef && ( !variable || Ext.isEmpty( variable.definition.id ) ) )
                		|| !this.loadVarDef ) {
                    this.insert( insertPos, new Ext.ux.suncode.FormCriteria( {
                        loadVarDef: this.loadVarDef,
                        variable: variable,
                        processNode: processNode,
                        variableDefPanel: this,
                        standardDataChooser: standardDataChooser
                    } ) );
                }
                this.insert( insertPos, new Ext.ux.suncode.ComboQueryDelay( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ComboNoLazyInit( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ComboFilteringDisabled( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.ComboForceSelection( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.DataChooserFieldTypeChooser( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    listeners: {
                    	scope: this,
                    	afterrender: function( field ) {
                    		if ( Ext.isEmpty( variable ) || variable.sort !== 'window' ) {
                    			window.setTimeout( function() {
                    				field.hide();
                    			}, 1 );
                    		}
                    	}
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.SortChooser( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onDataChooserSortSelect
                    }
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.DataChooserClasspath( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    saveTo: this,
                    processNode: processNode
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'USERLIST':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.ExtendedType( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.RoleUsersInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'USERLISTLISTBOX':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.ExtendedType( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.RoleUsersInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            case 'ROLEUSERS':
            case 'ROLEUSERS_NO_FILTER':
            	if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
            		this.dtParamsPanel.show();
                this.formActionsTable.hide();
                this.eventActionsTable.hide();
            	} else {
                if ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement === 'table' ) {
                  this.dtParamsPanel.show();
                  this.formActionsTable.hide();
                  this.eventActionsTable.hide();
                } else {
                  this.dtParamsPanel.hide();
                  this.formActionsTable.show();
                  this.eventActionsTable.show();
                }
            	}
                this.hideDtPanelItemsByGroupName( 'numeric' );
                this.insert( insertPos, new Ext.ux.suncode.ExtendedType( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.RoleUsersInitialValue( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable
                } ) );
                this.insert( insertPos, new Ext.ux.suncode.VariablePlacements( {
                    AV: advancedView,
                    loadVarDef: this.loadVarDef,
                    variable: variable,
                    forcedPlacement: forcedPlacement,
                    listeners: {
                    	scope: this,
                    	select: this.onPlacementSelect
                    }
                } ) );
                break;
            default:
                break;
        }

        this.doLayout();
        this.ownerCt.onBodyResize();
        this.loadVarDef = false;
    },
    onDtParamsPanelToggle: function( panel ) {
        this.doLayout();
    },
    hideDtPanelItemsByGroupName: function( groupName ) {
        Ext.each( this.dtParamsPanel.items.items, function( item, index, items ) {
            if ( item.groupName === groupName ) {
                item.hide();
            }
        }, this );
    },
    showDtPanelItemsByGroupName: function( groupName ) {
        Ext.each( this.dtParamsPanel.items.items, function( item, index, items ) {
            if ( item.groupName === groupName ) {
                item.show();
            }
        }, this );
    },
    saveForm: function() {
        var id = this.idItem.getValue();
        var name = this.nameItem.getValue();
        var type = this.typeItem.getValue();
        var variable = this.initialConfig.variable;
        var processNode = this.initialConfig.processNode;
        var placement = '';

        if ( Ext.isEmpty( id ) || Ext.isEmpty( name ) ) {
            showWarn( getTranslation( 'Podaj nazwę zmiennej procesu.' ) );
            return;
        } else if ( Ext.isEmpty( type ) ) {
        	  showWarn( getTranslation( 'Wybierz typ.' ) );
            return;
        }

        if ( !variable && processNode.findVariable( id ) ) {
            showWarn( getTranslation( 'Zmienna procesu już istnieje.' ) );
            return;
        } else if ( processNode.findLabel( id ) ) {
          showWarn( getTranslation( 'Identyfikator zmiennej procesu pokrywa się z identyfikatorem etykiety.' ) );
          return;
        } else if ( variable && variable.id != id ) {

            if ( processNode.findVariable( id ) ) {
              showWarn( getTranslation( 'Zmienna procesu już istnieje.' ) );
              return;
            } else {
              var againstButtonsValidationResult = processNode.validateVariableAgainstButtons( variable.id, id );

              if ( !againstButtonsValidationResult.valid ) {
                showWarn( getTranslation( 'Identyfikator zmiennej procesu pokrywa się z identyfikatorem przycisku o nazwie' ) + ' '
                  + againstButtonsValidationResult.buttonName + ' ' + getTranslation( 'W zadaniu' ).toLowerCase() + ' '
                  + againstButtonsValidationResult.activityName + '.' );
                return;
              }
            }
        }
        
        if ( !Ext.isEmpty( this.placementItem ) ) {
        	placement = this.placementItem.getValue();
        	
        	if ( Ext.isEmpty( placement ) ) {
        		showWarn( getTranslation( 'Wybierz położenie.' ) );
            return;
        	}
        }

      if ( processNode.findFormalParam( id ) ) {
        this.showSameIdAsFormalParameterConfirmation( id, type, placement );
      } else {
        this.validateId( id, type, placement );
      }
    },
    showSameIdAsFormalParameterConfirmation: function( id, type, placement ) {
      var warnMsg = getTranslation( 'Identyfikator zmiennej procesu pokrywa się z nazwą parametru formalnego.' );
      warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

      Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: warnMsg,
        buttons: {
          yes: getTranslation( 'Tak' ),
          no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
          if ( buttonId == 'yes' ) {
            this.validateId( id, type, placement );
          }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
      } );
    },
    validateId: function( id, type, placement ) {
        var variable = this.initialConfig.variable;
        var maskId = 'variable_id_validation_mask';
        showLoadingMask( maskId, getTranslation( 'Trwa walidacja...' ) );

        Ext.Ajax.request( {
            url: 'api/xpdl/validateVariableId',
            method: 'GET',
            params: {
                variableId: id,
                previousVariableId: variable ? variable.id : null
            },
            scope: this,
            success: function( response, opts ) {
                removeLoadingMask( maskId );
                var validation = Ext.util.JSON.decode( response.responseText );

                if ( validation.correct ) {
                    this.validateType( id, type, placement );
                } else {
                    showWarn( getTranslation( 'Zabroniony identyfikator.' ) );
                }
            },
            failure: function( response, opts ) {
                removeLoadingMask( maskId );
                showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    validateType: function( id, type, placement ) {
        if ( this.shouldValidateVariableType( id, type ) ) {
            var processNode = this.initialConfig.processNode;
            var maskId = 'variable_type_validation_mask';
            showLoadingMask( maskId, getTranslation( 'Trwa walidacja...' ) );

            Ext.Ajax.request( {
                url: 'api/xpdl/validateVariableType',
                method: 'GET',
                params: {
                    processDefId: processNode.attributes.processDefId,
                    variableId: id,
                    variableType: type,
                    placement: placement
                },
                timeout: 180000,
                scope: this,
                success: function( response, opts ) {
                    removeLoadingMask( maskId );
                    var validation = Ext.util.JSON.decode( response.responseText );

                    if ( validation.correct ) {
                        this.executeSaveVariable();
                    } else {
                        this.askForTypeChange();
                    }
                },
                failure: function( response, opts ) {
                    removeLoadingMask( maskId );
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            } );
        } else {
            this.executeSaveVariable();
        }
    },
    shouldValidateVariableType: function( id, type ) {
    	var variable = this.initialConfig.variable;
    	
    	return ( !variable || variable.id !== id || variable.type !== type );
    },
    askForTypeChange: function() {
    	var warnMsg = getTranslation( 'Zmiana typu zmiennej spowoduje utratę danych dla tej zmiennej.' );
        warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );
        
    	Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                	this.executeSaveVariable();
                }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
        } );
    },
    executeSaveVariable: function() {
    	  var id = this.idItem.getValue();
        var name = this.nameItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var setToObj = this.initialConfig.setToObj;
        var variable = this.initialConfig.variable;
        var processNode = this.initialConfig.processNode;
        var processDefId = processNode.attributes.processDefId;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var type = this.typeItem.getValue();
        var initialValue = '';
        var regex = '';
        var exType = '';
        var valuesList = new Array();
        var currentDate = new Date().format( 'Y-m-d H:i:s' );
        var vObj = new Object();

        switch ( type ) {
            case 'STRING':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                exType = this.exTypeItem.getValue();
                regex = this.regexItem.getValue();

                vObj = Ext.apply( {
                    exType: exType,
                	placement: placement
                }, vObj );
                break;
            case 'TEXTAREA':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                regex = this.regexItem.getValue();

                vObj = Ext.apply( {
                	placement: placement,
                  rememberSize: this.rememberSizeItem.getValue()
                }, vObj );

                if ( variable ) {
                  var validationResult = processNode.validateTextareasInOneLine( variable.id );

                  if ( !validationResult.valid ) {
                    showWarn( validationResult.errorMessage );
                    return;
                  }
                }
                break;
            case 'INTEGER':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                var thousandSeparator = this.thousandSeparatorItem.getValue();
                regex = this.regexItem.getValue();
                
                vObj = Ext.apply( {
                	format: this.formatItem.getValue(),
                	thousandSeparator: thousandSeparator,
                	placement: placement
                }, vObj );
                break;
            case 'FLOAT':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                var thousandSeparator = this.thousandSeparatorItem.getValue();
                regex = this.regexItem.getValue();
                
                vObj = Ext.apply( {
                	format: this.formatItem.getValue(),
                	thousandSeparator: thousandSeparator,
                	decimalPrecision: this.decimalPrecisionItem.getValue(),
                	placement: placement
                }, vObj );
                break;
            case 'DATE':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                regex = this.regexItem.getValue();

                vObj = Ext.apply( {
                	format: this.formatItem.getValue(),
                	placement: placement
                }, vObj );
                break;
            case 'DATETIME':
                initialValue = this.initialValueItem.getValue();
                regex = this.regexItem.getValue();
                
                vObj = Ext.apply( {
                	placement: 'form'
                }, vObj );
                break;
            case 'BOOLEAN':
                initialValue = this.initialValueItem.getValue();
                
                vObj = Ext.apply( {
                	placement: 'form'
                }, vObj );
                break;
            case 'AMOUNT':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                var thousandSeparator = this.thousandSeparatorItem.getValue();
                regex = this.regexItem.getValue();

                vObj = Ext.apply( {
                	format: this.formatItem.getValue(),
                	thousandSeparator: thousandSeparator,
                	decimalPrecision: this.decimalPrecisionItem.getValue(),
                	placement: placement
                }, vObj );
                break;
            case 'CHECKBOX':
                var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                var checkboxChoice = this.checkboxChoiceItem.getValue();

                if ( Ext.isEmpty( checkboxChoice ) ) {
                  showWarn( getTranslation( 'Podaj wartość wyboru.' ) );
                  return;
                }
                if ( !Ext.isEmpty( initialValue ) && initialValue !== checkboxChoice ) {
                  showWarn( getTranslation( 'Wartość początkowa jest różna od wartości wyboru.' ) );
                  return;
                }

                valuesList.push( {
                  value: checkboxChoice
                } );

                vObj = Ext.apply( {
                  valuesList: valuesList,
                  placement: placement
                }, vObj );
                break;
            case 'RADIOBUTTON':
                initialValue = this.initialValueItem.getValue();
                valuesList = this.readValuesListGrid();

                if ( valuesList == null ) {
                    showWarn( getTranslation( 'Podaj wartości.' ) );
                    return;
                }
                if ( !Ext.isEmpty( initialValue ) ) {
                    var correctInitialValue = false;

                    for ( var i = 0; i < valuesList.length; i++ ) {
                        if ( valuesList[i].value == initialValue ) {
                            correctInitialValue = true;
                            break;
                        }
                    }

                    if ( !correctInitialValue ) {
                        showWarn( getTranslation( 'Wartość początkowa nie występuje na liście wartości.' ) );
                        return;
                    }
                }

                vObj = Ext.apply( {
                    valuesList: valuesList,
                    placement: 'form'
                }, vObj );
                break;
            case 'LISTBOX':
            	var editable = this.editableListboxItem.getValue();
            	var filtered = this.filteredListboxItem.getValue();
            	var initialized = this.initializedListboxItem.getValue();
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                valuesList = this.readValuesListGrid();

                if ( valuesList == null ) {
                    showWarn( getTranslation( 'Podaj wartości.' ) );
                    return;
                }
                
                if ( editable && filtered && !initialized ) {
                	type = 'LISTBOX_EDIT';
                } else if ( !editable && !filtered && !initialized ) {
                	type = 'LISTBOX_NO_FILTER';
                } else if ( editable && !filtered && !initialized ) {
                	type = 'LISTBOX_EDIT_NO_FILTER';
                } else if ( !editable && filtered && initialized ) {
                	type = 'LISTBOX_NO_LAZY';
                } else if ( !editable && !filtered && initialized ) {
                	type = 'LISTBOX_NO_FILTER_NO_LAZY';
                }

                vObj = Ext.apply( {
                    valuesList: valuesList,
                    dcAlign: this.dcAlignItem.getValue(),
                	placement: placement
                }, vObj );
                break;
            case 'USERLIST':
            case 'USERLISTLISTBOX':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                exType = this.exTypeItem.getValue();

                vObj = Ext.apply( {
                    exType: exType,
                	placement: placement
                }, vObj );
                break;
            case 'ROLEUSERS':
            case 'ROLEUSERS_NO_FILTER':
            	var placement = this.placementItem.getValue();
                initialValue = this.initialValueItem.getValue();
                exType = this.exTypeItem.getValue();

                vObj = Ext.apply( {
                    exType: exType,
                	placement: placement
                }, vObj );
                break;
            case 'DATA_CHOOSER':
            	  var placement = this.placementItem.getValue();
                var sort = this.sortItem.getValue();
                var fieldType = this.fieldTypeItem.getValue();
                var classpath = '';
                var formCriteria = new Array();
                var mappings = this.readMappingsGrid( id );
                var customKeys = new Array();
                var definition = new Object();
                definition = Ext.apply( {
                	autoMapping: this.autoMappingPanel.readAutoMapping(),
                }, definition);
                initialValue = this.initialValueItem.getValue();

                if ( Ext.isEmpty( sort ) ) {
                    showWarn( getTranslation( 'Wybierz rodzaj.' ) );
                    return;
                } else if ( Ext.isEmpty( fieldType ) ) {
                    showWarn( getTranslation( 'Wybierz typ pola.' ) );
                    return;
                } else if ( Ext.isString( mappings ) ) {
                    showWarn( mappings );
                    return;
                } else if ( Ext.isEmpty( mappings ) ) {
                    showWarn( getTranslation( 'Podaj przynajmniej jedno mapowanie wartości.' ) );
                    return;
                }
                
                if ( !Ext.isEmpty( this.integrationComponentIdItem ) ) {
                  var parameters = this.parametersItem.getParametersValues();
                  var extraConfig = this.parametersItem.getExtraConfig();

                  if ( parameters ) {
                    definition = Ext.apply( {
                      id: this.integrationComponentIdItem.getValue(),
                      customDescription: extraConfig.customDescription,
                      inactive: extraConfig.inactive,
                      parameters: parameters,
                      mappings: mappings
                    }, definition );

                    vObj = Ext.apply( {
                      mappings: new Array()
                    }, vObj );
                  } else {
                    return;
                  }
                } else {
                	classpath = this.classpathContainer.items.first().getValue();
                	formCriteria = this.readFormCriteriaGrid();
                    customKeys = this.readCustomKeysGrid();
                    
                    if ( Ext.isEmpty( classpath ) ) {
                        showWarn( getTranslation( 'Podaj ścieżkę do klasy.' ) );
                        return;
                    } else if ( formCriteria == null ) {
                        showWarn( getTranslation( 'Podaj wszystkie kryteria formalne.' ) );
                        return;
                    } else if ( customKeys == null ) {
                        showWarn( getTranslation( 'Uzupełnij poprawnie klucze własne.' ) );
                        return;
                    }
                    
                    vObj = Ext.apply( {
                        mappings: mappings
                    }, vObj );
                }

                vObj = Ext.apply( {
                    classpath: classpath,
                    sort: sort,
                    fieldType: fieldType,
                    comboForceSelection: this.comboForceSelectionItem.getValue(),
                    comboFilteringDisabled: this.comboFilteringDisabledItem.getValue(),
                    comboNoLazyInit: this.comboNoLazyInitItem.getValue(),
                    comboQueryDelay: this.comboQueryDelayItem.getValue(),
                    formCriteria: formCriteria,
                    customKeys: customKeys,
                    exType: this.exTypeItem.getValue(),
                    dcAlign: this.dcAlignItem.getValue(),
                    definition: definition,
                	  placement: placement
                }, vObj );
                break;
            default:
                showWarn( getTranslation( 'Wybierz typ.' ) );
                return;
        }

        if ( saveToObj && varRecord ) {
            if ( variable ) {
                varRecord.set( 'id', id );
                varRecord.set( 'name', getXpdlVariableNameTranslation( packageId, processDefId, id, name ) );
                varRecord.set( 'type', type );
                varRecord.set( 'placement', vObj.placement );
                varRecord.set( 'modificationDate', currentDate );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    id: id,
                    name: name,
                    type: type,
                    placement: vObj.placement,
                    creationDate: currentDate,
                    modificationDate: currentDate
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        vObj = Ext.apply( {
            id: id,
            name: name,
            type: type,
            initialValue: initialValue,
            regex: regex,
            descr: this.descrItem.getValue(),
            requirement: this.requirementItem.getValue(),
            readonly: this.readonlyItem.getValue()
        }, vObj );

        var dtParamsPanel = this.dtParamsPanel;
        var formActionsTable = this.formActionsTable;
        var eventActionsTable = this.eventActionsTable;

        if ( dtParamsPanel.hidden ) {
            vObj = Ext.apply( {
                dtHidden: false,
                dtSize: 0,
                dtMinSize: 0,
                dtMenuDisabled: true,
                dtAlign: '',
                dtDecimalSeparator: '',
                dtAllowDecimals: true,
                dtSortable: false,
                dtGroupable: true
            }, vObj );
        } else {
            vObj = Ext.apply( {
                dtHidden: this.getDtParamValue( dtParamsPanel.dtHiddenItem, false ),
                dtSize: this.getDtParamValue( dtParamsPanel.dtSizeItem, 0 ),
                dtMinSize: this.getDtParamValue( dtParamsPanel.dtMinSizeItem, 0 ),
                dtMenuDisabled: this.getDtParamValue( dtParamsPanel.dtMenuDisabledItem, true ),
                dtAlign: this.getDtParamValue( dtParamsPanel.dtAlignItem, '' ),
                dtDecimalSeparator: this.getDtParamValue( dtParamsPanel.dtDecimalSeparatorItem, '' ),
                dtAllowDecimals: this.getDtParamValue( dtParamsPanel.dtAllowDecimalsItem, true ),
                dtSortable: this.getDtParamValue( dtParamsPanel.dtSortableItem, false ),
                dtGroupable: this.getDtParamValue( dtParamsPanel.dtGroupableItem, true )
            }, vObj );
        }

        if ( formActionsTable.hidden ) {
          vObj = Ext.apply( {
            formActions: new Array()
          }, vObj );
        } else {
          vObj = Ext.apply( {
            formActions: this.formActionsTable.readComponents()
          }, vObj );
        }

        if ( eventActionsTable.hidden ) {
          vObj = Ext.apply( {
            eventActions: new Array()
          }, vObj );
        } else {
          vObj = Ext.apply( {
            eventActions: this.eventActionsTable.readComponents()
          }, vObj );
        }

        var specification = this.readSpecification();
        var translationCacheFields = [ this.nameItem, this.descrItem ];
        
        if ( type == 'DATA_CHOOSER' ) {
        	translationCacheFields = translationCacheFields.concat( this.mappingsItem.getTranslationCacheFields() );
        }
        	
        if ( variable ) {
            vObj = Ext.apply( {
              creationDate: variable.creationDate,
              modificationDate: currentDate
            }, vObj );
            processNode.updateVariable( variable, vObj );
            Ext.ux.suncode.DocumentationService.editVariableSpecification( processNode, variable.id, id, specification );
            
            if ( variable.id != id ) {
            	Ext.ux.suncode.I18NService.onVariableIdChange( processDefId, variable.id, id );
            }
            
            Ext.ux.suncode.I18NService.updatePackageTranslationsFromCaches( translationCacheFields );
        } else {
            vObj = Ext.apply( {
              creationDate: currentDate,
              modificationDate: currentDate
            }, vObj );
            processNode.addVariable( vObj );
            Ext.ux.suncode.DocumentationService.addVariableSpecification( processNode, id, specification );
            Ext.ux.suncode.I18NService.addPackageTranslationsFromCaches( translationCacheFields );
        }

        if ( setToObj ) {
            setToObj.setValue( id );

            if ( setToObj.hasListener( 'select' ) ) {
                setToObj.fireEvent( 'select', setToObj );
            }
        }
        
        var afterSaveFunction = this.initialConfig.afterSaveFunction;

        if ( Ext.isFunction( afterSaveFunction ) ) {
            var afterSaveScope = !Ext.isEmpty( this.initialConfig.afterSaveScope ) ? this.initialConfig.afterSaveScope : window;
            afterSaveFunction.apply( afterSaveScope, [ vObj ] );
        }

        this.ownerCt.closeWindow();
    },
    removeAdditionals: function( i ) {
        var items = this.items.items;
        var startRemove = false;
        var itemsToRemove = new Array();

        Ext.each( items, function( item, index, allItems ) {
            if ( startRemove && item.additional ) {
                itemsToRemove.push( item );
            }

            if ( item.getId() == i.getId() ) {
                startRemove = true;
            }
        } );

        Ext.each( itemsToRemove, function( item, index, allItemsToRemove ) {
            this.remove( item );
        }, this );

        this.doLayout();
    },
    readValuesListGrid: function() {
        var valuesList = new Array();
        var store = this.valuesListItem.getStore();
        var isOk = true;

        if ( store.getCount() == 0 ) {
            return null;
        }

        store.each( function( rec ) {
            var value = rec.get( 'value' );

            if ( Ext.isEmpty( value ) ) {
                isOk = false;
                return false;
            }

            valuesList.push( {
                value: value
            } );
        } );

        if ( !isOk ) {
            return null;
        }

        return valuesList;
    },
    readFormCriteriaGrid: function() {
        var formCriteria = new Array();
        var ok = true;
        var store = this.formCriteriaItem.getStore();

        store.each( function( rec ) {
            var varId = rec.get( 'varId' );

            if ( Ext.isEmpty( varId ) ) {
                ok = false;
                return;
            }

            formCriteria.push( {
                varId: varId
            } );
        } );

        if ( ok ) {
            return formCriteria;
        } else {
            return null;
        }
    },
    readMappingsGrid: function( currentVarId ) {
    	var mappings = null;
    	var ok = true;
        var anyDisplayAdded = false;
        var hasSelfMapping = false;
        var store = this.mappingsItem.getStore();
    	
    	if ( !Ext.isEmpty( this.integrationComponentIdItem ) ) {
    		mappings = new Object();
    		anyDisplayAdded = true;
    		var duplicatedMapping = false;
    		
    		store.each( function( rec ) {
                var id = rec.get( 'id' );
                var varId = rec.get( 'varId' );
                var verify = rec.get( 'verify' );
                var display = rec.get( 'display' );
                var hidden = rec.get( 'hidden' );

                if ( ( Ext.isEmpty( display ) && !hidden ) || Ext.isEmpty( id ) || ( verify && Ext.isEmpty( varId ) ) ) {
                    ok = false;
                    return false;
                }
                
                if ( varId === currentVarId ) {
                	hasSelfMapping = true;
                }
                
                if ( !Ext.isEmpty( mappings[id] ) ) {
                	duplicatedMapping = true;
                	return false;
                }

                mappings[id] = {
                	name: display,
                	variable: varId,
                	hidden: hidden,
                    verify: verify
                };
            } );
    		
    		if ( duplicatedMapping ) {
    			return getTranslation( 'Występują zduplikowane mapowania wartości.' );
    		}
    	} else {
    		mappings = new Array();

            store.each( function( rec ) {
                var id = rec.get( 'id' );
                var varId = rec.get( 'varId' );
                var verify = rec.get( 'verify' );
                var display = rec.get( 'display' );

                if ( Ext.isEmpty( id ) || ( verify && Ext.isEmpty( varId ) ) ) {
                    ok = false;
                    return false;
                }

                if ( !Ext.isEmpty( display ) ) {
                    anyDisplayAdded = true;
                }
                
                if ( varId === currentVarId ) {
                	hasSelfMapping = true;
                }

                mappings.push( {
                    id: id,
                    varId: varId,
                    display: display,
                    verify: verify
                } );
            } );
    	}
    	
    	if ( ok && anyDisplayAdded ) {
    		if ( hasSelfMapping ) {
    			return mappings;
    		} else {
    			return getTranslation( 'Dodaj mapowanie wartości na aktualną zmienną procesu.' );
    		}
        } else {
            return getTranslation( 'Uzupełnij poprawnie mapowania wartości.' );
        }
    },
    readCustomKeysGrid: function() {
        var customKeys = new Array();
        var ok = true;
        var store = this.customKeysItem.getStore();

        store.each( function( rec ) {
            var id = rec.get( 'id' );
            var value = rec.get( 'value' );

            if ( Ext.isEmpty( id ) || Ext.isEmpty( value ) ) {
                ok = false;
                return;
            }

            customKeys.push( {
                id: id,
                value: value
            } );
        } );

        if ( ok ) {
            return customKeys;
        } else {
            return null;
        }
    },
    onChooseDC: function( dcId ) {
        var dc = Ext.getCmp( 'main_panel' ).getStandardDataChooser( dcId );
        var javaCodeButton = this.classpathContainer.javaCodeButton;
        var classpathField = this.classpathContainer.items.first();
        classpathField.enable();
    	classpathField.setValue( dc.definition.classpath );
    	if ( javaCodeButton ) {
    		javaCodeButton.show();
    	}
    	this.remove( this.formCriteriaItem );
    	this.remove( this.mappingsItem );
    	this.remove( this.customKeysItem );
    	this.remove( this.integrationComponentIdItem );
    	this.remove( this.parametersItem );
    	this.doLayout();
    	var insertPos = getInsertPos( this, this.comboQueryDelayItem );
    	
    	this.insert( insertPos, new Ext.ux.suncode.CustomKeys( {
            AV: this.initialConfig.AV,
            loadVarDef: this.loadVarDef,
            processNode: this.initialConfig.processNode
        } ) );
    	this.insert( insertPos, new Ext.ux.suncode.Mappings( {
            loadVarDef: this.loadVarDef,
            processNode: this.initialConfig.processNode,
            variableDefPanel: this
        } ) );
    	this.insert( insertPos, new Ext.ux.suncode.FormCriteria( {
            loadVarDef: this.loadVarDef,
            processNode: this.initialConfig.processNode,
            variableDefPanel: this
        } ) );
    	
    	this.refreshView();
        
        this.fillDCGrid( this.formCriteriaItem, dc.formCriteria );
        this.fillDCGrid( this.mappingsItem, dc.mappings );
        this.fillDCGrid( this.customKeysItem, dc.customKeys );

        if ( !Ext.isEmpty( dc.mappings ) ) {
            var store = this.mappingsItem.getStore();
            var rec = store.getAt( 0 );
            rec.set( 'varId', this.idItem.getValue() );
            rec.commit();
        }

        if ( !Ext.isEmpty( dc.customKeys ) ) {
            this.customKeysItem.getColumnModel().getColumnById( 'value' ).setEditor( new Ext.ux.suncode.ValuesChooser( {} ) );
        }
    },
    fillDCGrid: function( item, records ) {
        if ( !Ext.isEmpty( records ) ) {
            var store = item.getStore();
            store.loadData( records );
            store.commitChanges();
        }
    },
    updateDCConf: function( oldVarId, varId, newName ) {
        if ( this.typeItem.getValue() == 'DATA_CHOOSER' ) {
            var mappingGrid = this.mappingsItem;
            var mappingsStore = mappingGrid.getStore();
            var mappingsCm = mappingGrid.getColumnModel();
            var mappingsEditorStore = mappingsCm.getCellEditor( mappingsCm.getIndexById( 'varId' ), 0 ).field.getStore();
            mappingsEditorStore.each( function( rec ) {
                if ( rec.get( 'id' ) == oldVarId ) {
                    rec.set( 'id', varId );
                    rec.set( 'name', newName );
                    return;
                }
            } );
            
            mappingsStore.each( function( rec ) {
                if ( rec.get( 'varId' ) == oldVarId ) {
                    rec.set( 'varId', varId );
                    rec.commit();
                }
            } );

            if ( Ext.isEmpty( this.integrationComponentIdItem ) ) {
            	var formCriteriaGrid = this.formCriteriaItem;
                var formCriteriaStore = formCriteriaGrid.getStore();
                var formCriteriaCm = formCriteriaGrid.getColumnModel();
                var formCriteriaEditorStore = formCriteriaCm.getCellEditor( formCriteriaCm.getIndexById( 'varId' ), 0 ).field.getStore();
                formCriteriaEditorStore.each( function( rec ) {
                    if ( rec.get( 'id' ) == oldVarId ) {
                        rec.set( 'id', varId );
                        rec.set( 'name', newName );
                        return;
                    }
                } );

                formCriteriaStore.each( function( rec ) {
                    if ( rec.get( 'varId' ) == oldVarId ) {
                        rec.set( 'varId', varId );
                        rec.commit();
                    }
                } );
            }
        }
    },
    refreshView: function() {
    	this.doLayout();
    	this.doLayout();
    	this.ownerCt.onBodyResize();
    },
    getDtParamValue: function( field, defaultValue ) {
        return field.hidden ? defaultValue : field.getValue();
    },
    updateNumberFormat: function( varType ) {
    	var decimalPrecision = 0;
    	
    	switch ( varType ) {
	    	case 'FLOAT':
	    		decimalPrecision = this.displayedDecimalPrecisionItem.getValue();
	    		break;
	    	case 'AMOUNT':
	    		decimalPrecision = 2;
	    		break;
    		default:
    			break;
    	}
    	
    	var format = this.buildNumberFormat( decimalPrecision );
    	var thousandSeparator = this.thousandSeparatorItem.getValue();
    	var decimalSeparator = Ext.getCmp( 'main_panel' ).getSystemDecimalSeparator();
    	
    	this.formatItem.setValue( format );
    	this.formatPreviewItem.updatePreview( format, thousandSeparator, decimalSeparator );
    },
    buildNumberFormat: function( decimalPrecision ) {
    	var format = '0,000';

        if ( decimalPrecision > 0 ) {
            format += '.';

            for ( var i = 0; i < decimalPrecision; i++ ) {
                format += '0';
            }
        }

        return format;
    },
    onPlacementSelect: function( combo, record, index ) {
    	var type = this.typeItem.getValue();
		  var chosenPlacement = combo.getValue();
		
		switch ( chosenPlacement ) {
			case 'table':
				this.dtParamsPanel.show();
        this.formActionsTable.hide();
        this.eventActionsTable.hide();
				
				if ( type == 'DATA_CHOOSER' ) {
					if ( !Ext.isEmpty( this.integrationComponentIdItem ) ) {
						var parametersItem = this.parametersItem;
						parametersItem.rebuildParameters();
						parametersItem.setTableVariableAllowed( true );
						parametersItem.setColumnCheckboxEnabled( true );
					}
					
					var sortItem = this.sortItem;
					sortItem.setValue( 'combobox' );
					sortItem.disable();
					var fieldTypeItem = this.fieldTypeItem;
					fieldTypeItem.hide();
					fieldTypeItem.setValue( 'string' );
					this.mappingsItem.onPlacementChanged( chosenPlacement );
				} else if ( type == 'STRING' ) {
          var exTypeItem = this.exTypeItem;
          exTypeItem.onPlacementChanged( chosenPlacement );
        }
				break;
			default:
				this.dtParamsPanel.hide();
        this.formActionsTable.show();
        this.eventActionsTable.show();
			
				if ( type == 'DATA_CHOOSER' ) {
					if ( !Ext.isEmpty( this.integrationComponentIdItem ) ) {
						var parametersItem = this.parametersItem;
						parametersItem.rebuildParameters();
						parametersItem.setTableVariableAllowed( false );
						parametersItem.setColumnCheckboxEnabled( false );
					}
					
					var sortItem = this.sortItem;
					sortItem.enable();
					this.mappingsItem.onPlacementChanged( chosenPlacement );
				} else if ( type == 'STRING' ) {
          var exTypeItem = this.exTypeItem;
          exTypeItem.onPlacementChanged( chosenPlacement );
        }
				break;
		}
	},
	onDataChooserSortSelect: function( combo, record, index ) {
		var sort = combo.getValue();
		
		if ( sort === 'window' ) {
			this.fieldTypeItem.show();
		} else {
			this.fieldTypeItem.hide();
			this.fieldTypeItem.setValue( 'string' );
		}
	},
	isDataChooserInTable: function() {
		var type = this.typeItem.getValue();
		
		if ( type === 'DATA_CHOOSER' ) {
			var placement = this.placementItem.getValue();
			
			return placement === 'table';
		} else {
			return false;
		}
	},
	showUtilization: function() {
    var varId = this.idItem.getValue();
    var name = this.nameItem.getValue();

    if ( Ext.isEmpty( id ) || Ext.isEmpty( name ) ) {
      showWarn( getTranslation( 'Podaj nazwę zmiennej procesu.' ) );
      return;
    }

    var win = new Ext.ux.suncode.VariableUtilizationWindow( {
      windowTitle: getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + name,
      showCustomDescription: true,
      showVariableUtilizationActions: true,
      enableRemoveAll: false,
      processNode: this.initialConfig.processNode,
      variableId: varId
    } );
    win.show();
	},
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.SortChooser = function( config ) {
    var label = addTooltipToField( getTranslation( 'Rodzaj' ), getTranslation( 'Typ komponentu dynamicznej listy' ) );
    var sorts = [ [ 'combobox', getTranslation( 'Lista' ) ], [ 'window', getTranslation( 'Okno' ) ] ];
    var forcedPlacement = config.forcedPlacement;

    var sortItemValue = 'combobox';

    var variable = config.variable;
    var loadVarDef = config.loadVarDef;
    if ( variable && loadVarDef ) {
        sortItemValue = variable.sort;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'sortItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'sort', 'sortName' ],
            data: sorts
        } ),
        valueField: 'sort',
        displayField: 'sortName',
        forceSelection: true,
        editable: false,
        disabled: ( !Ext.isEmpty( forcedPlacement ) && forcedPlacement == 'table' ) ||
        	( loadVarDef && variable && variable.placement == 'table' ),
        value: sortItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.SortChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.SortChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.SortChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.DataChooserFieldTypeChooser = function( config ) {
    var fieldTypes = [ [ 'string', getTranslation( 'Tekstowy' ) ], [ 'textarea', getTranslation( 'Pole tekstowe' ) ] ];

    var fieldTypeItemValue = 'string';

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
    	fieldTypeItemValue = variable.fieldType;
    }

    config = Ext.apply( {
        fieldLabel: getTranslation( 'Typ pola' ),
        anchor: '100%',
        ref: 'fieldTypeItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'type', 'typeName' ],
            data: fieldTypes
        } ),
        valueField: 'type',
        displayField: 'typeName',
        forceSelection: true,
        editable: false,
        value: fieldTypeItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.DataChooserFieldTypeChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DataChooserFieldTypeChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.DataChooserFieldTypeChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.NumberInitialValue = function( config ) {
    var label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' ) );
    var variable = config.variable;

    config = Ext.apply( {
        allowDecimals: config.decimals,
        decimalPrecision: 10,
        fieldLabel: label,
        anchor: '100%',
        ref: 'initialValueItem',
        value: ( variable && config.loadVarDef ) ? variable.initialValue : '',
        additional: true
    }, config );

    Ext.ux.suncode.NumberInitialValue.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.NumberInitialValue, Ext.form.NumberField, {
    initComponent: function() {
        Ext.ux.suncode.NumberInitialValue.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.BooleanInitialValue = function( config ) {
    var variable = config.variable;
    var label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' )
                    + '.<br>' + getTranslation( 'Wybierz opcję z listy' ) );
    var initValues = [ [ 'TRUE', getTranslation( 'Prawda' ) ], [ 'FALSE', getTranslation( 'Fałsz' ) ] ];

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'initialValueItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'initialValue', 'initialValueName' ],
            data: initValues
        } ),
        valueField: 'initialValue',
        displayField: 'initialValueName',
        forceSelection: true,
        value: ( variable && config.loadVarDef ) ? variable.initialValue : '',
        additional: true,
        editable: false
    }, config );

    Ext.ux.suncode.BooleanInitialValue.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.BooleanInitialValue, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.BooleanInitialValue.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.RememberSize = function( config ) {
  var rememberSizeItemValue = false;

  var variable = config.variable;
  if ( variable && config.loadVarDef ) {
    rememberSizeItemValue = variable.rememberSize;
  }

  config = Ext.apply( {
    fieldLabel: getTranslation( 'Zapamiętuj wymiary' ),
    anchor: '100%',
    ref: 'rememberSizeItem',
    checked: rememberSizeItemValue,
    inputValue: 'true',
    additional: true
  }, config );

  Ext.ux.suncode.RememberSize.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RememberSize, Ext.form.Checkbox, {
  initComponent: function() {
    Ext.ux.suncode.RememberSize.superclass.initComponent.call( this );
  }
} );


Ext.ux.suncode.Regex = function( config ) {
    var label = addTooltipToField( getTranslation( 'Wyrażenie regularne' ),
                    getTranslation( 'Określa dodatkową walidację pola podczas akceptacji zadania.' ) + '<br>'
                                    + getTranslation( 'Wyrażenie powinno być w języku Java' ) );
    var regexItemValue = '';

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        regexItemValue = variable.regex;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'regexItem',
        value: regexItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.Regex.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.Regex, Ext.form.TextField, {
    initComponent: function() {
        Ext.ux.suncode.Regex.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.StringDateInitialValue = function( config ) {
    var variable = config.variable;
    var label = null;
    var initValues = null;
    var type = config.type;
    var forceSelection = true;

    if ( type == 'DATE' ) {
        label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' )
                        + '.<br>' + getTranslation( 'Wybierz opcję z listy' ) );
        initValues = [ [ '<CURRENTDATE>', getTranslation( 'Obecna data' ) ] ];
    } else if ( type == 'DATETIME' ) {
        label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' )
                        + '.<br>' + getTranslation( 'Wybierz opcję z listy' ) );
        initValues = [ [ '<CURRENTTIME>', getTranslation( 'Obecna data i czas' ) ] ];
    } else if ( type == 'STRING' || type == 'TEXTAREA' || type == 'DATA_CHOOSER' ) {
        label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' )
                        + '.<br>' + getTranslation( 'Wybierz opcję z listy lub podaj własną wartość' ) );
        initValues = [ [ '<CURRENTDATE>', getTranslation( 'Obecna data' ) ], [ '<CURRENTTIME>', getTranslation( 'Obecna data i czas' ) ],
                        [ '<INITIATOR>', getTranslation( 'Inicjator procesu: login' ) ],
                        [ '<INITIATORFULLNAME>', getTranslation( 'Inicjator procesu: imię i nazwisko' ) ],
                        [ '<INITIATORFULLNAMEREVERSED>', getTranslation( 'Inicjator procesu: nazwisko i imię' ) ],
                        [ '<NNNN>', getTranslation( 'Sekwencer' ) ], [ '<RRRR>', getTranslation( 'Aktualny rok (np. 2012)' ) ],
                        [ '<RR>', getTranslation( 'Aktualny rok (np. 12)' ) ], [ '<MM>', getTranslation( 'Aktualny miesiąc' ) ],
                        [ '<DD>', getTranslation( 'Aktualny dzień' ) ], [ '<RRRR>/<NNNN>', getTranslation( 'Sekwencer w ramach roku' ) ],
                        [ '<ROLEID>', getTranslation( 'Przypisanie zadania' ) ] ];
        forceSelection = false;
    } else {
        label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' ) );
        initValues = [];
        forceSelection = false;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'initialValueItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'initialValue', 'initialValueName' ],
            data: initValues
        } ),
        valueField: 'initialValue',
        displayField: 'initialValueName',
        forceSelection: forceSelection,
        value: ( variable && config.loadVarDef ) ? variable.initialValue : '',
        additional: true
    }, config );

    Ext.ux.suncode.StringDateInitialValue.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StringDateInitialValue, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.StringDateInitialValue.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.RoleUsersInitialValue = function( config ) {
    var variable = config.variable;
    var label = addTooltipToField( getTranslation( 'Wartość początkowa' ), getTranslation( 'Wartość, którą jest zainicjowana zmienna w procesie' )
                    + '.<br>' + getTranslation( 'Wybierz opcję z listy' ) );
    var initValues = [ [ '<INITIATOR>', getTranslation( 'Inicjator procesu: login' ) ] ];

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'initialValueItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'initialValue', 'initialValueName' ],
            data: initValues
        } ),
        valueField: 'initialValue',
        displayField: 'initialValueName',
        forceSelection: false,
        value: ( variable && config.loadVarDef ) ? variable.initialValue : '',
        additional: true
    }, config );

    Ext.ux.suncode.RoleUsersInitialValue.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RoleUsersInitialValue, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.RoleUsersInitialValue.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ExtendedType = function( config ) {
    var label = addTooltipToField( getTranslation( 'Typ rozszerzony' ), getTranslation( 'Określa dodatkowe formatowanie wartości' ),
                    'ProcessVariablesExtendedTypes' );

    var exTypeItemValue = '';
    var data = [ {
      exType: 'USERNAME',
      exTypeName: getTranslation( 'Imię i nazwisko' )
    }, {
      exType: 'PASSWORD',
      exTypeName: getTranslation( 'Hasło' )
    }, {
      exType: 'LINK',
      exTypeName: getTranslation( 'Link' )
    } ];
    var variable = config.variable;
    if ( variable  ) {
      if ( config.loadVarDef ) {
        exTypeItemValue = variable.exType;
      }

      if ( variable.type === 'STRING' && variable.placement === 'table' ) {
        data.push( {
          exType: 'RenderAsCheckbox',
          exTypeName: getTranslation( 'Pokaż jako checkbox' )
        } );
      }
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'exTypeItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.Store( {
          data: data,
          reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
              name: 'exType',
              type: 'string'
            }, {
              name: 'exTypeName',
              type: 'string'
            }] )
          } )
        } ),
        valueField: 'exType',
        displayField: 'exTypeName',
        forceSelection: true,
        value: exTypeItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.ExtendedType.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ExtendedType, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ExtendedType.superclass.initComponent.call( this );
    },
    onPlacementChanged: function( placement ) {
      var store = this.getStore();
      var recordType = store.recordType;

      switch( placement ) {
        case 'form':
          var value = this.getValue();

          if ( value == 'RenderAsCheckbox' ) {
            this.clearValue();
          }

          var index = store.find( 'exType', 'RenderAsCheckbox' );

          if ( index != -1 ) {
            store.removeAt( index );
          }
          break;
        case 'table':
          store.add( new recordType( {
            exType: 'RenderAsCheckbox',
            exTypeName: getTranslation( 'Pokaż jako checkbox' )
          } ) );
          break;
        default:
          break;
      }

      store.commitChanges();
    }
} );

Ext.ux.suncode.CheckboxChoice = function( config ) {
  var variable = config.variable;

  config = Ext.apply( {
    fieldLabel: getTranslation( 'Wartość wyboru' ),
    anchor: '100%',
    ref: 'checkboxChoiceItem',
    value: ( variable && !Ext.isEmpty( variable.valuesList ) && config.loadVarDef )
        ? variable.valuesList[0].value : '',
    additional: true
  }, config );

  Ext.ux.suncode.CheckboxChoice.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CheckboxChoice, Ext.form.TextField, {
  initComponent: function() {
    Ext.ux.suncode.CheckboxChoice.superclass.initComponent.call( this );
  }
} );

Ext.ux.suncode.ValuesList = function( config ) {
    var values = new Array();

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        values = variable.valuesList;
    }

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( values ) ) {
        store.loadData( values );
        store.commitChanges();
    }

    config = Ext.apply( {
        title: getTranslation( 'Wartości' ),
        anchor: '100%',
        additional: true,
        store: store,
        height: 300,
        enableColumnResize: false,
        columnLines: true,
        autoScroll: true,
        frame: false,
        style: 'margin-bottom: 5px;',
        ref: 'valuesListItem',
        enableDragDrop: true,
        ddGroup: 'dd_values',
        ddScope: this,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'value',
                header: getTranslation( 'Wartość' ),
                dataIndex: 'value',
                align: 'left',
                editor: config.valueEditor,
                renderer: config.valueRenderer
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'value' ) + '</b>';
                }
            }
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        value: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                    grid.startEditing( store.getCount() - 1, 1 );
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz wartość do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            scope: this,
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.getEl(), {
                    ddGroup: 'dd_values',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                        notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                          dd.grid.getView().refresh( false );
                        } );
                    }
                } );
            },
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.ValuesList.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ValuesList, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ValuesList.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.DataChooserClasspath = function( config ) {
	var items = new Array();
	var javaCodeButton = null;
    var label = addTooltipToField( getTranslation( 'Ścieżka do klasy' ), getTranslation( 'Ścieżka do klasy Java, która uzupełnia wartości listy' ) );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var compatibilityMode = mainPanel.getCompatibilityMode();
    var classpathItemValue = '';
    var categories = mainPanel.getDataChoosersIntegrationComponentCategories();

    var variable = config.variable;
    if ( variable && config.loadVarDef && Ext.isEmpty( variable.definition.id ) ) {
        classpathItemValue = variable.classpath;
    }
    
    items.push( {
        xtype: 'textfield',
        inputType: 'text',
        ref: '../classpathItem',
        flex: 1,
        maskRe: /[a-zA-Z0-9._$]/,
        disabled: ( config.loadVarDef && variable && !Ext.isEmpty( variable.definition.id ) ),
        value: classpathItemValue
    } );
    items.push( {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'config' ),
        tooltip: getTranslation( 'Pokaż systemowe dynamiczne listy' ),
        handler: this.showStandardDataChoosers,
        scope: this
    } );
    items.push( {
    	xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'config' ),
        tooltip: getTranslation( 'Wybierz zdefiniowany komponent' ),
        menu: new Ext.ux.suncode.IntegrationComponentMenu( {
            categories: categories,
            saveFunction: function( componentDef ) {
            	var classpathField = this.items.first();
            	classpathField.setValue( '' );
            	classpathField.disable();
            	if ( this.javaCodeButton ) {
            		this.javaCodeButton.hide();
            	}
            	var owner = this.ownerCt;
            	var placement = owner.placementItem.getValue();
            	this.removeItem( owner.formCriteriaItem );
            	this.removeItem( owner.customKeysItem );
            	this.removeItem( owner.integrationComponentIdItem );
            	this.removeItem( owner.parametersItem );
            	owner.doLayout();
            	var mappingsItem = owner.mappingsItem;
            	mappingsItem.onChooseIntegrationComponent( componentDef );
            	var insertPos = getInsertPos( owner, owner.comboQueryDelayItem );
            	var componentReg = Ext.ux.suncode.IntegrationComponentService.getDataChooserRegistration( componentDef.id );
            	var customForm = new Object();
                customForm = Ext.apply( {
                    fields: deepObjectCopy( componentDef.parameters ),
                    buildForm: !Ext.isEmpty( componentReg ) ? componentReg.buildForm : null,
                    validateForm: !Ext.isEmpty( componentReg ) ? componentReg.validateForm : null,
                    apiVersion: !Ext.isEmpty( componentReg ) ? componentReg.apiVersion : null
                }, customForm );
                
                owner.insert( insertPos, new Ext.form.TextField( {
                    ref: 'integrationComponentIdItem',
                    anchor: '100%',
                    hidden: true,
                    value: componentDef.id,
                    additional: true
                } ) );
                owner.insert( insertPos, new Ext.ux.suncode.CustomForm( {
            		title: getTranslation( 'Parametry' ),
                    ref: 'parametersItem',
                    border: true,
                    customDescriptionEnabled: true,
                    customForm: customForm,
                    processNode: this.initialConfig.processNode,
                    information: {
                    	deprecated: componentDef.deprecated,
                    	deprecatedMessage: getTranslation( 'Komponent jest przestarzały' ),
                      deprecationDescription: componentDef.deprecationDescription,
                    	replacement: componentDef.replacement,
                    	replacementMessage: getTranslation( 'Zastąpiony nowym komponentem' ),
                      nameValue: componentDef.name,
                      descriptionValue: componentDef.description,
                      documentationLink: componentDef.documentationLink
                    },
                    contextVariables: componentDef.contextVariables,
                    systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
                    customFormConfig: Ext.getCmp( 'main_panel' ).getCustomFormConfig(),
                    dataChooserMappingsTable: owner.mappingsItem,
                    tableVariableAllowed: placement == 'table',
                    anchor: '100%',
                    style: {
                        marginBottom: '5px'
                    },
                    additional: true,
                    isDataChooserInTableFunction: owner.isDataChooserInTable,
                    isDataChooserInTableScope: owner,
                    columnCheckboxEnabled: placement == 'table',
                } ) );
                
                this.refreshView();
            },
            saveScope: this
        } )
    } );

    if ( config.AV && !( config.loadVarDef && variable && !Ext.isEmpty( variable.definition.id ) )
    		&& compatibilityMode.showJavaCodeWindow( mainPanel.getExportJavaCode() ) ) {
    	javaCodeButton = new Ext.Button( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'java_code' ),
            tooltip: getTranslation( 'Przygotuj kod źródłowy' ),
            handler: this.showJavaCodingWindow,
            scope: this
        } );
    	
    	items.push( javaCodeButton );
    }
    
    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'classpathContainer',
        additional: true,
        javaCodeButton: javaCodeButton,
        items: items
    }, config );

    Ext.ux.suncode.DataChooserClasspath.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DataChooserClasspath, Ext.form.CompositeField, {
    initComponent: function() {
        Ext.ux.suncode.DataChooserClasspath.superclass.initComponent.call( this );
    },
    removeItem: function( item ) {
    	if ( !Ext.isEmpty( item ) ) {
    		this.ownerCt.remove( item );
    	}
    },
    refreshView: function() {
    	var owner = this.ownerCt;
    	owner.doLayout();
    	owner.doLayout();
        owner.ownerCt.onBodyResize();
    },
    showStandardDataChoosers: function() {
        var win = new Ext.ux.suncode.StandardDataChoosersWindow( {
            saveTo: this.initialConfig.saveTo
        } );
        win.show();
    },
    showJavaCodingWindow: function() {
        var qualifiedName = this.items.first().getValue();

        if ( Ext.isEmpty( qualifiedName ) ) {
            showWarn( getTranslation( 'Podaj ścieżkę do klasy.' ) );
            return;
        }

        var dcmappings = new Array();
        var mappingsStore = this.ownerCt.mappingsItem.getStore();

        if ( mappingsStore.getCount() == 0 ) {
            showWarn( getTranslation( 'Podaj przynajmniej jedno mapowanie wartości.' ) );
            return;
        }

        for ( var i = 0; i < mappingsStore.getCount(); i++ ) {
            var mappingRec = mappingsStore.getAt( i );
            var mapping = mappingRec.get( 'id' );

            if ( !Ext.isEmpty( mapping ) ) {
                dcmappings.push( mapping );
            }
        }

        var win = new Ext.ux.suncode.JavaCodingWindow( {
            winTitle: getTranslation( 'Kod źródłowy dynamicznej listy' ),
            sourceCodeType: 'JAVA_DATA_CHOOSER',
            qualifiedName: qualifiedName,
            options: {
                dcmappings: dcmappings
            }
        } );
        win.show();
    }
} );

Ext.ux.suncode.ComboForceSelection = function( config ) {
    var label = addTooltipToField( getTranslation( 'Wymuś wybór' ), getTranslation( 'Określa, czy jest możliwość wpisania wartości spoza listy' ) );
    var comboForceSelectionItemValue = true;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        comboForceSelectionItemValue = variable.comboForceSelection;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'comboForceSelectionItem',
        additional: true,
        checked: comboForceSelectionItemValue,
        inputValue: 'true'
    }, config );

    Ext.ux.suncode.ComboForceSelection.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ComboForceSelection, Ext.form.Checkbox, {
    initComponent: function() {
        Ext.ux.suncode.ComboForceSelection.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ComboFilteringDisabled = function( config ) {
    var label = addTooltipToField( getTranslation( 'Blokuj filtrowanie' ), getTranslation( 'Blokuje filtrowanie listy podczas wpisywania znaków' ) );
    var comboFilteringDisabledItemValue = false;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        comboFilteringDisabledItemValue = variable.comboFilteringDisabled;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'comboFilteringDisabledItem',
        additional: true,
        checked: comboFilteringDisabledItemValue,
        inputValue: 'true',
        hidden: !config.AV
    }, config );

    Ext.ux.suncode.ComboFilteringDisabled.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ComboFilteringDisabled, Ext.form.Checkbox, {
    initComponent: function() {
        Ext.ux.suncode.ComboFilteringDisabled.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ComboNoLazyInit = function( config ) {
    var label = addTooltipToField( getTranslation( 'Inicjuj' ), getTranslation( 'Dla listy, jeżeli opcja jest aktywna' ) + '<br>'
                    + getTranslation( 'lista jest inicjowana po uruchomieniu zadania' ) );
    var comboNoLazyInitItemValue = false;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        comboNoLazyInitItemValue = variable.comboNoLazyInit;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'comboNoLazyInitItem',
        additional: true,
        checked: comboNoLazyInitItemValue,
        inputValue: 'true',
        hidden: !config.AV
    }, config );

    Ext.ux.suncode.ComboNoLazyInit.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ComboNoLazyInit, Ext.form.Checkbox, {
    initComponent: function() {
        Ext.ux.suncode.ComboNoLazyInit.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ComboQueryDelay = function( config ) {
    var label = addTooltipToField( getTranslation( 'Opóźnienie zapytania' ), getTranslation( 'W milisekundach' ) + '<br>'
                    + getTranslation( 'Domyślnie: 500 milisekund' ) );
    var comboQueryDelayItemValue = false;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        comboQueryDelayItemValue = variable.comboQueryDelay;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        allowNegative: false,
        allowDecimals: false,
        ref: 'comboQueryDelayItem',
        additional: true,
        value: comboQueryDelayItemValue,
        hidden: !config.AV
    }, config );

    Ext.ux.suncode.ComboQueryDelay.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ComboQueryDelay, Ext.form.NumberField, {
    initComponent: function() {
        Ext.ux.suncode.ComboQueryDelay.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.FormCriteria = function( config ) {
    var variableDefPanel = config.variableDefPanel;
    var formCriteria = new Array();

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        formCriteria = variable.formCriteria;
        var standardDataChooser = config.standardDataChooser;

        if ( !Ext.isEmpty( standardDataChooser ) && !Ext.isEmpty( formCriteria ) && !Ext.isEmpty( standardDataChooser.formCriteria ) ) {
            Ext.each( formCriteria, function( formCrit, index, formCrits ) {
                Ext.each( standardDataChooser.formCriteria, function( defFormCrit, index, defFormCrits ) {
                    if ( formCrit.varId == defFormCrit.varId ) {
                        Ext.apply( formCrit, {
                            description: defFormCrit.description
                        } );
                    }
                } );
            } );
        }
    }

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'description',
                type: 'string'
            }, {
                name: 'varId',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( formCriteria ) ) {
        store.loadData( formCriteria );
        store.commitChanges();
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: config.processNode.attributes.variables,
        comboForceSelection: false,
        additionals: [ {
            id: variableDefPanel.idItem.getValue(),
            name: variableDefPanel.nameItem.getValue(),
            descr: variableDefPanel.descrItem.getValue()
        }, {
            id: 'processId',
            name: 'ProcessId',
            descr: getTranslation( 'Identyfikator procesu' )
        }, {
            id: 'activityId',
            name: 'ActivityId',
            descr: getTranslation( 'Identyfikator zadania' )
        }, {
            id: 'sTaskUserName',
            name: 'sTaskUserName',
            descr: getTranslation( 'Login użytkownika wykonującego zadanie' )
        } ]
    } );

    config = Ext.apply( {
        title: getTranslation( 'Kryteria formalne' ),
        anchor: '100%',
        additional: true,
        store: store,
        height: 250,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        frame: false,
        style: 'margin-bottom: 5px;',
        ref: 'formCriteriaItem',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editable: false,
                renderer: wrapColumnValue
            }, {
                id: 'varId',
                header: getTranslation( 'Zmienna procesu' ),
                dataIndex: 'varId',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        description: '',
                        varId: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                    grid.startEditing( store.getCount() - 1, 1 );
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz kryterium do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.FormCriteria.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormCriteria, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.FormCriteria.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.Mappings = function( config ) {
	var processNode = config.processNode;
    var variableDefPanel = config.variableDefPanel;
    var mappings = new Array();
    var addMappingsEnabled = true;
    var idEditor = new Ext.form.TextField( {
        maskRe: /[a-zA-Z0-9_\s.]/
    } );
    var variablesToMap = new Array();

    var variable = config.variable;
    if ( variable && config.loadVarDef && Ext.isEmpty( variable.definition.mappings ) ) {
        mappings = variable.mappings;
        var standardDataChooser = config.standardDataChooser;

        if ( !Ext.isEmpty( standardDataChooser ) && !Ext.isEmpty( mappings ) && !Ext.isEmpty( standardDataChooser.mappings ) ) {
            Ext.each( mappings, function( mapp, index, mapps ) {
                Ext.each( standardDataChooser.mappings, function( defMapp, index, defMapps ) {
                    if ( mapp.id == defMapp.id ) {
                        Ext.apply( mapp, {
                            description: defMapp.description
                        } );
                    }
                } );
            } );
        }
    } else if ( variable && config.loadVarDef && !Ext.isEmpty( variable.definition.mappings ) ) {
    	var integrationComponentDefinition = config.integrationComponentDefinition;
    	
    	Ext.iterate( variable.definition.mappings, function( key, mapping, allMappings ) {
    		mappings.push( {
    			id: key,
                description: '',
                varId: mapping.variable,
                display: mapping.name,
                hidden: mapping.hidden,
                verify: mapping.verify,
                definitionMapping: false
    		} );
    	} );
    	
    	if ( !Ext.isEmpty( integrationComponentDefinition ) && !Ext.isEmpty( mappings )
    			&& !Ext.isEmpty( integrationComponentDefinition.mappings ) ) {
            Ext.each( mappings, function( mapp, index, mapps ) {
                Ext.each( integrationComponentDefinition.mappings, function( defMapp, index, defMapps ) {
                    if ( mapp.id == defMapp.id ) {
                        Ext.apply( mapp, {
                            description: defMapp.description,
                            definitionMapping: true
                        } );
                    }
                } );
            } );
            
            addMappingsEnabled = integrationComponentDefinition.customMappingsEnabled;
            idEditor = this.buildMappingsChooser( integrationComponentDefinition.mappings );
        }
    }

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            idProperty: 'no_id',
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'varId',
                type: 'string'
            }, {
                name: 'display',
                type: 'string'
            }, {
                name: 'hidden',
                type: 'boolean'
            }, {
                name: 'verify',
                type: 'boolean'
            }, {
                name: 'definitionMapping',
                type: 'boolean'
            }, {
                name: 'readOnly'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( mappings ) ) {
        store.loadData( mappings );
        store.commitChanges();
    }
    
    if ( ( variable && config.loadVarDef && variable.placement === 'form' )
    		|| ( !variable && Ext.isEmpty( variableDefPanel.placementItem ) ) ) {
    	Ext.each( processNode.attributes.variables, function( v, index, vs ) {
    		if ( v.placement === 'form' ) {
    			variablesToMap.push( v );
    		}
    	} );
    } else {
    	variablesToMap = processNode.attributes.variables;
    }

    var allVariablesChooser = new Ext.ux.suncode.AllVariablesChooser( {
        variables: variablesToMap,
        additionals: [ {
            id: variableDefPanel.idItem.getValue(),
            name: variableDefPanel.nameItem.getValue(),
            descr: variableDefPanel.descrItem.getValue()
        } ]
    } );
    
    config = Ext.apply( {
        title: getTranslation( 'Mapowanie wartości' ),
        anchor: '100%',
        additional: true,
        store: store,
        height: 300,
        enableColumnResize: true,
        enableDragDrop: true,
        ddGroup: 'dd_mappings',
        ddScope: this,
        columnLines: true,
        autoScroll: true,
        frame: false,
        ref: 'mappingsItem',
        style: {
            marginBottom: '5px'
        },
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: false,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'id',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'id',
                align: 'left',
                editor: idEditor
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editable: false,
                renderer: wrapColumnValue
            }, {
                id: 'varId',
                header: getTranslation( 'Zmienna procesu' ),
                dataIndex: 'varId',
                align: 'left',
                editor: allVariablesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( allVariablesChooser )
            }, {
                id: 'display',
                header: getTranslation( 'Nazwa wyświetlana' ),
                dataIndex: 'display',
                align: 'left',
                editor: new Ext.form.TextField( {
                    inputType: 'text',
                    stripCharsRe: /;/g
                } ),
                renderer: wrapColumnValue
            }, {
                id: 'hidden',
                header: getTranslation( 'Ukryty' ),
                dataIndex: 'hidden',
                align: 'center',
                hidden: ( config.loadVarDef && variable && !Ext.isEmpty( variable.definition.mappings ) ) ? false : true,
                renderer: tickCrossValue
            }, {
                id: 'verify',
                header: getTranslation( 'Weryfikuj' ),
                dataIndex: 'verify',
                align: 'center',
                renderer: tickCrossValue
            }, {
                id: 'translations',
                header: getTranslation( 'Tłumaczenie' ),
                dataIndex: 'translations',
                align: 'center',
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                	return '<img src=\"' + getPluginImgPath( 'translations' ) + '\" width="12" height="12">';
                }
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'id' ) + '</b>';
                }
            }
        } ),
        caches: new Object(),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                hidden: !addMappingsEnabled,
                ref: 'addMappingButton',
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        id: '',
                        description: '',
                        varId: '',
                        display: '',
                        hidden: false,
                        verify: false,
                        readOnly: false,
                        definitionMapping: false
                    } );

                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz mapowanie do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afterrender: function( grid ) {
                if ( !( variable && config.loadVarDef ) ) {
                    var varId = variableDefPanel.idItem.getValue();
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        id: '',
                        description: '',
                        varId: varId,
                        display: '',
                        hidden: false,
                        verify: false,
                        definitionMapping: false
                    } );
                    store.add( rec );
                    store.commitChanges();
                }
                
                variableDefPanel.idItem.on( 'valid', this.onIdFieldValid, this );
            },
            beforeedit: function( e ) {
            	var grid = e.grid;
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var colId = cm.getColumnId( colIndex );
                var record = e.record;
                var readOnly = record.get( 'readOnly' );

                if ( grid.isCellReadOnly( readOnly, colId ) ) {
                	showWarn( getTranslation( 'Wartość nie może być edytowana.' ) );
                    return false;
                } else if ( colId == 'id' && record.get( 'definitionMapping' ) ) {
                	showWarn( getTranslation( 'Nazwa nie może być edytowana.' ) );
                	return false;
                } else if ( colId == 'display' && record.get( 'hidden' ) ) {
                	showWarn( getTranslation( 'Kolumna jest ukryta.' ) );
                	return false;
                }
            },
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;
                var colId = cm.getColumnId( colIndex );

                if ( colId == 'varId' && !Ext.isEmpty( value ) && store.findExact( 'varId', value ) != -1 ) {
                    showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w innym mapowaniu.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
                
                var grid = e.grid;
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var colId = cm.getColumnId( colIndex );
                
                if ( colId == 'id' && !Ext.isEmpty( grid.caches[e.originalValue] ) ) {
                	var cache = grid.caches[e.originalValue];
            		cache.key = cache.key.replace( 'MAPPING(' + e.originalValue + ')', 'MAPPING(' + e.value + ')' );
            		grid.caches[e.value] = cache;
            		delete grid.caches[e.originalValue];
                }
            },
            cellclick: function( grid, rowIndex, columnIndex, e ) {
                var store = grid.getStore();
                var rec = store.getAt( rowIndex );
                var readOnly = rec.get( 'readOnly' );
                var colId = grid.getColumnModel().getColumnId( columnIndex );
                
                if ( colId == 'verify' ) {
                	if ( grid.isCellReadOnly( readOnly, colId ) ) {
                    	showWarn( getTranslation( 'Wartość nie może być edytowana.' ) );
                        return false;
                    } else {
                    	var currentValue = rec.get( 'verify' );
                        rec.set( 'verify', !currentValue );
                        rec.commit();
                    }
                } else if ( colId == 'hidden' ) {
                	if ( grid.isCellReadOnly( readOnly, colId ) ) {
                    	showWarn( getTranslation( 'Wartość nie może być edytowana.' ) );
                        return false;
                    } else {
	                    var currentValue = rec.get( 'hidden' );
	                    rec.set( 'hidden', !currentValue );
	                    rec.commit();
                    }
                } else if ( colId == 'translations' ) {
                	var id = rec.get( 'id' );
                	
                	if ( Ext.isEmpty( id ) ) {
                		showWarn( getTranslation( 'Uzupełnij poprawnie mapowania wartości.' ) );
                		return;
                	}
                	
                	var cache = grid.caches[id];
                	if ( Ext.isEmpty( cache ) ) {
                		cache = new Object();
                		grid.caches[id] = cache;
                	}
                	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
                	var packageId = packageNode.attributes.packageId;
                	var processDefId = processNode.attributes.processDefId;
                	var win = new Ext.ux.suncode.I18NTranslationWindow( {
                		windowTitle: getTranslation( 'Tłumaczenia mapowania wartości' ),
                		key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATACHOOSER('
                			+ variableDefPanel.idItem.getValue() + ')_MAPPING(' + id + ')',
                		defaultTranslation: rec.get( 'display' ),
                		cache: cache,
                		saveToCache: true
                	} );
            		win.show();
                }
            },
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.getEl(), {
                    ddGroup: 'dd_mappings',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                        notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                          dd.grid.getView().refresh();
                        } );
                    }
                } );
            }
        }
    }, config );

    Ext.ux.suncode.Mappings.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.Mappings, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.Mappings.superclass.initComponent.call( this );
    },
    MAPPING_PROPERTIES: {
    	id: 'id',
    	description: 'description',
    	varId: 'variableId',
    	display: 'name',
    	hidden: 'hidden',
    	verify: 'verify',
    	readOnly: 'readOnly'
    },
    onChooseIntegrationComponent: function( componentDef ) {
    	var store = this.getStore();
    	store.removeAll();
    	var cm = this.getColumnModel();
    	var hiddenColumnIdx = cm.getIndexById( 'hidden' );
    	cm.setHidden( hiddenColumnIdx, false );
    	if ( componentDef.customMappingsEnabled ) {
    		this.getTopToolbar().addMappingButton.show();
    	} else {
    		this.getTopToolbar().addMappingButton.hide();
    	}

    	if ( !Ext.isEmpty( componentDef.mappings ) ) {
    		var v = store.recordType;
    		var records = new Array();
    		
    		Ext.each( componentDef.mappings, function( mapping, index, mappings ) {
    			records.push( new v( {
                    id: mapping.id,
                    description: !Ext.isEmpty( mapping.description ) ? mapping.description : '',
                    varId: mapping.self ? this.variableDefPanel.idItem.getValue() : '',
                    display: mapping.name,
                    hidden: mapping.hidden,
                    verify: false,
                    definitionMapping: true
                } ) );
    		}, this );
    		
    		store.add( records );
    		store.commitChanges();
    	}
    	
    	this.getColumnModel().getColumnById( 'id' ).setEditor( this.buildMappingsChooser( componentDef.mappings ) );
    },
    addMapping: function( mapping ) {
    	mapping = !Ext.isEmpty( mapping ) ? mapping : new Object();
    	var store = this.getStore();
    	var v = store.recordType;
    	var record = new v( {
            id: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.id, '' ),
            description: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.description, '' ),
            varId: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.varId, '' ),
            display: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.display, '' ),
            hidden: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.hidden, false ),
            verify: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.verify, false ),
            definitionMapping: false,
            readOnly: this.getMappingValue( mapping, this.MAPPING_PROPERTIES.readOnly, false )
        } );
    	store.add( record );
		  store.commitChanges();
    },
    getMappingValue: function( mapping, property, defaultValue ) {
    	var value = mapping[property];
    	
    	return !Ext.isEmpty( value ) ? value : defaultValue;
    },
    updateMapping: function( id, mapping ) {
      mapping = !Ext.isEmpty( mapping ) ? mapping : new Object();
      var store = this.getStore();
      var index = store.find( 'id', id );

      if ( index != -1 ) {
        var record = store.getAt( index );

        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.description] ) ) {
          record.set( 'description', mapping[this.MAPPING_PROPERTIES.description] );
        }
        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.varId] ) ) {
          record.set( 'varId', mapping[this.MAPPING_PROPERTIES.varId] );
        }
        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.display] ) ) {
          record.set( 'display', mapping[this.MAPPING_PROPERTIES.display] );
        }
        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.hidden] ) ) {
          record.set( 'hidden', mapping[this.MAPPING_PROPERTIES.hidden] );
        }
        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.verify] ) ) {
          record.set( 'verify', mapping[this.MAPPING_PROPERTIES.verify] );
        }
        if ( Ext.isDefined( mapping[this.MAPPING_PROPERTIES.readOnly] ) ) {
          record.set( 'readOnly', mapping[this.MAPPING_PROPERTIES.readOnly] );
        }

        record.commit();
      }
    },
    removeMapping: function( id ) {
      var store = this.getStore();
      var index = store.find( 'id', id );

      if ( index != -1 ) {
        store.removeAt( index );
        store.commitChanges();
      }
    },
    changeMappingPosition: function( id, newPosition ) {
      var store = this.getStore();

      if ( newPosition >= 0 && store.getCount() >= newPosition ) {
        var index = store.find( 'id', id );

        if ( index != -1 ) {
          var record = store.getAt( index );
          store.removeAt( index );
          store.insert( newPosition, [ record ] );
          store.commitChanges();
          this.getView().refresh();
        }
      }
    },
    getAllMappings: function() {
      var mappings = new Array();
      var store = this.getStore();

      store.each( function( record ) {
        var mapping = new Object();
        mapping[this.MAPPING_PROPERTIES.id] = record.get( 'id' );
        mapping[this.MAPPING_PROPERTIES.description] = record.get( 'description' );
        mapping[this.MAPPING_PROPERTIES.varId] = record.get( 'varId' );
        mapping[this.MAPPING_PROPERTIES.display] = record.get( 'display' );
        mapping[this.MAPPING_PROPERTIES.hidden] = record.get( 'hidden' );
        mapping[this.MAPPING_PROPERTIES.verify] = record.get( 'verify' );
        mapping[this.MAPPING_PROPERTIES.readOnly] = record.get( 'readOnly' );

        mappings.push( mapping );
      }, this );

      return mappings;
    },
    removeMappings: function() {
    	var store = this.getStore();
    	store.removeAll();
    	store.commitChanges();
    },
    isCellReadOnly: function( readOnly, columnId ) {
    	return ( !Ext.isEmpty( readOnly ) && 
    			( readOnly === true ||
    			( Ext.isString( readOnly ) && readOnly === this.MAPPING_PROPERTIES[columnId] ) ||
    			( Ext.isArray( readOnly ) && readOnly.indexOf( this.MAPPING_PROPERTIES[columnId] ) != -1 ) ) );
    },
    getTranslationCacheFields: function() {
    	var fields = new Array();
    	var store = this.getStore();
    	
    	Ext.iterate( this.caches, function( id, cache, allCaches ) {
    		fields.push( {
            	cache: cache,
            	getCache: function() {
            		return this.cache;
            	}
            } );
        } );
    	
    	return fields;
    },
    onIdFieldValid: function( field ) {
    	Ext.iterate( this.caches, function( id, cache, allCaches ) {
    		cache.key = cache.key.replace( 'DATACHOOSER(' + field.startValue + ')', 'DATACHOOSER(' + field.getValue() + ')' );
    	} );
    },
    buildMappingsChooser: function( mappings ) {
    	return new Ext.form.ComboBox( {
    		triggerAction: 'all',
    		mode: 'local',
    		store: new Ext.data.Store( {
    			data: mappings,
    			reader: new Ext.data.JsonReader( {
    				fields: Ext.data.Record.create( [ {
    					name: 'id',
    					type: 'string'
    				}, {
    					name: 'name',
    					type: 'string'
    				}, {
    					name: 'description',
    					type: 'string'
    				}, {
    					name: 'hidden',
    					type: 'boolean'
    				}, {
    					name: 'self',
    					type: 'boolean'
    				} ] )
    			} )
    		} ),
    		valueField: 'id',
    		displayField: 'id',
    		forceSelection: false,
    		maskRe: /[a-zA-Z0-9_\s.]/,
    		listeners: {
    			scope: this,
    			select: this.onSelectMapping
    		}
    	} );
    },
    onSelectMapping: function( combo, record, index ) {
    	var selModel = this.getSelectionModel();
        var rows = selModel.getSelections();
        
        if ( !Ext.isEmpty( rows ) ) {
        	var row = rows[0];
        	row.set( 'description', record.get( 'description' ) );
        	row.set( 'display', record.get( 'name' ) );
        	row.set( 'hidden', record.get( 'hidden' ) );
        	if ( record.get( 'self' ) ) {
        		row.set( 'varId', this.variableDefPanel.idItem.getValue() );
        	}
        	row.commit();
        }
    },
    onPlacementChanged: function( placement ) {
    	var processNode = this.initialConfig.processNode;
    	var variableDefPanel = this.initialConfig.variableDefPanel;
        var store = this.getStore();
        var columnModel = this.getColumnModel();
        var mappingsEditorStore = columnModel.getCellEditor( columnModel.getIndexById( 'varId' ), 0 ).field.getStore();
        mappingsEditorStore.removeAll();
        var recordType = store.recordType;
        
        if ( placement === 'form' ) {
        	store.each( function( rec ) {
            	var varId = rec.get( 'varId' );
            	var variable = processNode.findVariable( varId );
            	
                if ( !Ext.isEmpty( variable ) && variable.placement === 'table' ) {
                    rec.set( 'varId', '' );
                    rec.commit();
                }
            } );
        	
        	Ext.each( processNode.attributes.variables, function( v, index, vs ) {
        		if ( v.placement === 'form' ) {
        			mappingsEditorStore.add( new recordType( v ) );
        		}
        	} );
        } else {
        	Ext.each( processNode.attributes.variables, function( v, index, vs ) {
        		mappingsEditorStore.add( new recordType( v ) );
        	} );
        }
        
        mappingsEditorStore.add( new recordType( {
            id: variableDefPanel.idItem.getValue(),
            name: variableDefPanel.nameItem.getValue(),
            descr: variableDefPanel.descrItem.getValue()
        } ) );
        
        mappingsEditorStore.commitChanges();
    }
} );

Ext.ux.suncode.CustomKeys = function( config ) {
    var customKeys = new Array();

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        customKeys = variable.customKeys;
        var standardDataChooser = config.standardDataChooser;

        if ( !Ext.isEmpty( standardDataChooser ) && !Ext.isEmpty( customKeys ) && !Ext.isEmpty( standardDataChooser.customKeys ) ) {
            Ext.each( customKeys, function( custKey, index, custKeys ) {
                Ext.each( standardDataChooser.customKeys, function( defCustKey, index, defCustKeys ) {
                    if ( custKey.id == defCustKey.id ) {
                        Ext.apply( custKey, {
                            description: defCustKey.description
                        } );
                    }
                } );
            } );
        }
    }

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            }, {
                name: 'availableValues',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( customKeys ) ) {
        store.loadData( customKeys );
        store.commitChanges();
    }

    config = Ext.apply( {
        title: getTranslation( 'Klucze własne' ),
        hidden: !config.AV,
        anchor: '100%',
        additional: true,
        store: store,
        height: 250,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        frame: false,
        style: 'margin-bottom: 5px;',
        ref: 'customKeysItem',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: true
            },
            columns: [ new Ext.grid.RowNumberer(), {
                id: 'id',
                header: getTranslation( 'Klucz' ),
                dataIndex: 'id',
                align: 'left',
                editor: new Ext.form.TextField( {
                    inputType: 'text'
                } )
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editable: false,
                renderer: wrapColumnValue
            }, {
                id: 'value',
                header: getTranslation( 'Wartość' ),
                dataIndex: 'value',
                align: 'left',
                editor: new Ext.form.TextField( {
                    inputType: 'text'
                } )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        id: '',
                        description: '',
                        value: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                    grid.startEditing( store.getCount() - 1, 1 );
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz klucz do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            scope: this,
            beforeedit: this.setAvailableValues,
            validateedit: this.validateCustomKey,
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.CustomKeys.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CustomKeys, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.CustomKeys.superclass.initComponent.call( this );
    },
    forbiddenIds: [ 'class', 'type', 'comboForceSelection', 'comboFilteringDisabled', 'comboLazyInit', 'comboQueryDelay', 'formCriteria' ],
    setAvailableValues: function( e ) {
        if ( e.field == 'value' && !Ext.isEmpty( e.record.json ) && !Ext.isEmpty( e.record.json.availableValues ) ) {
            var editor = this.getColumnModel().getCellEditor( e.column, e.row ).field;
            var store = editor.getStore();
            store.loadData( e.record.json.availableValues );
            store.commitChanges();
        }
    },
    validateCustomKey: function( e ) {
        var grid = e.grid;
        var store = grid.getStore();
        var cm = grid.getColumnModel();
        var colIndex = e.column;
        var value = e.value;

        if ( cm.getColumnId( colIndex ) == 'id' && !Ext.isEmpty( value ) && ( value.isDCMapping() || this.forbiddenIds.indexOf( value ) != -1 ) ) {
            var msg = getTranslation( 'Klucz' );
            msg += ' ';
            msg += value;
            msg += ' ';
            msg += getTranslation( 'jest zabroniony' );
            msg += '.';
            showWarn( msg );
            return false;
        }
    }
} );

Ext.ux.suncode.VariableDateFormatChooser = function( config ) {
    var formats = [ [ 'Y-m-d', '2012-01-02' ], [ 'Y', '2012' ], [ 'Y/m/d D', '2012/01/15 pon' ], [ 'Y-M-d', '2012-Sty-15' ],
                    [ 'd-m-Y', '02-01-2012' ], [ 'd/m/Y D', '15/01/2012 pon' ], [ 'd-M-Y', '15-Sty-2012' ] ];
    var formatItemValue = 'Y-m-d';

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
    	formatItemValue = variable.format;
    }

    config = Ext.apply( {
        fieldLabel: getTranslation( 'Format' ),
        anchor: '100%',
        ref: 'formatItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'format', 'formatName' ],
            data: formats
        } ),
        valueField: 'format',
        displayField: 'formatName',
        forceSelection: false,
        value: formatItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.VariableDateFormatChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableDateFormatChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.VariableDateFormatChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ThousandSeparator = function( config ) {
    var label = addTooltipToField( getTranslation( 'Separator tysięczny' ), getTranslation( 'Oddziela tysiące, miliony itd.' ) );
    var separators = [ [ ' ', getTranslation( 'Spacja' ) ], [ ',', getTranslation( 'Przecinek' ) ], [ '.', getTranslation( 'Kropka' ) ],
                       [ '<NONE>', getTranslation( 'Brak' ) ] ];
    var thousandSeparatorItemValue = '';
    var forbiddenSeparator = config.forbiddenSeparator;
    
    if ( !Ext.isEmpty( forbiddenSeparator ) ) {
    	Ext.each( separators, function( value, index, values ) {
    		if ( forbiddenSeparator == value[0] ) {
    			separators.splice( index, 1 );
    			return false;
    		}
    	} );
    }

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
        thousandSeparatorItemValue = variable.thousandSeparator;
    }

    config = Ext.apply( {
        fieldLabel: label,
        anchor: '100%',
        ref: 'thousandSeparatorItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'separator', 'separatorName' ],
            data: separators
        } ),
        valueField: 'separator',
        displayField: 'separatorName',
        forceSelection: true,
        editable: false,
        value: thousandSeparatorItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.ThousandSeparator.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ThousandSeparator, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.ThousandSeparator.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.AutoMappingPanel = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var variable = config.variable;
    var loadVarDef = config.loadVarDef;
    var title = addTooltipToField( getTranslation( 'Autouzupełnianie' ),
                    getTranslation( 'Automatyczne uzupełnianie mapowań wartości podczas wyjścia z pola' ) );
    var clearMappedLabel = addTooltipToField( getTranslation( 'Autousuwanie' ),
                    getTranslation( 'Automatyczne usuwanie mapowanych wartości podczas wyczyszczenia pola' ) );
    var onlyUniqueLabel = addTooltipToField( getTranslation( 'Tylko unikalne wartości' ),
		    	     getTranslation( 'Zaznaczona opcja powoduje uzupełnienie wartości tylko wtedy, gdy w danych znajduje się tylko jeden identyczny bądź pasujący wynik. ' ) 
		    	     + getTranslation( 'Gdy opcja jest odznaczona funkcja uzupełnia pole pierwszym pasującym wynikiem.' ) );
    var filterValueLabel = addTooltipToField( getTranslation( 'Filtruj wyniki po wartości' ),
                    getTranslation( 'Włącza dodatkowe filtrowanie zwróconych wyników po wartości w polu' ) );
    var suspendChildrenPropagationLabel = addTooltipToField( getTranslation( 'Zawieś autouzupełnianie w podrzędnych listach dynamicznych' ),
            getTranslation( 'Wyłącza automatyczne uzupełnianie mapowań wartości dla listach dynamicznych-dzieci ' +
            		'na czas działania listy dynamicznej-rodzica' ) );

    config = Ext.apply( {
        layout: 'form',
        layoutConfig: {
            trackLabels: true
        },
        style: {
            marginBottom: '5px'
        },
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        title: title,
        iconCls: 'x-Module-autoMappingPanel',
        collapsible: true,
        collapsed: true,
        titleCollapse: true,
        animCollapse: mainPanel.getAnimationsOn(),
        hidden: !mainPanel.getEnableDataChooserAutoMapping(),
        additional: true,
        items: [ {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Aktywuj' ),
            ref: 'activateItem',
            checked: ( loadVarDef && variable ) ? variable.definition.autoMapping.active : true,
            inputValue: 'true',
            listeners: {
            	scope: this,
            	check: this.onActivateChange
            }
        }, {
            xtype: 'checkbox',
            fieldLabel: clearMappedLabel,
            ref: 'clearMappedItem',
            checked: ( loadVarDef && variable ) ? variable.definition.autoMapping.clearMapped : false,
            inputValue: 'true',
            disabled: ( loadVarDef && variable ) ? !variable.definition.autoMapping.active : false
        }, {
            xtype: 'checkbox',
            fieldLabel: onlyUniqueLabel,
            ref: 'onlyUniqueItem',
            checked: ( loadVarDef && variable ) ? variable.definition.autoMapping.onlyUnique : true,
            inputValue: 'true',
            disabled: ( loadVarDef && variable ) ? !variable.definition.autoMapping.active : false
        }, {
            xtype: 'checkbox',
            fieldLabel: filterValueLabel,
            ref: 'filterValueItem',
            checked: ( loadVarDef && variable ) ? variable.definition.autoMapping.filterValue : true,
            inputValue: 'true',
            disabled: ( loadVarDef && variable ) ? !variable.definition.autoMapping.active : false
        }, {
            xtype: 'checkbox',
            fieldLabel: suspendChildrenPropagationLabel,
            ref: 'suspendChildrenPropagationItem',
            checked: ( loadVarDef && variable ) ? variable.definition.autoMapping.suspendChildrenPropagation : false,
            inputValue: 'true',
            disabled: ( loadVarDef && variable ) ? !variable.definition.autoMapping.active : false
        } ]
    }, config );

    Ext.ux.suncode.AutoMappingPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AutoMappingPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.AutoMappingPanel.superclass.initComponent.call( this );
    },
    onActivateChange: function( checkbox, checked ) {
    	if ( checked ) {
    		this.clearMappedItem.enable();
            this.onlyUniqueItem.enable();
            this.filterValueItem.enable();
            this.suspendChildrenPropagationItem.enable();
    	} else {
    		this.clearMappedItem.disable();
            this.onlyUniqueItem.disable();
            this.filterValueItem.disable();
            this.suspendChildrenPropagationItem.disable();
    	}
    },
    readAutoMapping: function() {
        return {
            active: this.activateItem.getValue(),
            clearMapped: this.clearMappedItem.getValue(),
            onlyUnique: this.onlyUniqueItem.getValue(),
            filterValue: this.filterValueItem.getValue(),
            suspendChildrenPropagation: this.suspendChildrenPropagationItem.getValue()
        };
    }
} );

Ext.ux.suncode.VariablePlacements = function( config ) {
    var placements = [ [ 'form', getTranslation( 'Formularz' ) ], [ 'table', getTranslation( 'Tabela' ) ] ];
    var forcedPlacement = config.forcedPlacement;
    var variablePlacementItemValue = !Ext.isEmpty( forcedPlacement ) ? forcedPlacement : 'form';

    var variable = config.variable;
    if ( variable && config.loadVarDef && Ext.isEmpty( forcedPlacement ) ) {
    	variablePlacementItemValue = variable.placement;
    }

    config = Ext.apply( {
        fieldLabel: getTranslation( 'Umieszczenie' ),
        anchor: '100%',
        ref: 'placementItem',
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'placement', 'placementName' ],
            data: placements
        } ),
        valueField: 'placement',
        displayField: 'placementName',
        forceSelection: true,
        editable: false,
        readOnly: !Ext.isEmpty( forcedPlacement ) || !Ext.isEmpty( variable ),
        value: variablePlacementItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.VariablePlacements.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariablePlacements, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.VariablePlacements.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.DecimalPrecision = function( config ) {
	var decimalPrecisionLabel = addTooltipToField( getTranslation( 'Dokładność po przecinku' ),
            getTranslation( 'Dokładność po przecinku podczas zapisu w bazie danych, wartość domyślna: 2' ) );
    var decimalPrecisionItemValue = 2;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
    	decimalPrecisionItemValue = variable.decimalPrecision;
    }

    config = Ext.apply( {
    	fieldLabel: decimalPrecisionLabel,
        allowDecimals: false,
        allowNegative: false,
        anchor: '100%',
        ref: 'decimalPrecisionItem',
        value: decimalPrecisionItemValue,
        additional: true
    }, config );

    Ext.ux.suncode.DecimalPrecision.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DecimalPrecision, Ext.form.NumberField, {
    initComponent: function() {
        Ext.ux.suncode.DecimalPrecision.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.VariableNumberFormat = function( config ) {
    config = Ext.apply( {
        ref: 'formatItem',
        additional: true,
        value: config.format,
        hidden: true
    }, config );

    Ext.ux.suncode.VariableNumberFormat.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableNumberFormat, Ext.form.TextField, {
    initComponent: function() {
        Ext.ux.suncode.VariableNumberFormat.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.VariableNumberFormatPreview = function( config ) {
    config = Ext.apply( {
    	fieldLabel: getTranslation( 'Podgląd liczby' ),
    	anchor: '100%',
        ref: 'formatPreviewItem',
        additional: true,
        value: this.buildPreview( config.format, config.thousandSeparator, config.decimalSeparator )
    }, config );

    Ext.ux.suncode.VariableNumberFormatPreview.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VariableNumberFormatPreview, Ext.form.DisplayField, {
    initComponent: function() {
        Ext.ux.suncode.VariableNumberFormat.superclass.initComponent.call( this );
    },
    exampleValue: 123456789,
    defaultThousandSeparator: ' ',
    buildPreview: function( format, thousandSeparator, decimalSeparator ) {
    	thousandSeparator = Ext.isEmpty( thousandSeparator ) ? this.defaultThousandSeparator : thousandSeparator;
    	var formattedNumber = Ext.util.Format.number( this.exampleValue, format );
    	var splitted = formattedNumber.split( '.' );
        formattedNumber = formattedNumber.replace( new RegExp( '[,]', 'g' ), thousandSeparator )
        		.replace( new RegExp( '[.]', 'g' ), decimalSeparator );
        
        var result = splitted[0].replace( new RegExp( '[,]', 'g' ), thousandSeparator );
        
        if ( !Ext.isEmpty( splitted[1] ) ) {
        	result += decimalSeparator;
        	result += splitted[1];
        }
        
        return result;
    },
    updatePreview: function( format, thousandSeparator, decimalSeparator ) {
    	var value = this.buildPreview( format, thousandSeparator, decimalSeparator );
    	this.setValue( value );
    }
} );

Ext.ux.suncode.DisplayedDecimalPrecision = function( config ) {
	var label = addTooltipToField( getTranslation( 'Wyświetlana dokładność po przecinku' ),
            getTranslation( 'Dokładność po przecinku wyświetlana na formularzu, wartość domyślna: 2' ) );
    var itemValue = 2;

    var variable = config.variable;
    if ( variable && config.loadVarDef ) {
    	var format = variable.format;
    	var splitted = format.split( '.' );
    	
    	if ( !Ext.isEmpty( splitted[1] ) ) {
    		itemValue = splitted[1].length;
    	}
    }

    config = Ext.apply( {
    	fieldLabel: label,
        allowDecimals: false,
        allowNegative: false,
        anchor: '100%',
        ref: 'displayedDecimalPrecisionItem',
        value: itemValue,
        additional: true
    }, config );

    Ext.ux.suncode.DisplayedDecimalPrecision.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DisplayedDecimalPrecision, Ext.form.NumberField, {
    initComponent: function() {
        Ext.ux.suncode.DisplayedDecimalPrecision.superclass.initComponent.call( this );
    }
} );