function deleteRole( arg ) {
    var processNode = arg.processNode;
    var roleId = arg.roleId;
    var paper = arg.paper;
    var participants = processNode.attributes.participants;
    var firstRoleRemoved = false;
    var previousRoleId = '';

    if ( participants[0].roleId == roleId ) {
        firstRoleRemoved = true;

        if ( participants[1] ) {
            previousRoleId = participants[1].roleId;
        }
    } else {
        for ( var i = 1; i < participants.length; i++ ) {
            if ( participants[i].roleId == roleId ) {
                previousRoleId = participants[i - 1].roleId;
                break;
            }
        }
    }

    paper.bpmn.removeRole( paper, roleId, processNode, firstRoleRemoved, previousRoleId );
    processNode.removeRole( roleId );
}

function showRoleProperties( arg ) {
    var processNode = arg.processNode;
    var roleId = arg.roleId;
    var role = processNode.findRole( roleId );
    var rolePropertiesWindow = new Ext.ux.suncode.RolePropertiesWindow( {
        processNode: processNode,
        role: role,
        varRecord: arg.varRecord,
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    } );
    rolePropertiesWindow.show();
}

function showParticipantDefinition( processDefId, roleId ) {
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );

    showRoleProperties( {
        processNode: processNode,
        roleId: roleId
    } );
}

function drawGlobalParticipant( item ) {
    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
    var processNode = Ext.getCmp( 'package_panel' ).findProcess( processPanel.processDefId );

    switch ( item.roleType ) {
        case 'ROLE':
            processPanel.drawRole( 1, 1, item.roleName, item.roleId, true );
            break;
        case 'SYSTEM':
            processPanel.drawSystem( 1, 1, item.roleName, item.roleId, true );
            break;
        case 'RESOURCE':
            processPanel.drawBufor( 1, 1, item.roleName, item.roleId, true );
            break;
        default:
            break;
    }

    processNode.setRoleIdChanged( item.roleId );

    if ( !Ext.isEmpty( item.roleDescr ) ) {
        processNode.setRoleDescription( item.roleId, item.roleDescr );
    }
}

function updateParticipantForOneProcess( paper, processNode, oldRole, newRole ) {
    var oldRoleId = oldRole.roleId;
    var oldRoleType = oldRole.roleType;
    var newRoleId = newRole.roleId;
    var newRoleName = newRole.roleName;
    var newRoleType = newRole.roleType;

    if ( oldRoleType != newRoleType ) {
        paper.bpmn.changeRoleType( paper, oldRoleId, newRoleType );
    }

    paper.bpmn.updateRole( paper, oldRoleId, newRoleId, newRoleName );
    processNode.updateRole( oldRoleId, newRole );
    processNode.updateActivitiesPerformer( oldRoleId, newRoleId, newRoleName );
}

function updateParticipantForAllProcesses( oldRole, newRole ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var paperPanel = Ext.getCmp( 'paper_panel' );
    var currentProcess = paperPanel.getActiveTab();

    Ext.each( paperPanel.items.items, function( tab, index, tabs ) {
        var processDefId = tab.processDefId;
        var processNode = packagePanel.findProcess( processDefId );

        if ( processNode.findRole( oldRole.roleId ) ) {
            changeProcessTab( processDefId );
            updateParticipantForOneProcess( tab.paper, processNode, oldRole, newRole );
        }
    } );

    if ( !Ext.isEmpty( currentProcess ) ) {
        changeProcessTab( currentProcess.processDefId );
    }
}

Ext.ux.suncode.RolePropertiesWindow = function( config ) {
    var windowWidth = 500;
    var itemsConfig = new Object();

    itemsConfig = Ext.apply( {
        windowWidth: windowWidth,
        processNode: config.processNode,
        role: config.role,
        AV: config.AV
    }, itemsConfig );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Definicja uczestnika' ) + ' ' + config.role.roleName,
        items: [ new Ext.ux.suncode.RoleDefinitionPanel( itemsConfig ) ],
        closable: true,
        tbar: new Ext.ux.suncode.RoleDefinitionTopToolbar( itemsConfig )
    }, config );

    Ext.ux.suncode.RolePropertiesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RolePropertiesWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.RolePropertiesWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    saveForm: function( newRoleId, newRoleName, roleDescr ) {
        var oldRoleId = this.initialConfig.role.roleId;
        var paperPanel = Ext.getCmp( 'paper_panel' );
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var processTab = paperPanel.getActiveTab();
        var packagePanel = Ext.getCmp( 'package_panel' );
        var processNode = this.initialConfig.processNode;
        var processDefId = processNode.attributes.processDefId;
        var varRecord = this.initialConfig.varRecord;
        var roleType = this.initialConfig.role.roleType;

        if ( oldRoleId != newRoleId && processNode.findRole( newRoleId ) ) {
            showWarn( getTranslation( 'Uczestnik występuje już w procesie.' ) );
            return false;
        } else if ( oldRoleId != newRoleId && packagePanel.getRootNode().findParticipant( newRoleId ) ) {
            showWarn( getTranslation( 'Uczestnik występuje już w pakiecie.' ) );
            return false;
        }

        Ext.ux.suncode.I18NService.updatePackageTranslationsFromCaches( [ this.roleDefPanel.roleNameItem ] );

        var participantObj = new Object();
        participantObj = Ext.apply( {
            roleName: newRoleName,
            roleType: roleType,
            roleId: newRoleId,
            roleDescr: roleDescr
        }, participantObj );

        if ( varRecord ) {
          var roleNameTranslation = getXpdlProcessParticipantNameTranslation( packageId, processDefId, newRoleId, newRoleName );

          varRecord.set( 'roleId', newRoleId );
          varRecord.set( 'roleName', roleNameTranslation );
          varRecord.set( 'roleType', roleType );
          varRecord.commit();
        }

        if ( this.initialConfig.role.isGlobal ) {
            var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
            packageNode.updateParticipant( oldRoleId, participantObj );
            updateParticipantForAllProcesses( this.initialConfig.role, participantObj );
        } else {
            updateParticipantForOneProcess( processTab.paper, processNode, this.initialConfig.role, participantObj );
        }

        var specification = this.readSpecification();
        Ext.ux.suncode.DocumentationService.editParticipantSpecification( processNode, oldRoleId, newRoleId, specification );
        Ext.ux.suncode.I18NService.onProcessParticipantIdChange( processDefId, oldRoleId, newRoleId );

        this.close();
        return true;
    },
    readSpecification: function() {
        var specification = new Object();
        specification = Ext.apply( {
            description: this.roleDefPanel.specificationDescriptionItem.getSpecificationDescription()
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.RoleDefinitionPanel = function( config ) {
	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	var packageId = packageNode.attributes.packageId;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var items = new Array();
    var role = config.role;
    var specification = Ext.ux.suncode.DocumentationService.getParticipantSpecification( processNode, role.roleId );

    var roleIdItem = new Ext.ux.suncode.IdField( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Identyfikator uczestnika' ),
        value: role.roleId,
        ref: 'roleIdItem',
        hidden: ( !config.AV && role.roleType == 'ROLE' ),
        idMaxLength: Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH,
        idChanged: role.idChanged
    } );
    items.push( roleIdItem );

    var roleNameItem = new Ext.ux.suncode.I18NTranslatedField( {
    	fieldLabel: getTranslation( 'Nazwa uczestnika' ),
    	ref: 'roleNameItem',
    	field: {
            xtype: 'textfield',
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            value: role.roleName,
            disabled: role.roleType == 'ROLE' ? false : true,
            listeners: {
                blur: function( field ) {
                    if ( !role.idChanged ) {
                        var roleId = generateId( field.getValue(), Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH );
                        roleIdItem.setValue( roleId );
                    }
                }
            }
        },
        getIdFieldFunction: function() {
        	return this.roleIdItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator uczestnika.' ),
        windowTitle: getTranslation( 'Tłumaczenia nazwy uczestnika' ),
        keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_PARTICIPANT(',
        keyPostfix: ')',
        saveToCache: false,
        initialId: role.roleId
    } );
    items.push( roleNameItem );

    var roleDescrItem = new Ext.form.FieldSet( {
        height: 150,
        title: getTranslation( 'Opis' ),
        layout: 'fit',
        autoWidth: true,
        items: [ {
            xtype: 'textarea',
            anchor: '100%',
            value: role.roleDescr,
            ref: '../roleDescrItem'
        } ]
    } );
    items.push( roleDescrItem );

    items.push( new Ext.ux.suncode.SpecificationDescriptionArea( {
        processNode: processNode,
        description: specification.description
    } ) );

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        items: items,
        layout: 'form',
        ref: 'roleDefPanel',
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        autoHeight: true
    }, config );

    Ext.ux.suncode.RoleDefinitionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RoleDefinitionPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.RoleDefinitionPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.RoleDefinitionTopToolbar = function( config ) {
    var items = new Array();

    var changeDefButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: function() {
            var win = this.ownerCt.ownerCt;
            var newRoleId = win.roleDefPanel.roleIdItem.getValue();
            var newRoleName = win.roleDefPanel.roleNameItem.getValue();

            if ( Ext.isEmpty( newRoleId ) || Ext.isEmpty( newRoleName ) ) {
                showWarn( getTranslation( 'Podaj nazwę uczestnika' ) + '.' );
                return;
            } else if ( config.roleType == 'ROLE'
                            && ( newRoleName.toLowerCase().startsWith( 'system' ) || newRoleName.toLowerCase().startsWith( 'bufor' ) ) ) {
                showWarn( getTranslation( 'Nazwa uczestnika nie może rozpoczynać się od frazy "system" lub "bufor".' ) );
                return;
            } else if ( newRoleName.length > 255 ) {
                showWarn( getTranslation( 'Nazwa uczestnika nie może przekroczyć 255 znaków.' ) );
                return;
            }

            var roleDescr = win.roleDefPanel.roleDescrItem.getValue();
            this.ownerCt.ownerCt.saveForm( newRoleId, newRoleName, roleDescr );
        }
    } );
    items.push( changeDefButton );

    var closeWindowButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: function() {
            this.ownerCt.ownerCt.close();
        }
    } );
    items.push( closeWindowButton );

    config = Ext.apply( {
        items: items
    }, config );

    Ext.ux.suncode.RoleDefinitionTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RoleDefinitionTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.RoleDefinitionTopToolbar.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.GlobalParticipantWindow = function( config ) {
    var windowWidth = 500;
    var participant = config.participant;

    var winTitle = participant ? getTranslation( 'Definicja uczestnika' ) + ' ' + participant.roleName : getTranslation( 'Kreator uczestnika' );

    config = Ext.apply( {
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: [ new Ext.ux.suncode.GlobalParticipantPanel( config ) ],
        closable: true,
        iconCls: 'x-Module-globalParticipantWindow',
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.GlobalParticipantWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GlobalParticipantWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.GlobalParticipantWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.globalParticipantDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.GlobalParticipantPanel = function( config ) {
	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	var packageId = packageNode.attributes.packageId;
    var roleType = 'ROLE';
    var roleId = '';
    var roleName = '';
    var roleDescr = '';
    var enableIdGeneration = true;
    var initRoleType = '';

    var participant = config.participant;
    if ( participant ) {
        roleType = participant.roleType;
        roleId = participant.roleId;
        roleName = participant.roleName;
        roleDescr = participant.roleDescr;
        enableIdGeneration = false;
        initRoleType = roleType;
    }

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'globalParticipantDefPanel',
        items: [ new Ext.ux.suncode.RoleTypesChooser( {
            ref: 'roleTypeItem',
            typeItemValue: roleType,
            listeners: {
                scope: this,
                select: function( combo, record, index ) {
                    var roleType = combo.getValue();

                    if ( Ext.isEmpty( roleType ) || !combo.isValid() ) {
                        return;
                    }

                    switch ( roleType ) {
                        case 'SYSTEM':
                            this.roleNameItem.disable();
                            this.roleIdItem.show();
                            this.ownerCt.syncShadow();
                            this.roleIdItem.setValue( getTranslation( 'System' ) );
                            this.roleNameItem.setValue( getTranslation( 'System' ) );

                            if ( roleType != initRoleType ) {
                                enableIdGeneration = true;
                            } else if ( !Ext.isEmpty( initRoleType ) ) {
                                enableIdGeneration = false;
                            }
                            break;
                        case 'RESOURCE':
                            this.roleNameItem.disable();
                            this.roleIdItem.show();
                            this.ownerCt.syncShadow();
                            this.roleIdItem.setValue( getTranslation( 'Bufor' ) );
                            this.roleNameItem.setValue( getTranslation( 'Bufor' ) );

                            if ( roleType != initRoleType ) {
                                enableIdGeneration = true;
                            } else if ( !Ext.isEmpty( initRoleType ) ) {
                                enableIdGeneration = false;
                            }
                            break;
                        case 'ROLE':
                            this.roleNameItem.enable();
                            if ( !config.AV ) {
                                this.roleIdItem.hide();
                                this.ownerCt.syncShadow();
                            }
                            this.roleIdItem.setValue( '' );
                            this.roleNameItem.setValue( '' );

                            if ( roleType != initRoleType ) {
                                enableIdGeneration = true;
                            } else if ( !Ext.isEmpty( initRoleType ) ) {
                                enableIdGeneration = false;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        } ), new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Identyfikator uczestnika' ),
            allowBlank: true,
            value: roleId,
            ref: 'roleIdItem',
            hidden: ( !config.AV && roleType == 'ROLE' ),
            idMaxLength: Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH,
            idChanged: !enableIdGeneration
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa uczestnika' ),
        	ref: 'roleNameItem',
        	field: {
                xtype: 'textfield',
                value: roleName,
                disabled: roleType != 'ROLE' ? true : false,
                listeners: {
                    scope: this,
                    blur: function( field ) {
                        if ( enableIdGeneration ) {
                            var roleId = generateId( field.getValue(), Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH );
                            this.roleIdItem.setValue( roleId );
                        }
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.roleIdItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj identyfikator uczestnika.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy uczestnika' ),
            keyPrefix: 'PACK(' + packageId + ')_PARTICIPANT(',
            keyPostfix: ')',
            saveToCache: Ext.isEmpty( participant ),
            initialId: participant ? participant.roleId : null
        } ), {
            xtype: 'fieldset',
            height: 150,
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            autoWidth: true,
            items: [ {
                xtype: 'textarea',
                anchor: '100%',
                value: roleDescr,
                ref: '../roleDescrItem'
            } ]
        } ]
    }, config );

    Ext.ux.suncode.GlobalParticipantPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.GlobalParticipantPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.GlobalParticipantPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var roleType = this.roleTypeItem.getValue();
        var roleId = this.roleIdItem.getValue();
        var roleName = this.roleNameItem.getValue();
        var roleDescr = this.roleDescrItem.getValue();
        var participant = this.initialConfig.participant;
        var packageNode = this.initialConfig.packageNode;

        if ( Ext.isEmpty( roleType ) || Ext.isEmpty( roleId ) || Ext.isEmpty( roleName ) ) {
            showWarn( getTranslation( 'Uzupełnij poprawnie definicję uczestnika.' ) );
            return;
        } else if ( roleType == 'ROLE' && ( roleName.toLowerCase().startsWith( 'system' ) || roleName.toLowerCase().startsWith( 'bufor' ) ) ) {
            showWarn( getTranslation( 'Nazwa uczestnika nie może rozpoczynać się od frazy "system" lub "bufor".' ) );
            return;
        } else if ( roleName.length > 255 ) {
            showWarn( getTranslation( 'Nazwa uczestnika nie może przekroczyć 255 znaków.' ) );
            return;
        }

        if ( ( !participant || participant.roleId != roleId ) && packageNode.findParticipant( roleId ) ) {
            showWarn( getTranslation( 'Uczestnik występuje już w pakiecie.' ) );
            return;
        }

        var exists = false;
        if ( !participant || participant.roleId != roleId ) {
            packageNode.eachChild( function( processNode ) {
                if ( processNode.findRole( roleId ) ) {
                    exists = true;
                    var processDefId = processNode.attributes.processDefId;
                    var processName = processNode.attributes.processName;
                    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
                    showWarn( getTranslation( 'Uczestnik już istnieje w procesie o nazwie' ) + ' ' + processNameTranslation + '.' );
                    return false;
                }
            } );
        }

        if ( exists ) {
            return;
        }

        var participantObj = new Object();
        participantObj = Ext.apply( {
            roleName: roleName,
            roleType: roleType,
            roleId: roleId,
            roleDescr: roleDescr
        }, participantObj );

        if ( participant && participant.roleType != roleType ) {
            var firstText = 'Zmiana typu uczestnika może spowodować usunięcie zadań w zależności od ich typu ';
            firstText += 'dla danego uczestnika we wszystkich procesach.';
            var warnMsg = getTranslation( firstText );
            warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

            Ext.Msg.show( {
                title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
                msg: warnMsg,
                buttons: {
                    yes: getTranslation( 'Tak' ),
                    no: getTranslation( 'Nie' )
                },
                fn: function( buttonId ) {
                    if ( buttonId == 'yes' ) {
                        this.executeSaveForm( participantObj );
                    }
                },
                icon: Ext.Msg.QUESTION,
                scope: this
            } );
        } else {
            this.executeSaveForm( participantObj );
        }
    },
    executeSaveForm: function( participantObj ) {
        var participant = this.initialConfig.participant;
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var packageNode = this.initialConfig.packageNode;

        if ( saveToObj && varRecord ) {
            if ( participant ) {
                varRecord.set( 'roleName', participantObj.roleName );
                varRecord.set( 'roleType', participantObj.roleType );
                varRecord.set( 'roleId', participantObj.roleId );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    roleName: participantObj.roleName,
                    roleType: participantObj.roleType,
                    roleId: participantObj.roleId
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        if ( participant ) {
            var maskId = 'change_participant_mask';

            try {
                showLoadingMask( maskId, getTranslation( 'Trwa aktualizowanie uczestnika...' ) );
                packageNode.updateParticipant( participant.roleId, participantObj );
                updateParticipantForAllProcesses( participant, participantObj );
                
                if ( participant.roleId != participantObj.roleId ) {
                	Ext.ux.suncode.I18NService.onGlobalParticipantIdChange( processDefId, variable.id, id );
                	Ext.ux.suncode.I18NService.updatePackageTranslationsFromCaches( [ this.roleNameItem ] );
                }
            }
            finally {
                removeLoadingMask( maskId );
            }
        } else {
            packageNode.addParticipant( participantObj );
            Ext.ux.suncode.I18NService.addPackageTranslationsFromCaches( [ this.roleNameItem ] );
        }

        this.ownerCt.closeWindow();
    }
} );