Ext.ux.suncode.DTButtonsChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'defId',
        type: 'string'
    }, {
        name: 'name',
        type: 'string'
    }, {
        name: 'buttonId',
        type: 'string'
    }, {
        name: 'descr',
        type: 'string'
    }, {
        name: 'text',
        type: 'string'
    }, {
        name: 'icon',
        type: 'string'
    }, {
        name: 'tooltip',
        type: 'string'
    }, {
        name: 'handler',
        type: 'string'
    }, {
        name: 'params'
    } ] );

    var buttonsObj = new Object();
    if ( typeof CUF !== 'undefined' && typeof CUFDefs.DTButtons !== 'undefined' ) {
        buttonsObj = CUFDefs.DTButtons;
    }

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'POST',
            url: 'api/customobject/get',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        baseParams: {
            allObjects: Ext.util.JSON.encode( buttonsObj ),
            filterKey: 'name',
            start: 0,
            limit: 5
        }
    } );

    var buttonsTpl = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font ' + getTemplateStyle() + '><b>'
                    + getTranslation( 'Nazwa przycisku' ) + ': ' + '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle()
                    + '><b>' + getTranslation( 'Opis przycisku' ) + ': ' + '</b></font><span>{descr}</span></div>', '<div><font '
                    + getTemplateStyle() + '><b>' + getTranslation( 'Ilość parametrów' ) + ': ' + '</b></font><span>{params}</span></div></div>',
                    '<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>' );
    buttonsTpl = buttonsTpl.compile();

    config = Ext.apply( {
        displayField: 'name',
        valueField: 'defId',
        store: store,
        triggerAction: 'all',
        mode: 'remote',
        pageSize: 5,
        lazyInit: false,
        forceSelection: true,
        minChars: 0,
        itemSelector: 'div.x-Module-comboTemplateItem',
        tpl: buttonsTpl,
        anchor: '100%',
        resizable: true,
        firstLoad: !Ext.isEmpty( config.buttonDefId )
    }, config );

    Ext.ux.suncode.DTButtonsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTButtonsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.DTButtonsChooser.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        if ( !Ext.isEmpty( this.initialConfig.buttonDefId ) ) {
            this.getStore().load( {
                params: {
                    keyToVerify: this.initialConfig.valueField,
                    valueToVerify: this.initialConfig.buttonDefId
                },
                callback: this.onAfterLoad,
                scope: this
            } );
        }
    },
    onAfterLoad: function( records, options, success ) {
        if ( success ) {
            var record = records[0];
            this.setValue( record.get( 'defId' ) );
            this.fireEvent( 'select', this, record );
        }
    }
} );

Ext.ux.suncode.AcceptButtonFunctionsChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'defId',
        type: 'string'
    }, {
        name: 'handler',
        type: 'string'
    }, {
        name: 'descr',
        type: 'string'
    } ] );

    var acceptBtnsFuncsObj = new Object();
    if ( typeof CUF !== 'undefined' && typeof CUF.AcceptButtonFunctions !== 'undefined' ) {
        acceptBtnsFuncsObj = CUF.AcceptButtonFunctions;
    }

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'POST',
            url: 'api/customobject/get',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        baseParams: {
            allObjects: Ext.util.JSON.encode( acceptBtnsFuncsObj ),
            start: 0,
            limit: 5
        }
    } );

    var functionsTemplate = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font ' + getTemplateStyle()
                    + '><b>' + getTranslation( 'Nazwa funkcji' ) + ': ' + '</b></font><span>{handler}</span></div>', '<div><font '
                    + getTemplateStyle() + '><b>' + getTranslation( 'Opis funkcji' ) + ': ' + '</b></font><span>{descr}</span></div></div>',
                    '<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>' );
    functionsTemplate = functionsTemplate.compile();

    config = Ext.apply( {
        displayField: 'handler',
        valueField: 'handler',
        store: store,
        triggerAction: 'all',
        mode: 'remote',
        pageSize: 5,
        lazyInit: false,
        forceSelection: false,
        itemSelector: 'div.x-Module-comboTemplateItem',
        tpl: functionsTemplate,
        anchor: '100%',
        flex: 1,
        resizable: true,
        maskRe: /[a-zA-Z0-9_$]/,
        listeners: {
            scope: this,
            afterrender: function( c ) {
                if ( Ext.isEmpty( config.jsAction ) ) {
                    return;
                }

                c.getStore().load( {
                    params: {
                        keyToVerify: c.initialConfig.valueField,
                        valueToVerify: config.jsAction
                    },
                    callback: this.onAfterLoad,
                    scope: this
                } );
            }
        }
    }, config );

    Ext.ux.suncode.AcceptButtonFunctionsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AcceptButtonFunctionsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.AcceptButtonFunctionsChooser.superclass.initComponent.call( this );
    },
    onAfterLoad: function( records, options, success ) {
        if ( success ) {
            if ( !Ext.isEmpty( records ) ) {
                var record = records[0];
                this.setValue( record.get( 'handler' ) );
            } else if ( !Ext.isEmpty( this.initialConfig.jsAction ) ) {
                this.setValue( this.initialConfig.jsAction );
            }
        }
    }
} );