Raphael.el.initConnections = function() {
    this.inConnections = new Array();
    this.outConnections = new Array();
    this.inCondConnections = new Array();
    this.outCondConnections = new Array();
    this.inOtherwises = new Array();
    this.outOtherwises = new Array();
    this.inExceptions = new Array();
    this.outExceptions = new Array();
    this.deadlineClocks = new Array();
    this.connectionsInitialized = true;
};

Raphael.el.hasInitializedConnections = function() {
  return this.connectionsInitialized;
};

Raphael.el.addConnection = function( id, inConn, pathSet, connectedWith ) {
    var connDef = new Object();

    connDef = Ext.apply( {
        id: id,
        pathSet: pathSet,
        connectedWith: connectedWith
    }, connDef );

    if ( inConn ) {
        this.inConnections.push( connDef );
    } else {
        this.outConnections.push( connDef );
    }
};

Raphael.el.updateConnection = function( id, inConn, pathSet ) {
    if ( inConn ) {
        var inConns = this.inConnections;
        for ( var i = 0; i < inConns.length; i++ ) {
            var inConn = inConns[i];

            if ( id == inConn.id ) {
                inConn.pathSet = pathSet;
                break;
            }
        }
    } else {
        var outConns = this.outConnections;
        for ( var i = 0; i < outConns.length; i++ ) {
            var outConn = outConns[i];

            if ( id == outConn.id ) {
                outConn.pathSet = pathSet;
                break;
            }
        }
    }
};

Raphael.el.addOtherwiseConnection = function( id, inConn, pathSet, connectedWith ) {
    var connDef = new Object();

    connDef = Ext.apply( {
        id: id,
        pathSet: pathSet,
        connectedWith: connectedWith
    }, connDef );

    if ( inConn ) {
        this.inOtherwises.push( connDef );
    } else {
        this.outOtherwises.push( connDef );
    }
};

Raphael.el.updateOtherwiseConnection = function( id, inConn, pathSet ) {
    if ( inConn ) {
        var inOtherwises = this.inOtherwises;
        for ( var i = 0; i < inOtherwises.length; i++ ) {
            var inOtherwise = inOtherwises[i];

            if ( id == inOtherwise.id ) {
                inOtherwise.pathSet = pathSet;
                break;
            }
        }
    } else {
        var outOtherwises = this.outOtherwises;
        for ( var i = 0; i < outOtherwises.length; i++ ) {
            var outOtherwise = outOtherwises[i];

            if ( id == outOtherwise.id ) {
                outOtherwise.pathSet = pathSet;
                break;
            }
        }
    }
};

Raphael.el.addException = function( id, inConn, pathSet, connectedWith ) {
    var connDef = new Object();

    connDef = Ext.apply( {
        id: id,
        pathSet: pathSet,
        connectedWith: connectedWith
    }, connDef );

    if ( inConn ) {
        this.inExceptions.push( connDef );
    } else {
        this.outExceptions.push( connDef );
    }
};

Raphael.el.addDeadlineClock = function( id, clock ) {
    this.deadlineClocks.push( {
        id: id,
        clock: clock
    } );
};

Raphael.el.updateDeadlineClock = function( id, clock ) {
    var clocks = this.deadlineClocks;

    for ( var i = 0; i < clocks.length; i++ ) {
        var clockObj = clocks[i];

        if ( id == clockObj.id ) {
            clockObj.clock.remove();
            clockObj.clock = clock;
            break;
        }
    }
};

Raphael.el.getDeadlineClock = function( id ) {
    var clocks = this.deadlineClocks;

    for ( var i = 0; i < clocks.length; i++ ) {
        var clockObj = clocks[i];

        if ( id == clockObj.id ) {
            return clockObj.clock;
        }
    }

    return null;
};

Raphael.el.updateException = function( id, inConn, pathSet ) {
    if ( inConn ) {
        var inExceptions = this.inExceptions;
        for ( var i = 0; i < inExceptions.length; i++ ) {
            var inException = inExceptions[i];

            if ( id == inException.id ) {
                inException.pathSet = pathSet;
                break;
            }
        }
    } else {
        var outExceptions = this.outExceptions;
        for ( var i = 0; i < outExceptions.length; i++ ) {
            var outException = outExceptions[i];

            if ( id == outException.id ) {
                outException.pathSet = pathSet;
                break;
            }
        }
    }
};

Raphael.el.removeDeadlineClockById = function( id ) {
    var clocks = this.deadlineClocks;

    for ( var i = 0; i < clocks.length; i++ ) {
        var clockObj = clocks[i];

        if ( id == clockObj.id ) {
            clockObj.clock.remove();
            clocks.splice( i, 1 );
            break;
        }
    }
};

Raphael.el.addCondConnection = function( inTransitionId, outTransitionId, inConn, pathSet, inPathSet, box, connectedWith ) {
    var connDef = new Object();

    if ( inConn ) {
        connDef = Ext.apply( {
            inTransitionId: inTransitionId,
            outTransitionId: outTransitionId,
            pathSet: pathSet,
            box: box,
            connectedWith: connectedWith
        }, connDef );

        this.inCondConnections.push( connDef );
    } else {
        for ( var i = 0; i < this.outCondConnections.length; i++ ) {
            if ( this.outCondConnections[i].outTransitionId == outTransitionId ) {
                this.outCondConnections[i].connections.push( {
                    inTransitionId: inTransitionId,
                    connectedWith: connectedWith,
                    pathSet: inPathSet
                } );
                return;
            }
        }

        var connections = new Array();
        connections.push( {
            inTransitionId: inTransitionId,
            connectedWith: connectedWith,
            pathSet: inPathSet
        } );

        connDef = Ext.apply( {
            outTransitionId: outTransitionId,
            pathSet: pathSet,
            box: box,
            connections: connections
        }, connDef );

        this.outCondConnections.push( connDef );
    }
};

Raphael.el.getInConnectionBox = function( id ) {
    var inCondConns = this.inCondConnections;

    for ( var i = 0; i < inCondConns.length; i++ ) {
        var conn = inCondConns[i];

        if ( id == conn.inTransitionId ) {
            return conn.box;
        }
    }
};

Raphael.el.removeConnectionById = function( id, preventPathRemoval ) {
    var outConns = this.outConnections;

    for ( var i = 0; i < outConns.length; i++ ) {
        var conn = outConns[i];

        if ( conn.id == id ) {
            var connectedWith = conn.connectedWith;
            var inConns = connectedWith.inConnections;

            for ( var j = 0; j < inConns.length; j++ ) {
                if ( inConns[j].id == conn.id ) {
                    inConns.splice( j, 1 );
                    break;
                }
            }

            if ( !preventPathRemoval ) {
            	conn.pathSet.remove();
            }
            
            outConns.splice( i, 1 );

            var fromSetType = this.data( 'setType' );
            var toSetType = connectedWith.data( 'setType' );

            if ( fromSetType != 'start' ) {
                removeTransition( 'basic', id, this.data( 'activityDefId' ), connectedWith.data( 'activityDefId' ) );
            }

            if ( fromSetType == 'start' ) {
                resetStartConnectingActivity( this.data( 'terminationId' ) );
            } else if ( toSetType == 'stop' ) {
                resetStopConnectingActivity( connectedWith.data( 'terminationId' ) );
            }

            break;
        }
    }
};

Raphael.el.removeOtherwiseConnectionById = function( id, preventPathRemoval ) {
    var outOtherwises = this.outOtherwises;

    for ( var i = 0; i < outOtherwises.length; i++ ) {
        var conn = outOtherwises[i];

        if ( conn.id == id ) {
            var connectedWith = conn.connectedWith;
            var inConns = connectedWith.inConnections;

            for ( var j = 0; j < inConns.length; j++ ) {
                if ( inConns[j].id == conn.id ) {
                    inConns.splice( j, 1 );
                    break;
                }
            }

            if ( !preventPathRemoval ) {
            	conn.pathSet.remove();
            }
            
            outOtherwises.splice( i, 1 );
            removeTransition( 'otherwise', id, this.data( 'activityDefId' ), connectedWith.data( 'activityDefId' ) );
            break;
        }
    }
};

Raphael.el.removeExceptionById = function( id, preventPathRemoval ) {
    var outExceptions = this.outExceptions;

    for ( var i = 0; i < outExceptions.length; i++ ) {
        var conn = outExceptions[i];

        if ( conn.id == id ) {
            var connectedWith = conn.connectedWith;
            var inExceptions = connectedWith.inExceptions;

            for ( var j = 0; j < inExceptions.length; j++ ) {
                if ( inExceptions[j].id == conn.id ) {
                    inExceptions.splice( j, 1 );
                    break;
                }
            }

            if ( !preventPathRemoval ) {
            	conn.pathSet.remove();
            	this.removeDeadlineClockById( id );
            }
            
            outExceptions.splice( i, 1 );
            removeTransition( 'exception', id, this.data( 'activityDefId' ), connectedWith.data( 'activityDefId' ) );
            break;
        }
    }
};

Raphael.el.removeCondConnectionById = function( id, inout, preventBoxRemoval, preventPathRemoval ) {
    switch ( inout ) {
        case 'in':
            var inConns = this.inCondConnections;

            for ( var i = 0; i < inConns.length; i++ ) {
                var inConn = inConns[i];

                if ( inConn.inTransitionId == id ) {
                    var connectedWith = inConn.connectedWith;
                    var outTransitionId = inConn.outTransitionId;
                    var outConns = connectedWith.outCondConnections;
                    var stop = false;

                    for ( var j = 0; j < outConns.length; j++ ) {
                        var outConn = outConns[j];
                        var conns = outConn.connections;

                        if ( outConn.outTransitionId == outTransitionId ) {
                            for ( var k = 0; k < conns.length; k++ ) {
                                var conn = conns[k];

                                if ( conn.inTransitionId == id ) {
                                    conns.splice( k, 1 );
                                    stop = true;
                                    break;
                                }
                            }
                        }

                        if ( stop ) {
                            if ( conns.length == 0 && !preventBoxRemoval ) {
                                outConn.pathSet.remove();
                                outConns.splice( j, 1 );
                            }

                            break;
                        }
                    }

                    if ( !preventPathRemoval ) {
                    	inConn.pathSet.remove();
                    }
                    
                    inConns.splice( i, 1 );

                    var toSetType = this.data( 'setType' );
                    if ( toSetType != 'stop' ) {
                        removeTransition( 'cond', id, connectedWith.data( 'activityDefId' ), this.data( 'activityDefId' ) );
                    } else if ( toSetType == 'stop' ) {
                        resetStopConnectingActivity( this.data( 'terminationId' ) );
                    }

                    break;
                }
            }

            break;
        case 'out':
            var outConns = this.outCondConnections;

            for ( var i = 0; i < outConns.length; i++ ) {
                var outConn = outConns[i];

                if ( outConn.outTransitionId == id ) {
                    var conns = outConn.connections.slice();

                    for ( var j = 0; j < conns.length; j++ ) {
                        var conn = conns[j];
                        var connectedWith = conn.connectedWith;
                        var inTransitionId = conn.inTransitionId;

                        connectedWith.removeCondConnectionById( inTransitionId, 'in', preventBoxRemoval, preventPathRemoval );
                    }

                    break;
                }
            }

            break;
        default:
            break;
    }
};

Raphael.el.updateInCondConnection = function( id, pathSet ) {
    var inCondConns = this.inCondConnections;

    for ( var i = 0; i < inCondConns.length; i++ ) {
        var inConn = inCondConns[i];

        if ( inConn.inTransitionId == id ) {
            inConn.pathSet = pathSet;
            var connectedWith = inConn.connectedWith;
            var outCondConns = connectedWith.outCondConnections;
            var updated = false;

            for ( var j = 0; j < outCondConns.length; j++ ) {
                var outConn = outCondConns[j];

                for ( var k = 0; k < outConn.connections.length; k++ ) {
                    var c = outConn.connections[k];

                    if ( c.inTransitionId == id ) {
                        c.pathSet = pathSet;
                        updated = true;
                        break;
                    }
                }

                if ( updated ) {
                    break;
                }
            }

            break;
        }
    }
};

Raphael.el.updateOutCondConnection = function( id, pathSet ) {
    var outCondConns = this.outCondConnections;

    for ( var i = 0; i < outCondConns.length; i++ ) {
        var outConn = outCondConns[i];

        if ( outConn.outTransitionId == id ) {
            outConn.pathSet = pathSet;
            break;
        }
    }
};

Raphael.el.updateCondConnectionType = function( id, newConditionType ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var activityNode = packagePanel.findActivity( processDefId, this.data( 'activityDefId' ) );
    var outCondConns = this.outCondConnections;

    for ( var i = 0; i < outCondConns.length; i++ ) {
        var outConn = outCondConns[i];

        if ( outConn.outTransitionId == id ) {
            outConn.pathSet.data( 'conditionType', newConditionType );

            for ( var j = 0; j < outConn.connections.length; j++ ) {
                activityNode.updateCondTransitionType( {
                    id: outConn.connections[j].inTransitionId,
                    condType: newConditionType
                } );
            }
            break;
        }
    }

    activityNode.setSplitTransitionRestriction( newConditionType );
};

Raphael.el.updateConnectionsToInfo = function( newActivityDefId ) {
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;

    for ( var i = 0; i < this.inConnections.length; i++ ) {
        var conn = this.inConnections[i];

        var connectedWith = conn.connectedWith;
        var setType = connectedWith.data( 'setType' );

        if ( setType != 'start' ) {
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateBasicTransitionTo( {
                id: conn.id,
                to: newActivityDefId
            } );
        } else {
            setStartConnectingActivity( connectedWith.data( 'terminationId' ), newActivityDefId );
        }
    }

    for ( var i = 0; i < this.inCondConnections.length; i++ ) {
        var conn = this.inCondConnections[i];

        var connectedWith = conn.connectedWith;
        var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

        thatActivityNode.updateCondTransitionTo( {
            id: conn.inTransitionId,
            to: newActivityDefId
        } );
    }

    for ( var i = 0; i < this.inOtherwises.length; i++ ) {
        var conn = this.inOtherwises[i];

        var connectedWith = conn.connectedWith;
        var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

        thatActivityNode.updateOtherwiseTransitionTo( {
            id: conn.id,
            to: newActivityDefId
        } );
    }

    for ( var i = 0; i < this.inExceptions.length; i++ ) {
        var conn = this.inExceptions[i];

        var connectedWith = conn.connectedWith;
        var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

        thatActivityNode.updateDeadlineTransitionTo( {
            id: conn.id,
            to: newActivityDefId
        } );
    }

    for ( var i = 0; i < this.outConnections.length; i++ ) {
        var conn = this.outConnections[i];

        var connectedWith = conn.connectedWith;
        var setType = connectedWith.data( 'setType' );

        if ( setType == 'stop' ) {
            setStopConnectingActivity( connectedWith.data( 'terminationId' ), newActivityDefId );
        }
    }

    for ( var i = 0; i < this.outCondConnections.length; i++ ) {
        var conn = this.outCondConnections[i];
        var connections = conn.connections;

        for ( var j = 0; j < connections.length; j++ ) {
            var connectedWith = connections[j].connectedWith;
            var setType = connectedWith.data( 'setType' );

            if ( setType == 'stop' ) {
                setStopConnectingActivity( connectedWith.data( 'terminationId' ), newActivityDefId );
            }
        }
    }
};

Raphael.el.moveConnectionsOnRoleAction = function( dy, limit ) {
    var paper = this.paper;
    var thisSetType = this.data( 'setType' );
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var thisActivityNode = null;
    if ( thisSetType != 'start' ) {
        thisActivityNode = packagePanel.findActivity( processDefId, this.data( 'activityDefId' ) );
    }

    for ( var i = 0; i < this.outConnections.length; i++ ) {
        var conn = this.outConnections[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            if ( thisSetType != 'start' ) {
                thisActivityNode.updateBasicTransitionPaths( {
                    id: connId,
                    linePaths: decomposePathAttrFromLineSet( pathSet )
                } );
            }

            paper.bpmn.movedTransitions[connId] = true;
        }
    }

    for ( var i = 0; i < this.inConnections.length; i++ ) {
        var conn = this.inConnections[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            var connectedWith = conn.connectedWith;
            var thatSetType = connectedWith.data( 'setType' );

            if ( thatSetType != 'start' ) {
                var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

                thatActivityNode.updateBasicTransitionPaths( {
                    id: conn.id,
                    linePaths: decomposePathAttrFromLineSet( pathSet )
                } );
            }

            paper.bpmn.movedTransitions[connId] = true;
        }
    }

    for ( var i = 0; i < this.outCondConnections.length; i++ ) {
        var conn = this.outCondConnections[i];
        var pathSet = conn.pathSet;
        var outConnId = conn.outTransitionId;
        var connectionLimit = limit;

        if ( !paper.bpmn.movedTransitions[outConnId] ) {
            var boxBox = null;

            for ( var j = 0; j < pathSet.length; j++ ) {
              var el = pathSet[j];

              if ( el.data( 'isBox' ) && !el.data( 'conditionSign' ) ) {
                boxBox = Raphael.pathBBox( el.attr( 'path' ) );
                break;
              }
            }

            if ( !Ext.isEmpty( boxBox ) && boxBox.y < limit ) {
              connectionLimit = boxBox.y2;
            }

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];

                if ( !el.data( 'isBox' ) ) {
                    transformLineElOnRoleAction( el, connectionLimit, dy );
                }
            }

            paper.bpmn.movedTransitions[outConnId] = true;
        }

        transformConnsForOutConn( paper, conn, connectionLimit, dy, thisSetType, thisActivityNode );

        if ( thisSetType != 'start' ) {
            var cs = conn.connections;

            for ( var j = 0; j < cs.length; j++ ) {
                thisActivityNode.updateCondTransitionBoxPaths( {
                    id: cs[j].inTransitionId,
                    boxPaths: decomposePathAttrFromLineSet( pathSet )
                } );
            }
        }
    }

    for ( var i = 0; i < this.inCondConnections.length; i++ ) {
        var conn = this.inCondConnections[i];
        var pathSet = conn.pathSet;
        var box = conn.box;
        var boxBox = Raphael.pathBBox( box.attr( 'path' ) );
        var inConnId = conn.inTransitionId;
        var outConnId = box.data( 'transitionId' );
        var connectedWith = conn.connectedWith;
        var thatSetType = connectedWith.data( 'setType' );
        var thatActivityNode = null;
        if ( thatSetType != 'start' ) {
            thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );
        }

        if ( !paper.bpmn.movedTransitions[inConnId] ) {
            var connectionLimit = null;

            if ( boxBox.y < limit ) {
              connectionLimit = boxBox.y2;
            } else {
              connectionLimit = limit;
            }

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, connectionLimit, dy );
            }

            paper.bpmn.movedTransitions[inConnId] = true;
        }

        if ( boxBox.y > limit ) {
            var wholeBoxSet = box.data( 'wholeSet' );

            if ( !paper.bpmn.movedTransitions[outConnId] ) {
                for ( var j = 0; j < wholeBoxSet.length; j++ ) {
                    var el = wholeBoxSet[j];

                    if ( !el.data( 'isBox' ) ) {
                        transformLineElOnRoleAction( el, limit, dy );
                    }
                }

                if ( thatSetType != 'start' ) {
                    thatActivityNode.updateCondTransitionBoxPaths( {
                        id: inConnId,
                        boxPaths: decomposePathAttrFromLineSet( wholeBoxSet )
                    } );
                }

                paper.bpmn.movedTransitions[outConnId] = true;
            }

            for ( var j = 0; j < connectedWith.outCondConnections.length; j++ ) {
                transformConnsForOutConn( paper, connectedWith.outCondConnections[j], limit, dy, thisSetType, thatActivityNode );
            }
        }

        if ( thatSetType != 'start' ) {
            thatActivityNode.updateCondTransitionLinePaths( {
                id: inConnId,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    for ( var i = 0; i < this.outOtherwises.length; i++ ) {
        var conn = this.outOtherwises[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            thisActivityNode.updateOtherwiseTransitionPaths( {
                id: connId,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );

            paper.bpmn.movedTransitions[connId] = true;
        }
    }

    for ( var i = 0; i < this.inOtherwises.length; i++ ) {
        var conn = this.inOtherwises[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            var connectedWith = conn.connectedWith;
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateOtherwiseTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );

            paper.bpmn.movedTransitions[connId] = true;
        }
    }

    for ( var i = 0; i < this.outExceptions.length; i++ ) {
        var conn = this.outExceptions[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            thisActivityNode.updateDeadlineTransitionPaths( {
                id: connId,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );

            paper.bpmn.movedTransitions[connId] = true;
        }
    }

    for ( var i = 0; i < this.inExceptions.length; i++ ) {
        var conn = this.inExceptions[i];
        var connId = conn.id;

        if ( !paper.bpmn.movedTransitions[connId] ) {
            var pathSet = conn.pathSet;

            for ( var j = 0; j < pathSet.length; j++ ) {
                var el = pathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            var connectedWith = conn.connectedWith;
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateDeadlineTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );

            paper.bpmn.movedTransitions[connId] = true;
        }
    }
};

function transformLineElOnRoleAction( el, limit, dy ) {
    var path = el.attr( 'path' );
    var isArrow = el.data( 'isArrow' );
    var pathBox = Raphael.pathBBox( path );

    if ( isArrow && pathBox.y > limit ) {
        el.attr( {
            path: clearPath( Raphael.transformPath( path, '...T0,' + dy ), false )
        } );
    } else if ( !isArrow ) {
        for ( var i = 0; i < path.length; i++ ) {
            var seg = path[i];

            if ( seg[2] > limit ) {
                seg[2] = parseInt( seg[2] + dy );
            }
        }

        el.attr( {
            path: path
        } );
    }
}

function transformConnsForOutConn( paper, conn, limit, dy, thisSetType, thisActivityNode ) {
    var cs = conn.connections;

    for ( var i = 0; i < cs.length; i++ ) {
        var c = cs[i];
        var inPathSet = c.pathSet;
        var inConnId = c.inTransitionId;

        if ( !paper.bpmn.movedTransitions[inConnId] ) {
            for ( var j = 0; j < inPathSet.length; j++ ) {
                var el = inPathSet[j];
                transformLineElOnRoleAction( el, limit, dy );
            }

            if ( thisSetType != 'start' ) {
                thisActivityNode.updateCondTransitionLinePaths( {
                    id: inConnId,
                    linePaths: decomposePathAttrFromLineSet( inPathSet )
                } );
            }

            paper.bpmn.movedTransitions[inConnId] = true;
        }
    }
}

Raphael.el.moveConnectionsOnDragAction = function( dx, dy ) {
    var paper = this.paper;
    var thisSetType = this.data( 'setType' );
    var packagePanel = Ext.getCmp( 'package_panel' );
    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    var thisActivityNode = null;
    if ( thisSetType != 'start' ) {
        thisActivityNode = packagePanel.findActivity( processDefId, this.data( 'activityDefId' ) );
    }

    var outConns = this.outConnections;
    var connsToRemove = new Array();

    for ( var i = 0; i < outConns.length; i++ ) {
        var conn = outConns[i];
        var pathSet = conn.pathSet;
        var connectedWith = conn.connectedWith;
        var toBox = connectedWith.getBBox();
        var el = pathSet[0];

        var connToRemove = handleOutConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy, false );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            if ( thisSetType != 'start' ) {
                thisActivityNode.updateBasicTransitionPaths( {
                    id: conn.id,
                    linePaths: decomposePathAttrFromLineSet( pathSet )
                } );
            }
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        conn.pathSet.remove();
        var connectedWith = conn.connectedWith;
        var box = connectedWith.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.basicLine( paper, this, connectedWith, x, y, false, false, false, {
            tId: conn.id
        } );
    }

    var inConns = this.inConnections;
    connsToRemove = new Array();

    for ( var i = 0; i < inConns.length; i++ ) {
        var conn = inConns[i];
        var pathSet = conn.pathSet;
        var toBox = this.getBBox();
        var el = pathSet[0];

        var connToRemove = handleInConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            var connectedWith = conn.connectedWith;
            var thatSetType = connectedWith.data( 'setType' );

            if ( thatSetType != 'start' ) {
                var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

                thatActivityNode.updateBasicTransitionPaths( {
                    id: conn.id,
                    linePaths: decomposePathAttrFromLineSet( pathSet )
                } );
            }
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        var connectedWith = conn.connectedWith;
        conn.pathSet.remove();
        var box = this.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.basicLine( paper, connectedWith, this, x, y, false, false, false, {
            tId: conn.id
        } );
    }

    var outCondConns = this.outCondConnections;
    connsToRemove = new Array();

    for ( var i = 0; i < outCondConns.length; i++ ) {
        var conn = outCondConns[i];
        var pathSet = conn.pathSet;
        var box = conn.box;
        var toBox = box.getBBox();
        var el = pathSet[0];

        var connToRemove = handleOutConnectionMove( conn, el, null, toBox, dx, dy, true );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            if ( thisActivityNode ) {
                for ( var j = 0; j < conn.connections.length; j++ ) {
                    thisActivityNode.updateCondTransitionBoxPaths( {
                        id: conn.connections[j].inTransitionId,
                        boxPaths: decomposePathAttrFromLineSet( pathSet )
                    } );
                }
            }
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        var box = conn.box;
        paper.bpmn.conditionBox = box;
        var pathSet = conn.pathSet;
        pathSet[0].remove();
        var line = paper.bpmn.newConnectionToBox( paper, box.data( 'conditionType' ), box.data( 'connectFrom' ), conn.outTransitionId );
        var pointAtLength = Raphael.getPointAtLength( line.attr( 'path' ), 0 );

        for ( var j = 0; j < conn.connections.length; j++ ) {
            thisActivityNode.updateCondTransitionBoxInfo( {
                id: conn.connections[j].inTransitionId,
                x: parseInt( pointAtLength.x ),
                y: parseInt( pointAtLength.y ),
                firstLineDirection: line.data( 'direction' ),
                boxDirection: box.data( 'direction' ),
                boxPaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    var inCondConns = this.inCondConnections;
    connsToRemove = new Array();

    for ( var i = 0; i < inCondConns.length; i++ ) {
        var conn = inCondConns[i];
        var pathSet = conn.pathSet;
        var toBox = this.getBBox();
        var el = pathSet[0];

        var connToRemove = handleInConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            var connectedWith = conn.connectedWith;
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateCondTransitionLinePaths( {
                id: conn.inTransitionId,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        var box = conn.box;
        paper.bpmn.conditionBox = box;
        conn.pathSet.remove();
        var toBox = this.getBBox();
        var x = randomInsidePoint( toBox.width, toBox.x );
        var y = randomInsidePoint( toBox.height, toBox.y );
        paper.bpmn.conditionalLine( paper, box.data( 'conditionType' ), 4, conn.connectedWith, this, x, y, false, false, {
            tId: conn.inTransitionId
        } );
    }

    var outOtherwises = this.outOtherwises;
    connsToRemove = new Array();

    for ( var i = 0; i < outOtherwises.length; i++ ) {
        var conn = outOtherwises[i];
        var pathSet = conn.pathSet;
        var connectedWith = conn.connectedWith;
        var toBox = connectedWith.getBBox();
        var el = pathSet[0];

        var connToRemove = handleOutConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy, false );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            thisActivityNode.updateOtherwiseTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        conn.pathSet.remove();
        var connectedWith = conn.connectedWith;
        var box = connectedWith.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.otherwiseLine( paper, this, connectedWith, x, y, false, false, false, {
            tId: conn.id
        } );
    }

    var inOtherwises = this.inOtherwises;
    connsToRemove = new Array();

    for ( var i = 0; i < inOtherwises.length; i++ ) {
        var conn = inOtherwises[i];
        var pathSet = conn.pathSet;
        var toBox = this.getBBox();
        var el = pathSet[0];

        var connToRemove = handleInConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            var connectedWith = conn.connectedWith;
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateOtherwiseTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        var connectedWith = conn.connectedWith;
        conn.pathSet.remove();
        var box = this.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.otherwiseLine( paper, connectedWith, this, x, y, false, false, false, {
            tId: conn.id
        } );
    }

    var deadlineClocksToTranslate = new Array();
    var outExceptions = this.outExceptions;
    connsToRemove = new Array();

    for ( var i = 0; i < outExceptions.length; i++ ) {
        var conn = outExceptions[i];
        var pathSet = conn.pathSet;
        var connectedWith = conn.connectedWith;
        var toBox = connectedWith.getBBox();
        var el = pathSet[0];

        var connToRemove = handleOutConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy, false );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            thisActivityNode.updateDeadlineTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
            deadlineClocksToTranslate[conn.id] = el;
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        conn.pathSet.remove();
        var connectedWith = conn.connectedWith;
        var box = connectedWith.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.deadlineLine( paper, this, connectedWith, x, y, false, false, false, {
            tId: conn.id
        } );
    }

    var deadlineClocks = this.deadlineClocks;

    for ( var i = 0; i < deadlineClocks.length; i++ ) {
        var deadlineClock = deadlineClocks[i];
        var deadlineLine = deadlineClocksToTranslate[deadlineClock.id];

        if ( deadlineLine ) {
            var deadlinePathM = deadlineLine.attr( 'path' )[0];
            var clock = deadlineClock.clock;
            clock.attr( {
                x: deadlinePathM[1] - 8,
                y: deadlinePathM[2] - 8
            } );
            clock.toFront();
        }
    }

    var inExceptions = this.inExceptions;
    connsToRemove = new Array();

    for ( var i = 0; i < inExceptions.length; i++ ) {
        var conn = inExceptions[i];
        var pathSet = conn.pathSet;
        var toBox = this.getBBox();
        var el = pathSet[0];

        var connToRemove = handleInConnectionMove( conn, el, pathSet[pathSet.length - 1], toBox, dx, dy );

        if ( connToRemove ) {
            connsToRemove.push( connToRemove );
        } else {
            var connectedWith = conn.connectedWith;
            var thatActivityNode = packagePanel.findActivity( processDefId, connectedWith.data( 'activityDefId' ) );

            thatActivityNode.updateDeadlineTransitionPaths( {
                id: conn.id,
                linePaths: decomposePathAttrFromLineSet( pathSet )
            } );
        }
    }

    for ( var i = 0; i < connsToRemove.length; i++ ) {
        var conn = connsToRemove[i];
        var connectedWith = conn.connectedWith;
        conn.pathSet.remove();
        var box = this.getBBox();
        var x = randomInsidePoint( box.width, box.x );
        var y = randomInsidePoint( box.height, box.y );
        paper.bpmn.deadlineLine( paper, connectedWith, this, x, y, false, false, false, {
            tId: conn.id
        } );
    }
};

function handleOutConnectionMove( conn, el, arrow, toBox, dx, dy, isCond ) {
    var direction = el.data( 'direction' );
    var path = el.attr( 'path' );
    var arrowTranslate = '';
    var box = Raphael.pathBBox( path );
    var boxWidth = box.width;
    var boxHeight = box.height;
    var transformation = '';

    switch ( direction ) {
        case 'rightdown':
            var scaleX = ( boxWidth - dx ) / boxWidth;
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x2 + ',' + box.y2;

            break;
        case 'rightup':
            var scaleX = ( boxWidth - dx ) / boxWidth;
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x2 + ',' + box.y;

            break;
        case 'leftdown':
            var scaleX = ( boxWidth + dx ) / boxWidth;
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x + ',' + box.y2;

            break;
        case 'leftup':
            var scaleX = ( boxWidth + dx ) / boxWidth;
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x + ',' + box.y;

            break;
        case 'up':
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleY <= 0 || ( !isCond && ( toBox.x + 8 >= box.x + dx || toBox.x2 - 16 <= box.x2 + dx ) ) || ( isCond && dx != 0 ) ) {
                return conn;
            }

            transformation = '...S1,' + scaleY + ',' + box.x + ',' + box.y;

            if ( dx != 0 ) {
                transformation += 'T' + dx + ',0';
                arrowTranslate = '...T' + dx + ',0';
            }

            break;
        case 'down':
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleY <= 0 || ( !isCond && ( toBox.x + 8 >= box.x + dx || toBox.x2 - 16 <= box.x2 + dx ) ) || ( isCond && dx != 0 ) ) {
                return conn;
            }

            transformation = '...S1,' + scaleY + ',' + box.x + ',' + box.y2;

            if ( dx != 0 ) {
                transformation += 'T' + dx + ',0';
                arrowTranslate = '...T' + dx + ',0';
            }

            break;
        case 'right':
            var scaleX = ( boxWidth - dx ) / boxWidth;

            if ( scaleX <= 0 || ( !isCond && ( toBox.y + 8 >= box.y + dy || toBox.y2 - 14 <= box.y2 + dy ) ) || ( isCond && dy != 0 ) ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',1,' + box.x2 + ',' + box.y;

            if ( dy != 0 ) {
                transformation += 'T0,' + dy;
                arrowTranslate = '...T0,' + dy;
            }

            break;
        case 'left':
            var scaleX = ( boxWidth + dx ) / boxWidth;

            if ( scaleX <= 0 || ( !isCond && ( toBox.y + 8 >= box.y + dy || toBox.y2 - 14 <= box.y2 + dy ) ) || ( isCond && dy != 0 ) ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',1,' + box.x + ',' + box.y2;

            if ( dy != 0 ) {
                transformation += 'T0,' + dy;
                arrowTranslate = '...T0,' + dy;
            }

            break;
        case 'custom':
            var firstTurnIdx = 1;
            var lPath = path[firstTurnIdx];
            var xPos = parseInt( lPath[1] );
            var yPos = parseInt( lPath[2] );
            var paper = el.paper;
            var connectFrom = el.data( 'connectFrom' );
            var fromBox = connectFrom.getBBox();
            fromBox.setType = connectFrom.data( 'setType' );

            var newLineSet = paper.bpmn.basicLineTooltip( paper, fromBox, xPos, yPos );

            var newPath = newLineSet[0].attr( 'path' );
            for ( var i = ( firstTurnIdx + 1 ); i < path.length; i++ ) {
                newPath.push( path[i] );
            }

            el.attr( {
                path: clearPath( newPath, true )
            } );
            newLineSet.remove();
            return null;
            break;
        case 'empty':
            return conn;
        default:
            break;
    }

    el.attr( {
        path: clearPath( Raphael.transformPath( path, transformation ), true )
    } );

    if ( !Ext.isEmpty( arrowTranslate ) && arrow ) {
        path = arrow.attr( 'path' );

        arrow.attr( {
            path: clearPath( Raphael.transformPath( path, arrowTranslate ), false )
        } );
    }

    return null;
}

function handleInConnectionMove( conn, el, arrow, toBox, dx, dy ) {
    var direction = el.data( 'direction' );
    var path = el.attr( 'path' );
    var arrowTranslate = '';
    var box = Raphael.pathBBox( path );
    var boxWidth = box.width;
    var boxHeight = box.height;
    var transformation = '';

    switch ( direction ) {
        case 'rightdown':
            var scaleX = ( boxWidth + dx ) / boxWidth;
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x + ',' + box.y;
            arrowTranslate = '...T' + dx + ',' + dy;
            break;
        case 'rightup':
            var scaleX = ( boxWidth + dx ) / boxWidth;
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x + ',' + box.y2;
            arrowTranslate = '...T' + dx + ',' + dy;
            break;
        case 'leftdown':
            var scaleX = ( boxWidth - dx ) / boxWidth;
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x2 + ',' + box.y;
            arrowTranslate = '...T' + dx + ',' + dy;
            break;
        case 'leftup':
            var scaleX = ( boxWidth - dx ) / boxWidth;
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleX <= 0 || scaleY <= 0 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',' + scaleY + ',' + box.x2 + ',' + box.y2;
            arrowTranslate = '...T' + dx + ',' + dy;
            break;
        case 'up':
            var scaleY = ( boxHeight - dy ) / boxHeight;

            if ( scaleY <= 0 || toBox.x + 8 >= box.x || toBox.x2 - 16 <= box.x2 ) {
                return conn;
            }

            transformation = '...S1,' + scaleY + ',' + box.x + ',' + box.y2;
            arrowTranslate = '...T0,' + dy;
            break;
        case 'down':
            var scaleY = ( boxHeight + dy ) / boxHeight;

            if ( scaleY <= 0 || toBox.x + 8 >= box.x || toBox.x2 - 16 < box.x2 ) {
                return conn;
            }

            transformation = '...S1,' + scaleY + ',' + box.x + ',' + box.y;
            arrowTranslate = '...T0,' + dy;
            break;
        case 'right':
            var scaleX = ( boxWidth + dx ) / boxWidth;

            if ( scaleX <= 0 || toBox.y + 8 >= box.y || toBox.y2 - 14 < box.y2 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',1,' + box.x + ',' + box.y;
            arrowTranslate = '...T' + dx + ',0';
            break;
        case 'left':
            var scaleX = ( boxWidth - dx ) / boxWidth;

            if ( scaleX <= 0 || toBox.y + 8 >= box.y || toBox.y2 - 14 < box.y2 ) {
                return conn;
            }

            transformation = '...S' + scaleX + ',1,' + box.x2 + ',' + box.y;
            arrowTranslate = '...T' + dx + ',0';
            break;
        case 'custom':
            var lastTurnIdx = path.length - 2;
            var lastTurnElTab = path[lastTurnIdx];
            var beginPath = path.splice( 0, lastTurnIdx + 1 );
            var xPos = randomInsidePoint( toBox.width, toBox.x );
            var yPos = randomInsidePoint( toBox.height, toBox.y );
            var paper = el.paper;
            var xStart = parseInt( lastTurnElTab[1] );
            var yStart = parseInt( lastTurnElTab[2] );
            var fromBox = {
                x: xStart,
                y: yStart,
                x2: xStart,
                y2: yStart,
                width: 0,
                height: 0
            };

            var connectTo = el.data( 'connectedWith' );
            toBox.setType = connectTo.data( 'setType' );
            var newLineSet = paper.bpmn.basicLineFinal( paper, el.data( 'connectFrom' ), el.data( 'connectedWith' ), fromBox, toBox, xPos, yPos,
                            false );

            var newPath = beginPath.concat( newLineSet[0].attr( 'path' ) );
            el.attr( {
                path: clearPath( newPath, true )
            } );
            arrow.attr( {
                path: newLineSet[newLineSet.length - 1].attr( 'path' )
            } );
            newLineSet.remove();
            return null;
        case 'empty':
            return conn;
        default:
            break;
    }

    el.attr( {
        path: clearPath( Raphael.transformPath( path, transformation ), true )
    } );

    path = arrow.attr( 'path' );

    arrow.attr( {
        path: clearPath( Raphael.transformPath( path, arrowTranslate ), false )
    } );

    return null;
}

Raphael.el.removeAllConnections = function() {
    var inConnections = [].concat( this.inConnections );
    for ( var i = 0; i < inConnections.length; i++ ) {
        var conn = inConnections[i];
        var connectedWith = conn.connectedWith;
        var outConns = connectedWith.outConnections;

        for ( var j = 0; j < outConns.length; j++ ) {
            if ( outConns[j].id == conn.id ) {
                connectedWith.removeConnectionById( conn.id );
                break;
            }
        }
    }
    this.inConnections = new Array();

    var outConnections = [].concat( this.outConnections );
    for ( var i = 0; i < outConnections.length; i++ ) {
        var conn = outConnections[i];
        this.removeConnectionById( conn.id );
    }
    this.outConnections = new Array();

    var inCondConnections = [].concat( this.inCondConnections );
    for ( var i = 0; i < inCondConnections.length; i++ ) {
        var conn = inCondConnections[i];
        this.removeCondConnectionById( conn.inTransitionId, 'in', false );
    }
    this.inCondConnections = new Array();

    var outCondConnections = [].concat( this.outCondConnections );
    for ( var i = 0; i < outCondConnections.length; i++ ) {
        var conn = outCondConnections[i];
        this.removeCondConnectionById( conn.outTransitionId, 'out', false );
    }
    this.outCondConnections = new Array();

    var inOtherwises = [].concat( this.inOtherwises );
    for ( var i = 0; i < inOtherwises.length; i++ ) {
        var conn = inOtherwises[i];
        var connectedWith = conn.connectedWith;
        var outConns = connectedWith.outOtherwises;

        for ( var j = 0; j < outConns.length; j++ ) {
            if ( outConns[j].id == conn.id ) {
                connectedWith.removeOtherwiseConnectionById( conn.id );
                break;
            }
        }
    }
    this.inOtherwises = new Array();

    var outOtherwises = [].concat( this.outOtherwises );
    for ( var i = 0; i < outOtherwises.length; i++ ) {
        var conn = outOtherwises[i];
        this.removeOtherwiseConnectionById( conn.id );
    }
    this.outOtherwises = new Array();

    var inExceptions = [].concat( this.inExceptions );
    for ( var i = 0; i < inExceptions.length; i++ ) {
        var conn = inExceptions[i];
        var connectedWith = conn.connectedWith;
        var outConns = connectedWith.outExceptions;

        for ( var j = 0; j < outConns.length; j++ ) {
            if ( outConns[j].id == conn.id ) {
                connectedWith.removeExceptionById( conn.id );
                break;
            }
        }
    }
    this.inExceptions = new Array();

    var outExceptions = [].concat( this.outExceptions );
    for ( var i = 0; i < outExceptions.length; i++ ) {
        var conn = outExceptions[i];
        this.removeExceptionById( conn.id );
    }
    this.outExceptions = new Array();
};

Raphael.el.duplicateConnection = function( connectTo ) {
    var connectToActDefId = connectTo.data( 'activityDefId' );
    var outConns = this.outConnections;

    for ( var i = 0; i < outConns.length; i++ ) {
        var activityDefId = outConns[i].connectedWith.data( 'activityDefId' );

        if ( connectToActDefId == activityDefId ) {
            return true;
        }
    }

    var outCondConns = this.outCondConnections;

    for ( var i = 0; i < outCondConns.length; i++ ) {
        var connections = outCondConns[i].connections;
        for ( var j = 0; j < connections.length; j++ ) {
            var activityDefId = connections[j].connectedWith.data( 'activityDefId' );

            if ( connectToActDefId == activityDefId ) {
                return true;
            }
        }
    }

    var outExceptions = this.outExceptions;

    for ( var i = 0; i < outExceptions.length; i++ ) {
        var activityDefId = outExceptions[i].connectedWith.data( 'activityDefId' );

        if ( connectToActDefId == activityDefId ) {
            return true;
        }
    }

    return false;
};