Raphael.fn.bpmn = {
    movedTransitions: [],
    scaleFactor: 1.2,
    maxScale: 10,
    elDragged: false,
    timeout: null,
    startStopDiameter: 40,
    activityWidth: 90,
    activityHeight: 60,
    hoverBlocked: false,
    conditionSize: 20,
    conditionBox: null,
    roleWidth: 30,
    roleHeight: 150,
    minRoleWidth: 400,
    autoOffset: 20,
    helperRadius: 10,
    cornerOffset: 5,
    lineCursorSpread: 10,
    participantCornerRadius: 8,
    clickedLineStrokeWidth: 4,
    searchLinePrecision: 8,
    editionMode: true,
    currentActivityMapMode: false,
    simulationMode: false,
    processPreviewMode: false,
    gridMargin: 2,
    activateCurrentActivityMapMode: function() {
        this.editionMode = false;
        this.currentActivityMapMode = true;
        this.simulationMode = false;
        this.processPreviewMode = false;
    },
    activateSimulationMode: function() {
        this.editionMode = false;
        this.currentActivityMapMode = false;
        this.simulationMode = true;
        this.processPreviewMode = false;
    },
    activateProcessPreviewMode: function() {
        this.editionMode = false;
        this.currentActivityMapMode = false;
        this.simulationMode = false;
        this.processPreviewMode = true;
    },
    roundedRectangle: function( paper, x, y, w, h, r1, r2, r3, r4 ) {
        var pathArray = this.roundedRectanglePath( x, y, w, h, r1, r2, r3, r4 );

        roundedRectangle = paper.path( pathArray );
        roundedRectangle = roundedRectangle.data( 'roundedRectangle', true );

        return roundedRectangle;
    },
    roundedRectanglePath: function( x, y, w, h, r1, r2, r3, r4 ) {
        var pathArray = [];
        pathArray = pathArray.concat( [ 'M', x, r1 + y, 'Q', x, y, x + r1, y ] );
        pathArray = pathArray.concat( [ 'L', x + w - r2, y, 'Q', x + w, y, x + w, y + r2 ] );
        pathArray = pathArray.concat( [ 'L', x + w, y + h - r3, 'Q', x + w, y + h, x + w - r3, y + h ] );
        pathArray = pathArray.concat( [ 'L', x + r4, y + h, 'Q', x, y + h, x, y + h - r4, 'Z' ] );

        return pathArray;
    },
    zoomIn: function( paper ) {
        if ( paper.scale < 1 / this.maxScale ) {
            return;
        }

        var newScale = paper.scale / this.scaleFactor;
        paper.scale = newScale;
        this.handlePaperSize( paper );
    },
    zoomOut: function( paper ) {
        if ( paper.scale > this.maxScale ) {
            return;
        }

        var newScale = paper.scale * this.scaleFactor;
        paper.scale = newScale;
        this.handlePaperSize( paper );
    },
    resetZoom: function( paper ) {
        paper.scale = 1;
        this.handlePaperSize( paper );
    },
    fitProcessMapSizeVertically: function( paper ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        paper.scale = this.getHeightFitScale( paper, processPanel );
        this.handlePaperSize( paper );
    },
    fitProcessMapSizeHorizontally: function( paper ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        paper.scale = this.getWidthFitScale( paper, processPanel );
        this.handlePaperSize( paper );
    },
    fitProcessMapSize: function( paper ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var widthScale = this.getWidthFitScale( paper, processPanel );
        var heightScale = this.getHeightFitScale( paper, processPanel );

        if ( widthScale > heightScale ) {
            paper.scale = widthScale;
        } else {
            paper.scale = heightScale;
        }

        this.handlePaperSize( paper );
    },
    getWidthFitScale: function( paper, processPanel ) {
        var width = processPanel.getWidth();
        return ( paper.lastRoleXPos + this.roleWidth + 30 ) / width;
    },
    getHeightFitScale: function( paper, processPanel ) {
        var height = processPanel.getHeight() - 25;
        return ( paper.lastRoleYPos + 25 ) / height;
    },
    onRoleResizerDrag: function( x, y, e ) {
        var paper = this.paper;
        paper.bpmn.hoverBlocked = true;
        var roleField = this.data( 'roleField' );
        var box = roleField.getBBox();
        var resizeRect = paper.rect( 0, box.y, box.x2, box.height, paper.bpmn.participantCornerRadius );
        resizeRect = resizeRect.attr( {
            stroke: '#7F9DB9',
            'stroke-width': 1,
            'stroke-dasharray': [ '--' ]
        } ).data( 'setType', 'resizeRect' );
        paper.resizerTrash.push( resizeRect );
        this.resizeRect = resizeRect;
        this.lastdx = 0;
        this.lastdy = 0;
        this.limits = paper.bpmn.getRoleElementsLimits( paper, roleField );
        this.doDrop = true;
        this.toFront();
    },
    onRoleResizerMove: function( dx, dy, x, y, e ) {
        if ( !this.doDrop ) {
            return;
        }

        var roleField = this.data( 'roleField' );
        var roleBox = roleField.getBBox();
        var limits = this.limits;
        var resizeType = this.data( 'resizeType' );
        var resizeRect = this.resizeRect;
        var paper = this.paper;
        var scale = paper.scale;
        dx *= scale;
        dy *= scale;

        if ( resizeType == 'vertical' ) {
            dx = 0;
        } else if ( resizeType == 'horizontal' ) {
            dy = 0;
        }

        if ( roleBox.y2 + dy > limits.y ) {
            var yTransform = dy - this.lastdy;
            resizeRect.attr( {
                height: resizeRect.attr( 'height' ) + yTransform
            } );
            this.transform( '...T0,' + yTransform );
            this.lastdy = dy;
        }
        if ( roleBox.x2 + dx > limits.x ) {
            var xTransform = dx - this.lastdx;
            resizeRect.attr( {
                width: resizeRect.attr( 'width' ) + xTransform
            } );
            this.transform( '...T' + xTransform + ',0' );
            this.lastdx = dx;
        }
    },
    onRoleResizerDrop: function( e ) {
        if ( !this.doDrop ) {
            return;
        }

        var paper = this.paper;
        paper.bpmn.hoverBlocked = false;
        var resizeType = this.data( 'resizeType' );
        var roleField = this.data( 'roleField' );

        if ( resizeType == 'vertical' ) {
            paper.bpmn.executeSpreadRoleVerticaly( paper, roleField, this.lastdy, paper.set().push( this ) );
        } else if ( resizeType == 'horizontal' ) {
            paper.bpmn.executeSpreadRoleHorizontaly( paper, roleField, this.lastdx );
        } else {
            paper.bpmn.executeSpreadRoleVerticaly( paper, roleField, this.lastdy, paper.set().push( this ) );
            paper.bpmn.executeSpreadRoleHorizontaly( paper, roleField, this.lastdx );
        }

        paper.bpmn.eraseTrash( paper.resizerTrash );
        paper.bpmn.handlePaperSize( paper );
    },
    onElDrag: function( x, y, e ) {
        this.doDrop = false;
        var draggedSet = this;
        var paper = this[0].paper;

        paper.bpmn.timeout = window.setTimeout( function() {
            paper.bpmn.elDragged = true;
            var connector = null;
            paper.bpmn.eraseAllTrashes( paper );
            var xPos = 0;
            var yPos = 0;
            var connectorDragStartX = 0;
            var connectorDragStartY = 0; 

            for ( var i = 0; i < draggedSet.length; i++ ) {
                var item = draggedSet[i];
                var dragStartX = item.attr( 'x' );
                var dragStartY = item.attr( 'y' );

                if ( item.data( 'connector' ) ) {
                    connector = item;
                    xPos = dragStartX;
                    yPos = dragStartY;
                    connectorDragStartX = dragStartX;
                    connectorDragStartY = dragStartY;
                }
                
                item.dragStartX = dragStartX;
                item.dragStartY = dragStartY;
            }

            var connectorSetType = connector.data( 'setType' );
            var set = null;
            var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
            var panelPos = processPanel.getPosition();
            var scrollX = processPanel.body.dom.scrollLeft;
            var scrollY = processPanel.body.dom.scrollTop;
            var scale = paper.scale;
            var cursorStartX = ( x - panelPos[0] + scrollX ) * scale;
            var cursorStartY = ( y - panelPos[1] + scrollY ) * scale;
            
            if ( paper.snapToGrid ) {
            	var distanceXCompensation = paper.bpmn.getDistanceXFromGrid( paper, cursorStartX )
            		- paper.bpmn.getDistanceXFromGrid( paper, connectorDragStartX );
            	var distanceYCompensation = paper.bpmn.getDistanceYFromGrid( paper, cursorStartY )
            		- paper.bpmn.getDistanceYFromGrid( paper, connectorDragStartY );
            	draggedSet.distanceXCompensation = distanceXCompensation;
            	draggedSet.distanceYCompensation = distanceYCompensation;
            	xPos = paper.bpmn.evaluateGridXPosition( paper, connectorDragStartX );
            	yPos = paper.bpmn.evaluateGridYPosition( paper, connectorDragStartY );
            }
            
            switch ( connectorSetType ) {
                case 'route':
                    set = paper.bpmn.route( paper, xPos, yPos, true, 0, connector.data( 'activityName' ), connector.data( 'activityDefId' ) );
                    break;
                case 'activity':
                    set = paper.bpmn.activity( paper, xPos, yPos, true, 0, connector.data( 'activityName' ), connector.data( 'activityDefId' ) );
                    break;
                case 'tool':
                    set = paper.bpmn.tool( paper, xPos, yPos, true, 0, connector.data( 'activityName' ), connector.data( 'activityDefId' ) );
                    break;
                case 'subflow':
                    set = paper.bpmn.subflow( paper, xPos, yPos, true, 0, connector.data( 'activityName' ), connector.data( 'activityDefId' ) );
                    break;
                case 'start':
                    set = paper.bpmn.start( paper, xPos, yPos, true );
                    break;
                case 'stop':
                    set = paper.bpmn.stop( paper, xPos, yPos, true );
                    break;
                default:
                    break;
            }

            for ( var i = 0; i < set.length; i++ ) {
                var item = set[i];

                if ( item.type == 'circle' ) {
                    item.dragStartX = item.attr( 'cx' );
                    item.dragStartY = item.attr( 'cy' );
                } else {
                    item.dragStartX = item.attr( 'x' );
                    item.dragStartY = item.attr( 'y' );
                }

                if ( item.data( 'connector' ) ) {
                	if ( item.type == 'circle' ) {
                        item.connectorDragStartX = connectorDragStartX + paper.bpmn.startStopDiameter / 2;
                        item.connectorDragStartY = connectorDragStartY + paper.bpmn.startStopDiameter / 2;
                    } else {
                        item.connectorDragStartX = connectorDragStartX;
                        item.connectorDragStartY = connectorDragStartY;
                    }
                }
            }

            draggedSet.dndSet = set;
            paper.dragTrash.push( set );
            paper.bpmn.hoverBlocked = true;
            draggedSet.lastdx = 0;
            draggedSet.lastdy = 0;
            draggedSet.realdx = 0;
            draggedSet.realdy = 0;
            draggedSet.connectorDragStartX = connectorDragStartX;
            draggedSet.connectorDragStartY = connectorDragStartY;
        }, 100 );
    },
    onElMove: function( dx, dy, x, y, e ) {
        var paper = this[0].paper;
        if ( !paper.bpmn.elDragged || ( dx == 0 && dx == this.lastdx && dy == 0 && dy == this.lastdy ) ) {
            return;
        }

        var scale = paper.scale;
        dx *= scale;
        dy *= scale;

        var setType = this[0].data( 'setType' );
        var set = this.dndSet;
        var xBorder = paper.bpmn.roleWidth + 1;
        var yBorder = 1;

        if ( setType == 'start' || setType == 'stop' ) {
            xBorder = paper.bpmn.roleWidth + 2 + paper.bpmn.startStopDiameter / 2;
            yBorder = 2 + paper.bpmn.startStopDiameter / 2;
        }

        for ( var i = 0; i < set.length; i++ ) {
            var item = set[i];
            var itemType = item.type;
            var newX = item.dragStartX + dx;
            var newY = item.dragStartY + dy;
            var newTextX = newX;
            var newTextY = newY;
            
            if ( paper.snapToGrid ) {
            	newX = paper.bpmn.evaluateGridXPosition( paper, this.connectorDragStartX + this.distanceXCompensation + dx );
            	newY = paper.bpmn.evaluateGridYPosition( paper, this.connectorDragStartY + this.distanceYCompensation + dy );
            	
            	if ( setType == 'start' || setType == 'stop' ) {
                    newX += paper.bpmn.startStopDiameter / 2;
                    newY += paper.bpmn.startStopDiameter / 2;
                } else {
                	newTextX = newX + paper.bpmn.activityWidth / 2;
                	newTextY = newY + paper.bpmn.activityHeight / 2;
                }
            }

            if ( newX > xBorder ) {
                if ( itemType == 'circle' ) {
                    item.attr( {
                        cx: newX
                    } );
                } else if ( itemType == 'text' ) {
                	item.attr( {
                        x: newTextX
                    } );
                } else {
                    item.attr( {
                        x: newX
                    } );
                }

                this.lastdx = dx;
                
                if ( item.data( 'connector' ) ) {
                	this.realdx = newX - item.connectorDragStartX;
                }
            }
            
            if ( newY > yBorder ) {
                if ( itemType == 'circle' ) {
                    item.attr( {
                        cy: newY
                    } );
                } else if ( itemType == 'text' ) {
                	item.attr( {
                        y: newTextY
                    } );
                } else {
                    item.attr( {
                        y: newY
                    } );
                }

                this.lastdy = dy;
                
                if ( item.data( 'connector' ) ) {
                	this.realdy = newY - item.connectorDragStartY;
                }
            }
        }

        if ( Math.abs( dx ) > 0 || Math.abs( dy ) > 0 ) {
            this.doDrop = true;
        }
    },
    onElDrop: function( e ) {
        var paper = this[0].paper;
        var timeout = paper.bpmn.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        if ( !this.doDrop ) {
            paper.bpmn.clearElDragInfo( paper, this );
            return;
        }

        var lastdx = this.lastdx;
        var lastdy = this.lastdy;
        var realdx = this.realdx;
        var realdy = this.realdy;
        var connector = paper.bpmn.getConnectorFromSet( this );
        var setType = connector.data( 'setType' );
        var forbidden = false;
        var excludeRole = false;
        var excludeSystem = false;
        var xPos = connector.dragStartX + lastdx;
        var yPos = connector.dragStartY + lastdy;
        var roleField = null;

        if ( paper.snapToGrid ) {
        	xPos = paper.bpmn.evaluateGridXPosition( paper, this.connectorDragStartX + this.distanceXCompensation + lastdx );
        	yPos = paper.bpmn.evaluateGridYPosition( paper, this.connectorDragStartY + this.distanceYCompensation + lastdy );
        }
        
        switch ( setType ) {
            case 'activity':
                excludeSystem = true;
                break;
            case 'tool':
                excludeRole = true;
                break;
            case 'subflow':
                excludeSystem = true;
                break;
            default:
                break;
        }

        var set = paper.getElementsByPoint( xPos, yPos );

        for ( var i = 0; i < set.length; i++ ) {
            var item = set[i];
            var st = item.data( 'setType' );

            switch ( setType ) {
                case 'route':
                    if ( st == 'roleField' || st == 'systemField' ) {
                        roleField = item;
                    }
                    break;
                case 'activity':
                    if ( st == 'roleField' ) {
                        roleField = item;
                    } else if ( st == 'systemField' ) {
                        forbidden = true;
                    }
                    break;
                case 'tool':
                    if ( st == 'roleField' ) {
                        forbidden = true;
                    } else if ( st == 'systemField' ) {
                        roleField = item;
                    }
                    break;
                case 'subflow':
                    if ( st == 'roleField' ) {
                        roleField = item;
                    } else if ( st == 'systemField' ) {
                        forbidden = true;
                    }
                    break;
                case 'start':
                    if ( st == 'roleField' || st == 'systemField' ) {
                        roleField = item;
                    }
                    break;
                case 'stop':
                    if ( st == 'roleField' || st == 'systemField' ) {
                        roleField = item;
                    }
                    break;
                default:
                    return;
            }

            if ( forbidden ) {
                paper.bpmn.clearElDragInfo( paper, this );
                return;
            }
        }

        if ( !roleField ) {
            roleField = paper.bpmn.getLastRoleField( paper, xPos, yPos, excludeRole, excludeSystem );

            if ( !roleField ) {
                paper.bpmn.clearElDragInfo( paper, this );
                return;
            }
        }

        var droppedSet = this;
        var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 200 : 1;

        for ( var j = 0; j < this.length; j++ ) {
            var item = this[j];

            if ( item.data( 'connector' ) ) {
                item.animate( {
                    x: xPos,
                    y: yPos
                }, animDuration, 'linear', function() {
                    var connectorSetType = connector.data( 'setType' );
                    paper.bpmn.spreadRole( paper, xPos, yPos, connector, roleField, droppedSet );
                    paper.bpmn.dragRoleChange( droppedSet, roleField, connectorSetType );
                    connector.moveConnectionsOnDragAction( realdx, realdy );

                    var roleBox = Raphael.pathBBox( roleField.attr( 'path' ) );
                    if ( connectorSetType == 'start' ) {
                        setProcessStartLocation( connector.data( 'terminationId' ), roleField.data( 'roleId' ), xPos, ( yPos - roleBox.y ) );
                    } else if ( connectorSetType == 'stop' ) {
                        setProcessStopLocation( connector.data( 'terminationId' ), roleField.data( 'roleId' ), xPos, ( yPos - roleBox.y ) );
                    } else {
                        updateActivityLocation( connector.data( 'activityDefId' ), xPos, ( yPos - roleBox.y ) );
                    }

                    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                    var storageLine = processPanel.getFromStorage( 'conditionalLine' );

                    if ( storageLine ) {
                        var lineEl = storageLine[0];
                        var storageConnectFrom = lineEl.data( 'connectFrom' );

                        if ( storageConnectFrom.data( 'activityDefId' ) == connector.data( 'activityDefId' ) ) {
                            paper.bpmn.conditionBox = storageLine[storageLine.length - 1];

                            var condType = lineEl.data( 'conditionType' );
                            var connId = lineEl.data( 'transitionId' );
                            var newLine = paper.bpmn.newConnectionToBox( paper, condType, connector, connId );

                            newLine = newLine.attr( {
                                'stroke-dasharray': [ '--' ]
                            } );

                            lineEl.remove();
                            storageLine.splice( 0, 1, newLine );
                            processPanel.addToStorage( 'conditionalLine', storageLine );
                        }
                    } else {
                        storageLine = processPanel.getFromStorage( 'customLine' );

                        if ( storageLine ) {
                            var scf = storageLine.data( 'connectFrom' );
                            var actDefId1 = connector.data( 'activityDefId' );
                            var actDefId2 = scf.data( 'activityDefId' );
                            var termId1 = connector.data( 'terminationId' );
                            var termId2 = scf.data( 'terminationId' );

                            if ( actDefId1 == actDefId2 && termId1 == termId2 ) {
                                var storagePath = storageLine.attr( 'path' );
                                var firstTurnIdx = 1;
                                var lPath = storagePath[firstTurnIdx];
                                var lineXPos = parseInt( lPath[1] );
                                var lineYPos = parseInt( lPath[2] );
                                var fromBox = connector.getBBox();
                                fromBox.setType = setType;

                                var newLineSet = paper.bpmn.basicLineTooltip( paper, fromBox, lineXPos, lineYPos );

                                var newPath = newLineSet[0].attr( 'path' );
                                for ( var i = ( firstTurnIdx + 1 ); i < storagePath.length; i++ ) {
                                    newPath.push( storagePath[i] );
                                }

                                var deadlineClock = processPanel.getFromStorage( 'deadlineClock' );
                                if ( deadlineClock ) {
                                    var deadlinePathM = newPath[0];
                                    deadlineClock.attr( {
                                        x: deadlinePathM[1] - 8,
                                        y: deadlinePathM[2] - 8
                                    } );
                                    deadlineClock.toFront();
                                }

                                storageLine.attr( {
                                    path: clearPath( newPath, true )
                                } );
                                newLineSet.remove();
                            }
                        }
                    }
                    
                    paper.bpmn.clearElDragInfo( paper, droppedSet );
                } );
            } else {
            	var itemType = item.type;
            	
            	if ( itemType == 'text' ) {
            		item.animate( {
                        x: xPos + paper.bpmn.activityWidth / 2,
                        y: yPos + paper.bpmn.activityHeight / 2
                    }, animDuration, 'linear' );
            	} else {
            		item.animate( {
                        x: xPos,
                        y: yPos
                    }, animDuration, 'linear' );
            	}
            }
        }

        this.toFront();
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    clearElDragInfo: function( paper, set ) {
        for ( var j = 0; j < set.length; j++ ) {
            var item = set[j];
            delete item.dragStartX;
            delete item.dragStartY;
        }

        delete set.lastdx;
        delete set.lastdy;
        delete set.realdx;
        delete set.realdy;
        delete set.distanceXCompensation;
        delete set.distanceYCompensation;
        delete set.doDrop;

        paper.bpmn.elDragged = false;
        paper.bpmn.hoverBlocked = false;
        paper.bpmn.eraseTrash( paper.dragTrash );
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    dragRoleChange: function( items, roleField, connectorSetType ) {
        var newRoleId = roleField.data( 'roleId' );
        var oldRoleId = items[0].data( 'roleId' );

        if ( oldRoleId != newRoleId ) {
            var newRoleName = roleField.data( 'roleName' );
            items.data( 'roleId', newRoleId ).data( 'roleName', newRoleName );

            if ( connectorSetType == 'route' || connectorSetType == 'activity' || connectorSetType == 'tool' || connectorSetType == 'subflow' ) {
                var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
                var actDefId = items[0].data( 'activityDefId' );
                var activityNode = Ext.getCmp( 'package_panel' ).findActivity( procDefId, actDefId );
                activityNode.updateActivityPerformer( newRoleId, newRoleName );
            }
        }
    },
    onLineDrag: function( x, y, e ) {
        if ( e.button != 0 ) {
            return;
        }

        var line = this[0];
        var paper = line.paper;
        paper.bpmn.eraseAllTrashes( paper );
        var draggedSet = this;
        this.doDrop = false;

        paper.bpmn.timeout = window.setTimeout( function() {
            draggedSet.lastdx = 0;
            draggedSet.lastdy = 0;
            paper.bpmn.hoverBlocked = true;
            var isBasic = line.data( 'isBasic' );
            var isOtherwise = line.data( 'isOtherwise' );
            var isDeadline = line.data( 'isDeadline' );
            var endPoint = Raphael.getPointAtLength( line.attr( 'path' ), line.getTotalLength() );

            draggedSet.xTo = endPoint.x;
            draggedSet.yTo = endPoint.y;

            if ( !( isBasic || isOtherwise || isDeadline ) ) {
                var connId = line.data( 'transitionId' );
                var connectTo = line.data( 'connectedWith' );
                paper.bpmn.conditionBox = connectTo.getInConnectionBox( connId );
            }

            paper.bpmn.elDragged = true;
        }, 100 );
    },
    onLineMove: function( dx, dy, x, y, e ) {
        var line = this[0];
        var paper = line.paper;

        if ( !paper.bpmn.elDragged ) {
            return;
        }

        if ( this.dndSet ) {
            this.dndSet.remove();
        }

        var scale = paper.scale;
        dx *= scale;
        dy *= scale;
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var connectFrom = line.data( 'connectFrom' );
        var lastdx = this.lastdx;
        var lastdy = this.lastdy;
        var xTo = this.xTo;
        var yTo = this.yTo;
        var xBorder = paper.bpmn.roleWidth + 2;
        var yBorder = 2;
        var xPos = xTo + lastdx;
        var yPos = yTo + lastdy;
        var direction = line.data( 'direction' );

        if ( xTo + dx > xBorder ) {
            this.lastdx = dx;
            xPos = xTo + dx;
        }
        if ( yTo + dy > yBorder ) {
            this.lastdy = dy;
            yPos = yTo + dy;
        }

        if ( direction == 'custom' ) {
            var path = line.attr( 'path' );
            var lastTurnIdx = path.length - 2;
            var lastTurnElTab = path[lastTurnIdx];
            var xStart = parseInt( lastTurnElTab[1] );
            var yStart = parseInt( lastTurnElTab[2] );
            var fromBox = {
                x: xStart,
                y: yStart,
                x2: xStart,
                y2: yStart,
                width: 0,
                height: 0
            };

            this.dndSet = paper.bpmn.basicLineTooltip( paper, fromBox, xPos, yPos );

            if ( isDeadline ) {
                this.dndSet[0].attr( {
                    stroke: '#E16E6E',
                    'stroke-dasharray': [ '--' ]
                } );
                this.dndSet[1].attr( {
                    fill: '#E16E6E',
                    'stroke-width': 0
                } );
            } else if ( isOtherwise ) {
                this.dndSet[0].attr( {
                    stroke: '#FF9900',
                    'stroke-dasharray': [ '--' ]
                } );
                this.dndSet[1].attr( {
                    fill: '#FF9900',
                    'stroke-width': 0
                } );
            }
        } else {
            if ( isBasic ) {
                this.dndSet = paper.bpmn.basicLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else if ( isOtherwise ) {
                this.dndSet = paper.bpmn.otherwiseLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else if ( isDeadline ) {
                this.dndSet = paper.bpmn.deadlineLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else {
                var type = paper.bpmn.conditionBox.data( 'conditionType' );
                this.dndSet = paper.bpmn.conditionalLine( paper, type, 3, connectFrom, null, xPos, yPos, false, false );
            }
        }

        if ( Math.abs( dx ) > 6 || Math.abs( dy ) > 6 ) {
            this.doDrop = true;
        }
    },
    onLineDrop: function( e ) {
        if ( e.button != 0 ) {
            return;
        }

        if ( this.dndSet ) {
            this.dndSet.remove();
        }

        var line = this[0];
        var paper = line.paper;
        var timeout = paper.bpmn.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        paper.bpmn.elDragged = false;
        paper.bpmn.hoverBlocked = false;
        var doDrop = this.doDrop;

        if ( !doDrop ) {
            paper.bpmn.clearLineDragInfo( this );
            return;
        }

        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var connId = line.data( 'transitionId' );
        var connectFrom = line.data( 'connectFrom' );
        var connectTo = line.data( 'connectedWith' );
        var lastdx = this.lastdx;
        var lastdy = this.lastdy;
        var xTo = this.xTo;
        var yTo = this.yTo;
        var xPos = xTo + lastdx;
        var yPos = yTo + lastdy;
        var direction = line.data( 'direction' );
        var shouldMoveLine = false;
        var previousConnectTo = null;

        if ( connectTo.isPointInside( xPos, yPos ) ) {
        	shouldMoveLine = true
        } else {
        	var connector = paper.bpmn.getConnector( paper, xPos, yPos );
        	var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        	var connectionType = '';
        	
        	if ( isBasic ) {
        		connectionType = 'BASIC';
        	} else if ( isOtherwise ) {
        		connectionType = 'OTHERWISE';
        	} else if ( isDeadline ) {
        		connectionType = 'EXCEPTION';
        	} else {
        		connectionType = line.data( 'conditionType' );
        	}
            
            if ( connector && paper.bpmn.isConnEndingAvailable( connectionType, connector, connectFrom, processDefId ) ) {
            	previousConnectTo = connectTo;
            	connectTo = connector;
            	this.data( 'connectedWith', connector );
            	shouldMoveLine = true;
            }
        }
        
        if ( !shouldMoveLine ) {
        	paper.bpmn.clearLineDragInfo( this );
            return;
        }

        if ( direction == 'custom' ) {
            var arrow = this[this.length - 1];
            var path = line.attr( 'path' );
            var lastTurnIdx = path.length - 2;
            var lastTurnElTab = path[lastTurnIdx];
            var xStart = parseInt( lastTurnElTab[1] );
            var yStart = parseInt( lastTurnElTab[2] );
            var fromBox = {
                x: xStart,
                y: yStart,
                x2: xStart,
                y2: yStart,
                width: 0,
                height: 0
            };

            var newLineSet = paper.bpmn.basicLineFinal( paper, connectFrom, connectTo, fromBox, connectTo.getBBox(), xPos, yPos, false );

            var newPath = path.splice( 0, lastTurnIdx + 1 ).concat( newLineSet[0].attr( 'path' ) );
            line.attr( {
                path: clearPath( newPath, true )
            } );
            arrow.attr( {
                path: newLineSet[newLineSet.length - 1].attr( 'path' )
            } );
            newLineSet.remove();

            if ( isBasic ) {
                paper.bpmn.handleUpdateBasicLine( connectFrom, connectTo, connId, this, direction, previousConnectTo );
            } else if ( isOtherwise ) {
                paper.bpmn.handleUpdateOtherwiseLine( connectFrom, connectTo, connId, this, direction, previousConnectTo );
            } else if ( isDeadline ) {
                var clock = connectFrom.getDeadlineClock( connId );
                paper.bpmn.handleUpdateDeadlineLine( connectFrom, connectTo, connId, this, direction, clock.clone(), previousConnectTo );
            } else {
                paper.bpmn.handleUpdateCondLine( connectFrom, connectTo, connId, this, direction, previousConnectTo );
            }
        } else {
            this.remove();

            if ( isBasic ) {
                paper.bpmn.basicLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                    tId: connId,
                    previousConnectTo: previousConnectTo
                } );
            } else if ( isOtherwise ) {
                paper.bpmn.otherwiseLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                    tId: connId,
                    previousConnectTo: previousConnectTo
                } );
            } else if ( isDeadline ) {
                paper.bpmn.deadlineLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                    tId: connId,
                    previousConnectTo: previousConnectTo
                } );
            } else {
                var type = paper.bpmn.conditionBox.data( 'conditionType' );
                paper.bpmn.conditionalLine( paper, type, 4, connectFrom, connectTo, xPos, yPos, false, false, {
                    tId: connId,
                    previousConnectTo: previousConnectTo
                } );
            }
        }

        paper.bpmn.clearLineDragInfo( this );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    clearLineDragInfo: function( set ) {
        delete set.lastdx;
        delete set.lastdy;
        delete set.xTo;
        delete set.yTo;
        delete set.doDrop;
    },
    onLineReshaperDrag: function( x, y, e ) {
        if ( e.button != 0 ) {
            return;
        }

        var paper = this.paper;
        paper.bpmn.hoverBlocked = true;
        paper.bpmn.separateLineReshaperFromTrash( paper, this );

        var lineSet = this.data( 'wholeSet' );
        var line = lineSet[0];
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );

        if ( !( isBasic || isOtherwise || isDeadline ) ) {
            var connId = line.data( 'transitionId' );
            var connectTo = line.data( 'connectedWith' );
            paper.bpmn.conditionBox = connectTo.getInConnectionBox( connId );
        }

        this.xStart = this.attr( 'cx' );
        this.yStart = this.attr( 'cy' );
        this.lastdx = 0;
        this.lastdy = 0;
        paper.bpmn.elDragged = true;
        this.preventDrop = false;
    },
    onLineReshaperMove: function( dx, dy, x, y, e ) {
        var paper = this.paper;

        if ( !paper.bpmn.elDragged ) {
            return;
        }

        if ( this.dndSet ) {
            this.dndSet.remove();
        }
        if ( this.dndSet2 ) {
            this.dndSet2.remove();
        }

        var paper = this.paper;
        var scale = paper.scale;
        dx *= scale;
        dy *= scale;
        var xBorderMin = paper.bpmn.roleWidth + 4;
        var yBorderMin = 4;
        var xBorderMax = paper.lastRoleXPos + paper.bpmn.roleWidth - 10;
        var yBorderMax = paper.lastRoleYPos - 4;
        var xLimit = this.xStart + dx;
        var yLimit = this.yStart + dy;

        if ( xLimit > xBorderMin && xLimit < xBorderMax ) {
            var xTransform = dx - this.lastdx;
            this.transform( '...T' + xTransform + ',0' );
            this.lastdx = dx;
        }

        if ( yLimit > yBorderMin && yLimit < yBorderMax ) {
            var yTransform = dy - this.lastdy;
            this.transform( '...T0,' + yTransform );
            this.lastdy = dy;
        }

        var xPos = this.xStart + this.lastdx;
        var yPos = this.yStart + this.lastdy;
        var lineSet = this.data( 'wholeSet' );
        var line = lineSet[0];
        var linePath = handlePathAttrType( line.attr( 'path' ) );
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var pointIndex = this.data( 'pointIndex' );

        if ( pointIndex == 1 ) {
            var connectFrom = line.data( 'connectFrom' );

            if ( isBasic ) {
                this.dndSet = paper.bpmn.basicLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else if ( isOtherwise ) {
                this.dndSet = paper.bpmn.otherwiseLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else if ( isDeadline ) {
                this.dndSet = paper.bpmn.deadlineLine( paper, connectFrom, null, xPos, yPos, false, true, false );
            } else {
                var type = paper.bpmn.conditionBox.data( 'conditionType' );
                this.dndSet = paper.bpmn.conditionalLine( paper, type, 3, connectFrom, null, xPos, yPos, false, false );
            }

            var arrowIndex = 0;
            if ( isDeadline ) {
                arrowIndex = this.dndSet.length - 2;
            } else {
                arrowIndex = this.dndSet.length - 1;
            }

            var arrow = this.dndSet.splice( arrowIndex, 1 );
            arrow.remove();
        } else {
            var lineEl = linePath[pointIndex - 1];
            var x = lineEl[1];
            var y = lineEl[2];
            var firstFromBox = {
                x: x,
                y: y,
                x2: x,
                y2: y,
                width: 0,
                height: 0
            };

            this.dndSet = paper.bpmn.basicLineTooltip( paper, firstFromBox, xPos, yPos, true );

            if ( isDeadline ) {
                this.dndSet[0].attr( {
                    stroke: '#E16E6E',
                    'stroke-dasharray': [ '--' ]
                } );
            } else if ( isOtherwise ) {
                this.dndSet[0].attr( {
                    stroke: '#FF9900',
                    'stroke-dasharray': [ '--' ]
                } );
            }
        }

        var xTo = 0;
        var yTo = 0;
        var skipSecondLineArrow = false;
        var secondFromBox = {
            x: xPos,
            y: yPos,
            x2: xPos,
            y2: yPos,
            width: 0,
            height: 0
        };

        if ( pointIndex == linePath.length - 2 ) {
            this.preventDrop = false;
            skipSecondLineArrow = false;
            var connectTo = line.data( 'connectedWith' );
            var toBox = connectTo.getBBox();
            var xToBoxMin = toBox.x;
            var yToBoxMin = toBox.y;
            var xToBoxMax = toBox.x2;
            var yToBoxMax = toBox.y2;

            if ( xPos >= xToBoxMin && xPos <= xToBoxMax ) {
                xTo = xPos;

                if ( yPos > yToBoxMax ) {
                    yTo = yToBoxMax;
                } else if ( yPos < yToBoxMin ) {
                    yTo = yToBoxMin;
                } else {
                    this.preventDrop = true;
                }
            } else {
                if ( yPos > yToBoxMin && yPos < yToBoxMax ) {
                    yTo = yPos;

                    if ( xPos > xToBoxMax ) {
                        xTo = xToBoxMax;
                    } else {
                        xTo = xToBoxMin;
                    }
                } else {
                    xTo = xToBoxMin + toBox.width / 2;

                    if ( yPos > yToBoxMax ) {
                        yTo = yToBoxMax;
                    } else {
                        yTo = yToBoxMin;
                    }
                }
            }
        } else {
            skipSecondLineArrow = true;
            var lineEl = linePath[pointIndex + 1];
            xTo = lineEl[1];
            yTo = lineEl[2];
        }

        if ( !this.preventDrop ) {
            this.dndSet2 = paper.bpmn.basicLineTooltip( paper, secondFromBox, xTo, yTo, skipSecondLineArrow );

            if ( isDeadline ) {
                this.dndSet2[0].attr( {
                    stroke: '#E16E6E',
                    'stroke-dasharray': [ '--' ]
                } );

                if ( !skipSecondLineArrow ) {
                    this.dndSet2[1].attr( {
                        fill: '#E16E6E',
                        'stroke-width': 0
                    } );
                }
            } else if ( isOtherwise ) {
                this.dndSet2[0].attr( {
                    stroke: '#FF9900',
                    'stroke-dasharray': [ '--' ]
                } );

                if ( !skipSecondLineArrow ) {
                    this.dndSet2[1].attr( {
                        fill: '#FF9900',
                        'stroke-width': 0
                    } );
                }
            }
        }

        this.toFront();

        if ( Math.abs( dx ) > 6 || Math.abs( dy ) > 6 ) {
            this.doDrop = true;
        }
    },
    onLineReshaperDrop: function( e ) {
        if ( e.button != 0 ) {
            return;
        }

        var paper = this.paper;

        if ( !this.doDrop || this.preventDrop ) {
            paper.bpmn.clearLineReshaperDragInfo( this );
            paper.bpmn.hoverBlocked = false;
            return;
        }

        var lineSet = this.data( 'wholeSet' );
        var line = lineSet[0];
        var arrow = lineSet[1];
        var linePath = handlePathAttrType( line.attr( 'path' ) );
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var connId = line.data( 'transitionId' );
        var connectFrom = line.data( 'connectFrom' );
        var connectTo = line.data( 'connectedWith' );
        var pointIndex = this.data( 'pointIndex' );
        var firstLinePath = this.dndSet[0].attr( 'path' );
        var secondLinePath = this.dndSet2[0].attr( 'path' );
        var newPath = new Array();
        var firstOldPathStopIndex = -1;
        var firstLinePathStartIndex = -1;
        var secondOldPathStartIndex = -1;

        if ( pointIndex == 1 ) {
            firstOldPathStopIndex = 0;
            firstLinePathStartIndex = 0;
        } else {
            firstOldPathStopIndex = pointIndex;
            firstLinePathStartIndex = 1;
        }

        if ( pointIndex == linePath.length - 2 ) {
            secondOldPathStartIndex = linePath.length;
        } else {
            secondOldPathStartIndex = pointIndex + 1;
        }

        for ( var i = 0; i < firstOldPathStopIndex; i++ ) {
            newPath.push( linePath[i] );
        }
        for ( var i = firstLinePathStartIndex; i < firstLinePath.length; i++ ) {
            newPath.push( firstLinePath[i] );
        }
        for ( var i = 1; i < secondLinePath.length; i++ ) {
            newPath.push( secondLinePath[i] );
        }
        for ( var i = secondOldPathStartIndex; i < linePath.length; i++ ) {
            newPath.push( linePath[i] );
        }

        line.attr( {
            path: clearPath( newPath, true )
        } );

        if ( pointIndex == linePath.length - 2 ) {
            arrow.attr( {
                path: this.dndSet2[this.dndSet2.length - 1].attr( 'path' )
            } );
        }

        if ( isBasic ) {
            paper.bpmn.handleUpdateBasicLine( connectFrom, connectTo, connId, lineSet, 'custom' );
        } else if ( isOtherwise ) {
            paper.bpmn.handleUpdateOtherwiseLine( connectFrom, connectTo, connId, lineSet, 'custom' );
        } else if ( isDeadline ) {
            var clock = connectFrom.getDeadlineClock( connId );

            if ( pointIndex == 1 ) {
                var pathM = newPath[0];

                clock = clock.attr( {
                    x: pathM[1] - 8,
                    y: pathM[2] - 8
                } );
            }

            paper.bpmn.handleUpdateDeadlineLine( connectFrom, connectTo, connId, lineSet, 'custom', clock.clone() );
        } else {
            paper.bpmn.handleUpdateCondLine( connectFrom, connectTo, connId, lineSet, 'custom' );
        }

        paper.bpmn.clearLineReshaperDragInfo( this );
        paper.bpmn.hoverBlocked = false;
        paper.bpmn.drawLineReshapers( paper, lineSet );
    },
    clearLineReshaperDragInfo: function( reshaper ) {
        this.elDragged = false;
        if ( reshaper.dndSet ) {
            reshaper.dndSet.remove();
        }
        if ( reshaper.dndSet2 ) {
            reshaper.dndSet2.remove();
        }
        reshaper.remove();
    },
    onBoxDrag: function( x, y, e ) {
        var paper = this.paper;
        this.doDrop = false;
        var box = this;

        paper.bpmn.timeout = window.setTimeout( function() {
            paper.bpmn.eraseAllTrashes( paper );
            paper.bpmn.conditionBox = box;
            var pathBox = Raphael.pathBBox( box.attr( 'path' ) );
            var rectD = paper.bpmn.conditionSize;
            var dndSet = paper.set();
            var xPos = pathBox.x;
            var yPos = pathBox.y + rectD;
            var boxCopy = paper.path( 'M' + xPos + ' ' + yPos + 'L' + ( xPos + rectD ) + ' ' + ( yPos + rectD ) + 'L' + ( xPos + 2 * rectD ) + ' '
                            + yPos + 'L' + ( xPos + rectD ) + ' ' + ( yPos - rectD ) + 'Z' );
            boxCopy = boxCopy.attr( {
                stroke: '#444444',
                'stroke-dasharray': [ '--' ]
            } );
            boxCopy.dragStartX = pathBox.x;
            boxCopy.dragStartY = pathBox.y;
            dndSet.push( boxCopy );

            box.dndSet = dndSet;
            paper.dragTrash.push( dndSet );
            paper.bpmn.elDragged = true;
            paper.bpmn.hoverBlocked = true;
            box.lastdx = 0;
            box.lastdy = 0;
        }, 100 );
    },
    onBoxMove: function( dx, dy, x, y, e ) {
        var paper = this.paper;

        if ( !paper.bpmn.elDragged ) {
            return;
        }

        var scale = paper.scale;
        dx *= scale;
        dy *= scale;

        var set = this.dndSet;
        var xLimit = set[0].dragStartX + dx;
        var yLimit = set[0].dragStartY + dy;
        var pathBox = Raphael.pathBBox( this.attr( 'path' ) );
        var xBorderMin = paper.bpmn.roleWidth + 2;
        var yBorderMin = 2;
        var xBorderMax = paper.lastRoleXPos + paper.bpmn.roleWidth - pathBox.width - 10;
        var yBorderMax = paper.lastRoleYPos - pathBox.height - 10;

        for ( var i = 0; i < set.length; i++ ) {
            var item = set[i];
            var transformation = '...T';

            if ( xLimit > xBorderMin && xLimit < xBorderMax ) {
                transformation += dx - this.lastdx;
                this.lastdx = dx;
            } else {
                transformation += '0';
            }

            transformation += ',';

            if ( yLimit > yBorderMin && yLimit < yBorderMax ) {
                transformation += dy - this.lastdy;
                this.lastdy = dy;
            } else {
                transformation += '0';
            }

            item.attr( {
                path: Raphael.transformPath( item.attr( 'path' ), transformation )
            } );
        }

        if ( Math.abs( dx ) > 6 || Math.abs( dy ) > 6 ) {
            this.doDrop = true;
        }
    },
    onBoxDrop: function( e ) {
        if ( this.dndSet ) {
            this.dndSet.remove();
        }

        var paper = this.paper;
        var timeout = paper.bpmn.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        paper.bpmn.elDragged = false;
        paper.bpmn.hoverBlocked = false;
        var doDrop = this.doDrop;

        if ( !doDrop ) {
            paper.bpmn.clearBoxDragInfo( this );
            return;
        }

        var wholeSet = this.data( 'wholeSet' );
        var lineToDelete = null;
        for ( var i = 0; i < wholeSet.length; i++ ) {
            var item = wholeSet[i];
            var transform = false;

            if ( item.data( 'isBox' ) ) {
                transform = true;
            } else {
                lineToDelete = item;
            }

            if ( transform ) {
                var prevTr = item.data( 'tr' );
                item.transform( '' );
                item.attr( {
                    path: Raphael.transformPath( item.attr( 'path' ), '...T' + this.lastdx + ',' + this.lastdy )
                } );
                if ( prevTr ) {
                    item.transform( prevTr );
                }
            }
        }

        lineToDelete.remove();
        var connectFrom = this.data( 'connectedWith' );
        var transitionId = this.data( 'transitionId' );
        var conditionType = this.data( 'conditionType' );
        var line = paper.bpmn.newConnectionToBox( paper, conditionType, connectFrom, transitionId );
        var pointAtLength = Raphael.getPointAtLength( line.attr( 'path' ), 0 );
        var packagePanel = Ext.getCmp( 'package_panel' );
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var activityNode = packagePanel.findActivity( processDefId, connectFrom.data( 'activityDefId' ) );

        var outCondConns = connectFrom.outCondConnections;
        for ( var i = 0; i < outCondConns.length; i++ ) {
            var outConn = outCondConns[i];

            if ( outConn.outTransitionId == transitionId ) {
                var conns = outConn.connections;

                for ( var j = 0; j < conns.length; j++ ) {
                    var conn = conns[j];
                    var pathSet = conn.pathSet;
                    var inTransitionId = conn.inTransitionId;
                    var outgoingLine = pathSet[0];
                    var connectTo = conn.connectedWith;

                    if ( outgoingLine.data( 'direction' ) == 'custom' ) {
                        var outgoingLinePath = outgoingLine.attr( 'path' );
                        outgoingLinePath = handlePathAttrType( outgoingLinePath );
                        var firstTurnIdx = 1;
                        var lPath = outgoingLinePath[firstTurnIdx];
                        var startPath = outgoingLinePath[0];
                        var lineXPos = parseInt( lPath[1] );
                        var lineYPos = parseInt( lPath[2] );
                        var fromBox = {
                            x: parseInt( startPath[1] + this.lastdx ),
                            y: parseInt( startPath[2] + this.lastdy ),
                            x2: parseInt( startPath[1] + this.lastdx ),
                            y2: parseInt( startPath[2] + this.lastdy ),
                            width: 0,
                            height: 0
                        };

                        var newLineSet = paper.bpmn.basicLineTooltip( paper, fromBox, lineXPos, lineYPos );

                        var newPath = newLineSet[0].attr( 'path' );
                        newPath = handlePathAttrType( newPath );
                        for ( var i = ( firstTurnIdx + 1 ); i < outgoingLinePath.length; i++ ) {
                            newPath.push( outgoingLinePath[i] );
                        }

                        outgoingLine.attr( {
                            path: clearPath( newPath, true )
                        } );
                        newLineSet.remove();

                        activityNode.updateCondTransitionLinePaths( {
                            id: inTransitionId,
                            linePaths: decomposePathAttrFromLineSet( pathSet )
                        } );
                    } else {
                        pathSet.remove();
                        var toBox = connectTo.getBBox();

                        var xPos = randomInsidePoint( toBox.width, toBox.x );
                        var yPos = randomInsidePoint( toBox.height, toBox.y );
                        paper.bpmn.conditionalLine( paper, conditionType, 4, connectFrom, connectTo, xPos, yPos, false, false, {
                            tId: inTransitionId
                        } );
                    }

                    activityNode.updateCondTransitionBoxInfo( {
                        id: inTransitionId,
                        x: parseInt( pointAtLength.x ),
                        y: parseInt( pointAtLength.y ),
                        firstLineDirection: line.data( 'direction' ),
                        boxDirection: this.data( 'direction' ),
                        boxPaths: decomposePathAttrFromLineSet( wholeSet )
                    } );
                }

                break;
            }
        }

        paper.bpmn.clearBoxDragInfo( this );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    clearBoxDragInfo: function( box ) {
        delete box.lastdx;
        delete box.lastdy;
        delete box.doDrop;
        delete box.dndSet;
    },
    onParticipantDrag: function( x, y, e ) {
        this.doDrop = false;
        var draggedHeaderEl = this;
        var paper = this.paper;

        paper.bpmn.timeout = window.setTimeout( function() {
            var roleIsEmpty = true;
            var box = Raphael.pathBBox( draggedHeaderEl.attr( 'path' ) );
            var roleYStart = box.y;
            var roleYStop = box.y2;

            paper.forEach( function( el ) {
                var setType = el.data( 'setType' );

                if ( !( setType == 'roleHeader' || setType == 'roleField' || setType == 'systemHeader' || setType == 'systemField' || setType == 'grid' ) ) {
                    var elBox = null;

                    if ( el.type == 'path' ) {
                        elBox = Raphael.pathBBox( el.attr( 'path' ) );
                    } else {
                        elBox = el.getBBox();
                    }

                    var elY = elBox.y;
                    var elY2 = elBox.y2;

                    if ( elY > roleYStart && elY < roleYStop && elY2 > roleYStart && elY2 < roleYStop ) {
                        roleIsEmpty = false;
                        return false;
                    }
                }
            } );

            if ( !roleIsEmpty ) {
                return;
            }

            paper.bpmn.eraseAllTrashes( paper );

            var set = paper.set();
            var cr = paper.bpmn.participantCornerRadius;
            var rw = paper.bpmn.roleWidth;

            var rolebox = paper.bpmn.roundedRectangle( paper, 1, box.y, rw, box.height, cr, 0, 0, cr );
            rolebox.attr( {
                stroke: '#7F9DB9',
                'stroke-width': 1,
                'stroke-dasharray': [ '--' ]
            } );

            var roleContainerWidth = paper.lastRoleXPos - 5;
            var roleContainer = paper.bpmn.roundedRectangle( paper, rw, box.y, roleContainerWidth, box.height, 0, cr, cr, 0 );
            roleContainer.attr( {
                stroke: '#7F9DB9',
                'stroke-width': 1,
                'stroke-dasharray': [ '--' ]
            } );

            set.push( rolebox );
            set.push( roleContainer );

            draggedHeaderEl.dndSet = set;
            paper.dragTrash.push( set );
            paper.bpmn.hoverBlocked = true;
            draggedHeaderEl.roleStartY = box.y;
            draggedHeaderEl.roleStopY = box.y2;
            draggedHeaderEl.roleSizeY = box.height;

            var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
            var panelPos = processPanel.getPosition();
            var scrollY = processPanel.body.dom.scrollTop;
            var yPos = y - panelPos[1] + scrollY;
            yPos *= paper.scale;

            draggedHeaderEl.dragStartY = yPos;
            draggedHeaderEl.lastdy = 0;
            paper.bpmn.elDragged = true;
        }, 100 );
    },
    onParticipantMove: function( dx, dy, x, y, e ) {
        var paper = this.paper;
        if ( !paper.bpmn.elDragged ) {
            return;
        }

        var scale = paper.scale;
        dy *= scale;

        if ( this.roleStartY + dy > 0 ) {
            var diff = ( dy - this.lastdy );
            var translation = '...T0,' + diff;
            var set = this.dndSet;

            for ( var i = 0; i < set.length; i++ ) {
                var el = set[i];

                el.attr( {
                    path: Raphael.transformPath( el.attr( 'path' ), translation )
                } );
            }

            this.lastdy = dy;
        }

        if ( Math.abs( dy ) > 12 ) {
            this.doDrop = true;
        }
    },
    onParticipantDrop: function( e ) {
        var paper = this.paper;
        var timeout = paper.bpmn.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        if ( !this.doDrop ) {
            paper.bpmn.clearParticipantDragInfo( paper, this );
            return;
        }

        var draggedRoleId = this.data( 'roleId' );
        var droppedSet = this.data( 'wholeSet' );
        var lastdy = this.lastdy;
        var dropPos = this.dragStartY + lastdy;
        var roleSizeY = this.roleSizeY;
        var newRoleYPos = -1;
        var droppedRoleId = null;

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( el.type == 'path' && ( setType == 'roleHeader' || setType == 'systemHeader' ) ) {
                var box = Raphael.pathBBox( el.attr( 'path' ) );

                if ( box.y < dropPos && box.y2 > dropPos && draggedRoleId != el.data( 'roleId' ) ) {
                    if ( lastdy > 0 ) {
                        newRoleYPos = box.y2 - roleSizeY;
                    } else {
                        newRoleYPos = box.y;
                    }

                    droppedRoleId = el.data( 'roleId' );
                    return false;
                }
            }
        } );

        if ( !droppedRoleId ) {
            paper.bpmn.clearParticipantDragInfo( paper, this );
            return;
        }

        var diff = newRoleYPos - this.roleStartY;
        var translation = '...T0,' + diff;

        for ( var i = 0; i < droppedSet.length; i++ ) {
            var item = droppedSet[i];

            if ( item.type == 'path' ) {
                item.attr( {
                    path: Raphael.transformPath( item.attr( 'path' ), translation )
                } );
            } else {
                var prevTr = item.data( 'tr' );
                item.transform( '' );
                item.attr( {
                    y: item.attr( 'y' ) + diff
                } );
                if ( prevTr ) {
                    item.transform( prevTr );
                }
            }
        }

        paper.bpmn.moveElsOnY( paper, this.roleStopY - 1, ( -1 ) * roleSizeY, droppedSet );
        paper.bpmn.moveElsOnY( paper, newRoleYPos - 1, roleSizeY, droppedSet );

        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        processNode.switchRolesOrder( draggedRoleId, droppedRoleId );

        paper.bpmn.clearParticipantDragInfo( paper, this );
        Ext.getCmp( 'main_panel' ).setSaved( false );
    },
    clearParticipantDragInfo: function( paper, headerEl ) {
        delete headerEl.roleStartY;
        delete headerEl.roleStopY;
        delete headerEl.roleSizeY;
        delete headerEl.dragStartY;
        delete headerEl.lastdy;
        delete headerEl.doDrop;

        paper.bpmn.elDragged = false;
        paper.bpmn.hoverBlocked = false;
        paper.bpmn.eraseTrash( paper.dragTrash );
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    separateField: function( paper, set, xPos, yPos, expected, secondExpected ) {
        var field = null;

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];
            var setType = el.data( 'setType' );

            if ( setType == expected || ( secondExpected && setType == secondExpected ) ) {
                field = el;
            }
        }

        if ( !field ) {
            var excludeRole = expected == 'roleField' ? false : true;
            var excludeSystem = !excludeRole;

            if ( secondExpected ) {
                excludeSystem = secondExpected == 'systemField' ? false : true;
            }

            field = this.getLastRoleField( paper, xPos, yPos, excludeRole, excludeSystem );
        }

        return field;
    },
    isOnlyParticipantField: function( paper, set ) {
        var res = true;

        if ( set.length == 0 ) {
            return false;
        }

        set.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( !( setType == 'roleField' || setType == 'systemField' ) ) {
                res = false;
                return false;
            }
        } );

        return res;
    },
    getConnectorFromSet: function( set ) {
        for ( var i = 0; i < set.length; i++ ) {
            var item = set[i];

            if ( item.data( 'connector' ) ) {
                return item;
            }
        }

        return null;
    },
    disabled: function( paper, xPos, yPos ) {
        var disabledSet = new paper.set();
        var eR = 16;
        var iR = 12;
        var h = 4;

        disabledSet.push( paper.circle( xPos + eR, yPos + eR, eR ).attr( {
            fill: '#E16E6E',
            stroke: 'none'
        } ).data( 'setType', 'disabled' ) );
        disabledSet.push( paper.circle( xPos + eR, yPos + eR, iR ).attr( {
            fill: '#FFFFFF',
            stroke: 'none'
        } ).data( 'setType', 'disabled' ) );
        disabledSet.push( paper.rect( xPos + 1, yPos + eR - h / 2, 2 * eR - 2, h ).attr( {
            fill: '#E16E6E',
            stroke: 'none'
        } ).transform( 'R135' ).data( 'setType', 'disabled' ).data( 'tr', 'R135' ) );

        return disabledSet;
    },
    eraseTrash: function( trash ) {
        Ext.each( trash, function( el, index, els ) {
            el.remove();
        } );

        clearArray( trash );
    },
    eraseClickedLineSetTrash: function( paper ) {
        var trash = paper.clickedLineSetTrash;
        Ext.each( trash, function( set, index, sets ) {
            this.changeLineColor( set, this.getLineDefaultColor( set ) );
            set.forEach( function( el ) {
                if ( el.data( 'isArrow' ) || el.data( 'conditionSign' ) ) {
                    el.attr( {
                        'stroke-width': 0
                    } );
                } else {
                    el.attr( {
                        'stroke-width': 1
                    } );
                }
            } );
            set.removeData( 'blockColorChange' );
        }, this );

        clearArray( trash );
    },
    eraseMarkedElIdsTrash: function( paper ) {
      clearArray( paper.markedElIdsTrash );
    },
    eraseFadedTrash: function( paper ) {
      var trash = paper.fadedTrash;
      Ext.each( trash, function( el, index, els ) {
        el = el.attr( {
          opacity: 1
        } );
      }, this );

      clearArray( trash );
    },
    eraseAllTrashes: function( paper ) {
        this.eraseTrash( paper.hoverTrash );
        this.eraseTrash( paper.resizerTrash );
        this.eraseTrash( paper.helperTrash );
        this.eraseTrash( paper.dragTrash );
        this.eraseTrash( paper.validationTrash );
        this.eraseTrash( paper.clickedTaskTrash );
        this.eraseClickedLineSetTrash( paper );
        this.eraseMarkedElIdsTrash( paper );
        this.eraseFadedTrash( paper );
    },
    eraseAllTrashesWithDelay: function( paper, delay ) {
        window.setTimeout( function() {
            paper.bpmn.eraseAllTrashes( paper );
        }, delay );
    },
    start: function( paper, xPos, yPos, tooltip ) {
        var startSet = new paper.set();
        var width = this.startStopDiameter;
        var height = this.startStopDiameter;
        
        if ( paper.snapToGrid ) {
        	xPos = this.evaluateGridXPosition( paper, xPos );
        	yPos = this.evaluateGridYPosition( paper, yPos );
        }

        if ( tooltip ) {
            var eR = this.startStopDiameter / 2;
            xPos = xPos + eR;
            yPos = yPos + eR;
            var eCircle = paper.circle( xPos, yPos, eR );
            eCircle.attr( {
                stroke: '#39921C',
                'stroke-width': 1,
                'stroke-dasharray': [ '-' ]
            } ).data( 'setType', 'startTooltip' ).data( 'connector', true );
            startSet.push( eCircle );
            return startSet;
        }

        var role = paper.getElementsByPoint( xPos, yPos );
        var roleField = this.separateField( paper, role, xPos, yPos, 'roleField', 'systemField' );
        if ( !roleField ) {
            return this.disabled( paper, xPos, yPos );
        }

        var startImg = paper.image( getPluginImgPath( 'start' ), xPos, yPos, width, height );
        startImg.attr( {
            cursor: 'move'
        } ).data( 'connector', true );
        startImg.initConnections();
        startSet.push( startImg );

        var roleId = roleField.data( 'roleId' );
        var terminationId = 'start_' + Ext.id();
        startSet.data( 'roleId', roleId ).data( 'roleName', roleField.data( 'roleName' ) ).data( 'setType', 'start' ).data( 'terminationId',
                        terminationId ).data( 'wholeSet', startSet );

        if ( this.editionMode ) {
            startSet.hover( this.hoverTerminationIn, this.hoverTerminationOut, startImg, startImg );
            startSet.drag( this.onElMove, this.onElDrag, this.onElDrop, startSet, startSet, startSet );
            startSet.click( this.taskClick );
        }

        this.spreadRole( paper, xPos, yPos, startImg, roleField, startSet );

        var roleBox = roleField.getBBox();
        addProcessStart( terminationId, roleId, xPos, yPos - roleBox.y );

        return startSet;
    },
    stop: function( paper, xPos, yPos, tooltip ) {
        var stopSet = new paper.set();
        var width = this.startStopDiameter;
        var height = this.startStopDiameter;
        
        if ( paper.snapToGrid ) {
        	xPos = this.evaluateGridXPosition( paper, xPos );
        	yPos = this.evaluateGridYPosition( paper, yPos );
        }

        if ( tooltip ) {
        	var eR = this.startStopDiameter / 2;
            xPos = xPos + eR;
            yPos = yPos + eR;
            var eCircle = paper.circle( xPos, yPos, eR );
            eCircle.attr( {
                stroke: '#D31C1C',
                'stroke-width': 1,
                'stroke-dasharray': [ '-' ]
            } ).data( 'setType', 'stopTooltip' ).data( 'connector', true );
            stopSet.push( eCircle );
            return stopSet;
        }

        var role = paper.getElementsByPoint( xPos, yPos );
        var roleField = this.separateField( paper, role, xPos, yPos, 'roleField', 'systemField' );
        if ( !roleField ) {
            return this.disabled( paper, xPos, yPos );
        }

        var stopImg = paper.image( getPluginImgPath( 'stop' ), xPos, yPos, width, height );
        stopImg.attr( {
            cursor: 'move'
        } ).data( 'connector', true );
        stopImg.initConnections();
        stopSet.push( stopImg );

        var roleId = roleField.data( 'roleId' );
        var terminationId = 'stop_' + Ext.id();
        stopSet.data( 'roleId', roleId ).data( 'roleName', roleField.data( 'roleName' ) ).data( 'setType', 'stop' ).data( 'terminationId',
                        terminationId ).data( 'wholeSet', stopSet );

        if ( this.editionMode ) {
            stopSet.hover( this.hoverTerminationIn, this.hoverTerminationOut, stopImg, stopImg );
            stopSet.drag( this.onElMove, this.onElDrag, this.onElDrop, stopSet, stopSet, stopSet );
        }

        this.spreadRole( paper, xPos, yPos, stopImg, roleField, stopSet );

        var roleBox = roleField.getBBox();
        addProcessStop( terminationId, roleId, xPos, yPos - roleBox.y );

        return stopSet;
    },
    hoverTerminationIn: function( e ) {
        var paper = this.paper;
        var setType = this.data( 'setType' );
        var hoverColor = null;

        if ( setType == 'start' ) {
            hoverColor = '#308E11';
        } else if ( setType == 'stop' ) {
            hoverColor = '#E16E6E';
        }

        var frame = paper.bpmn.highlightTermination( paper, this, hoverColor );
        paper.hoverTrash.push( frame );
    },
    hoverTerminationOut: function() {
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    highlightTermination: function( paper, termination, color ) {
      var box = termination.getBBox();
      var r = paper.bpmn.startStopDiameter / 2;
      var frame = paper.circle( box.x + r, box.y + r, r );
      frame.attr( {
        stroke: '#FFFFFF',
        'stroke-width': 1
      } );
      var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 500 : 1;
      frame.animate( {
        stroke: color,
        'stroke-width': 3
      }, animDuration );

      return frame;
    },
    markTermination: function( paper, termination, color ) {
      var frame = paper.bpmn.highlightTermination( paper, termination, color );
      paper.clickedTaskTrash.push( frame );
      paper.markedElIdsTrash.push( frame.id );
    },
    route: function( paper, xPos, yPos, tooltip, activityNo, routeName, activityDefId ) {
        return this.task( paper, xPos, yPos, {
            tooltip: tooltip,
            activityNo: activityNo,
            tooltipColor: '#679902',
            setType: 'route',
            separatedField: 'roleField',
            secondSeparatedField: 'systemField',
            img: getPluginImgPath( 'route' ),
            activityType: Ext.ux.suncode.Constants.ROUTE,
            taskName: routeName,
            activityDefId: activityDefId,
            performer: getTranslation( 'System' )
        } );
    },
    activity: function( paper, xPos, yPos, tooltip, activityNo, activityName, activityDefId ) {
        return this.task( paper, xPos, yPos, {
            tooltip: tooltip,
            activityNo: activityNo,
            tooltipColor: '#0299CA',
            setType: 'activity',
            separatedField: 'roleField',
            img: getPluginImgPath( 'activity' ),
            activityType: Ext.ux.suncode.Constants.ACTIVITY,
            taskName: activityName,
            activityDefId: activityDefId
        } );
    },
    tool: function( paper, xPos, yPos, tooltip, activityNo, toolName, activityDefId ) {
        return this.task( paper, xPos, yPos, {
            tooltip: tooltip,
            activityNo: activityNo,
            tooltipColor: '#676767',
            setType: 'tool',
            separatedField: 'systemField',
            img: getPluginImgPath( 'tool' ),
            activityType: Ext.ux.suncode.Constants.TOOL,
            taskName: toolName,
            activityDefId: activityDefId
        } );
    },
    applicationIntegrationComponent: function( paper, xPos, yPos, tooltip, activityNo, component, toolName, activityDefId ) {
        var tool = this.task( paper, xPos, yPos, {
            tooltip: tooltip,
            activityNo: activityNo,
            tooltipColor: '#676767',
            setType: 'tool',
            separatedField: 'systemField',
            img: getPluginImgPath( 'tool' ),
            activityType: Ext.ux.suncode.Constants.TOOL,
            taskName: toolName,
            activityDefId: activityDefId
        } );

        if ( !tooltip ) {
            tool.data( 'applicationIntegrationComponent', component );
        }

        return tool;
    },
    subflow: function( paper, xPos, yPos, tooltip, activityNo, subflowName, activityDefId ) {
        return this.task( paper, xPos, yPos, {
            tooltip: tooltip,
            activityNo: activityNo,
            tooltipColor: '#824619',
            setType: 'subflow',
            separatedField: 'roleField',
            img: getPluginImgPath( 'subflow' ),
            activityType: Ext.ux.suncode.Constants.SUBFLOW,
            taskName: subflowName,
            activityDefId: activityDefId
        } );
    },
    task: function( paper, xPos, yPos, config ) {
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var set = new paper.set();
        var width = this.activityWidth;
        var height = this.activityHeight;
        var radius = 5;
        var setType = config.setType;
        
        if ( paper.snapToGrid ) {
        	xPos = this.evaluateGridXPosition( paper, xPos );
        	yPos = this.evaluateGridYPosition( paper, yPos );
        }

        if ( config.tooltip ) {
            var tooltip = paper.rect( xPos, yPos, width, height, radius );
            tooltip = tooltip.attr( {
                stroke: config.tooltipColor,
                'stroke-width': 1,
                'stroke-dasharray': [ '--' ]
            } ).data( 'setType', setType + 'Tooltip' ).data( 'connector', true );
            set.push( tooltip );

            if ( config.taskName ) {
                var name = paper.text( xPos + width / 2, yPos + height / 2, this.prepareActivityName( processDefId, config.activityDefId, config.taskName ) );
                name.attr( {
                    fill: '#000000',
                    stroke: 'none',
                    'font-size': 10,
                    'font-family': 'Tahoma,Helvetica,sans-serif',
                    cursor: 'move'
                } ).data( 'setType', setType + 'Tooltip' );
                set.push( name );
            }

            return set;
        }

        var role = paper.getElementsByPoint( xPos, yPos );
        var roleField = this.separateField( paper, role, xPos, yPos, config.separatedField, config.secondSeparatedField );

        if ( !roleField ) {
            return this.disabled( paper, xPos, yPos );
        }

        var img = paper.image( config.img, xPos, yPos, width, height );
        img.attr( {
            cursor: 'move'
        } ).data( 'connector', true );
        img.initConnections();
        set.push( img );

        var packagePanel = Ext.getCmp( 'package_panel' );
        var activityNo = config.activityNo;
        var taskName = config.taskName ? config.taskName : getTranslation( 'Zadanie' ) + ' ' + activityNo;

        if ( !config.activityDefId ) {
            while ( packagePanel.findActivity( processDefId, generateId( taskName, Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH ) ) ) {
                activityNo++;
                taskName = getTranslation( 'Zadanie' ) + ' ' + activityNo;
            }
        }

        var actDefId = config.activityDefId ? config.activityDefId : generateId( taskName, Ext.ux.suncode.Constants.ACTIVITY_DEF_ID_MAX_LENGTH );
        var taskTxt = this.prepareActivityName( processDefId, actDefId, taskName );
        var name = paper.text( xPos + width / 2, yPos + height / 2, taskTxt );
        name.attr( {
            fill: '#000000',
            stroke: 'none',
            'font-size': 10,
            'font-family': 'Tahoma,Helvetica,sans-serif',
            cursor: 'move'
        } );
        set.push( name );
        img.data( 'taskNameElement', name );
        img.data( 'wholeSet', set );

        var performer = config.performer ? config.performer : roleField.data( 'roleName' );
        var roleBox = roleField.getBBox();
        set.data( 'setType', setType ).data( 'activityDefId', actDefId ).data( 'activityName', taskName ).data( 'roleId', roleField.data( 'roleId' ) )
                        .data( 'roleName', performer ).data( 'activityType', config.activityType ).data( 'xOffset', xPos ).data( 'yOffset',
                                        yPos - roleBox.y ).data( 'wholeSet', set );
        if ( this.editionMode ) {
            set.hover( this.hoverTaskIn, this.hoverTaskOut, img, img );
            set.drag( this.onElMove, this.onElDrag, this.onElDrop, set, set, set );
            img.click( this.taskClick );
            img.dblclick( this.taskDblClick );
            img.mouseup( this.taskContextMenu );

            var nameFirstElement = name[0];

            if ( !Ext.isEmpty( nameFirstElement ) ) {
              var me = this;
              nameFirstElement.onclick = function( e ) {
                me.taskClick.apply( name, [ e ] );
              };
              nameFirstElement.ondblclick = function( e ) {
                me.taskDblClick.apply( name, [ e ] );
              };
              nameFirstElement.oncontextmenu = function( e ) {
                me.taskContextMenu.apply( name, [ e ] );
              };
            }
        } else if ( this.simulationMode || this.currentActivityMapMode ) {
            set.hover( paper.simul.hoverTaskIn, paper.simul.hoverTaskOut, img, img );
            img.dblclick( paper.simul.showActivityDetails );
            name.dblclick( paper.simul.showActivityDetails );
        } else if ( this.processPreviewMode ) {
            set.hover( this.hoverTaskIn, this.hoverTaskOut, img, img );
        }

        this.spreadRole( paper, xPos, yPos, img, roleField, set );

        return set;
    },
    getXpdlTranslatedTaskName: function( processDefId, activityDefId, taskName ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var pakcageId = packageNode.attributes.packageId;

      return getXpdlActivityNameTranslation( pakcageId, processDefId, activityDefId, taskName );
    },
    taskContextMenu: function( e ) {
    	if ( e.button == 2 ) {
    		var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
    		var actDefId = this.data( 'activityDefId' );
            var activityNode = Ext.getCmp( 'package_panel' ).findActivity( procDefId, actDefId );
            activityNode.showContextMenu( [ e.pageX, e.pageY ] );
        }
    },
    addTaskToLastRole: function( paper, processPanel, taskType ) {
        var lastRoleField = null;
        var xPos = this.roleWidth + 10;

        switch ( taskType ) {
            case 'route':
                lastRoleField = this.getLastRoleField( paper, xPos, paper.lastRoleYPos + 10, false, false );

                if ( !lastRoleField ) {
                    showWarn( getTranslation( 'Brak właściwych uczestników.' ) );
                    return null;
                }

                var box = Raphael.pathBBox( lastRoleField.attr( 'path' ) );
                var yPos = box.y + 10;
                return processPanel.drawRoute( xPos, yPos );
            case 'activity':
                lastRoleField = this.getLastRoleField( paper, xPos, paper.lastRoleYPos + 10, false, true );

                if ( !lastRoleField ) {
                    showWarn( getTranslation( 'Brak właściwych uczestników.' ) );
                    return null;
                }

                var box = Raphael.pathBBox( lastRoleField.attr( 'path' ) );
                var yPos = box.y + 10;
                return processPanel.drawActivity( xPos, yPos );
            case 'tool':
                lastRoleField = this.getLastRoleField( paper, xPos, paper.lastRoleYPos + 10, true, false );

                if ( !lastRoleField ) {
                    showWarn( getTranslation( 'Brak właściwych uczestników.' ) );
                    return null;
                }

                var box = Raphael.pathBBox( lastRoleField.attr( 'path' ) );
                var yPos = box.y + 10;
                return processPanel.drawTool( xPos, yPos );
            case 'subflow':
                lastRoleField = this.getLastRoleField( paper, xPos, paper.lastRoleYPos + 10, false, true );

                if ( !lastRoleField ) {
                    showWarn( getTranslation( 'Brak właściwych uczestników.' ) );
                    return null;
                }

                var box = Raphael.pathBBox( lastRoleField.attr( 'path' ) );
                var yPos = box.y + 10;
                return processPanel.drawSubflow( xPos, yPos );
            default:
                return null;
        }
    },
    hoverTaskIn: function( e ) {
        var paper = this.paper;
        if ( paper.bpmn.elDragged ) {
            return;
        }

        var color = Ext.getCmp( 'main_panel' ).getHoverColor();
        var frame = paper.bpmn.highlightTask( paper, this, color );
        paper.hoverTrash.push( frame );

        for ( var i = 0; i < this.deadlineClocks.length; i++ ) {
            this.deadlineClocks[i].clock.toFront();
        }

        var showTooltips = Ext.getCmp( 'main_panel' ).getShowTooltips();
        if ( !showTooltips || paper.bpmn.hoverBlocked ) {
            return;
        }

        var actDefId = this.data( 'activityDefId' );
        var setType = this.data( 'setType' );
        var img = '';
        var performer = this.data( 'roleName' );

        if ( setType == 'activity' || setType == 'subflow' ) {
            img = getPluginImgPath( 'role' );
        } else if ( setType == 'route' ) {
            img = getPluginImgPath( 'system' );
            performer = getTranslation( 'System' );
        } else if ( setType == 'tool' ) {
            var component = this.data( 'applicationIntegrationComponent' );

            if ( !Ext.isEmpty( component ) ) {
                img = component.icon.icon;
            } else {
                img = getPluginImgPath( 'system' );
            }
        }

        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var activityNode = Ext.getCmp( 'package_panel' ).findActivity( processDefId, actDefId );
        var activityName = activityNode.attributes.activityName;
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId
        var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, actDefId, activityName );
        var tooltipText = '<table border="0"><tr><td width="25"><img width="16" height="16" src="' + img + '"></td>';
        tooltipText += '<td><b>' + getTranslation( 'Wykonawca' ) + ':</b> ' + performer + '<br>';
        tooltipText += '<b>' + getTranslation( 'Nazwa zadania' ) + ':</b> ' + activityNameTranslation + '<br>';
        tooltipText += '<b>' + getTranslation( 'Opis zadania' ) + ':</b> ' + activityNode.attributes.activityDescr + '</td></tr></table>';

        var activityTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        activityTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( activityTooltip );
    },
    hoverTaskOut: function( e ) {
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    markTask: function( paper, task, color ) {
        var frame = paper.bpmn.highlightTask( paper, task, color );
        paper.clickedTaskTrash.push( frame );
        paper.markedElIdsTrash.push( frame.id );
    },
    highlightTask: function( paper, task, color ) {
        var box = task.getBBox();
        var frame = paper.rect( box.x, box.y, paper.bpmn.activityWidth, paper.bpmn.activityHeight, 10 );
        frame.attr( {
            stroke: '#FFFFFF',
            'stroke-width': 1
        } );
        var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 500 : 1;
        frame.animate( {
            stroke: color,
            'stroke-width': 3
        }, animDuration );

        return frame;
    },
    taskClick: function( e ) {
        var paper = this.paper;
        var set = this.data( 'wholeSet' );
        var paperPanel = Ext.getCmp( 'paper_panel' );

        if ( Ext.isEmpty( paperPanel.getTopToolbar().usedButton ) ) {
            var setType = this.data( 'setType' );

            if ( setType != 'start' && setType != 'stop' ) {
                var packagePanel = Ext.getCmp( 'package_panel' );
                var procDefId = paperPanel.getActiveTab().processDefId;
                var activityNode = packagePanel.findActivity( procDefId, this.data( 'activityDefId' ) );
                packagePanel.selectPath( activityNode.getPath() );
            }

            paper.bpmn.timeout = window.setTimeout( function() {
                paper.bpmn.eraseAllTrashes( paper );
                paper.bpmn.taskHelpers( paper, set );
            }, 10 );
        }
    },
    taskDblClick: function( e ) {
        var paper = this.paper;
        var timeout = paper.bpmn.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        var actDefId = this.data( 'activityDefId' );
        var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var packagePanel = Ext.getCmp( 'package_panel' );
        var activityNode = packagePanel.findActivity( procDefId, actDefId );
        var setType = this.data( 'setType' );

        if ( setType == 'subflow' ) {
            var subflowDefId = activityNode.attributes.subflow.id;

            if ( Ext.isEmpty( subflowDefId ) ) {
                showActivityProperties( {
                  activityNode: activityNode
                } );
            } else {
                changeProcessTab( subflowDefId );
            }
        } else if ( setType == 'activity' ) {
            designActivityForm( activityNode );
        } else {
          showActivityProperties( {
            activityNode: activityNode
          } );
        }

        paper.bpmn.eraseAllTrashesWithDelay( paper, 100 );
    },
    isConnBeginningAvailable: function( type, connector, processDefId ) {
        var setType = connector.data( 'setType' );

        switch ( setType ) {
            case 'conditionalLineBox':
                var conditionType = connector.data( 'conditionType' );

                if ( conditionType != type ) {
                    showWarn( getTranslation( 'Niewłaściwy typ połączenia.' ) );
                    return false;
                }
                break;
            case 'stop':
                showWarn( getTranslation( 'Zakończenie procesu nie może posiadać wychodzących połączeń.' ) );
                return false;
                break;
            case 'start':
                if ( type == 'BASIC' ) {
                    var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );

                    if ( processNode.isStartConnected( connector.data( 'terminationId' ) ) ) {
                        showWarn( getTranslation( 'Rozpoczęcie procesu posiada już wychodzące połączenie.' ) );
                        return false;
                    }
                } else if ( type == 'XOR' ) {
                    showWarn( getTranslation( 'Rozpoczęcie procesu nie może posiadać połączenia warunkowego.' ) );
                    return false;
                } else if ( type == 'AND' ) {
                    showWarn( getTranslation( 'Rozpoczęcie procesu nie może posiadać połączenia równoległego.' ) );
                    return false;
                } else if ( type == 'OTHERWISE' ) {
                    showWarn( getTranslation( 'Rozpoczęcie procesu nie może posiadać połączenia "w przeciwnym razie".' ) );
                    return false;
                } else if ( type == 'EXCEPTION' ) {
                    showWarn( getTranslation( 'Rozpoczęcie procesu nie może posiadać wyjątku.' ) );
                    return false;
                }
                break;
            default:
                var activityNode = Ext.getCmp( 'package_panel' ).findActivity( processDefId, connector.data( 'activityDefId' ) );
                var activityTransitions = activityNode.attributes.transitions;
                var deadlines = activityNode.attributes.deadlines;

                if ( type == 'EXCEPTION' ) {
                    if ( deadlines.length == 0 ) {
                        showWarn( getTranslation( 'Zadanie nie posiada terminów ostatecznych.' ) );
                        return false;
                    } else if ( deadlines.length <= activityTransitions.exception.length ) {
                        showWarn( getTranslation( 'Wszystkie terminy ostateczne dla zadania zostały już określone.' ) );
                        return false;
                    }
                } else if ( !( type == 'BASIC' || type == 'OTHERWISE' ) && activityTransitions.cond.length > 0 ) {
                    showWarn( getTranslation( 'Zadanie posiada już wychodzące połączenie warunkowe/równoległe.' ) );
                    return false;
                }
                break;
        }

        return true;
    },
    isConnEndingAvailable: function( type, connector, connectFrom, processDefId ) {
        if ( connector.data( 'isBox' ) ) {
            return false;
        }

        var fromSetType = connectFrom.data( 'setType' );
        var setType = connector.data( 'setType' );

        if ( setType == 'start' ) {
            showWarn( getTranslation( 'Rozpoczęcie procesu nie może posiadać wchodzących połączeń.' ) );
            return false;
        } else if ( setType == 'stop' ) {
            if ( type == 'BASIC' ) {
                var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );

                if ( processNode.isStopConnected( connector.data( 'terminationId' ) ) ) {
                    showWarn( getTranslation( 'Zakończenie procesu posiada już wchodzące połączenie.' ) );
                    return false;
                }
            } else if ( type == 'XOR' ) {
                showWarn( getTranslation( 'Zakończenie procesu nie może posiadać wchodzących połączeń warunkowych.' ) );
                return false;
            } else if ( type == 'AND' ) {
                showWarn( getTranslation( 'Zakończenie procesu nie może posiadać wchodzących połączeń równoległych.' ) );
                return false;
            } else if ( type == 'OTHERWISE' ) {
                showWarn( getTranslation( 'Zakończenie procesu nie może posiadać wchodzących połączeń "w przeciwnym przypadku".' ) );
                return false;
            } else if ( type == 'EXCEPTION' ) {
                showWarn( getTranslation( 'Zakończenie procesu nie może posiadać wchodzących wyjątków.' ) );
                return false;
            }
        } else if ( fromSetType == 'start' ) {
            if ( connector.inConnections.length > 0 || connector.inCondConnections.length > 0 || connector.inOtherwises.length > 0
                            || connector.inExceptions.length > 0 ) {
                showWarn( getTranslation( 'Zadanie rozpoczynające proces nie może posiadać innego połączenia wchodzącego.' ) );
                return false;
            }
        } else {
            var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );

            if ( processNode.anyStartConnectedToActivity( connector.data( 'activityDefId' ) ) && connector.id != connectFrom.id ) {
                showWarn( getTranslation( 'Zadanie rozpoczynające proces nie może posiadać innego połączenia wchodzącego.' ) );
                return false;
            }
        }

        return true;
    },
    customLine: function( paper, customLineType, xPos, yPos, xStart, yStart, connectFrom, connectTo ) {
        this.hoverBlocked = true;
        var lineSet = null;

        var fromBox = {
            x: xStart,
            y: yStart,
            x2: xStart,
            y2: yStart,
            width: 0,
            height: 0,
            straightOffset: 10
        };

        if ( !connectTo ) {
            lineSet = this.basicLineTooltip( paper, fromBox, xPos, yPos );
            lineSet.data( 'setType', 'customLineTooltip' );
        } else {
            var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
            var storageLine = processPanel.getFromStorage( 'customLine' );
            var storagePathAttr = storageLine.attr( 'path' );
            storagePathAttr = handlePathAttrType( storagePathAttr );

            var connId = generateTransitionId();
            var toBox = connectTo.getBBox();
            toBox.setType = connectTo.data( 'setType' );
            lineSet = this.basicLineFinal( paper, connectFrom, connectTo, fromBox, toBox, xPos, yPos, true );

            if ( lineSet.duplicated ) {
                return lineSet;
            }

            processPanel.removeFromStorage( 'customLine' );
            var line = lineSet[0];
            var linePath = line.attr( 'path' );
            linePath = handlePathAttrType( linePath );
            var arrow = lineSet[1];
            line.data( 'isArrow', false );
            arrow.data( 'isArrow', true );
            var direction = 'custom';
            var storageEnd = Raphael.getPointAtLength( storagePathAttr, storageLine.getTotalLength() );
            var pathStart = Raphael.getPointAtLength( linePath, 0 );

            if ( !( storageEnd.x == pathStart.x && storageEnd.y == pathStart.y ) ) {
                storagePathAttr.push( [ 'L', pathStart.x, pathStart.y ] );
            }

            var newPath = storagePathAttr.concat( linePath.splice( 1, linePath.length ) );
            line.attr( {
                path: clearPath( newPath, true )
            } );
            line = line.attr( {
                stroke: '#444444'
            } );
            arrow = arrow.attr( {
                fill: '#444444',
                'stroke-width': 0
            } );

            if ( lineSet.duplicated ) {
                this.hoverBlocked = false;
                return lineSet;
            }

            if ( customLineType == 'BASIC' ) {
                lineSet.data( 'setType', 'basicLine' ).data( 'direction', direction ).data( 'transitionId', connId )
                                .data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo ).data( 'isBasic', true ).data( 'wholeSet',
                                                lineSet );
                this.handleAddBasicLine( connectFrom, connectTo, connId, lineSet, direction );
            } else if ( customLineType == 'OTHERWISE' ) {
                lineSet.data( 'setType', 'basicLine' ).data( 'direction', direction ).data( 'transitionId', connId )
                                .data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo ).data( 'isOtherwise', true ).data( 'wholeSet',
                                                lineSet );
                this.handleAddOtherwiseLine( connectFrom, connectTo, connId, lineSet, direction );
            } else if ( customLineType == 'EXCEPTION' ) {
                var deadlineClock = processPanel.getFromStorage( 'deadlineClock' );
                deadlineClock.toFront();
                lineSet.data( 'setType', 'deadlineLine' ).data( 'direction', direction ).data( 'transitionId', connId ).data( 'connectFrom',
                                connectFrom ).data( 'connectedWith', connectTo ).data( 'isDeadline', true ).data( 'wholeSet', lineSet );
                this.handleAddDeadlineLine( connectFrom, connectTo, connId, lineSet, direction, deadlineClock, '' );
                processPanel.resetStorage( 'deadlineClock' );
            } else {
                lineSet.data( 'inout', 'in' ).data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo ).data( 'transitionId', connId )
                                .data( 'direction', direction ).data( 'setType', 'conditionalLine' ).data( 'isBasic', false ).data( 'wholeSet',
                                                lineSet );
                this.handleAddCondLine( customLineType, connectFrom, connectTo, connId, lineSet, '' );
            }
        }

        if ( customLineType == 'OTHERWISE' && lineSet.length > 0 ) {
            lineSet[0].attr( {
                stroke: '#FF9900'
            } );
            lineSet[1].attr( {
                fill: '#FF9900'
            } );
        } else if ( customLineType == 'EXCEPTION' && lineSet.length > 0 ) {
            lineSet[0].attr( {
                stroke: '#E16E6E'
            } );
            lineSet[1].attr( {
                fill: '#E16E6E'
            } );
        }

        this.hoverBlocked = false;
        return lineSet;
    },
    handleAddBasicLine: function( connectFrom, connectTo, connId, basicLineSet, direction ) {
        var arrow = basicLineSet[basicLineSet.length - 1];

        if ( this.editionMode ) {
            basicLineSet.hover( this.hoverLineIn, this.hoverLineOut, basicLineSet, basicLineSet );
            basicLineSet.mouseup( this.basicLineContextMenu );
            basicLineSet.click( this.basicLineClick );
            arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, basicLineSet, basicLineSet, basicLineSet );
        }

        connectFrom.addConnection( connId, false, basicLineSet, connectTo );
        connectTo.addConnection( connId, true, basicLineSet, connectFrom );

        var connectFromSetType = connectFrom.data( 'setType' );
        var connectToSetType = connectTo.data( 'setType' );

        if ( connectFromSetType != 'start' && connectToSetType != 'stop' ) {
            addBasicTransition( connectFrom.data( 'activityDefId' ), {
                id: connId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: direction,
                linePaths: decomposePathAttrFromLineSet( basicLineSet )
            } );
        } else if ( connectToSetType == 'stop' ) {
            setStopConnectingActivity( connectTo.data( 'terminationId' ), connectFrom.data( 'activityDefId' ) );
        } else if ( connectFromSetType == 'start' ) {
            setStartConnectingActivity( connectFrom.data( 'terminationId' ), connectTo.data( 'activityDefId' ) );
        }
    },
    handleUpdateBasicLine: function( connectFrom, connectTo, connId, basicLineSet, direction, previousConnectTo ) {
        basicLineSet.unmouseup( this.basicLineContextMenu );
        basicLineSet.mouseup( this.basicLineContextMenu );
        basicLineSet.unclick( this.basicLineClick );
        basicLineSet.click( this.basicLineClick );
        var arrow = basicLineSet[basicLineSet.length - 1];
        arrow.undrag();
        arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, basicLineSet, basicLineSet, basicLineSet );

        if ( previousConnectTo ) {
        	connectFrom.removeConnectionById( connId, true );
        	connectFrom.addConnection( connId, false, basicLineSet, connectTo );
            connectTo.addConnection( connId, true, basicLineSet, connectFrom );
        } else {
        	connectFrom.updateConnection( connId, false, basicLineSet );
            connectTo.updateConnection( connId, true, basicLineSet );
        }

        var connectFromSetType = connectFrom.data( 'setType' );
        var connectToSetType = connectTo.data( 'setType' );

        if ( connectFromSetType != 'start' && connectToSetType != 'stop' ) {
        	if ( previousConnectTo ) {
        		addBasicTransition( connectFrom.data( 'activityDefId' ), {
                    id: connId,
                    to: connectTo.data( 'activityDefId' ),
                    firstLineDirection: direction,
                    linePaths: decomposePathAttrFromLineSet( basicLineSet )
                } );
        	} else {
        		updateBasicTransition( connectFrom.data( 'activityDefId' ), {
                    id: connId,
                    to: connectTo.data( 'activityDefId' ),
                    firstLineDirection: direction,
                    linePaths: decomposePathAttrFromLineSet( basicLineSet )
                } );
        	}
        }

        basicLineSet.data( 'direction', direction );

        basicLineSet.unhover( this.hoverLineIn, this.hoverLineOut );
        basicLineSet.hover( this.hoverLineIn, this.hoverLineOut, basicLineSet, basicLineSet );
    },
    handleAddCondLine: function( type, connectFrom, connectTo, inTransitionId, condLineSet, condition ) {
        var arrow = condLineSet[condLineSet.length - 1];
        var conditionBox = this.conditionBox;
        var boxWholeSet = conditionBox.data( 'wholeSet' );
        condLineSet.data( 'boxWholeSet', boxWholeSet );

        if ( this.editionMode ) {
            condLineSet.hover( this.hoverLineIn, this.hoverLineOut, condLineSet, condLineSet );
            condLineSet.mouseup( this.conditionalLineContextMenu );
            condLineSet.click( this.conditionalLineClick );
            condLineSet.dblclick( this.conditionalLineDblClick );
            arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, condLineSet, condLineSet, condLineSet );
        }

        var connectToSetType = connectTo.data( 'setType' );
        var outTransitionId = conditionBox.data( 'transitionId' );
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var storage = processPanel.getFromStorage( 'conditionalLine' );

        if ( storage ) {
            processPanel.resetStorage( 'conditionalLine' );

            if ( this.editionMode ) {
                boxWholeSet.hover( this.hoverBoxIn, this.hoverBoxOut, conditionBox, conditionBox );
                boxWholeSet.click( this.boxClick );
                boxWholeSet.dblclick( this.boxDblClick );
            }
        }

        connectFrom.addCondConnection( inTransitionId, outTransitionId, false, boxWholeSet, condLineSet, conditionBox, connectTo );
        connectTo.addCondConnection( inTransitionId, outTransitionId, true, condLineSet, condLineSet, conditionBox, connectFrom );

        if ( connectToSetType != 'stop' ) {
            addCondTransition( connectFrom.data( 'activityDefId' ), {
                id: inTransitionId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: boxWholeSet[0].data( 'direction' ),
                secondLineDirection: condLineSet[0].data( 'direction' ),
                boxDirection: conditionBox.data( 'direction' ),
                boxPaths: decomposePathAttrFromLineSet( boxWholeSet ),
                linePaths: decomposePathAttrFromLineSet( condLineSet ),
                condType: type,
                condition: condition
            } );
        } else if ( connectToSetType == 'stop' ) {
            setStopConnectingActivity( connectTo.data( 'terminationId' ), connectFrom.data( 'activityDefId' ) );
        }
    },
    handleUpdateCondLine: function( connectFrom, connectTo, inTransitionId, condLineSet, direction, previousConnectTo ) {
        condLineSet.unmouseup( this.conditionalLineContextMenu );
        condLineSet.mouseup( this.conditionalLineContextMenu );
        condLineSet.unclick( this.conditionalLineClick );
        condLineSet.click( this.conditionalLineClick );
        condLineSet.undblclick( this.conditionalLineDblClick );
        condLineSet.dblclick( this.conditionalLineDblClick );
        var arrow = condLineSet[condLineSet.length - 1];
        arrow.undrag();
        arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, condLineSet, condLineSet, condLineSet );

        if ( previousConnectTo ) {
        	var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
            var packagePanel = Ext.getCmp( 'package_panel' );
            var fromActivityNode = packagePanel.findActivity( processDefId, connectFrom.data( 'activityDefId' ) );
            var condition = fromActivityNode.getCondTransitionCondition( inTransitionId );
        	var conditionBox = previousConnectTo.getInConnectionBox( inTransitionId );
        	previousConnectTo.removeCondConnectionById( inTransitionId, 'in', true, true );
            var boxWholeSet = conditionBox.data( 'wholeSet' );
        	var outTransitionId = conditionBox.data( 'transitionId' );
        	connectFrom.addCondConnection( inTransitionId, outTransitionId, false, boxWholeSet, condLineSet, conditionBox, connectTo );
            connectTo.addCondConnection( inTransitionId, outTransitionId, true, condLineSet, condLineSet, conditionBox, connectFrom );

            if ( connectToSetType != 'stop' ) {
                addCondTransition( connectFrom.data( 'activityDefId' ), {
                    id: inTransitionId,
                    to: connectTo.data( 'activityDefId' ),
                    firstLineDirection: boxWholeSet[0].data( 'direction' ),
                    secondLineDirection: condLineSet[0].data( 'direction' ),
                    boxDirection: conditionBox.data( 'direction' ),
                    boxPaths: decomposePathAttrFromLineSet( boxWholeSet ),
                    linePaths: decomposePathAttrFromLineSet( condLineSet ),
                    condType: conditionBox.data( 'conditionType' ),
                    condition: condition
                } );
            } else if ( connectToSetType == 'stop' ) {
                setStopConnectingActivity( connectTo.data( 'terminationId' ), connectFrom.data( 'activityDefId' ) );
            }
        } else {
        	connectTo.updateInCondConnection( inTransitionId, condLineSet );

            var connectToSetType = connectTo.data( 'setType' );

            if ( connectToSetType != 'stop' ) {
                updateCondTransitionLinePathsWithDir( connectFrom.data( 'activityDefId' ), {
                    id: inTransitionId,
                    secondLineDirection: direction,
                    linePaths: decomposePathAttrFromLineSet( condLineSet )
                } );
            }
        }

        condLineSet.data( 'direction', direction );

        condLineSet.unhover( this.hoverLineIn, this.hoverLineOut );
        condLineSet.hover( this.hoverLineIn, this.hoverLineOut, condLineSet, condLineSet );
    },
    handleAddOtherwiseLine: function( connectFrom, connectTo, connId, otherwiseLineSet, direction ) {
        var arrow = otherwiseLineSet[otherwiseLineSet.length - 1];

        if ( this.editionMode ) {
            otherwiseLineSet.hover( this.hoverLineIn, this.hoverLineOut, otherwiseLineSet, otherwiseLineSet );
            otherwiseLineSet.mouseup( this.otherwiseLineContextMenu );
            otherwiseLineSet.click( this.otherwiseLineClick );
            arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, otherwiseLineSet, otherwiseLineSet, otherwiseLineSet );
        }

        connectFrom.addOtherwiseConnection( connId, false, otherwiseLineSet, connectTo );
        connectTo.addOtherwiseConnection( connId, true, otherwiseLineSet, connectFrom );

        addOtherwiseTransition( connectFrom.data( 'activityDefId' ), {
            id: connId,
            to: connectTo.data( 'activityDefId' ),
            firstLineDirection: direction,
            linePaths: decomposePathAttrFromLineSet( otherwiseLineSet )
        } );
    },
    handleUpdateOtherwiseLine: function( connectFrom, connectTo, connId, otherwiseLineSet, direction, previousConnectTo ) {
        otherwiseLineSet.unmouseup( this.otherwiseLineContextMenu );
        otherwiseLineSet.mouseup( this.otherwiseLineContextMenu );
        otherwiseLineSet.unclick( this.otherwiseLineClick );
        otherwiseLineSet.click( this.otherwiseLineClick );
        var arrow = otherwiseLineSet[otherwiseLineSet.length - 1];
        arrow.undrag();
        arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, otherwiseLineSet, otherwiseLineSet, otherwiseLineSet );

        if ( previousConnectTo ) {
        	connectFrom.removeOtherwiseConnectionById( connId, true );
        	connectFrom.addOtherwiseConnection( connId, false, otherwiseLineSet, connectTo );
            connectTo.addOtherwiseConnection( connId, true, otherwiseLineSet, connectFrom );

            addOtherwiseTransition( connectFrom.data( 'activityDefId' ), {
                id: connId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: direction,
                linePaths: decomposePathAttrFromLineSet( otherwiseLineSet )
            } );
        } else {
        	connectFrom.updateOtherwiseConnection( connId, false, otherwiseLineSet );
            connectTo.updateOtherwiseConnection( connId, true, otherwiseLineSet );

            updateOtherwiseTransition( connectFrom.data( 'activityDefId' ), {
                id: connId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: direction,
                linePaths: decomposePathAttrFromLineSet( otherwiseLineSet )
            } );
        }

        otherwiseLineSet.data( 'direction', direction );

        otherwiseLineSet.unhover( this.hoverLineIn, this.hoverLineOut );
        otherwiseLineSet.hover( this.hoverLineIn, this.hoverLineOut, otherwiseLineSet, otherwiseLineSet );
    },
    handleAddDeadlineLine: function( connectFrom, connectTo, connId, deadlineLineSet, direction, clock, exceptionName ) {
        var arrow = deadlineLineSet[deadlineLineSet.length - 1];

        if ( this.editionMode ) {
            deadlineLineSet.hover( this.hoverLineIn, this.hoverLineOut, deadlineLineSet, deadlineLineSet );
            deadlineLineSet.mouseup( this.deadlineLineContextMenu );
            deadlineLineSet.click( this.deadlineLineClick );
            deadlineLineSet.dblclick( this.deadlineLineDblClick );
            arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, deadlineLineSet, deadlineLineSet, deadlineLineSet );
        }

        connectFrom.addException( connId, false, deadlineLineSet, connectTo );
        connectFrom.addDeadlineClock( connId, clock );
        connectTo.addException( connId, true, deadlineLineSet, connectFrom );

        addDeadlineTransition( connectFrom.data( 'activityDefId' ), {
            id: connId,
            to: connectTo.data( 'activityDefId' ),
            firstLineDirection: direction,
            linePaths: decomposePathAttrFromLineSet( deadlineLineSet ),
            exceptionName: exceptionName
        } );
    },
    handleUpdateDeadlineLine: function( connectFrom, connectTo, connId, deadlineLineSet, direction, clock, previousConnectTo ) {
        deadlineLineSet.unmouseup( this.deadlineLineContextMenu );
        deadlineLineSet.mouseup( this.deadlineLineContextMenu );
        deadlineLineSet.unclick( this.deadlineLineClick );
        deadlineLineSet.click( this.deadlineLineClick );
        deadlineLineSet.undblclick( this.deadlineLineDblClick );
        deadlineLineSet.dblclick( this.deadlineLineDblClick );
        var arrow = deadlineLineSet[deadlineLineSet.length - 1];
        arrow.undrag();
        arrow.drag( this.onLineMove, this.onLineDrag, this.onLineDrop, deadlineLineSet, deadlineLineSet, deadlineLineSet );

        if ( previousConnectTo ) {
        	connectFrom.removeExceptionById( connId, true );
        	connectFrom.addException( connId, false, deadlineLineSet, connectTo );
            connectTo.addException( connId, true, deadlineLineSet, connectFrom );

            addDeadlineTransition( connectFrom.data( 'activityDefId' ), {
                id: connId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: direction,
                linePaths: decomposePathAttrFromLineSet( deadlineLineSet ),
                exceptionName: exceptionName
            } );
        } else {
        	connectFrom.updateException( connId, false, deadlineLineSet );
            connectTo.updateException( connId, true, deadlineLineSet );

            updateDeadlineTransition( connectFrom.data( 'activityDefId' ), {
                id: connId,
                to: connectTo.data( 'activityDefId' ),
                firstLineDirection: direction,
                linePaths: decomposePathAttrFromLineSet( deadlineLineSet )
            } );
        }
        
        connectFrom.updateDeadlineClock( connId, clock );

        deadlineLineSet.data( 'direction', direction );

        deadlineLineSet.unhover( this.hoverLineIn, this.hoverLineOut );
        deadlineLineSet.hover( this.hoverLineIn, this.hoverLineOut, deadlineLineSet, deadlineLineSet );
    },
    fitLineStartXToTermination: function( box, xPos, yPos ) {
        var add = 0;
        var setType = box.setType;

        if ( setType == 'start' || setType == 'stop' ) {
            var x = box.x;
            var y = box.y;
            var x2 = box.x2;
            var y2 = box.y2;
            var r = this.startStopDiameter / 2;

            if ( y <= yPos && y2 >= yPos ) {
                if ( xPos <= x ) {
                    add = r - Math.ceil( Math.sqrt( ( yPos - y ) * ( y2 - yPos ) ) );
                } else if ( xPos >= x2 ) {
                    add = ( -1 ) * ( r - Math.ceil( Math.sqrt( ( yPos - y ) * ( y2 - yPos ) ) ) );
                }
            }
        }

        return add;
    },
    fitLineStartYToTermination: function( box, xPos, yPos ) {
        var add = 0;
        var setType = box.setType;

        if ( setType == 'start' || setType == 'stop' ) {
            var x = box.x;
            var y = box.y;
            var x2 = box.x2;
            var y2 = box.y2;
            var r = this.startStopDiameter / 2;

            if ( x <= xPos && x2 >= xPos ) {
                if ( yPos <= y ) {
                    add = r - Math.ceil( Math.sqrt( ( xPos - x ) * ( x2 - xPos ) ) );
                } else if ( yPos >= y2 ) {
                    add = ( -1 ) * ( r - Math.ceil( Math.sqrt( ( xPos - x ) * ( x2 - xPos ) ) ) );
                }
            }
        }

        return add;
    },
    fitLineEndXToTermination: function( box, direction, yPos ) {
        var add = 0;
        var setType = box.setType;

        if ( setType == 'start' || setType == 'stop' ) {
            var y = box.y;
            var y2 = box.y2;
            var r = this.startStopDiameter / 2;

            if ( direction == 'right' ) {
                add = r - Math.ceil( Math.sqrt( ( yPos - y ) * ( y2 - yPos ) ) );
            } else if ( direction == 'left' ) {
                add = ( -1 ) * ( r - Math.ceil( Math.sqrt( ( yPos - y ) * ( y2 - yPos ) ) ) );
            }
        }

        return add;
    },
    fitLineEndYToTermination: function( box, direction, xPos ) {
        var add = 0;
        var setType = box.setType;

        if ( setType == 'start' || setType == 'stop' ) {
            var x = box.x;
            var x2 = box.x2;
            var r = this.startStopDiameter / 2;

            if ( direction == 'down' || direction == 'rightdown' || direction == 'leftdown' ) {
                add = r - Math.ceil( Math.sqrt( ( xPos - x ) * ( x2 - xPos ) ) );
            } else if ( direction == 'up' || direction == 'rightup' || direction == 'leftup' ) {
                add = ( -1 ) * ( r - Math.ceil( Math.sqrt( ( xPos - x ) * ( x2 - xPos ) ) ) );
            }
        }

        return add;
    },
    startLineCursor: function( paper, xPos, yPos, setType ) {
        var set = paper.set();
        var spread = this.lineCursorSpread;

        var pathH = paper.path( 'M' + ( xPos - spread ) + ' ' + yPos + 'L' + ( xPos + spread ) + ' ' + yPos );
        pathH = pathH.attr( {
            stroke: '#444444',
            cursor: 'none'
        } );
        var pathV = paper.path( 'M' + xPos + ' ' + ( yPos - spread ) + 'L' + xPos + ' ' + ( yPos + spread ) );
        pathV = pathV.attr( {
            stroke: '#444444',
            cursor: 'none'
        } );

        var imgName = '';

        switch ( setType ) {
            case 'basicLineTooltip':
                imgName = 'basic_line';
                break;
            case 'XOR':
                imgName = 'cond_line_xor';
                break;
            case 'AND':
                imgName = 'cond_line_and';
                break;
            case 'otherwiseLineTooltip':
                imgName = 'otherwise';
                break;
            case 'deadlineLineTooltip':
                imgName = 'deadline';
                break;
            default:
                break;
        }

        var img = paper.image( getPluginImgPath( imgName ), xPos + spread / 2, yPos + spread / 2, 16, 16 );
        img = img.attr( {
            cursor: 'none'
        } );
        var rect = paper.rect( xPos - spread, yPos - spread, 2 * spread, 2 * spread );
        rect = rect.attr( {
            fill: '#FFFFFF',
            opacity: 0,
            'stroke-width': 0,
            cursor: 'none'
        } );

        set.push( pathH );
        set.push( pathV );
        set.push( img );
        set.push( rect );
        set.data( 'setType', setType );

        return set;
    },
    basicLine: function( paper, connectFrom, connectTo, xPos, yPos, checkDuplicate, tooltip, add, t ) {
        var basicLineSet = null;

        if ( !connectFrom ) {
            return this.startLineCursor( paper, xPos, yPos, 'basicLineTooltip' );
        }

        this.hoverBlocked = true;
        var fromBox = connectFrom.getBBox();
        fromBox.setType = connectFrom.data( 'setType' );

        if ( !connectTo ) {
            return this.basicLineTooltip( paper, connectFrom.getBBox(), xPos, yPos );
        }

        var pathTable = null;
        var tId = null;
        var direction = '';
        var previousConnectTo = null;

        if ( t ) {
            pathTable = t.linePaths;
            tId = t.tId;
            direction = t.firstLineDirection;
            previousConnectTo = t.previousConnectTo;
        }

        var line = null;
        var arrow = null;
        var connId = tId ? tId : generateTransitionId();

        if ( !pathTable ) {
            var toBox = connectTo.getBBox();
            toBox.setType = connectTo.data( 'setType' );
            var set = this.basicLineFinal( paper, connectFrom, connectTo, fromBox, toBox, xPos, yPos, checkDuplicate );

            if ( set.duplicated ) {
                set.duplicated = true;
                return set;
            }

            line = set[0];
            arrow = set[1];
        } else {
            line = paper.path( pathTable[0] );
            arrow = paper.path( pathTable[1] );
        }

        direction = direction ? direction : line.data( 'direction' );

        basicLineSet = paper.set();
        line.data( 'isArrow', false );
        arrow.data( 'isArrow', true );
        basicLineSet.push( line );
        basicLineSet.push( arrow );
        basicLineSet.data( 'setType', 'basicLine' ).data( 'direction', direction ).data( 'transitionId', connId ).data( 'connectFrom', connectFrom )
                        .data( 'connectedWith', connectTo ).data( 'isBasic', true ).data( 'wholeSet', basicLineSet );

        arrow = arrow.attr( {
            fill: '#444444',
            'stroke-width': 0
        } );

        if ( tooltip ) {
            line = line.attr( {
                stroke: '#444444',
                'stroke-dasharray': [ '--' ]
            } );
        } else {
            line = line.attr( {
                stroke: '#444444'
            } );

            if ( add ) {
                this.handleAddBasicLine( connectFrom, connectTo, connId, basicLineSet, direction );
            } else {
                this.handleUpdateBasicLine( connectFrom, connectTo, connId, basicLineSet, direction, previousConnectTo );
            }
        };

        this.hoverBlocked = false;

        return basicLineSet;
    },
    createReturningLine: function( paper, fromBox ) {
        var lineSet = paper.set();
        var trH = 8;
        var trA = 8;
        var turnSize = 25;
        var x2 = fromBox.x2;
        var x1 = x2 - 2 * this.cornerOffset;
        var y1 = fromBox.y;
        var y2 = y1 + 2 * this.cornerOffset;

        var line = paper.path( 'M' + x2 + ' ' + y2 + 'L' + ( x2 + turnSize ) + ' ' + y2 + 'L' + ( x2 + turnSize ) + ' ' + ( y2 - turnSize ) + 'L'
                        + x1 + ' ' + ( y2 - turnSize ) + 'L' + x1 + ' ' + y1 );
        var arrow = paper.path( 'M' + x1 + ' ' + y1 + 'L' + ( x1 + trA / 2 ) + ' ' + ( y1 - trH ) + 'L' + ( x1 - trA / 2 ) + ' ' + ( y1 - trH ) + 'L'
                        + x1 + ' ' + y1 + 'Z' );

        line = line.attr( {
            stroke: '#444444',
            'stroke-width': 1,
            'stroke-dasharray': [ '--' ]
        } );
        lineSet.push( line );
        arrow = arrow.attr( {
            fill: '#444444',
            'stroke-width': 0
        } );
        lineSet.push( arrow );
        lineSet.data( 'direction', 'empty' );

        return lineSet;
    },
    basicLineTooltip: function( paper, fromBox, xPos, yPos, skipArrow ) {
        var basicLineSet = paper.set();
        var straightOffset = fromBox.straightOffset ? fromBox.straightOffset : 0;
        var xFromBoxMin = fromBox.x;
        var yFromBoxMin = fromBox.y;
        var xFromBoxMax = fromBox.x2;
        var yFromBoxMax = fromBox.y2;
        var xFrom = 0;
        var yFrom = 0;
        var pathDef = '';
        var pathM = '';
        var pathL = '';
        var pathArrow = '';
        var trH = 8;
        var trA = 8;
        var arrowLeft = false;
        var arrowRight = false;
        var arrowUp = false;
        var arrowDown = false;
        var turn = false;
        var dashLine = null;
        var dashArrow = null;

        if ( xPos >= xFromBoxMin - straightOffset && xPos <= xFromBoxMax + straightOffset ) {
            xFrom = straightOffset ? xFromBoxMin : xPos;
            xPos = straightOffset ? xFrom : xPos;

            if ( yPos > yFromBoxMax ) {
                yFrom = yFromBoxMax;
                arrowDown = true;
            } else if ( yPos < yFromBoxMin ) {
                yFrom = yFromBoxMin;
                arrowUp = true;
            } else {
                this.hoverBlocked = false;
                basicLineSet = this.createReturningLine( paper, fromBox );
                basicLineSet.data( 'setType', 'basicLineTooltip' );

                return basicLineSet;
            }
        } else {
            if ( xPos > xFromBoxMax ) {
                xFrom = xFromBoxMax;
                arrowRight = true;
            } else {
                xFrom = xFromBoxMin;
                arrowLeft = true;
            }

            if ( yPos >= yFromBoxMin - straightOffset && yPos <= yFromBoxMax + straightOffset ) {
                yFrom = straightOffset ? yFromBoxMin : yPos;
                yPos = straightOffset ? yFrom : yPos;
            } else {
                yFrom = yFromBoxMin + fromBox.height / 2;
                turn = true;
                arrowLeft = false;
                arrowRight = false;

                if ( yPos < yFromBoxMin ) {
                    arrowUp = true;
                } else {
                    arrowDown = true;
                }
            }
        }

        xFrom += this.fitLineStartXToTermination( fromBox, xPos, yPos );
        yFrom += this.fitLineStartYToTermination( fromBox, xPos, yPos );

        if ( !skipArrow ) {
            if ( arrowLeft ) {
                pathArrow = 'L' + ( xPos + trH ) + ' ' + ( yPos - trA / 2 ) + 'L' + ( xPos + trH ) + ' ' + ( yPos + trA / 2 ) + 'L' + xPos + ' '
                                + yPos + 'Z';
            } else if ( arrowRight ) {
                pathArrow = 'L' + ( xPos - trH ) + ' ' + ( yPos - trA / 2 ) + 'L' + ( xPos - trH ) + ' ' + ( yPos + trA / 2 ) + 'L' + xPos + ' '
                                + yPos + 'Z';;
            } else if ( arrowUp ) {
                pathArrow = 'L' + ( xPos + trA / 2 ) + ' ' + ( yPos + trH ) + 'L' + ( xPos - trA / 2 ) + ' ' + ( yPos + trH ) + 'L' + xPos + ' '
                                + yPos + 'Z';
            } else if ( arrowDown ) {
                pathArrow = 'L' + ( xPos + trA / 2 ) + ' ' + ( yPos - trH ) + 'L' + ( xPos - trA / 2 ) + ' ' + ( yPos - trH ) + 'L' + xPos + ' '
                                + yPos + 'Z';
            }
        }

        if ( turn ) {
            pathL = 'L' + xPos + ' ' + yFrom + 'L' + xPos + ' ' + yPos;
        } else {
            if ( ( arrowLeft || arrowRight ) && yFrom != yPos ) {
                yPos = yFrom;
            } else if ( ( arrowUp || arrowDown ) && xFrom != xPos ) {
                xPos = xFrom;
            }

            pathL = 'L' + xPos + ' ' + yPos;
        }

        pathM = 'M' + xFrom + ' ' + yFrom;
        pathDef = pathM + pathL;

        dashLine = paper.path( pathDef );
        dashLine = dashLine.attr( {
            stroke: '#444444',
            'stroke-width': 1,
            'stroke-dasharray': [ '--' ]
        } );
        basicLineSet.push( dashLine );
        if ( !skipArrow ) {
            dashArrow = paper.path( 'M' + xPos + ' ' + yPos + pathArrow );
            dashArrow = dashArrow.attr( {
                fill: '#444444',
                'stroke-width': 0
            } );
        }
        basicLineSet.push( dashArrow );
        basicLineSet.data( 'setType', 'basicLineTooltip' );

        return basicLineSet;
    },
    basicLineFinal: function( paper, connectFrom, connectTo, fromBox, toBox, xPos, yPos, checkDuplicate ) {
        var basicLineSet = paper.set();
        var xFromBoxMin = fromBox.x;
        var yFromBoxMin = fromBox.y;
        var xFromBoxMax = fromBox.x2;
        var yFromBoxMax = fromBox.y2;
        var pathDef = '';
        var pathM = '';
        var pathL = '';
        var pathArrow = '';
        var trH = 8;
        var trA = 8;
        var arrowLeft = false;
        var arrowRight = false;
        var arrowUp = false;
        var arrowDown = false;
        var extraWay = false;
        var turn = false;
        var xToBoxMin = toBox.x;
        var yToBoxMin = toBox.y;
        var xToBoxMax = toBox.x2;
        var yToBoxMax = toBox.y2;
        var xTo = 0;
        var yTo = 0;

        if ( ( xFromBoxMin <= xToBoxMin && xFromBoxMax >= xToBoxMin ) || ( xFromBoxMin >= xToBoxMin && xFromBoxMax <= xToBoxMax ) ) {
            if ( yFromBoxMin > yToBoxMax ) {
                yFrom = yFromBoxMin;
                yTo = yToBoxMax;
                direction = 'up';
                arrowUp = true;
            } else if ( yFromBoxMax < yToBoxMin ) {
                yFrom = yFromBoxMax;
                yTo = yToBoxMin;
                direction = 'down';
                arrowDown = true;
            } else {
                xFrom = xFromBoxMin;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xToBoxMin + toBox.width / 2;
                yTo = yToBoxMin;
                direction = 'empty';
                arrowDown = true;
            }

            if ( direction != 'empty' ) {
                if ( xPos <= xFromBoxMax ) {
                    if ( xPos >= xFromBoxMin ) {
                        xFrom = xPos;
                    } else {
                        turn = true;
                        direction = 'left' + direction;
                        xFrom = xFromBoxMin;
                        yFrom = yFromBoxMin + fromBox.height / 2;
                    }
                } else {
                    turn = true;
                    direction = 'right' + direction;
                    xFrom = xFromBoxMax;
                    yFrom = yFromBoxMin + fromBox.height / 2;
                }

                xTo = xPos;
            } else {
                if ( checkDuplicate && connectFrom.duplicateConnection( connectTo ) ) {
                    basicLineSet.duplicated = true;
                    return basicLineSet;
                }

                return this.createReturningLine( paper, fromBox );
            }
        } else if ( xFromBoxMin <= xToBoxMax && xFromBoxMax >= xToBoxMax ) {
            if ( yFromBoxMin > yToBoxMax ) {
                yFrom = yFromBoxMin;
                yTo = yToBoxMax;
                direction = 'up';
                arrowUp = true;
            } else if ( yFromBoxMax < yToBoxMin ) {
                yFrom = yFromBoxMax;
                yTo = yToBoxMin;
                direction = 'down';
                arrowDown = true;
            } else {
                xFrom = xFromBoxMin;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xToBoxMin + toBox.width / 2;
                yTo = yToBoxMin;
                direction = 'empty';
                arrowDown = true;
            }

            if ( direction != 'empty' ) {
                if ( xPos >= xFromBoxMin ) {
                    xFrom = xPos;
                } else {
                    turn = true;
                    direction = 'left' + direction;
                    xFrom = xFromBoxMin;
                    yFrom = yFromBoxMin + fromBox.height / 2;
                }

                xTo = xPos;
            } else {
                if ( checkDuplicate && connectFrom.duplicateConnection( connectTo ) ) {
                    basicLineSet.duplicated = true;
                    return basicLineSet;
                }

                return this.createReturningLine( paper, fromBox );
            }
        } else if ( xFromBoxMin > xToBoxMax ) {
            if ( yFromBoxMin > yToBoxMax ) {
                turn = true;
                direction = 'leftup';
                arrowUp = true;
                xFrom = xFromBoxMin;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xPos;
                yTo = yToBoxMax;
            } else if ( yFromBoxMax < yToBoxMin ) {
                turn = true;
                direction = 'leftdown';
                arrowDown = true;
                xFrom = xFromBoxMin;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xPos;
                yTo = yToBoxMin;
            } else if ( yFromBoxMin <= yToBoxMax && yFromBoxMin >= yToBoxMin ) {
                if ( yPos >= yFromBoxMin ) {
                    if ( yPos <= yFromBoxMax ) {
                        xFrom = xFromBoxMin;
                        yFrom = yPos;
                        direction = 'left';
                        arrowLeft = true;
                        xTo = xToBoxMax;
                        yTo = yPos;
                    } else {
                        extraWay = true;
                        turn = true;
                        xFrom = xFromBoxMin;
                        yFrom = yFromBoxMin + fromBox.height / 2;
                        direction = 'leftup';
                        arrowLeft = true;
                        xTo = xToBoxMax;
                        yTo = yPos;
                    }
                } else {
                    extraWay = true;
                    turn = true;
                    direction = 'leftup';
                    arrowLeft = true;
                    xFrom = xFromBoxMin + fromBox.width / 2;
                    yFrom = yFromBoxMin;
                    xTo = xToBoxMax;
                    yTo = yPos;
                }
            } else {
                if ( yPos <= yFromBoxMax ) {
                    direction = 'left';
                    arrowLeft = true;
                    xFrom = xFromBoxMin;
                    yFrom = yPos;
                    xTo = xToBoxMax;
                    yTo = yPos;
                } else {
                    extraWay = true;
                    turn = true;
                    direction = 'leftdown';
                    arrowLeft = true;
                    xFrom = xFromBoxMin + fromBox.width / 2;
                    yFrom = yFromBoxMax;
                    xTo = xToBoxMax;
                    yTo = yPos;
                }
            }
        } else {
            if ( yFromBoxMin > yToBoxMax ) {
                turn = true;
                direction = 'rightup';
                arrowUp = true;
                xFrom = xFromBoxMax;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xPos;
                yTo = yToBoxMax;
            } else if ( yFromBoxMax < yToBoxMin ) {
                turn = true;
                direction = 'rightdown';
                arrowDown = true;
                xFrom = xFromBoxMax;
                yFrom = yFromBoxMin + fromBox.height / 2;
                xTo = xPos;
                yTo = yToBoxMin;
            } else if ( yFromBoxMin <= yToBoxMax && yFromBoxMin >= yToBoxMin ) {
                if ( yPos >= yFromBoxMin ) {
                    if ( yPos <= yFromBoxMax ) {
                        xFrom = xFromBoxMax;
                        yFrom = yPos;
                        direction = 'right';
                        arrowRight = true;
                        xTo = xToBoxMin;
                        yTo = yPos;
                    } else {
                        extraWay = true;
                        turn = true;
                        xFrom = xFromBoxMax;
                        yFrom = yFromBoxMin + fromBox.height / 2;
                        direction = 'rightdown';
                        arrowRight = true;
                        xTo = xToBoxMin;
                        yTo = yPos;
                    }
                } else {
                    extraWay = true;
                    turn = true;
                    direction = 'rightup';
                    arrowRight = true;
                    xFrom = xFromBoxMin + fromBox.width / 2;
                    yFrom = yFromBoxMin;
                    xTo = xToBoxMin;
                    yTo = yPos;
                }
            } else {
                if ( yPos <= yFromBoxMax ) {
                    direction = 'right';
                    arrowRight = true;
                    xFrom = xFromBoxMax;
                    yFrom = yPos;
                    xTo = xToBoxMin;
                    yTo = yPos;
                } else {
                    extraWay = true;
                    turn = true;
                    direction = 'rightdown';
                    arrowRight = true;
                    xFrom = xFromBoxMin + fromBox.width / 2;
                    yFrom = yFromBoxMax;
                    xTo = xToBoxMin;
                    yTo = yPos;
                }
            }
        }

        xFrom += this.fitLineStartXToTermination( fromBox, xFrom, yFrom );
        yFrom += this.fitLineStartYToTermination( fromBox, xFrom, yFrom );
        xTo += this.fitLineEndXToTermination( toBox, direction, yPos );
        yTo += this.fitLineEndYToTermination( toBox, direction, xPos, yPos );

        if ( arrowLeft ) {
            pathArrow = 'L' + ( xTo + trH ) + ' ' + ( yTo - trA / 2 ) + 'L' + ( xTo + trH ) + ' ' + ( yTo + trA / 2 ) + 'L' + xTo + ' ' + yTo + 'Z';
        } else if ( arrowRight ) {
            pathArrow = 'L' + ( xTo - trH ) + ' ' + ( yTo - trA / 2 ) + 'L' + ( xTo - trH ) + ' ' + ( yTo + trA / 2 ) + 'L' + xTo + ' ' + yTo + 'Z';
        } else if ( arrowUp ) {
            pathArrow = 'L' + ( xTo + trA / 2 ) + ' ' + ( yTo + trH ) + 'L' + ( xTo - trA / 2 ) + ' ' + ( yTo + trH ) + 'L' + xTo + ' ' + yTo + 'Z';
        } else if ( arrowDown ) {
            pathArrow = 'L' + ( xTo + trA / 2 ) + ' ' + ( yTo - trH ) + 'L' + ( xTo - trA / 2 ) + ' ' + ( yTo - trH ) + 'L' + xTo + ' ' + yTo + 'Z';
        }

        if ( turn ) {
            if ( extraWay ) {
                pathL = 'L' + xFrom + ' ' + yTo + 'L' + xTo + ' ' + yTo;
            } else {
                pathL = 'L' + xTo + ' ' + yFrom + 'L' + xTo + ' ' + yTo;
            }
        } else {
            pathL = 'L' + xTo + ' ' + yTo;
        }

        pathM = 'M' + xFrom + ' ' + yFrom;
        pathDef = pathM + pathL;

        if ( checkDuplicate && connectFrom.duplicateConnection( connectTo ) ) {
            basicLineSet.duplicated = true;
            return basicLineSet;
        }

        line = paper.path( pathDef );
        arrow = paper.path( 'M' + xTo + ' ' + yTo + pathArrow );
        basicLineSet.push( line );
        basicLineSet.push( arrow );
        basicLineSet.data( 'direction', direction );

        return basicLineSet;
    },
    basicLineContextMenu: function( e ) {
        if ( e.button == 2 ) {
        	var paper = this.paper;
            paper.bpmn.lineContextMenu( e, paper );
        }
    },
    basicLineClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.lineClick( paper, this );
    },
    conditionalLineClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.lineClick( paper, this );
    },
    otherwiseLineClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.lineClick( paper, this );
    },
    deadlineLineClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.lineClick( paper, this );
    },
    lineClick: function( paper, clickedEl ) {
        this.eraseAllTrashes( paper );
        var set = clickedEl.data( 'wholeSet' );
        var boxSet = clickedEl.data( 'boxWholeSet' );
        var color = Ext.getCmp( 'main_panel' ).getHoverColor();
        this.markLine( paper, set, color );
        if ( !Ext.isEmpty( boxSet ) ) {
        	this.markLine( paper, boxSet, color );
        }
        this.drawLineReshapers( paper, set );
    },
    markLine: function( paper, set, color ) {
        set.data( 'blockColorChange', true );
        set.attr( {
            'stroke-width': this.clickedLineStrokeWidth
        } );
        this.putLineSetToFront( set );
        this.changeLineColor( set, color );
        paper.clickedLineSetTrash.push( set );
        this.addMarkedElIdsToTrash( paper, set );
    },
    putLineSetToFront: function( set ) {
        var conditionSigns = new Array();

        set.forEach( function( el ) {
            if ( el.data( 'conditionSign' ) ) {
                conditionSigns.push( el );
            } else {
                set.toFront();
            }
        } );

        for ( var i = 0; i < conditionSigns.length; i++ ) {
            conditionSigns[i].toFront();
        }
    },
    markTaskIncomingConnections: function( paper, activityDefId ) {
      var taskSet = this.findMapObjectElements( paper, 'activityDefId', activityDefId );
      var connector = this.getConnectorFromSet( taskSet );

      if ( !Ext.isEmpty( connector ) ) {
        var color = Ext.getCmp( 'main_panel' ).getHoverColor();
        this.markTask( paper, connector, color );
        this.addMarkedElIdsToTrash( paper, taskSet );
        this.markConnectorIncomingConnections( paper, connector );
        this.fadeElementsAfterMarkingActivityConnections( paper );
      }
    },
    markTaskOutgoingConnections: function( paper, activityDefId ) {
      var taskSet = this.findMapObjectElements( paper, 'activityDefId', activityDefId );
      var connector = this.getConnectorFromSet( taskSet );

      if ( !Ext.isEmpty( connector ) ) {
        var color = Ext.getCmp( 'main_panel' ).getHoverColor();
        this.markTask( paper, connector, color );
        this.addMarkedElIdsToTrash( paper, taskSet );
        this.markConnectorOutgoingConnections( paper, connector );
        this.fadeElementsAfterMarkingActivityConnections( paper );
      }
    },
    markAllTaskConnections: function( paper, activityDefId ) {
      var taskSet = this.findMapObjectElements( paper, 'activityDefId', activityDefId );
      var connector = this.getConnectorFromSet( taskSet );

      if ( !Ext.isEmpty( connector ) ) {
        var color = Ext.getCmp( 'main_panel' ).getHoverColor();
        this.markTask( paper, connector, color );
        this.addMarkedElIdsToTrash( paper, taskSet );
        this.markConnectorIncomingConnections( paper, connector );
        this.markConnectorOutgoingConnections( paper, connector );
        this.fadeElementsAfterMarkingActivityConnections( paper );
      }
    },
    markConnectorIncomingConnections: function( paper, connector ) {
      var color = Ext.getCmp( 'main_panel' ).getIncomingTransitionColor();

      var inConns = connector.inConnections;
      for ( var i = 0; i < inConns.length; i++ ) {
        var inConn = inConns[i];
        var connectedWith = inConn.connectedWith;
        var setType = connectedWith.data( 'setType' );
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );

        if ( setType == 'start' || setType == 'stop' ) {
          this.markTermination( paper, connectedWith, color );
        } else {
          this.markTask( paper, connectedWith, color );
        }

        this.markLine( paper, inConn.pathSet, color );
      }

      var inCondConns = connector.inCondConnections;
      for ( var i = 0; i < inCondConns.length; i++ ) {
        var inConn = inCondConns[i];
        var connectedWith = inConn.connectedWith;
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
        this.markTask( paper, connectedWith, color );
        this.markLine( paper, inConn.pathSet, color );

        var outCondConns = connectedWith.outCondConnections;

        for ( var j = 0; j < outCondConns.length; j++ ) {
          var outConn = outCondConns[j];

          if ( outConn.outTransitionId == inConn.outTransitionId ) {
            this.markLine( paper, outConn.pathSet, color );
          }
        }
      }

      var inOtherwises = connector.inOtherwises;
      for ( var i = 0; i < inOtherwises.length; i++ ) {
        var inOtherwise = inOtherwises[i];
        var connectedWith = inOtherwise.connectedWith;
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
        this.markTask( paper, connectedWith, color );
        this.markLine( paper, inOtherwise.pathSet, color );
      }

      var inExceptions = connector.inExceptions;
      for ( var i = 0; i < inExceptions.length; i++ ) {
        var inException = inExceptions[i];
        var connectedWith = inException.connectedWith;
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
        this.markTask( paper, connectedWith, color );
        this.markLine( paper, inException.pathSet, color );
        var clock = connectedWith.getDeadlineClock( inException.id );

        if ( !Ext.isEmpty( clock ) ) {
          paper.markedElIdsTrash.push( clock.id );
        }
      }
    },
    markConnectorOutgoingConnections: function( paper, connector ) {
      var color = Ext.getCmp( 'main_panel' ).getOutgoingTransitionColor();

      var outConns = connector.outConnections;
      for ( var i = 0; i < outConns.length; i++ ) {
        var outConn = outConns[i];
        var connectedWith = outConn.connectedWith;
        var setType = connectedWith.data( 'setType' );
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );

        if ( setType == 'start' || setType == 'stop' ) {
          this.markTermination( paper, connectedWith, color );
        } else {
          this.markTask( paper, connectedWith, color );
        }

        this.markLine( paper, outConn.pathSet, color );
      }

      var outCondConns = connector.outCondConnections;
      for ( var i = 0; i < outCondConns.length; i++ ) {
        var outConn = outCondConns[i];
        this.markLine( paper, outConn.pathSet, color );

        var conns = outConn.connections;
        for ( var j = 0; j < conns.length; j++ ) {
          var conn = conns[j];
          var connectedWith = conn.connectedWith;
          this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
          this.markTask( paper, connectedWith, color );
          this.markLine( paper, conn.pathSet, color );
        }
      }

      var outOtherwises = connector.outOtherwises;
      for ( var i = 0; i < outOtherwises.length; i++ ) {
        var outOtherwise = outOtherwises[i];
        var connectedWith = outOtherwise.connectedWith;
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
        this.markTask( paper, connectedWith, color );
        this.markLine( paper, outOtherwise.pathSet, color );
      }

      var outExceptions = connector.outExceptions;
      for ( var i = 0; i < outExceptions.length; i++ ) {
        var outException = outExceptions[i];
        var connectedWith = outException.connectedWith;
        this.addMarkedElIdsToTrash( paper, connectedWith.data( 'wholeSet' ) );
        this.markTask( paper, connectedWith, color );
        this.markLine( paper, outException.pathSet, color );
        var clock = connector.getDeadlineClock( outException.id );

        if ( !Ext.isEmpty( clock ) ) {
          paper.markedElIdsTrash.push( clock.id );
        }
      }
    },
    addMarkedElIdsToTrash: function( paper, set ) {
      set.forEach( function( el ) {
        paper.markedElIdsTrash.push( el.id );
      } );
    },
    fadeElementsAfterMarkingActivityConnections: function( paper ) {
      var markedElIdsTrash = paper.markedElIdsTrash;

      paper.forEach( function( el ) {
        if ( markedElIdsTrash.indexOf( el.id ) == -1 ) {
          el = el.attr( {
            opacity: 0.2
          } );

          paper.fadedTrash.push( el );
        }
      } );
    },
    otherwiseLine: function( paper, connectFrom, connectTo, xPos, yPos, checkDuplicate, tooltip, add, t ) {
        var lineSet = null;

        if ( !connectFrom ) {
            return this.startLineCursor( paper, xPos, yPos, 'otherwiseLineTooltip' );
        }

        var pathTable = null;
        var tId = null;
        var direction = '';
        var previousConnectTo = null;

        if ( t ) {
            pathTable = t.linePaths;
            tId = t.tId;
            direction = t.firstLineDirection;
            previousConnectTo = t.previousConnectTo;
        }

        if ( !pathTable ) {
            if ( !connectTo ) {
                lineSet = this.basicLine( paper, connectFrom, connectTo, xPos, yPos, checkDuplicate, tooltip, add, t );
            } else {
                lineSet = this.basicLineFinal( paper, connectFrom, connectTo, connectFrom.getBBox(), connectTo.getBBox(), xPos, yPos, checkDuplicate );
            }

            if ( lineSet.duplicated ) {
                return lineSet;
            }

            line = lineSet[0];
            arrow = lineSet[1];
        } else {
            lineSet = paper.set();
            lineSet.push( paper.path( pathTable[0] ) );
            lineSet.push( paper.path( pathTable[1] ) );
        }

        var line = lineSet[0];
        var arrow = lineSet[1];
        var path = line.attr( 'path' );

        direction = direction ? direction : line.data( 'direction' );
        var connId = tId ? tId : generateTransitionId();

        line.data( 'isArrow', false );
        arrow.data( 'isArrow', true );
        lineSet.data( 'direction', direction ).data( 'transitionId', connId ).data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo )
                        .data( 'isOtherwise', true ).data( 'wholeSet', lineSet );

        arrow = arrow.attr( {
            fill: '#FF9900',
            'stroke-width': 0
        } );

        if ( tooltip || !connectTo ) {
            line = line.attr( {
                stroke: '#FF9900',
                'stroke-dasharray': [ '--' ]
            } );
        } else {
            line = line.attr( {
                stroke: '#FF9900'
            } );

            if ( add ) {
                this.handleAddOtherwiseLine( connectFrom, connectTo, connId, lineSet, direction );
            } else {
                this.handleUpdateOtherwiseLine( connectFrom, connectTo, connId, lineSet, direction, previousConnectTo );
            }
        };

        lineSet.data( 'setType', connectTo ? 'otherwiseLine' : 'otherwiseLineTooltip' );

        return lineSet;
    },
    otherwiseLineContextMenu: function( e ) {
        if ( e.button == 2 ) {
        	var paper = this.paper;
            paper.bpmn.lineContextMenu( e, paper );
        }
    },
    deadlineLine: function( paper, connectFrom, connectTo, xPos, yPos, checkDuplicate, tooltip, add, t ) {
        var lineSet = null;

        if ( !connectFrom ) {
            return this.startLineCursor( paper, xPos, yPos, 'deadlineLineTooltip' );
        }

        var pathTable = null;
        var tId = null;
        var direction = '';
        var exceptionName = '';
        var previousConnectTo = null;

        if ( t ) {
            pathTable = t.linePaths;
            tId = t.tId;
            direction = t.firstLineDirection;
            exceptionName = t.exceptionName ? t.exceptionName : '';
            previousConnectTo = t.previousConnectTo;
        }

        if ( !pathTable ) {
            if ( !connectTo ) {
                lineSet = this.basicLine( paper, connectFrom, connectTo, xPos, yPos, checkDuplicate, tooltip, add, t );
            } else {
                lineSet = this.basicLineFinal( paper, connectFrom, connectTo, connectFrom.getBBox(), connectTo.getBBox(), xPos, yPos, checkDuplicate );
            }

            if ( lineSet.duplicated ) {
                return lineSet;
            }

            line = lineSet[0];
            arrow = lineSet[1];
        } else {
            lineSet = paper.set();
            lineSet.push( paper.path( pathTable[0] ) );
            lineSet.push( paper.path( pathTable[1] ) );
        }

        var line = lineSet[0];
        var arrow = lineSet[1];
        var path = line.attr( 'path' );
        var pathM = path[0];
        var clockImg = paper.image( getPluginImgPath( 'deadline' ), pathM[1] - 8, pathM[2] - 8, 16, 16 );

        direction = direction ? direction : line.data( 'direction' );
        var connId = tId ? tId : generateTransitionId();

        line.data( 'isArrow', false );
        arrow.data( 'isArrow', true );
        lineSet.data( 'direction', direction ).data( 'transitionId', connId ).data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo )
                        .data( 'isDeadline', true ).data( 'wholeSet', lineSet );

        arrow = arrow.attr( {
            fill: '#E16E6E',
            'stroke-width': 0
        } );

        if ( tooltip || !connectTo ) {
            line = line.attr( {
                stroke: '#E16E6E',
                'stroke-dasharray': [ '--' ]
            } );
            lineSet.push( clockImg );
        } else {
            line = line.attr( {
                stroke: '#E16E6E'
            } );

            if ( add ) {
                this.handleAddDeadlineLine( connectFrom, connectTo, connId, lineSet, direction, clockImg, exceptionName );
            } else {
                this.handleUpdateDeadlineLine( connectFrom, connectTo, connId, lineSet, direction, clockImg, previousConnectTo );
            }
        };

        lineSet.data( 'setType', connectTo ? 'deadlineLine' : 'deadlineLineTooltip' );

        return lineSet;
    },
    deadlineLineContextMenu: function( e ) {
        if ( e.button == 2 ) {
        	var paper = this.paper;
            paper.bpmn.lineContextMenu( e, paper );
        }
    },
    deadlineLineDblClick: function( e ) {
    	var paper = this.paper;
    	paper.bpmn.onDeadlineLineDblClick( this );
    },
    onDeadlineLineDblClick: function( el ) {
    	typeDeadlineExceptionName( {
            connector: el.data( 'connectFrom' ),
            transitionId: el.data( 'transitionId' )
        } );
    },
    conditionalLineContextMenu: function( e ) {
        if ( e.button == 2 ) {
        	var paper = this.paper;
            paper.bpmn.lineContextMenu( e, paper );
        }
    },
    conditionalLineDblClick: function( e ) {
    	var paper = this.paper;
    	paper.bpmn.onConditionalLineDblClick( this );
    },
    onConditionalLineDblClick: function( el ) {
    	showConditionalLineCondition( {
            el: el,
            processDefId: Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId
        } );
    },
    conditionalLineBoxContextMenu: function( e ) {
        if ( e.button == 2 ) {
        	var paper = this.paper;
            paper.bpmn.lineContextMenu( e, paper );
        }
    },
    conditionalLine: function( paper, type, conditionalLineStep, connectFrom, connectTo, xPos, yPos, checkDuplicate, add, t ) {
        this.hoverBlocked = true;

        switch ( conditionalLineStep ) {
            case 0:
                var condLineSet = this.startLineCursor( paper, xPos, yPos, type );
                condLineSet.data( 'setType', 'conditionalLineTooltip' );
                return condLineSet;
            case 1:
                return this.conditionalLineFirstStep( paper, type, connectFrom, xPos, yPos, true );
            case 2:
                var condLineSet = this.conditionalLineSecondStep( paper, type, connectFrom, xPos, yPos, t );
                if ( condLineSet ) {
                    var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
                    processPanel.addToStorage( 'conditionalLine', condLineSet );
                    processPanel.conditionalLineStep++;
                    return null;
                }
                return condLineSet;
            case 3:
                return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos, true, false );
            case 4:
                var condLineSet = this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos, false, checkDuplicate, t );
                return this.conditionalLineFourthStep( paper, condLineSet, type, connectFrom, connectTo, xPos, yPos, checkDuplicate, add, t );
            default:
                return null;
        }
    },
    conditionalLineFirstStep: function( paper, type, connectFrom, xPos, yPos, tooltip, t ) {
        var condLineSet = paper.set();
        var tt = tooltip ? 'Tooltip' : '';

        var pathTable = null;
        var xFrom = 0;
        var yFrom = 0;
        var lineDirection = '';
        var boxDirection = '';

        if ( t ) {
            pathTable = t.boxPaths;
            lineDirection = t.firstLineDirection;
            boxDirection = t.boxDirection;
        }

        var connId = generateTransitionId();
        var dashLine = null;
        var rect1 = null;
        var rect2 = null;
        var dashRect = null;

        if ( !pathTable ) {
            var fromBox = connectFrom.getBBox();
            var xFromBoxMin = fromBox.x;
            var yFromBoxMin = fromBox.y;
            var xFromBoxMax = fromBox.x2;
            var yFromBoxMax = fromBox.y2;
            var pathDef = '';
            var pathM = '';
            var pathL = '';
            var pathRect = '';
            var arrowLeft = false;
            var arrowRight = false;
            var arrowUp = false;
            var arrowDown = false;
            var turn = false;
            var rectD = this.conditionSize;
            var andX = 0;
            var andY = 0;

            if ( xPos >= xFromBoxMin && xPos <= xFromBoxMax ) {
                xFrom = xPos;

                if ( yPos > yFromBoxMax ) {
                    yFrom = yFromBoxMax;
                    arrowDown = true;
                    lineDirection = 'down';
                } else if ( yPos < yFromBoxMin ) {
                    yFrom = yFromBoxMin;
                    arrowUp = true;
                    lineDirection = 'up';
                } else {
                    this.hoverBlocked = false;
                    return null;
                }
            } else {
                if ( xPos > xFromBoxMax ) {
                    xFrom = xFromBoxMax;
                    arrowRight = true;
                    lineDirection = 'right';
                } else {
                    xFrom = xFromBoxMin;
                    arrowLeft = true;
                    lineDirection = 'left';
                }

                if ( yPos > yFromBoxMin && yPos < yFromBoxMax ) {
                    yFrom = yPos;
                } else {
                    yFrom = yFromBoxMin + fromBox.height / 2;
                    turn = true;
                    arrowLeft = false;
                    arrowRight = false;

                    if ( yPos < yFromBoxMin ) {
                        arrowUp = true;
                        lineDirection += 'up';
                    } else {
                        arrowDown = true;
                        lineDirection += 'down';
                    }
                }
            }

            if ( turn ) {
                pathL = 'L' + xPos + ' ' + yFrom + 'L' + xPos + ' ' + yPos;
            } else {
                pathL = 'L' + xPos + ' ' + yPos;
            }

            pathRect = 'M' + xPos + ' ' + yPos;
            if ( arrowLeft ) {
                pathRect += 'L' + ( xPos - rectD ) + ' ' + ( yPos + rectD ) + 'L' + ( xPos - 2 * rectD ) + ' ' + yPos + 'L' + ( xPos - rectD ) + ' '
                                + ( yPos - rectD ) + 'Z';
                boxDirection = 'left';
                andX = 2 * rectD;
            } else if ( arrowRight ) {
                pathRect += 'L' + ( xPos + rectD ) + ' ' + ( yPos + rectD ) + 'L' + ( xPos + 2 * rectD ) + ' ' + yPos + 'L' + ( xPos + rectD ) + ' '
                                + ( yPos - rectD ) + 'Z';
                boxDirection = 'right';
            } else if ( arrowUp ) {
                pathRect += 'L' + ( xPos - rectD ) + ' ' + ( yPos - rectD ) + 'L' + xPos + ' ' + ( yPos - 2 * rectD ) + 'L' + ( xPos + rectD ) + ' '
                                + ( yPos - rectD ) + 'Z';
                boxDirection = 'up';
                andX = rectD;
                andY = rectD;
            } else if ( arrowDown ) {
                pathRect += 'L' + ( xPos - rectD ) + ' ' + ( yPos + rectD ) + 'L' + xPos + ' ' + ( yPos + 2 * rectD ) + 'L' + ( xPos + rectD ) + ' '
                                + ( yPos + rectD ) + 'Z';
                boxDirection = 'down';
                andX = rectD;
                andY = ( -1 ) * rectD;
            }

            pathM = 'M' + xFrom + ' ' + yFrom;
            pathDef = pathM + pathL;

            dashLine = paper.path( pathDef );
            dashRect = paper.path( pathRect );

            var rWidth = rectD * 0.1;
            var rHeight = rectD;
            var crossPathX = xPos + rectD - rWidth / 2 - andX;
            var crossPathY = yPos - rHeight / 2 - andY;
            rect1 = paper.path( 'M' + crossPathX + ' ' + crossPathY + 'L' + crossPathX + ' ' + ( crossPathY + rHeight ) + 'L'
                            + ( crossPathX + rWidth ) + ' ' + ( crossPathY + rHeight ) + 'L' + ( crossPathX + rWidth ) + ' ' + crossPathY + 'Z' );
            crossPathX = xPos + rectD - rHeight / 2 - andX;
            crossPathY = yPos - rWidth / 2 - andY;
            rect2 = paper.path( 'M' + crossPathX + ' ' + crossPathY + 'L' + crossPathX + ' ' + ( crossPathY + rWidth ) + 'L'
                            + ( crossPathX + rHeight ) + ' ' + ( crossPathY + rWidth ) + 'L' + ( crossPathX + rHeight ) + ' ' + crossPathY + 'Z' );
        } else {
            dashLine = paper.path( pathTable[0] );
            dashRect = paper.path( pathTable[3] );
            rect1 = paper.path( pathTable[1] );
            rect2 = paper.path( pathTable[2] );
        }

        if ( type == 'XOR' ) {
            rect1.data( 'tr', 'R45' ).transform( 'R45' );
            rect2.data( 'tr', 'R45' ).transform( 'R45' );
        }

        dashLine = dashLine.attr( {
            stroke: '#444444'
        } ).data( 'setType', 'conditionalLine' + tt ).data( 'direction', lineDirection ).data( 'isBox', false );
        rect1 = rect1.attr( {
            fill: '#444444',
            'stroke-width': 0
        } ).data( 'setType', 'conditionalLineBox' + tt ).data( 'isBox', true ).data( 'conditionSign', true );
        rect2 = rect2.attr( {
            fill: '#444444',
            'stroke-width': 0
        } ).data( 'setType', 'conditionalLineBox' + tt ).data( 'isBox', true ).data( 'conditionSign', true );

        condLineSet.push( dashLine );
        condLineSet.push( rect1 );
        condLineSet.push( rect2 );
        condLineSet.push( dashRect );

        dashRect = dashRect.attr( {
            fill: '0-#FFFFFF-#FFFFE0:50-#FFFFC0',
            stroke: '#444444'
        } ).data( 'setType', 'conditionalLineBox' + tt ).data( 'connector', true ).data( 'direction', boxDirection ).data( 'isBox', true );

        rect1 = rect1.data( 'isBoxSign', true );
        rect2 = rect2.data( 'isBoxSign', true );
        dashRect = dashRect.data( 'boxSigns', [ rect1, rect2 ] );

        this.conditionBox = dashRect;

        if ( tooltip ) {
            dashLine = dashLine.attr( {
                'stroke-dasharray': [ '--' ]
            } );
            dashRect = dashRect.attr( {
                'stroke-dasharray': [ '--' ]
            } );
        } else {
            condLineSet.data( 'inout', 'out' ).data( 'connectedWith', connectFrom );

            if ( this.editionMode ) {
                condLineSet.mouseup( this.conditionalLineBoxContextMenu );
                rect1.drag( this.onBoxMove, this.onBoxDrag, this.onBoxDrop, dashRect, dashRect, dashRect );
                rect2.drag( this.onBoxMove, this.onBoxDrag, this.onBoxDrop, dashRect, dashRect, dashRect );
                dashRect.drag( this.onBoxMove, this.onBoxDrag, this.onBoxDrop, dashRect, dashRect, dashRect );
            }
        }

        condLineSet.data( 'connectFrom', connectFrom ).data( 'transitionId', connId ).data( 'conditionType', type ).data( 'wholeSet', condLineSet );

        return condLineSet;
    },
    conditionalLineSecondStep: function( paper, type, connectFrom, xPos, yPos, t ) {
        return this.conditionalLineFirstStep( paper, type, connectFrom, xPos, yPos, false, t );
    },
    conditionalLineThirdStep: function( paper, connectFrom, connectTo, xPos, yPos, tooltip, checkDuplicate, t ) {
        var condLineSet = paper.set();
        var tt = tooltip ? 'Tooltip' : '';

        var pathTable = null;
        var tId = null;
        var lineDirection = '';

        if ( t ) {
            pathTable = t.linePaths;
            tId = t.tId;
            lineDirection = t.secondLineDirection;
        }

        var dashLine = null;
        var dashArrow = null;
        var xTo = 0;
        var yTo = 0;

        if ( !pathTable ) {
            var toBox = null;
            if ( connectTo ) {
                toBox = connectTo.getBBox();
            }

            var xFromBoxMin = 0;
            var yFromBoxMin = 0;
            var xFromBoxMax = 0;
            var yFromBoxMax = 0;
            var rectD = this.conditionSize;
            var xFrom = 0;
            var yFrom = 0;
            var arrowLeft = false;
            var arrowRight = false;
            var arrowUp = false;
            var arrowDown = false;
            var extraWay = false;
            var pathDef = '';
            var pathM = '';
            var pathL = '';
            var pathArrow = '';
            var trH = 8;
            var trA = 8;
            var turn = false;
            var box = this.conditionBox;
            var boxBox = Raphael.pathBBox( box.attr( 'path' ) );
            var condX = boxBox.x + rectD;
            var condY = boxBox.y + rectD;

            switch ( box.data( 'direction' ) ) {
                case 'up':
                    xFromBoxMin = condX - rectD;
                    yFromBoxMin = condY - rectD;
                    xFromBoxMax = condX + rectD;
                    yFromBoxMax = condY + rectD;

                    if ( xPos >= xFromBoxMin && xPos <= xFromBoxMax ) {
                        if ( yPos < yFromBoxMin ) {
                            xFrom = condX;
                            yFrom = yFromBoxMin;

                            if ( toBox ) {
                                if ( toBox.x < condX && toBox.x2 > condX ) {
                                    xTo = condX;
                                    yTo = toBox.y2;
                                } else if ( toBox.x > condX ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos + rectD, yPos, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos - rectD, yPos, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = condX;
                                yTo = yPos;
                            }

                            arrowUp = true;
                            lineDirection = 'up';
                        } else {
                            xFrom = condX;
                            yFrom = yFromBoxMax;

                            if ( toBox ) {
                                if ( toBox.x < condX && toBox.x2 > condX ) {
                                    xTo = condX;
                                    yTo = toBox.y;
                                } else if ( toBox.x > condX ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos + rectD, yPos, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos - rectD, yPos, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = condX;
                                yTo = yPos;
                            }

                            arrowDown = true;
                            lineDirection = 'down';
                        }
                    } else {
                        yFrom = condY;

                        if ( xPos < xFromBoxMin ) {
                            xFrom = xFromBoxMin;

                            if ( toBox ) {
                                xTo = toBox.x2;
                            } else {
                                xTo = xPos;
                            }

                            arrowLeft = true;
                            lineDirection = 'left';
                        } else {
                            xFrom = xFromBoxMax;

                            if ( toBox ) {
                                xTo = toBox.x;
                            } else {
                                xTo = xPos;
                            }

                            arrowRight = true;
                            lineDirection = 'right';
                        }

                        if ( yPos > condY - trH && yPos < condY + trH ) {
                            yTo = condY;
                        } else if ( yPos < condY - trH ) {
                            if ( toBox ) {
                                if ( toBox.y2 < condY - trH ) {
                                    xTo = xPos;
                                    yTo = toBox.y2;
                                    arrowLeft = false;
                                    arrowRight = false;
                                    arrowUp = true;
                                    turn = true;
                                    lineDirection += 'up';
                                } else {
                                    yTo = condY;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowLeft = false;
                                arrowRight = false;
                                arrowUp = true;
                                turn = true;
                                lineDirection += 'up';
                            }
                        } else {
                            if ( toBox ) {
                                if ( toBox.y > condY + trH ) {
                                    xTo = xPos;
                                    yTo = toBox.y;
                                    arrowLeft = false;
                                    arrowRight = false;
                                    arrowDown = true;
                                    turn = true;
                                    lineDirection += 'down';
                                } else {
                                    yTo = condY;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowLeft = false;
                                arrowRight = false;
                                arrowDown = true;
                                turn = true;
                                lineDirection += 'down';
                            }
                        }
                    }

                    break;
                case 'right':
                    xFromBoxMin = condX - rectD;
                    yFromBoxMin = condY - rectD;
                    xFromBoxMax = condX + rectD;
                    yFromBoxMax = condY + rectD;

                    if ( yPos >= yFromBoxMin && yPos <= yFromBoxMax ) {
                        if ( xPos > xFromBoxMax ) {
                            xFrom = xFromBoxMax;
                            yFrom = condY;

                            if ( toBox ) {
                                if ( toBox.y < condY && toBox.y2 > condY ) {
                                    xTo = toBox.x;
                                    yTo = condY;
                                } else if ( toBox.y > condY ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos + rectD, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos - rectD, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = xPos;
                                yTo = condY;
                            }

                            arrowRight = true;
                            lineDirection = 'right';
                        } else {
                            xFrom = xFromBoxMin;
                            yFrom = condY;

                            if ( toBox ) {
                                if ( toBox.y < condY && toBox.y2 > condY ) {
                                    xTo = toBox.x2;
                                    yTo = condY;
                                } else if ( toBox.y > condY ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos + rectD, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos - rectD, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = xPos;
                                yTo = condY;
                            }

                            arrowLeft = true;
                            lineDirection = 'left';
                        }
                    } else {
                        xFrom = condX;

                        if ( yPos < yFromBoxMin ) {
                            yFrom = yFromBoxMin;

                            if ( toBox ) {
                                yTo = toBox.y2;
                            } else {
                                yTo = yPos;
                            }

                            arrowUp = true;
                            lineDirection = 'up';
                        } else {
                            yFrom = yFromBoxMax;

                            if ( toBox ) {
                                yTo = toBox.y;
                            } else {
                                yTo = yPos;
                            }

                            arrowDown = true;
                            lineDirection = 'down';
                        }

                        if ( xPos > condX - trH && xPos < condX + trH ) {
                            xTo = condX;
                        } else if ( xPos < condX - trH ) {
                            if ( toBox ) {
                                if ( toBox.x2 < condX - trH ) {
                                    xTo = toBox.x2;
                                    yTo = yPos;
                                    arrowUp = false;
                                    arrowDown = false;
                                    arrowLeft = true;
                                    turn = true;
                                    extraWay = true;
                                    lineDirection = 'left' + lineDirection;
                                } else {
                                    xTo = condX;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowUp = false;
                                arrowDown = false;
                                arrowLeft = true;
                                turn = true;
                                extraWay = true;
                                lineDirection = 'left' + lineDirection;
                            }
                        } else {
                            if ( toBox ) {
                                if ( toBox.x > condX - trH ) {
                                    xTo = toBox.x;
                                    yTo = yPos;
                                    arrowUp = false;
                                    arrowDown = false;
                                    arrowRight = true;
                                    turn = true;
                                    extraWay = true;
                                    lineDirection = 'right' + lineDirection;
                                } else {
                                    xTo = condX;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowUp = false;
                                arrowDown = false;
                                arrowRight = true;
                                turn = true;
                                extraWay = true;
                                lineDirection = 'right' + lineDirection;
                            }
                        }
                    }

                    break;
                case 'down':
                    xFromBoxMin = condX - rectD;
                    yFromBoxMin = condY - rectD;
                    xFromBoxMax = condX + rectD;
                    yFromBoxMax = condY + rectD;

                    if ( xPos >= xFromBoxMin && xPos <= xFromBoxMax ) {
                        if ( yPos > yFromBoxMax ) {
                            xFrom = condX;
                            yFrom = yFromBoxMax;

                            if ( toBox ) {
                                if ( toBox.x < condX && toBox.x2 > condX ) {
                                    xTo = condX;
                                    yTo = toBox.y;
                                } else if ( toBox.x > condX ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos + rectD, yPos, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos - rectD, yPos, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = condX;
                                yTo = yPos;
                            }

                            arrowDown = true;
                            lineDirection = 'down';
                        } else {
                            xFrom = condX;
                            yFrom = yFromBoxMin;

                            if ( toBox ) {
                                if ( toBox.x < condX && toBox.x2 > condX ) {
                                    xTo = condX;
                                    yTo = toBox.y2;
                                } else if ( toBox.x > condX ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos + rectD, yPos, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos - rectD, yPos, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = condX;
                                yTo = yPos;
                            }

                            arrowUp = true;
                            lineDirection = 'up';
                        }
                    } else {
                        yFrom = condY;

                        if ( xPos < xFromBoxMin ) {
                            xFrom = xFromBoxMin;

                            if ( toBox ) {
                                xTo = toBox.x2;
                            } else {
                                xTo = xPos;
                            }

                            arrowLeft = true;
                            lineDirection = 'left';
                        } else {
                            xFrom = xFromBoxMax;

                            if ( toBox ) {
                                xTo = toBox.x;
                            } else {
                                xTo = xPos;
                            }

                            arrowRight = true;
                            lineDirection = 'right';
                        }

                        if ( yPos > condY - trH && yPos < condY + trH ) {
                            yTo = condY;
                        } else if ( yPos < condY - trH ) {
                            if ( toBox ) {
                                if ( toBox.y2 < condY - trH ) {
                                    xTo = xPos;
                                    yTo = toBox.y2;
                                    arrowLeft = false;
                                    arrowRight = false;
                                    arrowUp = true;
                                    turn = true;
                                    lineDirection += 'up';
                                } else {
                                    yTo = condY;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowLeft = false;
                                arrowRight = false;
                                arrowUp = true;
                                turn = true;
                                lineDirection += 'up';
                            }
                        } else {
                            if ( toBox ) {
                                if ( toBox.y > condY + trH ) {
                                    xTo = xPos;
                                    yTo = toBox.y;
                                    arrowLeft = false;
                                    arrowRight = false;
                                    arrowDown = true;
                                    turn = true;
                                    lineDirection += 'down';
                                } else {
                                    yTo = condY;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowLeft = false;
                                arrowRight = false;
                                arrowDown = true;
                                turn = true;
                                lineDirection += 'down';
                            }
                        }
                    }

                    break;
                case 'left':
                    xFromBoxMin = condX - rectD;
                    yFromBoxMin = condY - rectD;
                    xFromBoxMax = condX + rectD;
                    yFromBoxMax = condY + rectD;

                    if ( yPos >= yFromBoxMin && yPos <= yFromBoxMax ) {
                        if ( xPos < xFromBoxMin ) {
                            xFrom = xFromBoxMin;
                            yFrom = condY;

                            if ( toBox ) {
                                if ( toBox.y < condY && toBox.y2 > condY ) {
                                    xTo = toBox.x2;
                                    yTo = condY;
                                } else if ( toBox.y > condY ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos + rectD, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos - rectD, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = xPos;
                                yTo = condY;
                            }

                            arrowLeft = true;
                            lineDirection = 'left';
                        } else {
                            xFrom = xFromBoxMax;
                            yFrom = condY;

                            if ( toBox ) {
                                if ( toBox.y < condY && toBox.y2 > condY ) {
                                    xTo = toBox.x;
                                    yTo = condY;
                                } else if ( toBox.y > condY ) {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos + rectD, tooltip, checkDuplicate );
                                } else {
                                    return this.conditionalLineThirdStep( paper, connectFrom, connectTo, xPos, yPos - rectD, tooltip, checkDuplicate );
                                }
                            } else {
                                xTo = xPos;
                                yTo = condY;
                            }

                            arrowRight = true;
                            lineDirection = 'right';
                        }
                    } else {
                        xFrom = condX;

                        if ( yPos < yFromBoxMin ) {
                            yFrom = yFromBoxMin;

                            if ( toBox ) {
                                yTo = toBox.y2;
                            } else {
                                yTo = yPos;
                            }

                            arrowUp = true;
                            lineDirection = 'up';
                        } else {
                            yFrom = yFromBoxMax;

                            if ( toBox ) {
                                yTo = toBox.y;
                            } else {
                                yTo = yPos;
                            }

                            arrowDown = true;
                            lineDirection = 'down';
                        }

                        if ( xPos > condX - trH && xPos < condX + trH ) {
                            xTo = condX;
                        } else if ( xPos < condX - trH ) {
                            if ( toBox ) {
                                if ( toBox.x2 < condX - trH ) {
                                    xTo = toBox.x2;
                                    yTo = yPos;
                                    arrowUp = false;
                                    arrowDown = false;
                                    arrowLeft = true;
                                    turn = true;
                                    extraWay = true;
                                    lineDirection = 'left' + lineDirection;
                                } else {
                                    xTo = condX;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowUp = false;
                                arrowDown = false;
                                arrowLeft = true;
                                turn = true;
                                extraWay = true;
                                lineDirection = 'left' + lineDirection;
                            }
                        } else {
                            if ( toBox ) {
                                if ( toBox.x > condX - trH ) {
                                    xTo = toBox.x;
                                    yTo = yPos;
                                    arrowUp = false;
                                    arrowDown = false;
                                    arrowRight = true;
                                    turn = true;
                                    extraWay = true;
                                    lineDirection = 'right' + lineDirection;
                                } else {
                                    xTo = condX;
                                }
                            } else {
                                xTo = xPos;
                                yTo = yPos;
                                arrowUp = false;
                                arrowDown = false;
                                arrowRight = true;
                                turn = true;
                                extraWay = true;
                                lineDirection = 'right' + lineDirection;
                            }
                        }
                    }

                    break;
                default:
                    break;
            }

            if ( arrowLeft ) {
                pathArrow = 'L' + ( xTo + trH ) + ' ' + ( yTo - trA / 2 ) + 'L' + ( xTo + trH ) + ' ' + ( yTo + trA / 2 ) + 'L' + xTo + ' ' + yTo
                                + 'Z';
            } else if ( arrowRight ) {
                pathArrow = 'L' + ( xTo - trH ) + ' ' + ( yTo - trA / 2 ) + 'L' + ( xTo - trH ) + ' ' + ( yTo + trA / 2 ) + 'L' + xTo + ' ' + yTo
                                + 'Z';
            } else if ( arrowUp ) {
                pathArrow = 'L' + ( xTo + trA / 2 ) + ' ' + ( yTo + trH ) + 'L' + ( xTo - trA / 2 ) + ' ' + ( yTo + trH ) + 'L' + xTo + ' ' + yTo
                                + 'Z';
            } else if ( arrowDown ) {
                pathArrow = 'L' + ( xTo + trA / 2 ) + ' ' + ( yTo - trH ) + 'L' + ( xTo - trA / 2 ) + ' ' + ( yTo - trH ) + 'L' + xTo + ' ' + yTo
                                + 'Z';
            }

            if ( turn ) {
                if ( extraWay ) {
                    pathL = 'L' + xFrom + ' ' + yTo + 'L' + xTo + ' ' + yTo;
                } else {
                    pathL = 'L' + xTo + ' ' + yFrom + 'L' + xTo + ' ' + yTo;
                }
            } else {
                pathL = 'L' + xTo + ' ' + yTo;
            }

            pathM = 'M' + xFrom + ' ' + yFrom;
            pathDef = pathM + pathL;

            if ( checkDuplicate && connectFrom.duplicateConnection( connectTo ) ) {
                condLineSet.duplicated = true;
                return condLineSet;
            }

            dashLine = paper.path( pathDef );
            dashArrow = paper.path( 'M' + xTo + ' ' + yTo + pathArrow );
        } else {
            dashLine = paper.path( pathTable[0] );
            dashArrow = paper.path( pathTable[1] );
        }

        dashLine.data( 'isArrow', false );
        dashArrow.data( 'isArrow', true );
        dashLine.data( 'wholeSet', condLineSet );
        condLineSet.push( dashLine );
        condLineSet.push( dashArrow );

        dashArrow = dashArrow.attr( {
            fill: '#444444',
            'stroke-width': 0
        } );

        if ( tooltip ) {
            dashLine.attr( {
                stroke: '#444444',
                'stroke-dasharray': [ '--' ]
            } );
        } else {
            dashLine.attr( {
                stroke: '#444444'
            } );
        }

        if ( !tooltip ) {
            condLineSet.data( 'inout', 'in' );
        }

        var connId = tId ? tId : generateTransitionId();
        condLineSet.data( 'connectFrom', connectFrom ).data( 'connectedWith', connectTo ).data( 'transitionId', connId ).data( 'direction',
                        lineDirection ).data( 'setType', 'conditionalLine' + tt ).data( 'isBasic', false ).data( 'wholeSet', condLineSet );

        return condLineSet;
    },
    conditionalLineFourthStep: function( paper, condLineSet, type, connectFrom, connectTo, xPos, yPos, checkDuplicate, add, t ) {
        if ( condLineSet.duplicated ) {
            return condLineSet;
        }

        var tId = null;
        var condition = '';
        var previousConnectTo = null;
        
        if ( t ) {
            tId = t.tId;
            condition = t.condition ? t.condition : '';
            previousConnectTo = t.previousConnectTo;
        }

        var inTransitionId = tId ? tId : condLineSet[0].data( 'transitionId' );

        if ( add ) {
            this.handleAddCondLine( type, connectFrom, connectTo, inTransitionId, condLineSet, condition );
        } else {
            this.handleUpdateCondLine( connectFrom, connectTo, inTransitionId, condLineSet, condLineSet[0].data( 'direction' ),
            		previousConnectTo );
        }

        this.hoverBlocked = false;
        return condLineSet;
    },
    lineContextMenu: function( e, paper ) {
        var lines = paper.bpmn.searchForLines( paper, e.clientX, e.clientY );
        
        if ( !Ext.isEmpty( lines ) ) {
        	paper.bpmn.executeLineOperation( e, paper, lines, paper.bpmn.lineContextMenuOperation );
        }
    },
    hoverLineIn: function( e ) {
        var line = this[0];
        var paper = line.paper;
        var mainPanel = Ext.getCmp( 'main_panel' );
        var hoverColor = mainPanel.getHoverColor();
        if ( Ext.isEmpty( line.data( 'blockColorChange' ) ) ) {
            paper.bpmn.changeLineColor( this, hoverColor );
        }

        var showTooltips = mainPanel.getShowTooltips();
        if ( !showTooltips || paper.bpmn.hoverBlocked ) {
            return;
        }

        var fromActDefId = line.data( 'connectFrom' ).data( 'activityDefId' );
        var toActDefId = line.data( 'connectedWith' ).data( 'activityDefId' );
        var procDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var packagePanel = Ext.getCmp( 'package_panel' );
        var fromActivityNode = packagePanel.findActivity( procDefId, fromActDefId );
        var toActivityNode = packagePanel.findActivity( procDefId, toActDefId );
        var tooltipText = '<table border="0"><tr><td width="25"><img src="';
        
        if ( line.data( 'isDeadline' ) ) {
        	tooltipText += getPluginImgPath( 'calendar_edit' );
        } else if ( line.data( 'isBasic' ) ) {
        	tooltipText += getPluginImgPath( 'basic_line' );
        } else if ( line.data( 'isOtherwise' ) ) {
        	tooltipText += getPluginImgPath( 'otherwise' );
        } else {
        	tooltipText += getPluginImgPath( 'condition' );
        }
        
        tooltipText += '"></td>';
        tooltipText += '<td><b>' + getTranslation( 'Z zadania' ) + ':</b> ' + fromActivityNode.attributes.activityName + '<br>';
        tooltipText += '<b>' + getTranslation( 'Do zadania' ) + ':</b> ' + toActivityNode.attributes.activityName;
        
        if ( line.data( 'isDeadline' ) ) {
        	var deadlineTransition = fromActivityNode.findDeadlineTransition( line.data( 'transitionId' ) );
            var exceptionName = deadlineTransition.exceptionName;
            tooltipText += '<br>';
            tooltipText += '<b>' + getTranslation( 'Nazwa terminu ostatecznego' ) + ':</b> ' + exceptionName;
        } else if ( !( line.data( 'isBasic' ) || line.data( 'isOtherwise' ) ) ) {
        	var cond = fromActivityNode.getCondTransitionCondition( line.data( 'transitionId' ) );
            cond = cond.replaceAll( '&&', getTranslation( 'i' ) ).replaceAll( '||', getTranslation( 'lub' ) );
            tooltipText += '<br>';
            tooltipText += '<b>' + getTranslation( 'Warunek' ) + ':</b> ' + cond;
        }
        
        tooltipText += '</td></tr></table>';

        var lineTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        lineTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( lineTooltip );
    },
    hoverLineOut: function( e ) {
        var line = this[0];
        var paper = line.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );

        if ( Ext.isEmpty( line.data( 'blockColorChange' ) ) ) {
            paper.bpmn.changeLineColor( this, paper.bpmn.getLineDefaultColor( this ) );
        }
    },
    getLineDefaultColor: function( set ) {
        var line = set[0];

        if ( line.data( 'isOtherwise' ) ) {
            return '#FF9900';
        } else if ( line.data( 'isDeadline' ) ) {
            return '#E16E6E';
        } else {
            return '#444444';
        }
    },
    changeLineColor: function( set, color ) {
        var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 500 : 1;
        set.forEach( function( el ) {
            if ( el.data( 'isArrow' ) ) {
                el.animate( {
                    fill: color,
                    stroke: color
                }, animDuration );
            } else {
                el.animate( {
                    stroke: color
                }, animDuration );
            }
        } );
    },
    changeLineColorWithDelay: function( set, color, seconds ) {
        var scope = this;
        window.setTimeout( function() {
            scope.changeLineColor( set, color );
        }, 1000 * seconds );
    },
    hoverBoxIn: function( e ) {
        var paper = this.paper;
        var mainPanel = Ext.getCmp( 'main_panel' );
        var line = this.data( 'wholeSet' )[0];

        if ( Ext.isEmpty( line.data( 'blockColorChange' ) ) ) {
            var hoverColor = mainPanel.getHoverColor();
            var box = Raphael.pathBBox( this.attr( 'path' ) );
            var rectD = paper.bpmn.conditionSize;
            var xPos = box.x;
            var yPos = box.y + rectD;
            var pathTooltip = 'M' + xPos + ' ' + yPos + 'L' + ( xPos + rectD ) + ' ' + ( yPos + rectD ) + 'L' + ( xPos + 2 * rectD ) + ' ' + yPos
                            + 'L' + ( xPos + rectD ) + ' ' + ( yPos - rectD ) + 'Z';
            var frame = paper.path( pathTooltip );
            frame.attr( {
                stroke: '#FFFFFF',
                'stroke-width': 1
            } );
            var animDuration = mainPanel.getAnimationsOn() ? 500 : 1;
            frame.animate( {
                stroke: hoverColor,
                'stroke-width': 3
            }, animDuration );
            paper.hoverTrash.push( frame );

            line.animate( {
                stroke: hoverColor
            }, animDuration );
        }

        var showTooltips = mainPanel.getShowTooltips();
        if ( !showTooltips || paper.bpmn.hoverBlocked ) {
            return;
        }

        var actDefId = this.data( 'connectFrom' ).data( 'activityDefId' );
        if ( !actDefId ) {
            return;
        }

        var packagePanel = Ext.getCmp( 'package_panel' );
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var activityNode = packagePanel.findActivity( processDefId, actDefId );
        var processNode = activityNode.parentNode;
        var packageNode = processNode.parentNode;
        var packageId = packageNode.attributes.packageId;
        var tooltipText = '<table border="0"><tr><td width="25">';
        tooltipText += '<img src="' + getPluginImgPath( 'condition' ) + '"></td>';
        tooltipText += '<td><b><u>' + getTranslation( 'Warunki' ) + ':</u></b><br>';

        Ext.each( activityNode.attributes.transitions.cond, function( t, idx, ts ) {
            var toActivityNode = packagePanel.findActivity( processDefId, t.to );
            var toActivityName = toActivityNode.attributes.activityName;
            var toActivityDefId = toActivityNode.attributes.activityDefId;
            var toActivityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, toActivityDefId, toActivityName );

            var cond = t.condition;
            cond = cond.replaceAll( '&&', getTranslation( 'i' ) ).replaceAll( '||', getTranslation( 'lub' ) );
            tooltipText += '<b>' + toActivityNameTranslation + ':</b> ' + cond + '<br>';
        } );

        tooltipText += '</td></tr></table>';

        var boxTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        boxTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( boxTooltip );
    },
    hoverBoxOut: function( e ) {
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );

        var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 500 : 1;
        var line = this.data( 'wholeSet' )[0];

        if ( Ext.isEmpty( line.data( 'blockColorChange' ) ) ) {
            line.animate( {
                stroke: '#000000'
            }, animDuration );
        }
    },
    boxClick: function( e ) {
        var paper = this.paper;
        var set = this.data( 'wholeSet' );
        var connectFrom = this.data( 'connectedWith' );

        paper.bpmn.timeout = window.setTimeout( function() {
            var color = Ext.getCmp( 'main_panel' ).getHoverColor();
            paper.bpmn.eraseAllTrashes( paper );
            paper.bpmn.markLine( paper, set, color );
            paper.bpmn.boxHelpers( paper, set );
            
            if ( !Ext.isEmpty( connectFrom ) && !Ext.isEmpty( connectFrom.outCondConnections ) ) {
                var outConnections = connectFrom.outCondConnections;

                for ( var i = 0; i < outConnections.length; i++ ) {
                    var outConnection = outConnections[i];
                    var conns = outConnection.connections;

                    for ( var j = 0; j < conns.length; j++ ) {
                        var conn = conns[j];
                        paper.bpmn.markLine( paper, conn.pathSet, color );
                    }
                }
            }
        }, 10 );
    },
    boxDblClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.onBoxDblClick( this );
    },
    onBoxDblClick: function( el ) {
        var timeout = this.timeout;
        if ( timeout ) {
            window.clearTimeout( timeout );
        }

        showConditionalLineConditions( {
            connectFrom: el.data( 'connectFrom' )
        } );

        this.eraseAllTrashesWithDelay( paper, 100 );
    },
    newConnectionToBox: function( paper, type, connectFrom, transitionId ) {
        var rectD = this.conditionSize;
        var box = this.conditionBox;
        var boxBox = Raphael.pathBBox( box.attr( 'path' ) );
        var xCornerHMin = boxBox.x;
        var xCornerHMax = boxBox.x2;
        var xCornerV = xCornerHMin + rectD;
        var yCornerVMin = boxBox.y;
        var yCornerVMax = boxBox.y2;
        var yCornerH = yCornerVMin + rectD;
        var fromBox = connectFrom.getBBox();
        var xFromBoxMin = fromBox.x;
        var yFromBoxMin = fromBox.y;
        var xFromBoxMax = fromBox.x2;
        var yFromBoxMax = fromBox.y2;
        var xFrom = 0;
        var yFrom = 0;
        var xTo = 0;
        var yTo = 0;
        var pathDef = '';
        var pathM = '';
        var pathL = '';
        var turn = false;
        var boxDirection = '';
        var lineDirection = '';

        if ( xFromBoxMin < xCornerV && xFromBoxMax > xCornerV ) {
            xFrom = xCornerV;
            xTo = xCornerV;

            if ( yFromBoxMax < yCornerVMin ) {
                yFrom = yFromBoxMax;
                yTo = yCornerVMin;
                boxDirection = 'down';
                lineDirection = 'down';
            } else if ( yFromBoxMin > yCornerVMax ) {
                yFrom = yFromBoxMin;
                yTo = yCornerVMax;
                boxDirection = 'up';
                lineDirection = 'up';
            } else {
                yFrom = yFromBoxMin;
                yTo = yCornerVMax;
                boxDirection = 'up';
                lineDirection = 'up';
            }
        } else if ( xFromBoxMax < xCornerV ) {
            boxDirection = 'right';
            xTo = xCornerHMin;
            yTo = yCornerH;

            if ( yFromBoxMin < yCornerH && yFromBoxMax > yCornerH ) {
                xFrom = xFromBoxMax;
                yFrom = yCornerH;
                lineDirection = 'right';
            } else if ( yFromBoxMax < yCornerH ) {
                xFrom = xFromBoxMin + fromBox.width / 2;
                yFrom = yFromBoxMax;
                lineDirection = 'rightdown';
                turn = true;
            } else {
                xFrom = xFromBoxMin + fromBox.width / 2;
                yFrom = yFromBoxMin;
                lineDirection = 'rightup';
                turn = true;
            }
        } else {
            boxDirection = 'left';
            xTo = xCornerHMax;
            yTo = yCornerH;

            if ( yFromBoxMin < yCornerH && yFromBoxMax > yCornerH ) {
                xFrom = xFromBoxMin;
                yFrom = yCornerH;
                lineDirection = 'left';
            } else if ( yFromBoxMax < yCornerH ) {
                xFrom = xFromBoxMin + fromBox.width / 2;
                yFrom = yFromBoxMax;
                lineDirection = 'leftdown';
                turn = true;
            } else {
                xFrom = xFromBoxMin + fromBox.width / 2;
                yFrom = yFromBoxMin;
                lineDirection = 'leftup';
                turn = true;
            }
        }

        if ( turn ) {
            pathL = 'L' + xFrom + ' ' + yTo + 'L' + xTo + ' ' + yTo;
        } else {
            pathL = 'L' + xTo + ' ' + yTo;
        }

        pathM = 'M' + xFrom + ' ' + yFrom;
        pathDef = pathM + pathL;

        var line = paper.path( pathDef );
        line = line.attr( {
            stroke: '#444444'
        } );
        line = line.data( 'setType', 'conditionalLine' ).data( 'direction', lineDirection ).data( 'isBox', false ).data( 'connectFrom', connectFrom )
                        .data( 'transitionId', transitionId ).data( 'conditionType', type ).data( 'inout', 'out' )
                        .data( 'connectedWith', connectFrom );
        var wholeSet = box.data( 'wholeSet' );
        wholeSet.splice( 0, 1, line );

        box.data( 'direction', boxDirection ).data( 'wholeSet', wholeSet );
        connectFrom.updateOutCondConnection( transitionId, wholeSet );

        return line;
    },
    getConnector: function( paper, x, y ) {
        var connector = null;

        paper.forEach( function( el ) {
            if ( el.isPointInside( x, y ) ) {
                if ( el.data( 'connector' ) ) {
                    connector = el;
                    return false;
                }
            }
        } );

        return connector;
    },
    updateActivity: function( paper, def ) {
        var taskSet = this.findMapObjectElements( paper, 'activityDefId', def.oldActDefId );
        taskSet.data( 'activityDefId', def.newActDefId ).data( 'activityName', def.actName );
        var connector = null;

        for ( var i = 0; i < taskSet.length; i++ ) {
            var el = taskSet[i];

            if ( el.type == 'text' ) {
                el.attr( {
                    text: this.prepareActivityName( def.processDefId, def.newActDefId, def.actName )
                } );
            }

            if ( el.data( 'connector' ) ) {
                connector = el;
            }
        }

        if ( def.oldActDefId != def.newActDefId ) {
            connector.updateConnectionsToInfo( def.newActDefId );
        }
    },
    prepareActivityName: function( processDefId, activityDefId, actName ) {
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, actName );

        return this.prepareName( activityNameTranslation, 12, 3 );
    },
    findMapObjectElements: function( paper, dataId, dataValue ) {
        var set = paper.set();

        paper.forEach( function( el ) {
            if ( el.data( dataId ) == dataValue ) {
                set.push( el );
            }
        } );

        return set;
    },
    removeMapObject: function( paper, dataId, dataValue ) {
        var set = this.findMapObjectElements( paper, dataId, dataValue );

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];
            if ( el.data( 'connector' ) ) {
                el.removeAllConnections();
            }
            el.remove();
        }
    },
    role: function( paper, xPos, yPos, tooltip, roleNo, name, id, isGlobal ) {
        var roleName = name ? name : getTranslation( 'Uczestnik' ) + ' ' + roleNo;

        return this.participant( paper, xPos, yPos, {
            tooltip: tooltip,
            isGlobal: isGlobal,
            image: getPluginImgPath( 'role' ),
            tooltipSetType: 'roleTooltip',
            roleboxFill: '#FFFFFF',
            headerSetType: 'roleHeader',
            containerSetType: 'roleField',
            roleTxt: name ? this.prepareRoleName( this.roleHeight * 0.6, id, name ) : getTranslation( 'Uczestnik' ) + ' ' + roleNo,
            roleName: roleName,
            roleId: id ? id : generateId( roleName, Ext.ux.suncode.Constants.ROLE_ID_MAX_LENGTH ),
            roleType: 'ROLE'
        } );
    },
    system: function( paper, xPos, yPos, tooltip, name, id, isGlobal ) {
        return this.participant( paper, xPos, yPos, {
            tooltip: tooltip,
            isGlobal: isGlobal,
            image: getPluginImgPath( 'system' ),
            tooltipSetType: 'systemTooltip',
            roleboxFill: '0-#DADADA-#E2E2E2:50-#EAEAEA',
            headerSetType: 'systemHeader',
            containerSetType: 'systemField',
            roleTxt: name ? this.prepareRoleName( this.roleHeight * 0.6, id, name ) : getTranslation( 'System' ),
            roleName: name ? name : getTranslation( 'System' ),
            roleId: id,
            roleType: 'SYSTEM'
        } );
    },
    bufor: function( paper, xPos, yPos, tooltip, name, id, isGlobal ) {
        return this.participant( paper, xPos, yPos, {
            tooltip: tooltip,
            isGlobal: isGlobal,
            image: getPluginImgPath( 'buffer' ),
            tooltipSetType: 'buforTooltip',
            roleboxFill: '0-#DADADA-#E2E2E2:50-#EAEAEA',
            headerSetType: 'roleHeader',
            containerSetType: 'roleField',
            roleTxt: name ? this.prepareRoleName( this.roleHeight * 0.6, id, name ) : getTranslation( 'Bufor' ),
            roleName: name ? name : getTranslation( 'Bufor' ),
            roleId: id,
            roleType: 'RESOURCE'
        } );
    },
    participant: function( paper, xPos, yPos, config ) {
        var roleSet = paper.set();
        var img = null;

        if ( config.tooltip ) {
            img = paper.image( config.image, xPos, yPos, 16, 16 );
            img.attr( {
                cursor: 'none'
            } );
            img = img.data( 'setType', config.tooltipSetType );
            roleSet.push( img );
            return roleSet;
        }

        xPos = 1;
        yPos = paper.lastRoleYPos;
        var cr = this.participantCornerRadius;
        var rolebox = this.roundedRectangle( paper, xPos, yPos, this.roleWidth, this.roleHeight, cr, 0, 0, cr );
        rolebox.attr( {
            fill: config.roleboxFill,
            stroke: '#7F9DB9',
            'stroke-width': 1
        } ).data( 'setType', config.headerSetType );

        img = paper.image( config.image, xPos + this.roleWidth / 2 - 8, yPos + this.roleHeight * 0.8, 16, 16 );
        img.data( 'setType', config.headerSetType ).data( 'tr', 'R270' ).transform( 'R270' );

        var roleContainerWidth = paper.lastRoleXPos - 5;
        var roleContainer = this.roundedRectangle( paper, this.roleWidth, yPos, roleContainerWidth, this.roleHeight, 0, cr, cr, 0 );
        roleContainer.attr( {
            fill: '#FFFFFF',
            stroke: '#7F9DB9',
            'stroke-width': 1
        } ).data( 'setType', config.containerSetType );
        var roleNameText = paper.text( xPos + this.roleWidth / 2, yPos + this.roleHeight / 2, config.roleTxt );
        roleNameText = roleNameText.attr( {
            fill: '#000000',
            stroke: 'none',
            'font-size': 10,
            'font-family': 'Tahoma,Helvetica,sans-serif'
        } ).data( 'setType', config.headerSetType ).data( 'tr', 'R270' ).transform( 'R270' );
        rolebox.data( 'roleContainer', roleContainer );

        roleSet.push( rolebox );
        roleSet.push( roleContainer );
        roleSet.toBack();
        roleSet.push( roleNameText );
        roleSet.push( img );
        roleSet.data( 'roleName', config.roleName ).data( 'roleType', config.roleType ).data( 'roleId', config.roleId ).data( 'roleWidth',
                        roleContainer.getBBox().width ).data( 'roleHeight', this.roleHeight ).data( 'isGlobal', config.isGlobal );
        rolebox.data( 'wholeSet', roleSet );

        if ( this.editionMode ) {
            rolebox.hover( this.hoverParticipantIn, this.hoverParticipantOut, rolebox, rolebox );
            roleNameText.hover( this.hoverParticipantIn, this.hoverParticipantOut, rolebox, rolebox );
            img.hover( this.hoverParticipantIn, this.hoverParticipantOut, rolebox, rolebox );
            rolebox.drag( this.onParticipantMove, this.onParticipantDrag, this.onParticipantDrop, rolebox, rolebox, rolebox );
            roleNameText.drag( this.onParticipantMove, this.onParticipantDrag, this.onParticipantDrop, rolebox, rolebox, rolebox );
            img.drag( this.onParticipantMove, this.onParticipantDrag, this.onParticipantDrop, rolebox, rolebox, rolebox );
            roleSet.click( this.participantClick );
            roleSet.dblclick( this.participantDblClick );
            roleSet.mouseup( this.participantContextMenu );
        }

        paper.lastRoleYPos += this.roleHeight;
        this.handlePaperSize( paper );
        return roleSet;
    },
    participantClick: function( e ) {
        var paper = this.paper;
        paper.bpmn.eraseAllTrashes( paper );
        var lines = paper.bpmn.searchForLines( paper, e.clientX, e.clientY );
        
        if ( !Ext.isEmpty( lines ) ) {
        	var line = lines[0];
        	var lineEl = line.el;
        	paper.bpmn.lineClick( paper, lineEl );
        } else {
        	var setType = this.data( 'setType' );
            
            if ( setType == 'roleField' || setType == 'systemField' ) {
                paper.bpmn.resizers( paper, this );
            }
        }
    },
    participantDblClick: function( e ) {
    	var paper = this.paper;
        var lines = paper.bpmn.searchForLines( paper, e.clientX, e.clientY );
        
        if ( !Ext.isEmpty( lines ) ) {
        	var line = lines[0];
        	var lineEl = line.el;
        	var setType = lineEl.data( 'setType' );
        	
        	switch( setType ) {
        		case 'conditionalLine':
        			paper.bpmn.onConditionalLineDblClick( lineEl );
        			break;
        		case 'conditionalLineBox':
        			paper.bpmn.onBoxDblClick( lineEl );
        			break;
        		case 'deadlineLine':
        			paper.bpmn.onDeadlineLineDblClick( lineEl );
        			break;
    			default:
    				break;
    		}
        } else {
	        var setType = this.data( 'setType' );
	
	        if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
	            var packagePanel = Ext.getCmp( 'package_panel' );
	            var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
	            var processNode = packagePanel.findProcess( processDefId );
	            showRoleProperties( {
	                processNode: processNode,
	                roleId: this.data( 'roleId' )
	            } );
	        }
        }
    },
    participantContextMenu: function( e ) {
      if ( e.button == 2 ) {
        var paper = this.paper;
        paper.bpmn.searchWithMatrix( paper, e );
      }
    },
    searchWithMatrix: function( paper, e ) {
      var lineReshaper = paper.bpmn.searchForLineReshaper( paper, e.clientX, e.clientY );

      if ( !Ext.isEmpty( lineReshaper ) && !Ext.isEmpty( lineReshaper.el ) && lineReshaper.el.data( 'hasContextMenu' ) ) {
        paper.bpmn.onLineReshaperContextMenu( e, paper, lineReshaper.el );
        return;
      }

      var lines = paper.bpmn.searchForLines( paper, e.clientX, e.clientY );

      if ( !Ext.isEmpty( lines ) ) {
        paper.bpmn.executeLineOperation( e, paper, lines, paper.bpmn.lineContextMenuOperation );
        return;
      }
    },
    executeLineOperation: function( e, paper, lines, operation ) {
    	if ( lines.length == 1 && Ext.isFunction( operation ) ) {
    		operation.apply( this, [ e, paper, lines[0] ] );
    	} else {
    		var items = new Array();
        	
        	Ext.each( lines, function( line, index, allLines ) {
    			var lineEl = line.el;
    			var connectFrom = lineEl.data( 'connectFrom' );
    	        var connectTo = lineEl.data( 'connectedWith' );
    	        
    	        items.push( {
        			xtype: 'menuitem',
        			cls: 'x-btn-text-icon',
        			icon: this.getConnectionIcon( lineEl ),
                    text: connectFrom.data( 'activityName' ) + ' -> ' + connectTo.data( 'activityName' ),
                    line: line,
                    listeners: {
                    	scope: this,
                    	click: function( menuItem ) {
                    		if ( Ext.isFunction( operation ) ) {
                    			operation.apply( this, [ e, paper, menuItem.line ] );
                    		}
                    	}
                    }
        		} );
    		}, this );
        	
        	var menu = new Ext.menu.Menu( {
        		items: items
        	} );
            menu.showAt( [ e.clientX, e.clientY + getPageYOffset() ] );
    	}
    },
    getConnectionIcon: function( lineEl ) {
    	var setType = lineEl.data( 'setType' );
    	
    	switch( setType ) {
    		case 'basicLine':
    			return getPluginImgPath( 'basic_line' );
    		case 'conditionalLine':
    		case 'conditionalLineBox':
    			var conditionType = lineEl.data( 'conditionType' );
    			
    			if ( conditionType === 'XOR' ) {
    				return getPluginImgPath( 'cond_line_xor' );
    			} else {
    				return getPluginImgPath( 'cond_line_and' );
    			}
    		case 'otherwiseLine':
    			return getPluginImgPath( 'otherwise' );
    		case 'deadlineLine':
    			return getPluginImgPath( 'deadline' );
			default:
				return '';
		}
    },
    lineContextMenuOperation: function( e, paper, line ) {
    	var lineEl = line.el;
    	var xOffset = line.xOffset;
    	var yOffset = line.yOffset;
    	var setType = lineEl.data( 'setType' );
    	
    	switch( setType ) {
    		case 'basicLine':
    			paper.bpmn.lineClick( paper, lineEl );
    			Ext.getCmp( 'paper_panel' ).getActiveTab().showBasicLineMenu( e, lineEl, xOffset, yOffset );
    			break;
    		case 'conditionalLine':
    			paper.bpmn.lineClick( paper, lineEl );
    			var inout = lineEl.data( 'inout' );
    			
    			if ( inout === 'in' ) {
    				Ext.getCmp( 'paper_panel' ).getActiveTab().showConditionalLineMenu( e, lineEl, xOffset, yOffset );
    			} else {
    				Ext.getCmp( 'paper_panel' ).getActiveTab().showConditionalLineBoxMenu( e, lineEl );
    			}
    			break;
    		case 'conditionalLineBox':
    			paper.bpmn.lineClick( paper, lineEl );
    			Ext.getCmp( 'paper_panel' ).getActiveTab().showConditionalLineBoxMenu( e, lineEl );
    			break;
    		case 'otherwiseLine':
    			paper.bpmn.lineClick( paper, lineEl );
    			Ext.getCmp( 'paper_panel' ).getActiveTab().showOtherwiseLineMenu( e, lineEl, xOffset, yOffset );
    			break;
    		case 'deadlineLine':
    			paper.bpmn.lineClick( paper, lineEl );
    			Ext.getCmp( 'paper_panel' ).getActiveTab().showDeadlineLineMenu( e, lineEl, xOffset, yOffset );
    			break;
			default:
				break;
		}
    },
    hoverParticipantIn: function( e ) {
        var paper = this.paper;
        var mainPanel = Ext.getCmp( 'main_panel' );
        var hoverColor = mainPanel.getHoverColor();
        var roleContainer = this.data( 'roleContainer' );
        var headerBox = Raphael.pathBBox( this.attr( 'path' ) );
        var containerBox = Raphael.pathBBox( roleContainer.attr( 'path' ) );
        var animDuration = mainPanel.getAnimationsOn() ? 500 : 1;
        var cr = paper.bpmn.participantCornerRadius;
        var headerFrame = paper.bpmn.roundedRectangle( paper, headerBox.x, headerBox.y, headerBox.width, headerBox.height, cr, 0, 0, cr );
        headerFrame.attr( {
            stroke: '#FFFFFF',
            'stroke-width': 1
        } );
        headerFrame.animate( {
            stroke: hoverColor,
            'stroke-width': 3
        }, animDuration );
        paper.hoverTrash.push( headerFrame );

        var ctrFrame = paper.bpmn.roundedRectangle( paper, containerBox.x, containerBox.y, containerBox.width, containerBox.height, 0, cr, cr, 0 );
        ctrFrame.attr( {
            stroke: '#FFFFFF',
            'stroke-width': 1
        } );
        ctrFrame.animate( {
            stroke: hoverColor,
            'stroke-width': 3
        }, animDuration );
        paper.hoverTrash.push( ctrFrame );
    },
    hoverParticipantOut: function( e ) {
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    resizers: function( paper, roleField ) {
        var box = roleField.getBBox();
        var xV = box.x + box.width / 2;
        var yV = box.y2;
        var xH = box.x2;
        var yH = box.y + box.height / 2;
        var resizerColor = Ext.getCmp( 'main_panel' ).getHoverColor();

        var vCircle = paper.circle( xV, yV, 4, 4 );
        vCircle.attr( {
            fill: resizerColor,
            stroke: '#000000',
            'stroke-width': 1,
            cursor: 'move'
        } ).data( 'setType', 'vRoleResizer' ).data( 'roleField', roleField ).data( 'resizeType', 'vertical' );
        paper.resizerTrash.push( vCircle );

        vCircle.drag( this.onRoleResizerMove, this.onRoleResizerDrag, this.onRoleResizerDrop, vCircle, vCircle, vCircle );

        var hCircle = paper.circle( xH, yH, 4, 4 );
        hCircle.attr( {
            fill: resizerColor,
            stroke: '#000000',
            'stroke-width': 1,
            cursor: 'move'
        } ).data( 'setType', 'hRoleResizer' ).data( 'roleField', roleField ).data( 'resizeType', 'horizontal' );
        paper.resizerTrash.push( hCircle );

        hCircle.drag( this.onRoleResizerMove, this.onRoleResizerDrag, this.onRoleResizerDrop, hCircle, hCircle, hCircle );

        var bCircle = paper.circle( xH, yV, 4, 4 );
        bCircle.attr( {
            fill: resizerColor,
            stroke: '#000000',
            'stroke-width': 1,
            cursor: 'move'
        } ).data( 'setType', 'bRoleResizer' ).data( 'roleField', roleField ).data( 'resizeType', 'both' );
        paper.resizerTrash.push( bCircle );

        bCircle.drag( this.onRoleResizerMove, this.onRoleResizerDrag, this.onRoleResizerDrop, bCircle, bCircle, bCircle );
    },
    drawLineReshapers: function( paper, lineSet ) {
        var resizerColor = Ext.getCmp( 'main_panel' ).getHoverColor();
        var line = lineSet[0];
        var path = handlePathAttrType( line.attr( 'path' ) );

        for ( var i = 1; i < path.length - 1; i++ ) {
            var pathEl = path[i];
            var x = pathEl[1];
            var y = pathEl[2];
            var reshaper = paper.circle( x, y, 4, 4 );
            reshaper.attr( {
                fill: resizerColor,
                stroke: '#000000',
                'stroke-width': 1
            } ).data( 'setType', 'lineReshaper' ).data( 'wholeSet', lineSet ).data( 'pointIndex', i );
            paper.resizerTrash.push( reshaper );

            reshaper.drag( this.onLineReshaperMove, this.onLineReshaperDrag, this.onLineReshaperDrop, reshaper, reshaper, reshaper );

            if ( i > 1 && i < path.length - 2 ) {
                reshaper.data( 'hasContextMenu', true );

                reshaper.mouseup( function( e ) {
                  if ( e.button == 2 ) {
                    paper.bpmn.searchWithMatrix( paper, e );
                  }
                } );
            }
        }
    },
    separateLineReshaperFromTrash: function( paper, reshaper ) {
        for ( var i = 0; i < paper.resizerTrash.length; i++ ) {
            var otherReshaper = paper.resizerTrash[i];
            if ( otherReshaper.id == reshaper.id ) {
                paper.resizerTrash.splice( i, 1 );
                break;
            }
        }

        paper.bpmn.eraseTrash( paper.resizerTrash );
    },
    onLineReshaperContextMenu: function( e, paper, reshaperEl ) {
      paper.bpmn.separateLineReshaperFromTrash( paper, reshaperEl );
      paper.resizerTrash.push( reshaperEl );
      showLineReshaperContextMenu( e, reshaperEl );
    },
    addLinePoint: function( paper, line, x, y ) {
        var linePath = handlePathAttrType( line.attr( 'path' ) );
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var connId = line.data( 'transitionId' );
        var connectFrom = line.data( 'connectFrom' );
        var connectTo = line.data( 'connectedWith' );
        var lineSet = line.data( 'wholeSet' );
        var direction = line.data( 'direction' );
        var newPath = new Array();
        var added = false;

        for ( var i = 0; i < linePath.length; i++ ) {
            var linePathEl = linePath[i];
            newPath.push( linePathEl );

            if ( added || i >= linePath.length - 1 ) {
                continue;
            }

            var nextLinePathEl = linePath[i + 1];
            var xPos = linePathEl[1];
            var yPos = linePathEl[2];
            var xCheck = Math.abs( xPos - x );
            var yCheck = Math.abs( yPos - y );

            if ( ( xCheck <= 1 && isPointYBetweenLineEnds( y, yPos, nextLinePathEl[2] ) )
                            || ( yCheck <= 1 && isPointXBetweenLineEnds( x, xPos, nextLinePathEl[1] ) ) ) {
                var newPointX = x;
                var newPointY = y;

                if ( xCheck <= 1 ) {
                    newPointX = xPos;
                } else {
                    newPointY = yPos;
                }

                newPath.push( [ 'L', newPointX, newPointY ] );
                added = true;
            }
        }

        line.attr( {
            path: newPath
        } );

        if ( isBasic ) {
            paper.bpmn.handleUpdateBasicLine( connectFrom, connectTo, connId, lineSet, direction );
        } else if ( isOtherwise ) {
            paper.bpmn.handleUpdateOtherwiseLine( connectFrom, connectTo, connId, lineSet, direction );
        } else if ( isDeadline ) {
            var clock = connectFrom.getDeadlineClock( connId );
            paper.bpmn.handleUpdateDeadlineLine( connectFrom, connectTo, connId, lineSet, direction, clock.clone() );
        } else {
            paper.bpmn.handleUpdateCondLine( connectFrom, connectTo, connId, lineSet, direction );
        }

        this.eraseAllTrashes( paper );
        this.drawLineReshapers( paper, lineSet );
    },
    deleteLinePoint: function( paper, reshaper ) {
        var lineSet = reshaper.data( 'wholeSet' );
        var line = lineSet[0];
        var linePath = handlePathAttrType( line.attr( 'path' ) );
        var isBasic = line.data( 'isBasic' );
        var isOtherwise = line.data( 'isOtherwise' );
        var isDeadline = line.data( 'isDeadline' );
        var pointIndex = reshaper.data( 'pointIndex' );
        var connId = line.data( 'transitionId' );
        var connectFrom = line.data( 'connectFrom' );
        var connectTo = line.data( 'connectedWith' );
        var direction = line.data( 'direction' );

        var deletedPoint = linePath[pointIndex];
        var previousPoint = linePath[pointIndex - 1];
        var nextPoint = linePath[pointIndex + 1];

        if ( deletedPoint[1] == previousPoint[1] ) {
            previousPoint[1] = nextPoint[1];
        } else {
            previousPoint[2] = nextPoint[2];
        }

        linePath.splice( pointIndex, 2 );

        line.attr( {
            path: linePath
        } );

        if ( isBasic ) {
            paper.bpmn.handleUpdateBasicLine( connectFrom, connectTo, connId, lineSet, direction );
        } else if ( isOtherwise ) {
            paper.bpmn.handleUpdateOtherwiseLine( connectFrom, connectTo, connId, lineSet, direction );
        } else if ( isDeadline ) {
            var clock = connectFrom.getDeadlineClock( connId );
            paper.bpmn.handleUpdateDeadlineLine( connectFrom, connectTo, connId, lineSet, direction, clock.clone() );
        } else {
            paper.bpmn.handleUpdateCondLine( connectFrom, connectTo, connId, lineSet, direction );
        }

        paper.bpmn.eraseTrash( paper.resizerTrash );
        paper.bpmn.drawLineReshapers( paper, lineSet );
    },
    reduceLineToShortestPath: function( paper, lineEl ) {
        this.eraseAllTrashes( paper );
        var isBasic = lineEl.data( 'isBasic' );
        var isOtherwise = lineEl.data( 'isOtherwise' );
        var isDeadline = lineEl.data( 'isDeadline' );
        var connId = lineEl.data( 'transitionId' );
        var connectFrom = lineEl.data( 'connectFrom' );
        var connectTo = lineEl.data( 'connectedWith' );
        var toBox = connectTo.getBBox();
        var xPos = toBox.x + toBox.width / 2;
        var yPos = toBox.y + toBox.height / 2;

        if ( isBasic ) {
            this.basicLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                tId: connId
            } );
        } else if ( isOtherwise ) {
            this.otherwiseLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                tId: connId
            } );
        } else if ( isDeadline ) {
            this.deadlineLine( paper, connectFrom, connectTo, xPos, yPos, false, false, false, {
                tId: connId
            } );
        } else {
            this.conditionBox = connectTo.getInConnectionBox( connId );
            var type = this.conditionBox.data( 'conditionType' );
            this.conditionalLine( paper, type, 4, connectFrom, connectTo, xPos, yPos, false, false, {
                tId: connId
            } );
        }

        lineEl.data( 'wholeSet' ).remove();
    },
    taskHelpers: function( paper, set ) {
        if ( this.elDragged ) {
            return;
        }

        var AV = Ext.getCmp( 'main_panel' ).getAdvancedView();
        var connector = this.getConnectorFromSet( set );
        var connectorSetType = connector.data( 'setType' );
        var box = connector.getBBox();
        var r = this.helperRadius;
        var x = box.x2 + r + 3;
        var y = box.y + r;

        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'blaTaskHelper',
            clickHandler: this.blaTaskHelperClicked,
            img: getPluginImgPath( 'activity_small' )
        } );

        y += 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'blrTaskHelper',
            clickHandler: this.blrTaskHelperClicked,
            img: getPluginImgPath( 'route_small' )
        } );

        y += 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'bltTaskHelper',
            clickHandler: this.bltTaskHelperClicked,
            img: getPluginImgPath( 'tool_small' )
        } );

        if ( connectorSetType == 'start' ) {
            x -= 2 * r;
            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'blTaskHelper',
                clickHandler: this.blTaskHelperClicked,
                img: getPluginImgPath( 'basic_line' )
            } );
        } else {
            y += 2 * r;

            if ( AV ) {
                this.helper( paper, {
                    x: x,
                    y: y,
                    r: r,
                    connector: connector,
                    setType: 'blsubTaskHelper',
                    clickHandler: this.blsubTaskHelperClicked,
                    img: getPluginImgPath( 'subflow_small' )
                } );

                x -= 2 * r;
                this.helper( paper, {
                    x: x,
                    y: y,
                    r: r,
                    connector: connector,
                    setType: 'elTaskHelper',
                    clickHandler: this.elTaskHelperClicked,
                    img: getPluginImgPath( 'deadline' )
                } );

                x -= 2 * r;
            }

            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'olTaskHelper',
                clickHandler: this.olTaskHelperClicked,
                img: getPluginImgPath( 'otherwise' )
            } );

            x -= 2 * r;
            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'cliTaskHelper',
                clickHandler: this.cliTaskHelperClicked,
                img: getPluginImgPath( 'cond_line_and' )
            } );

            x -= 2 * r;
            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'cleTaskHelper',
                clickHandler: this.cleTaskHelperClicked,
                img: getPluginImgPath( 'cond_line_xor' )
            } );

            x -= 2 * r;
            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'blTaskHelper',
                clickHandler: this.blTaskHelperClicked,
                img: getPluginImgPath( 'basic_line' )
            } );

            x -= 2 * r;
            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'bleTaskHelper',
                clickHandler: this.bleTaskHelperClicked,
                img: getPluginImgPath( 'stop_small' )
            } );

            if ( AV ) {
                y -= 2 * r;
            } else {
                x -= 2 * r;
            }

            this.helper( paper, {
                x: x,
                y: y,
                r: r,
                connector: connector,
                setType: 'blsTaskHelper',
                clickHandler: this.blsTaskHelperClicked,
                img: getPluginImgPath( 'start_small' )
            } );
        }
    },
    boxHelpers: function( paper, set ) {
        var connector = this.getConnectorFromSet( set );
        var conditionType = connector.data( 'conditionType' );
        var box = connector.getBBox();
        var r = this.helperRadius;
        var x = box.x2 + r;
        var y = box.y + r;

        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'claBoxHelper',
            clickHandler: this.claBoxHelperClicked,
            img: getPluginImgPath( 'activity_small' ),
            conditionType: conditionType
        } );

        y += 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'clrBoxHelper',
            clickHandler: this.clrBoxHelperClicked,
            img: getPluginImgPath( 'route_small' ),
            conditionType: conditionType
        } );

        y += 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'cltBoxHelper',
            clickHandler: this.cltBoxHelperClicked,
            img: getPluginImgPath( 'tool_small' ),
            conditionType: conditionType
        } );

        x -= 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: 'clsubBoxHelper',
            clickHandler: this.clsubBoxHelperClicked,
            img: getPluginImgPath( 'subflow_small' ),
            conditionType: conditionType
        } );

        x -= 2 * r;
        this.helper( paper, {
            x: x,
            y: y,
            r: r,
            connector: connector,
            setType: conditionType == 'XOR' ? 'cleOnlyBoxHelper' : 'cliOnlyBoxHelper',
            clickHandler: this.clOnlyBoxHelperClicked,
            img: getPluginImgPath( 'XOR' ? 'cond_line_xor' : 'cond_line_and' ),
            conditionType: conditionType
        } );
    },
    helper: function( paper, config ) {
        var connector = config.connector;
        var setType = config.setType;
        var imgSize = 16;
        var x = config.x;
        var y = config.y;
        var set = paper.set();
        var connectFrom = connector.data( 'connectFrom' ) ? connector.data( 'connectFrom' ) : connector;
        var direction = connector.data( 'direction' ) ? connector.data( 'direction' ) : '';

        var circle = paper.circle( x, y, config.r );
        circle = circle.attr( {
            fill: '#FFFFC0',
            opacity: 0.5
        } );
        set.push( circle );

        var img = paper.image( config.img, x - imgSize / 2, y - imgSize / 2, imgSize, imgSize );
        img = img.attr( {
            opacity: 0.5
        } );
        set.push( img );

        circle.data( 'wholeSet', set );
        paper.helperTrash.push( set );
        set = set.data( 'setType', setType ).data( 'connectFrom', connectFrom ).data( 'connector', connector ).data( 'direction', direction ).data(
                        'conditionType', config.conditionType );
        set.click( config.clickHandler );
        set.hover( this.hoverHelperIn, this.hoverHelperOut, circle, circle );
    },
    blrTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_route_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    clrBoxHelperClicked: function( e ) {
        var paper = this.paper;
        paper.bpmn.clBoxHelperClicked( paper, this );
        var button = Ext.getCmp( 'draw_conditional_line_with_route_button' );
        button.handler.call( button, e );
    },
    blaTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_activity_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    claBoxHelperClicked: function( e ) {
        var paper = this.paper;
        paper.bpmn.clBoxHelperClicked( paper, this );
        var button = Ext.getCmp( 'draw_conditional_line_with_activity_button' );
        button.handler.call( button, e );
    },
    bltTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_tool_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    cltBoxHelperClicked: function( e ) {
        var paper = this.paper;
        paper.bpmn.clBoxHelperClicked( paper, this );
        var button = Ext.getCmp( 'draw_conditional_line_with_tool_button' );
        button.handler.call( button, e );
    },
    blsubTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_subflow_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    clsubBoxHelperClicked: function( e ) {
        var paper = this.paper;
        paper.bpmn.clBoxHelperClicked( paper, this );
        var button = Ext.getCmp( 'draw_conditional_line_with_subflow_button' );
        button.handler.call( button, e );
    },
    blTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = this.data( 'connectFrom' );
            processPanel.connectingStarted = true;
            var button = Ext.getCmp( 'draw_basic_line_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    cleTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'XOR', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            processPanel.conditionalLineStep = 1;
            processPanel.connectingStarted = true;
            var button = Ext.getCmp( 'draw_conditional_xor_line_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    cliTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'AND', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            processPanel.conditionalLineStep = 1;
            processPanel.connectingStarted = true;
            var button = Ext.getCmp( 'draw_conditional_and_line_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    olTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'OTHERWISE', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = this.data( 'connectFrom' );
            processPanel.connectingStarted = true;
            var button = Ext.getCmp( 'draw_otherwise_line_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    elTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'EXCEPTION', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            processPanel.connectingStarted = true;
            var button = Ext.getCmp( 'draw_deadline_line_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    blsTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );
        var startSimulEl = {
            data: function( arg ) {
                return 'start';
            }
        };

        if ( this.paper.bpmn.isConnEndingAvailable( 'BASIC', connectFrom, startSimulEl, processPanel.processDefId ) ) {
            processPanel.connectTo = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_start_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    bleTaskHelperClicked: function( e ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var connectFrom = this.data( 'connectFrom' );

        if ( this.paper.bpmn.isConnBeginningAvailable( 'BASIC', connectFrom, processPanel.processDefId ) ) {
            processPanel.connectFrom = connectFrom;
            var button = Ext.getCmp( 'draw_basic_line_with_stop_button' );
            button.handler.call( button, e );
        }

        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    clOnlyBoxHelperClicked: function( e ) {
        var paper = this.paper;
        var conditionType = this.data( 'conditionType' );
        paper.bpmn.clBoxHelperClicked( paper, this );
        var buttonId = conditionType == 'XOR' ? 'draw_conditional_xor_line_button' : 'draw_conditional_and_line_button';
        var button = Ext.getCmp( buttonId );
        button.handler.call( button, e );
    },
    clBoxHelperClicked: function( paper, el ) {
        var box = el.data( 'connector' );
        paper.bpmn.conditionBox = box;
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        processPanel.connectFrom = el.data( 'connectFrom' );
        processPanel.condLineType = el.data( 'conditionType' );
        processPanel.conditionalLineStep = 3;
        paper.bpmn.eraseTrash( paper.helperTrash );
    },
    hoverHelperIn: function( e ) {
        var paper = this.paper;
        var set = this.data( 'wholeSet' );
        var setType = this.data( 'setType' );

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];

            if ( el == 'circle' ) {
                this.attr( {
                    stroke: '#FF0000'
                } );
            }

            el.attr( {
                opacity: 1.0
            } );
        }

        var showTooltips = Ext.getCmp( 'main_panel' ).getShowTooltips();
        if ( !showTooltips || paper.bpmn.hoverBlocked ) {
            return;
        }

        var img = '';
        var text = '';
        if ( setType == 'blaTaskHelper' || setType == 'claBoxHelper' ) {
            img = getPluginImgPath( 'activity_small' );
            text = getTranslation( 'Wstaw zadanie' );
        } else if ( setType == 'bltTaskHelper' || setType == 'cltBoxHelper' ) {
            img = getPluginImgPath( 'tool_small' );
            text = getTranslation( 'Wstaw narzędzie systemowe' );
        } else if ( setType == 'blrTaskHelper' || setType == 'clrBoxHelper' ) {
            img = getPluginImgPath( 'route_small' );
            text = getTranslation( 'Wstaw przekierowanie' );
        } else if ( setType == 'blsubTaskHelper' || setType == 'clsubBoxHelper' ) {
            img = getPluginImgPath( 'subflow_small' );
            text = getTranslation( 'Wstaw podproces' );
        } else if ( setType == 'blTaskHelper' ) {
            img = getPluginImgPath( 'basic_line' );
            text = getTranslation( 'Wstaw połączenie bezwarunkowe' );
        } else if ( setType == 'cleTaskHelper' || setType == 'cleOnlyBoxHelper' ) {
            img = getPluginImgPath( 'cond_line_xor' );
            text = getTranslation( 'Wstaw połączenie warunkowe wykluczające' );
        } else if ( setType == 'cliTaskHelper' || setType == 'cliOnlyBoxHelper' ) {
            img = getPluginImgPath( 'cond_line_and' );
            text = getTranslation( 'Wstaw połączenie równoległe' );
        } else if ( setType == 'olTaskHelper' ) {
            img = getPluginImgPath( 'otherwise' );
            text = getTranslation( 'Wstaw połączenie "w przeciwnym razie"' );
        } else if ( setType == 'elTaskHelper' ) {
            img = getPluginImgPath( 'deadline' );
            text = getTranslation( 'Wstaw wyjątek' );
        } else if ( setType == 'blsTaskHelper' ) {
            img = getPluginImgPath( 'start_small' );
            text = getTranslation( 'Wstaw rozpoczęcie procesu' );
        } else if ( setType == 'bleTaskHelper' ) {
            img = getPluginImgPath( 'stop_small' );
            text = getTranslation( 'Wstaw zakończenie procesu' );
        }

        var tooltipText = '<table border="0"><tr><td width="25"><img src="' + img + '"></td>';
        tooltipText += '<td><b>' + text + '</b></td></tr></table>';

        var helperTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        helperTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( helperTooltip );
    },
    hoverHelperOut: function( e ) {
        var paper = this.paper;
        var set = this.data( 'wholeSet' );

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];

            if ( el == 'circle' ) {
                this.attr( {
                    stroke: '#000000'
                } );
            }

            el.attr( {
                opacity: 0.5
            } );
        }

        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    basicLineWithRoute: function( paper, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.basicLineWithTask( paper, connectFrom, xPos, yPos, tooltip, activityNo, 'basicLineWithRoute' );
    },
    conditionalLineWithRoute: function( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.conditionalLineWithTask( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo,
                        'conditionalLineWithRoute' );
    },
    basicLineWithActivity: function( paper, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.basicLineWithTask( paper, connectFrom, xPos, yPos, tooltip, activityNo, 'basicLineWithActivity' );
    },
    conditionalLineWithActivity: function( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.conditionalLineWithTask( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo,
                        'conditionalLineWithActivity' );
    },
    basicLineWithTool: function( paper, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.basicLineWithTask( paper, connectFrom, xPos, yPos, tooltip, activityNo, 'basicLineWithTool' );
    },
    conditionalLineWithTool: function( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.conditionalLineWithTask( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo,
                        'conditionalLineWithTool' );
    },
    basicLineWithSubflow: function( paper, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.basicLineWithTask( paper, connectFrom, xPos, yPos, tooltip, activityNo, 'basicLineWithSubflow' );
    },
    conditionalLineWithSubflow: function( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo ) {
        return this.conditionalLineWithTask( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo,
                        'conditionalLineWithSubflow' );
    },
    basicLineWithTask: function( paper, connectFrom, xPos, yPos, tooltip, activityNo, setType ) {
        var set = paper.set();
        var taskSet = null;
        switch ( setType ) {
            case 'basicLineWithRoute':
                taskSet = this.route( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'route_small' ), false );
                }
                break;
            case 'basicLineWithActivity':
                taskSet = this.activity( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'activity_small' ), false );
                }
                break;
            case 'basicLineWithTool':
                taskSet = this.tool( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'tool_small' ), false );
                }
                break;
            case 'basicLineWithSubflow':
                taskSet = this.subflow( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'subflow_small' ), false );
                }
                break;
            default:
                break;
        }
        var connectTo = this.getConnectorFromSet( taskSet );

        for ( var i = 0; i < taskSet.length; i++ ) {
            set.push( taskSet[i] );
        }

        if ( connectTo ) {
            var basicLineSet = this.basicLine( paper, connectFrom, connectTo, xPos + this.activityWidth / 2, yPos + this.activityHeight / 2, false,
                            tooltip, true );

            for ( var i = 0; i < basicLineSet.length; i++ ) {
                set.push( basicLineSet[i] );
            }

            if ( !tooltip ) {
                Ext.getCmp( 'paper_panel' ).getActiveTab().connectFrom = connectTo;
            }
        }

        if ( tooltip ) {
            set.setType = setType + 'Tooltip';
        } else {
            set.setType = setType;
        }

        return set;
    },
    basicLineWithStart: function( paper, connectTo, xPos, yPos, tooltip ) {
        var set = paper.set();
        var startSet = this.start( paper, xPos, yPos, tooltip );
        var connectFrom = this.getConnectorFromSet( startSet );

        for ( var i = 0; i < startSet.length; i++ ) {
            set.push( startSet[i] );
        }

        if ( connectFrom ) {
            var r = this.startStopDiameter / 2;
            var o = this.cornerOffset;
            var toBox = connectTo.getBBox();
            var x = 0;
            if ( xPos + r > toBox.x + o && xPos + r < toBox.x2 - o ) {
                x = xPos + this.startStopDiameter / 2;
            } else {
                x = toBox.x + toBox.width / 2;
            }
            var y = 0;
            if ( yPos + r > toBox.y + o && yPos + r < toBox.y2 - o ) {
                y = yPos + this.startStopDiameter / 2;
            } else {
                y = toBox.y + toBox.height / 2;
            }
            var basicLineSet = this.basicLine( paper, connectFrom, connectTo, x, y, false, tooltip, true );

            for ( var i = 0; i < basicLineSet.length; i++ ) {
                set.push( basicLineSet[i] );
            }
        }

        if ( tooltip ) {
            set.setType = 'basicLineWithStartTooltip';
        } else {
            set.setType = 'basicLineWithStart';
        }

        return set;
    },
    basicLineWithStop: function( paper, connectFrom, xPos, yPos, tooltip ) {
        var set = paper.set();
        var stopSet = this.stop( paper, xPos, yPos, tooltip );
        var connectTo = this.getConnectorFromSet( stopSet );

        for ( var i = 0; i < stopSet.length; i++ ) {
            set.push( stopSet[i] );
        }

        if ( connectTo ) {
            var basicLineSet = this.basicLine( paper, connectFrom, connectTo, xPos + this.startStopDiameter / 2, yPos + this.startStopDiameter / 2,
                            false, tooltip, true );

            for ( var i = 0; i < basicLineSet.length; i++ ) {
                set.push( basicLineSet[i] );
            }
        }

        if ( tooltip ) {
            set.setType = 'basicLineWithStopTooltip';
        } else {
            set.setType = 'basicLineWithStop';
        }

        return set;
    },
    conditionalLineWithTask: function( paper, type, conditionalLineStep, connectFrom, xPos, yPos, tooltip, activityNo, setType ) {
        var set = paper.set();
        var taskSet = null;
        switch ( setType ) {
            case 'conditionalLineWithRoute':
                taskSet = this.route( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'route_small' ), true );
                }
                break;
            case 'conditionalLineWithActivity':
                taskSet = this.activity( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'activity_small' ), true );
                }
                break;
            case 'conditionalLineWithTool':
                taskSet = this.tool( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'tool_small' ), true );
                }
                break;
            case 'conditionalLineWithSubflow':
                taskSet = this.subflow( paper, xPos, yPos, tooltip, activityNo );

                if ( !tooltip ) {
                    initAddActivity( taskSet, xPos, yPos, getPluginImgPath( 'subflow_small' ), true );
                }
                break;
            default:
                break;
        }
        var connectTo = this.getConnectorFromSet( taskSet );

        for ( var i = 0; i < taskSet.length; i++ ) {
            set.push( taskSet[i] );
        }

        if ( connectTo ) {
            var condLineSet = this.conditionalLine( paper, type, conditionalLineStep, connectFrom, connectTo, xPos + this.activityWidth / 2, yPos
                            + this.activityHeight / 2, false, true );

            for ( var i = 0; i < condLineSet.length; i++ ) {
                set.push( condLineSet[i] );
            }
        }

        if ( tooltip ) {
            set.setType = setType + 'Tooltip';
        } else {
            set.setType = setType;
        }

        return set;
    },
    changeConditionalLinesTypeForActivity: function( paper, activityDefId, conditionType ) {
        var set = this.findMapObjectElements( paper, 'activityDefId', activityDefId );
        var el = set[0];

        if ( !Ext.isEmpty( el ) && !Ext.isEmpty( el.outCondConnections ) ) {
            var connections = el.outCondConnections;

            for ( var i = 0; i < connections.length; i++ ) {
                var connection = connections[i];
                var box = connection.box;
                this.changeConditionalLineType( box, conditionType );
            }
        }
    },
    changeConditionalLineType: function( el, conditionType ) {
        var set = el.data( 'wholeSet' );

        var animDuration = Ext.getCmp( 'main_panel' ).getAnimationsOn() ? 300 : 1;
        set.forEach( function( el ) {
            if ( el.data( 'conditionSign' ) ) {
                var tr = conditionType == 'XOR' ? 'R45' : '';
                el.data( 'tr', tr );
                el.animate( {
                    transform: tr
                }, animDuration );
            }
        } );

        var connector = el.data( 'connectedWith' );
        var transitionId = el.data( 'transitionId' );
        connector.updateCondConnectionType( transitionId, conditionType );
    },
    getLastRoleField: function( paper, xPos, yPos, excludeRole, excludeSystem ) {
        var lastRole = null;
        var lastRolePos = 1;

        if ( xPos < this.roleWidth + 2 ) {
            return lastRole;
        }

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( ( setType == 'roleField' && !excludeRole ) || ( setType == 'systemField' && !excludeSystem ) ) {
                var box = Raphael.pathBBox( el.attr( 'path' ) );
                var roleStartPos = box.y;
                var pos = roleStartPos + box.height;

                if ( pos > lastRolePos && yPos > roleStartPos ) {
                    lastRolePos = pos;
                    lastRole = el;
                }
            }
        } );

        return lastRole;
    },
    setRoleSize: function( paper, fieldName, roleId, width, height ) {
        paper.forEach( function( el ) {
            if ( el.data( 'setType' ) == fieldName && el.data( 'roleId' ) == roleId ) {
                var paper = el.paper;
                var box = Raphael.pathBBox( el.attr( 'path' ) );
                var diff = height - box.height;
                paper.bpmn.executeSpreadRoleVerticaly( paper, el, diff, paper.set() );
                diff = width - box.width;
                paper.bpmn.executeSpreadRoleHorizontaly( paper, el, diff, paper.set() );
                return false;
            }
        } );
    },
    spreadRole: function( paper, xPos, yPos, el, roleField, set ) {
        var height = el.attr( 'height' );
        var width = el.attr( 'width' );
        var box = Raphael.pathBBox( roleField.attr( 'path' ) );
        var diff = yPos + height + 10 - ( box.y + box.height );
        this.spreadRoleVerticaly( paper, roleField, diff, set );
        diff = xPos + width + 10 - ( box.x + box.width );
        this.spreadRoleHorizontaly( paper, roleField, diff );
        this.handlePaperSize( paper );
    },
    spreadRoleVerticaly: function( paper, roleField, diff, set ) {
        if ( diff <= 0 ) {
            return;
        }

        this.executeSpreadRoleVerticaly( paper, roleField, diff, set );
    },
    executeSpreadRoleVerticaly: function( paper, roleField, diff, set ) {
        if ( diff == 0 ) {
            return;
        }

        paper.lastRoleYPos += diff;
        var roleFieldBox = Raphael.pathBBox( roleField.attr( 'path' ) );
        var currentHeight = roleFieldBox.height;
        var newHeight = currentHeight + diff;
        var roleId = roleField.data( 'roleId' );
        var roleEls = this.findRoleElements( paper, roleId );
        var headerTxt = null;
        var headerField = null;

        var limit = roleFieldBox.y + currentHeight - 1;
        this.moveElsOnY( paper, limit, diff, set );

        var cr = this.participantCornerRadius;
        roleEls.forEach( function( el ) {
            if ( el.type == 'path' ) {
                var setType = el.data( 'setType' );
                if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
                    headerField = el;
                    el.attr( {
                        path: paper.bpmn.roundedRectanglePath( 1, roleFieldBox.y, paper.bpmn.roleWidth, newHeight, cr, 0, 0, cr )
                    } );
                } else if ( setType == 'roleField' || setType == 'systemField' ) {
                    el.attr( {
                        path: paper.bpmn.roundedRectanglePath( 1 + paper.bpmn.roleWidth, roleFieldBox.y, roleFieldBox.width, newHeight, 0, cr, cr, 0 )
                    } );
                }
            } else if ( el.type == 'image' ) {
                var prevTr = el.data( 'tr' );
                el.transform( '' );
                el.attr( {
                    y: roleFieldBox.y + newHeight * 0.8
                } );
                if ( prevTr ) {
                    el.transform( prevTr );
                }
            } else if ( el.type == 'text' ) {
                var prevTr = el.data( 'tr' );
                el.transform( '' );
                el.attr( {
                    y: el.attr( 'y' ) + diff / 2
                } );
                if ( prevTr ) {
                    el.transform( prevTr );
                }
                headerTxt = el;
            }
        } );

        this.updateRoleName( headerField, headerTxt, roleId, headerTxt.data( 'roleName' ) );
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        processNode.updateRoleHeight( roleId, parseInt( newHeight ) );
    },
    moveElsOnY: function( paper, limit, diff, set ) {
        set.data( 'movingBlocked', true );
        var translation = '...T0,' + diff;
        var connectors = new Array();
        var boxConnectors = new Array();

        paper.forEach( function( el ) {
            if ( el.getBBox().y >= limit && !el.data( 'movingBlocked' ) ) {
                if ( el.type != 'path' ) {
                    var prevTr = el.data( 'tr' );
                    el.transform( '' );
                    el.attr( {
                        y: el.attr( 'y' ) + diff
                    } );
                    if ( prevTr ) {
                        el.transform( prevTr );
                    }
                    if ( el.data( 'connector' ) && el.hasInitializedConnections() ) {
                        connectors.push( el );
                    }
                } else if ( el.data( 'isBox' ) && !el.data( 'isBoxSign' ) ) {
                    var boxSigns = el.data( 'boxSigns' );

                    if ( el.getBBox().y >= limit && Ext.isArray( boxSigns ) ) {
                      Ext.each( boxSigns, function( boxSign, index, allBoxSigns ) {
                        paper.bpmn.moveBoxElOnY( boxSign, translation );
                      } );
                    }

                    paper.bpmn.moveBoxElOnY( el, translation );

                    if ( el.data( 'connector' ) ) {
                      boxConnectors.push( el );
                    }
                } else if ( el.data( 'roundedRectangle' ) ) {
                    el.attr( {
                        path: Raphael.transformPath( el.attr( 'path' ), translation )
                    } );
                }
            }
        } );

        for ( var i = 0; i < connectors.length; i++ ) {
            connectors[i].moveConnectionsOnRoleAction( diff, limit );
        }

        for ( var i = 0; i < boxConnectors.length; i++ ) {
            var boxEl = boxConnectors[i];
            var outConnId = boxEl.data( 'transitionId' );
            if ( !paper.bpmn.movedTransitions[outConnId] ) {
                boxEl.data( 'connectFrom' ).moveConnectionsOnRoleAction( diff, limit );
            }
        }

        this.movedTransitions = new Array();
        set.removeData( 'movingBlocked' );
    },
    moveBoxElOnY: function( el, translation ) {
      var prevTr = el.data( 'tr' );
      el.transform( '' );
      el.attr( {
        path: clearPath( Raphael.transformPath( el.attr( 'path' ), translation ), false )
      } );
      if ( prevTr ) {
        el.transform( prevTr );
      }
    },
    spreadRoleHorizontaly: function( paper, roleField, diff ) {
        if ( diff <= 0 ) {
            return;
        }

        this.executeSpreadRoleHorizontaly( paper, roleField, diff );
    },
    executeSpreadRoleHorizontaly: function( paper, roleField, diff ) {
        if ( diff == 0 ) {
            return;
        }

        paper.lastRoleXPos += diff;
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
        var cr = this.participantCornerRadius;

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );
            if ( setType == 'roleField' || setType == 'systemField' ) {
                var roleId = el.data( 'roleId' );
                var pathAttr = el.attr( 'path' );
                var box = Raphael.pathBBox( pathAttr );
                var newWidth = box.width + diff;
                el.attr( {
                    path: paper.bpmn.roundedRectanglePath( 1 + paper.bpmn.roleWidth, box.y, newWidth, box.height, 0, cr, cr, 0 )
                } );
                processNode.updateRoleWidth( roleId, parseInt( newWidth ) );
            }
        } );
    },
    findRoleElements: function( paper, roleId ) {
        var set = paper.set();

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );
            if ( el.data( 'roleId' ) == roleId
                            && ( setType == 'roleHeader' || setType == 'roleField' || setType == 'systemHeader' || setType == 'systemField' ) ) {
                set.push( el );
            }
        } );

        return set;
    },
    getRoleElementsLimits: function( paper, roleField ) {
        var offset = 10;
        var roleBox = Raphael.pathBBox( roleField.attr( 'path' ) );
        var roleYStart = roleBox.y;
        var roleYStop = roleBox.y2;
        var xLimit = this.minRoleWidth;
        var yLimit = roleYStart;

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );
            var resizeType = el.data( 'resizeType' );

            if ( !( setType == 'roleHeader' || setType == 'roleField' || setType == 'systemHeader' || setType == 'systemField'
                            || setType == 'resizeRect' || setType == 'grid' || resizeType ) ) {
                var newValue = -1;
                var elBox = null;

                if ( el.type == 'path' ) {
                    elBox = Raphael.pathBBox( el.attr( 'path' ) );
                } else {
                    elBox = el.getBBox();
                }

                var elY = elBox.y;
                var elY2 = elBox.y2;
                var elX2 = elBox.x2;

                if ( elX2 > xLimit ) {
                    xLimit = elX2;
                }

                if ( elY > roleYStart && elY < roleYStop ) {
                    newValue = elY;
                }

                if ( elY2 > roleYStart && elY2 < roleYStop ) {
                    newValue = elY2;
                }

                if ( newValue != -1 && newValue > yLimit ) {
                    yLimit = newValue;
                }
            }
        } );

        xLimit += offset;
        if ( yLimit - roleYStart > this.roleHeight ) {
            yLimit += offset;
        } else {
            yLimit = roleYStart + this.roleHeight;
        }

        return {
            x: xLimit,
            y: yLimit
        };
    },
    updateRole: function( paper, oldRoleId, newRoleId, newRoleName ) {
        var set = this.findMapObjectElements( paper, 'roleId', oldRoleId );
        var headerTxt = null;
        var headerField = null;

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];
            var setType = el.data( 'setType' );

            if ( ( setType == 'roleHeader' || setType == 'systemHeader' ) ) {
                if ( el.type == 'text' ) {
                    headerTxt = el;
                } else if ( el.type == 'path' ) {
                    headerField = el;
                }
            }

            el.data( 'roleId', newRoleId );
            el.data( 'roleName', newRoleName );
        }

        this.updateRoleName( headerField, headerTxt, newRoleId, newRoleName );
    },
    updateRoleName: function( headerField, headerTxt, roleId, roleName ) {
        var box = Raphael.pathBBox( headerField.attr( 'path' ) );
        headerTxt.attr( {
            text: this.prepareRoleName( box.height * 0.6, roleId, roleName )
        } );
    },
    prepareRoleName: function( h, roleId, roleName ) {
      var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
      var packageId = packageNode.attributes.packageId;
      var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
      var roleNameTranslation = getXpdlProcessParticipantNameTranslation( packageId, processDefId, roleId, roleName );

      return this.prepareName( roleNameTranslation, Math.floor( h / 4.8 ), 1 );
    },
    prepareName: function( name, limit, entersLimit ) {
        if ( name.length <= limit ) {
            return name;
        }

        var thisLineLength = 0;
        var spacesSplit = name.split( ' ' );
        var enters = 0;
        var br = false;
        name = '';

        for ( var i = 0; i < spacesSplit.length; i++ ) {
            if ( br ) {
                if ( enters < entersLimit ) {
                    name += '\n';
                    enters++;
                    thisLineLength = 0;
                } else {
                    name = name.substring( 0, name.length - 1 );
                    name += '...';
                    break;
                }
            }

            br = false;

            if ( spacesSplit[i].length > limit ) {
            	if ( thisLineLength == 0 ) {
            		name += spacesSplit[i].substring( 0, limit ) + '...';
                    br = true;
            	} else {
            		i--;
                    br = true;
            	}
            } else {
                if ( thisLineLength + spacesSplit[i].length <= limit ) {
                    name += spacesSplit[i] + ' ';
                    thisLineLength += spacesSplit[i].length + 1;
                } else {
                    i--;
                    br = true;
                }
            }
        }

        return name;
    },
    changeRoleType: function( paper, roleId, newRoleType ) {
        var headerType = '';
        var fieldType = '';
        var img = '';
        var headerFill = '';
        var taskTypesToRemove = [];

        switch ( newRoleType ) {
            case 'ROLE':
                headerType = 'roleHeader';
                fieldType = 'roleField';
                img = getPluginImgPath( 'role' );
                headerFill = '#FFFFFF';
                taskTypesToRemove['tool'] = true;
                break;
            case 'SYSTEM':
                headerType = 'systemHeader';
                fieldType = 'systemField';
                img = getPluginImgPath( 'system' );
                headerFill = '0-#DADADA-#E2E2E2:50-#EAEAEA';
                taskTypesToRemove['activity'] = true;
                taskTypesToRemove['subflow'] = true;
                break;
            case 'RESOURCE':
                headerType = 'roleHeader';
                fieldType = 'roleField';
                img = getPluginImgPath( 'buffer' );
                headerFill = '0-#DADADA-#E2E2E2:50-#EAEAEA';
                taskTypesToRemove['tool'] = true;
                break;
            default:
                return;
                break;
        }

        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var packagePanel = Ext.getCmp( 'package_panel' );
        var set = this.findMapObjectElements( paper, 'roleId', roleId );

        for ( var i = 0; i < set.length; i++ ) {
            var el = set[i];
            var setType = el.data( 'setType' );

            if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
                if ( el.type == 'image' ) {
                    el.attr( {
                        src: img
                    } );
                } else if ( el.type == 'path' ) {
                    el.attr( {
                        fill: headerFill
                    } );
                }

                el.data( 'setType', headerType );
            } else if ( setType == 'roleField' || setType == 'systemField' ) {
                el.data( 'setType', fieldType );
            } else if ( el.data( 'connector' ) && taskTypesToRemove[setType] ) {
                var activityDefId = el.data( 'activityDefId' );
                var activityNode = packagePanel.findActivity( processDefId, activityDefId );
                executeDeleteActivity( activityNode );
            }
        }

        set.data( 'roleType', newRoleType );
    },
    removeRole: function( paper, roleId, processNode, firstRoleRemoved, previousRoleId ) {
        var removedRoleSet = this.findMapObjectElements( paper, 'roleId', roleId );
        var removedRoleHeight = 0;

        removedRoleSet.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( ( setType == 'roleHeader' || setType == 'systemHeader' ) && el.type == 'path' ) {
                var box = Raphael.pathBBox( el.attr( 'path' ) );
                removedRoleHeight = box.height;
            } else if ( el.data( 'connector' ) ) {
                el.removeAllConnections();

                if ( setType == 'start' ) {
                    removeProcessStart( el.data( 'terminationId' ) );
                } else if ( setType == 'stop' ) {
                    removeProcessStop( el.data( 'terminationId' ) );
                } else {
                    processNode.removeActivityById( el.data( 'activityDefId' ) );
                }
            }

            el.remove();
        } );

        var previousRoleSet = null;
        var newHeight = 0;
        var headerTxt = null;
        var headerField = null;
        var roleFieldBox = null;

        if ( !Ext.isEmpty( previousRoleId ) ) {
            previousRoleSet = this.findRoleElements( paper, previousRoleId );

            previousRoleSet.forEach( function( el ) {
                var setType = el.data( 'setType' );

                if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
                    roleFieldBox = Raphael.pathBBox( el.attr( 'path' ) );
                    newHeight = roleFieldBox.height + removedRoleHeight;
                    var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
                    var processNode = Ext.getCmp( 'package_panel' ).findProcess( processDefId );
                    processNode.updateRoleHeight( previousRoleId, parseInt( newHeight ) );
                    return false;
                }
            } );
        }

        if ( newHeight > 0 ) {
            var cr = this.participantCornerRadius;
            previousRoleSet.forEach( function( el ) {
                if ( el.type == 'path' ) {
                    if ( firstRoleRemoved ) {
                        var translation = '...T0,-' + removedRoleHeight;
                        el.attr( {
                            path: Raphael.transformPath( el.attr( 'path' ), translation )
                        } );
                    }

                    var box = Raphael.pathBBox( el.attr( 'path' ) );
                    var setType = el.data( 'setType' );
                    if ( setType == 'roleHeader' || setType == 'systemHeader' ) {
                        headerField = el;
                        el.attr( {
                            path: paper.bpmn.roundedRectanglePath( 1, box.y, paper.bpmn.roleWidth, newHeight, cr, 0, 0, cr )
                        } );
                    } else if ( setType == 'roleField' || setType == 'systemField' ) {
                        el.attr( {
                            path: paper.bpmn.roundedRectanglePath( 1 + paper.bpmn.roleWidth, box.y, box.width, newHeight, 0, cr, cr, 0 )
                        } );
                    }
                } else if ( el.type == 'image' ) {
                    var prevTr = el.data( 'tr' );
                    el.transform( '' );
                    el.attr( {
                        y: firstRoleRemoved ? newHeight * 0.8 : roleFieldBox.y + newHeight * 0.8
                    } );
                    if ( prevTr ) {
                        el.transform( prevTr );
                    }
                } else if ( el.type == 'text' ) {
                    var prevTr = el.data( 'tr' );
                    el.transform( '' );
                    el.attr( {
                        y: firstRoleRemoved ? newHeight / 2 : el.attr( 'y' ) + removedRoleHeight / 2
                    } );
                    if ( prevTr ) {
                        el.transform( prevTr );
                    }
                    headerTxt = el;
                }
            } );

            this.updateRoleName( headerField, headerTxt, roleId, headerTxt.data( 'roleName' ) );
            processNode.updateRoleHeight( roleId, parseInt( newHeight ) );
        } else {
            paper.lastRoleYPos = 1;
        }

        this.movedTransitions = new Array();
        this.handlePaperSize( paper );
    },
    searchForLines: function( paper, x, y ) {
    	var lines = new Array();
    	var searchArray = [ { x: 0, y: -1 }, { x: 1, y: 0 }, { x: 0, y: 1 }, { x: -1, y: 0 } ];
    	var found = new Object();
        
        for ( var i = 1; i < this.searchLinePrecision; i++ ) {
        	for ( var j = 0; j< searchArray.length; j++ ) {
        		var diff = searchArray[j];
        		var xOffset = i * diff.x;
        		var yOffset = i * diff.y;
        		var currentX = x + xOffset;
        		var currentY = y + yOffset;
        		var elements = getElementsFromPoint( currentX, currentY );
            	
                if ( !Ext.isEmpty( elements ) ) {
                	for ( var k = 0; k < elements.length; k++ ) {
                		var element = elements[k];
                		
                		if ( !Ext.isEmpty( element.raphaelid ) ) {
                			var el = paper.getById( element.raphaelid );
                    		
                        	if ( !Ext.isEmpty( el ) ) {
                        		var elSetType = el.data( 'setType' );
                        		
                        		switch( elSetType ) {
                            		case 'basicLine':
                            		case 'conditionalLine':
                            		case 'conditionalLineBox':
                            		case 'otherwiseLine':
                            		case 'deadlineLine':
                            			var connId = el.data( 'transitionId' );
                            			
                            			if ( !found[connId] ) {
                            				lines.push( {
                                				el: el,
                                				x: currentX,
                                				y: currentY,
                                				xOffset: xOffset,
                                				yOffset: yOffset
                                			} );
                            				
                            				found[connId] = true;
                            			}
                        			default:
                        				break;
                        		}
                        	}
                		}
                	}
                }
        	}
        }
        
        lines.sort( this.sortLines );
        
        return lines;
    },
    searchForLineReshaper: function( paper, x, y ) {
      var reshaper = new Array();
      var searchArray = [ { x: 0, y: -1 }, { x: 1, y: 0 }, { x: 0, y: 1 }, { x: -1, y: 0 } ];
      var found = new Object();

      for ( var i = 1; i < this.searchLinePrecision; i++ ) {
        for ( var j = 0; j< searchArray.length; j++ ) {
          var diff = searchArray[j];
          var xOffset = i * diff.x;
          var yOffset = i * diff.y;
          var currentX = x + xOffset;
          var currentY = y + yOffset;
          var elements = getElementsFromPoint( currentX, currentY );

          if ( !Ext.isEmpty( elements ) ) {
            for ( var k = 0; k < elements.length; k++ ) {
              var element = elements[k];

              if ( !Ext.isEmpty( element.raphaelid ) ) {
                var el = paper.getById( element.raphaelid );

                if ( !Ext.isEmpty( el ) ) {
                  var elSetType = el.data( 'setType' );

                  switch( elSetType ) {
                    case 'lineReshaper':
                      return {
                        el: el,
                        x: currentX,
                        y: currentY,
                        xOffset: xOffset,
                        yOffset: yOffset
                      };
                    default:
                      break;
                  }
                }
              }
            }
          }
        }
      }

      return null;
    },
    sortLines: function( line1, line2 ) {
    	var lineEl1 = line1.el;
		var connectFrom1 = lineEl1.data( 'connectFrom' );
		var fromActivityName1 = connectFrom1.data( 'activityName' );
		var lineEl2 = line2.el;
		var connectFrom2 = lineEl2.data( 'connectFrom' );
		var fromActivityName2 = connectFrom2.data( 'activityName' );
		
		if ( fromActivityName1 === fromActivityName2 ) {
			var connectTo1 = lineEl1.data( 'connectedWith' );
			var toActivityName1 = connectTo1.data( 'activityName' );
			var connectTo2 = lineEl2.data( 'connectedWith' );
			var toActivityName2 = connectTo2.data( 'activityName' );
			
			return compareStringsWithNumbers( toActivityName1, toActivityName2 );
		} else {
			return compareStringsWithNumbers( fromActivityName1, fromActivityName2 );
		}
    },
    drawTerminations: function( paper ) {
        var autoOffset = this.autoOffset;
        var ssR = this.startStopDiameter / 2;
        var roleWidth = this.roleWidth;

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( el.data( 'connector' ) && !( setType == 'start' || setType == 'stop' || setType == 'conditionalLineBox' ) ) {
                var box = el.getBBox();
                var outConns = el.outConnections;
                var outCondConns = el.outCondConnections;
                var outOtherwises = el.outOtherwises;
                var outExc = el.outExceptions;

                if ( outConns.length == 0 && outCondConns.length == 0 && outOtherwises.length == 0 && outExc.length == 0 ) {
                    paper.bpmn.basicLineWithStop( paper, el, box.x2 + autoOffset, box.y + box.height / 2 - ssR, false );
                }

                var inConns = el.inConnections;
                var inCondConns = el.inCondConnections;
                var inOtherwises = el.inOtherwises;
                var inExc = el.inExceptions;

                if ( inConns.length == 0 && inCondConns.length == 0 && inOtherwises.length == 0 && inExc.length == 0 ) {
                    var xPos = box.x - autoOffset - 2 * ssR;
                    var yPos = box.y + box.height / 2 - ssR;

                    if ( xPos - ssR < roleWidth ) {
                        xPos = box.x + box.width / 2 - ssR;
                        yPos = box.y2 + autoOffset;
                    }

                    paper.bpmn.basicLineWithStart( paper, el, xPos, yPos, false );
                }
            }
        } );
    },
    removeTerminations: function( paper ) {
        var terminationsToRemove = new Array();

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( setType == 'start' || setType == 'stop' ) {
                terminationsToRemove.push( el );
            }
        } );

        Ext.each( terminationsToRemove, function( el, idx, els ) {
            deleteElement( el );
        } );
    },
    handlePaperSize: function( paper ) {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var minWidth = processPanel.getWidth() - 25;
        var minHeight = processPanel.getHeight() - 25;
        var newPaperWidth = parseInt( ( paper.lastRoleXPos + this.roleWidth + 25 ) / paper.scale );
        var newPaperHeight = parseInt( ( paper.lastRoleYPos + 25 ) / paper.scale );

        if ( minWidth > newPaperWidth ) {
            newPaperWidth = minWidth;
        }
        if ( minHeight > newPaperHeight ) {
            newPaperHeight = minHeight;
        }

        paper.setSize( newPaperWidth, newPaperHeight );
        paper.setViewBox( 0, 0, newPaperWidth * paper.scale, newPaperHeight * paper.scale );
        
        if ( paper.snapToGrid && paper.showGrid ) {
        	this.redrawGrid( paper );
        }
    },
    showGrid: function( paper ) {
    	var size = paper.gridSize;
    	
    	for ( var i = 0; i < Math.floor( paper.lastRoleXPos / size ) + 1 ; i++ ) {
    		var x = this.roleWidth + this.gridMargin + size * i;
    		var line = paper.path( 'M' + x + ' ' + this.gridMargin + 'L' + x + ' ' + paper.lastRoleYPos + 'Z' );
    		line = line.attr( {
	    	    stroke: '#7F9DB9',
	    	    'stroke-width': 1,
	    	    'stroke-opacity': 0.3
	    	} );
        line = line.data( 'setType', 'grid' );
    		line.toBack();
    		paper.gridSet.push( line );
    	}
    	
    	for ( var i = 0; i < Math.floor( paper.lastRoleYPos / size ) + 1; i++ ) {
    		var y = this.gridMargin + size * i;
    		var line = paper.path( 'M' + ( this.roleWidth + this.gridMargin ) + ' ' + y
    				+ 'L' + ( paper.lastRoleXPos + this.roleWidth - 4 ) + ' ' + y + 'Z' );
    		line = line.attr( {
	    	    stroke: '#7F9DB9',
	    	    'stroke-width': 1,
	    	    'stroke-opacity': 0.3
	    	} );
        line = line.data( 'setType', 'grid' );
    		line.toBack();
    		paper.gridSet.push( line );
    	}
    	
    	paper.forEach( function( el ) {
    		var roleContainer = el.data( 'roleContainer' );

            if ( !Ext.isEmpty( roleContainer ) ) {
            	roleContainer.toBack();
            }
        } );
    },
    hideGrid: function( paper ) {
    	paper.gridSet.remove();
    },
    redrawGrid: function( paper ) {
    	this.hideGrid( paper );
    	this.showGrid( paper );
    },
    evaluateGridXPosition: function( paper, pos ) {
    	return this.evaluateGridPosition( pos, paper.gridSize, paper.bpmn.roleWidth + paper.bpmn.gridMargin );
    },
    evaluateGridYPosition: function( paper, pos ) {
    	return this.evaluateGridPosition( pos, paper.gridSize, paper.bpmn.gridMargin );
    },
    evaluateGridPosition: function( pos, gridSize, limit ) {
    	var squares = this.evaluateGridSquares( pos, gridSize, limit );
    	
    	return squares * gridSize + limit;
    },
    evaluateGridSquares: function( pos, gridSize, limit ) {
    	return Math.floor( ( pos - limit ) / gridSize );
    },
    getDistanceXFromGrid: function( paper, pos ) {
    	return this.getDistanceFromGrid( pos, paper.gridSize, paper.bpmn.roleWidth + paper.bpmn.gridMargin );
    },
    getDistanceYFromGrid: function( paper, pos ) {
    	return this.getDistanceFromGrid( pos, paper.gridSize, paper.bpmn.gridMargin );
    },
    getDistanceFromGrid: function( pos, gridSize, limit ) {
    	var gridPos = this.evaluateGridPosition( pos, gridSize, limit );
    	
    	return pos - gridPos;
    }
};
