Ext.ux.suncode.IntegrationComponentsPluginsWindow = function() {
    var config = new Object();
    var viewSize = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.7,
        height: viewSize.height * 0.5,
        title: getTranslation( 'Wtyczki' ),
        layout: 'fit',
        items: [ new Ext.ux.suncode.IntegrationComponentsPluginsPanel() ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentsPluginsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentsPluginsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentsPluginsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationComponentsPluginsPanel = function() {
	var config = new Object();
	var mainPanel = Ext.getCmp( 'main_panel' );
	var pluginsMap = new HashMap();
	pluginsMap = this.collectComponents( pluginsMap, mainPanel.getFormActionsIntegrationComponentCategories() );
	pluginsMap = this.collectComponents( pluginsMap, mainPanel.getValidatorsIntegrationComponentCategories() );
	pluginsMap = this.collectComponents( pluginsMap, mainPanel.getVariablesSettersIntegrationComponentCategories() );
	pluginsMap = this.collectComponents( pluginsMap, mainPanel.getApplicationsIntegrationComponentCategories() );
	pluginsMap = this.collectComponents( pluginsMap, mainPanel.getDataChoosersIntegrationComponentCategories() );
	var componentsUtilizationMap = Ext.ux.suncode.IntegrationComponentService.getIntegrationComponentsUtilization();
	var data = new Array();
	
	pluginsMap.each( function( key, value ) {
		data.push( {
			id: key,
			name: value.name,
			description: value.description,
			noOfComponents: value.components.length
		} );
	} );

    config = Ext.apply( {
        store: new Ext.data.Store( {
            data: data,
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( [ {
                    name: 'id',
                    type: 'string'
                }, {
                    name: 'name',
                    type: 'string'
                }, {
                    name: 'description',
                    type: 'string'
                }, {
                    name: 'noOfComponents',
                    type: 'int'
                } ] )
            } )
        } ),
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        pluginsMap: pluginsMap,
        componentsUtilizationMap: componentsUtilizationMap,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                header: getTranslation( 'Identyfikator' ),
                dataIndex: 'id',
                align: 'left'
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'noOfComponents',
                header: getTranslation( 'Liczba komponentów' ),
                dataIndex: 'noOfComponents',
                align: 'center'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak wtyczek' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
        	scope: this,
        	rowdblclick: this.showPluginComponents
        }
    }, config );

    Ext.ux.suncode.IntegrationComponentsPluginsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentsPluginsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentsPluginsPanel.superclass.initComponent.call( this );
    },
    collectComponents: function( pluginsMap, categories ) {
    	Ext.iterate( categories, function( category, components, allCategories ) {
            Ext.each( components, function( component, index, allComponents ) {
            	var pluginId = component.source.id;
            	var plugin = pluginsMap.get( pluginId );
            	
            	if ( !Ext.isEmpty( plugin ) ) {
            		plugin.components.push( component );
            	} else {
            		plugin = {
            			id: pluginId,
            			name: component.source.name,
            			description: component.source.description,
            			components: [ component ]
            		};
            	}
            	
            	pluginsMap.put( pluginId, plugin );
            } );
        } );
    	
    	return pluginsMap;
    },
    showPluginComponents: function() {
    	var record = this.getSelectedRecord();
        if ( !record ) {
            return;
        }
        var pluginId = record.get( 'id' );
        var plugin = this.pluginsMap.get( pluginId );
        var win = new Ext.ux.suncode.IntegrationComponentsPluginComponentsWindow( {
        	plugin: plugin,
        	componentsUtilizationMap: this.componentsUtilizationMap
        } );
        win.show();
    },
    getSelectedRecord: function() {
        var record = this.getSelectionModel().getSelected();
        if ( !record ) {
            showWarn( getTranslation( 'Wybierz wtyczkę.' ) );
            return null;
        }
        return record;
    }
} );

Ext.ux.suncode.IntegrationComponentsPluginComponentsWindow = function( config ) {
    var viewSize = Ext.getBody().getViewSize();
    var plugin = config.plugin;
    var winTitle = getTranslation( 'Wtyczka' ) +  ' ' + plugin.name;
    
    var detailsPanel = new Ext.ux.suncode.IntegrationComponentDetailsPanel( {
        ref: 'detailsPanel',
        region: 'east',
        split: true,
        bodyStyle: 'overflowY: scroll;'
    } );

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.8,
        height: viewSize.height * 0.6,
        title: winTitle,
        layout: 'border',
        items: [ new Ext.ux.suncode.IntegrationComponentCatalog( {
        	ref: 'catalog',
        	region: 'center',
        	viewerScroll: true,
        	categories: this.convertToCategories( plugin.components ),
        	detailsPanel: detailsPanel
        } ), detailsPanel ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'utilization' ),
                tooltip: getTranslation( 'Pokaż wykorzystanie komponentu' ),
                handler: this.showComponentUtilization,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentsPluginComponentsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentsPluginComponentsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentsPluginComponentsWindow.superclass.initComponent.call( this );
    },
    convertToCategories: function( components ) {
    	var categories = new Object();
        
        if ( !Ext.isEmpty( components ) ) {
        	Ext.each( components, function( component, index, allComponents ) {
        		if ( !Ext.isEmpty( categories[component.groupName] ) ) {
        			var subcategory = categories[component.groupName];
        			
        			if ( !Ext.isEmpty( subcategory[component.category] ) ) {
        				subcategory[component.category].push( component );
        			} else {
        				subcategory[component.category] = [ component ];
        			}
            	} else {
            		var subcategory = new Object();
            		subcategory[component.category] = [ component ];
            		categories[component.groupName] = subcategory;
            	}
        	} );
        }
        
        return categories;
    },
    showComponentUtilization: function() {
    	var catalog = this.catalog;
        var component = catalog.getSelectedComponent();

        if ( !Ext.isEmpty( component ) ) {
            var componentId = component.id;
            var utilization = this.initialConfig.componentsUtilizationMap.get( componentId );
            var win = new Ext.ux.suncode.VariableUtilizationWindow( {
              windowTitle: getTranslation( 'Wykorzystanie komponentu integracyjnego' ) + ': ' + component.name,
            	utilization: utilization,
            	showProcessName: true,
              enableRemoveAll: true
            } );
            win.show();
        } else {
        	showWarn( getTranslation( 'Wybierz komponent.' ) );
        }
    },
    closeWindow: function() {
        this.close();
    }
} );