Ext.ux.suncode.IntegrationComponentMenu = function( config ) {
    config = Ext.apply( {
        items: [ new Ext.ux.suncode.IntegrationComponentSearchPanel(), new Ext.ux.suncode.IntegrationComponentTabPanel( config ) ],
        listeners: {
          show: function( menu ) {
            fitWindowToView( menu, function( x ) {
              return ( Ext.getBody().getWidth() - menu.getWidth() );
            }, function( y ) {
              return ( y - menu.getHeight() - 25 );
            } );
          }
        }
    }, config );

    Ext.ux.suncode.IntegrationComponentMenu.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentMenu, Ext.menu.Menu, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentMenu.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.IntegrationComponentSearchPanel = function() {
    var config = new Object();

    config = Ext.apply( {
        frame: false,
        border: false,
        items: [ {
            xtype: 'compositefield',
            width: 300,
            ref: 'searchItem',
            items: [ {
                xtype: 'textfield',
                emptyText: getTranslation( 'Szukaj' ) + '...',
                flex: 1,
                listeners: {
                    scope: this,
                    afterrender: this.onFilterAfterRender
                }
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść filtr' ),
                style: 'margin-top: 8px;',
                flex: 0,
                handler: this.clearFilter,
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.suncode.IntegrationComponentSearchPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentSearchPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentSearchPanel.superclass.initComponent.call( this );
    },
    onFilterAfterRender: function( filter ) {
        filter.getEl().on( 'keyup', function() {
            this.filterComponents( filter );
        }, this, {
            buffer: 500
        } );
    },
    filterComponents: function( filter ) {
        var categoriesItem = this.ownerCt.categoriesItem;
        var allComponentsItem = categoriesItem.getComponent( 0 );

        if ( !Ext.isEmpty( allComponentsItem ) ) {
            var value = filter.getValue();
            var valueIsEmpty = Ext.isEmpty( value );
            if ( valueIsEmpty ) {
                categoriesItem.hideTabStripItem( allComponentsItem );
                categoriesItem.setActiveTab( 1 );
            } else {
                categoriesItem.unhideTabStripItem( allComponentsItem );
                categoriesItem.setActiveTab( 0 );
            }
            categoriesItem.items.each( function( categoryItem ) {
                var categoryViewer = categoryItem.categoryViewer;
                var store = categoryViewer.getStore();
                store.filter( 'name', value, true );
                categoryViewer.select( 0 );
            } );
        }
    },
    clearFilter: function() {
        var filter = this.searchItem.items.first();
        filter.setValue( '' );
        this.filterComponents( filter );
    }
} );

Ext.ux.suncode.IntegrationComponentTabPanel = function( config ) {
    var viewSize = Ext.getBody().getViewSize();

    config = Ext.apply( {
        ref: 'categoriesItem',
        border: false,
        width: viewSize.width * 0.5,
        height: viewSize.height * 0.5,
        minWidth: 700,
        enableTabScroll: true
    }, config );

    Ext.ux.suncode.IntegrationComponentTabPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTabPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTabPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var categories = this.getCategories();
        var saveFunction = this.initialConfig.saveFunction;
        var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
        var destroyOnClose = this.initialConfig.destroyOnClose;
        var allComponents = new Array();

        if ( !Ext.isEmpty( categories ) ) {
            var items = new Array();

            Ext.iterate( categories, function( category, components, allCategories ) {
                allComponents = allComponents.concat( components );
                items.push( new Ext.ux.suncode.IntegrationComponentCategoryPanel( {
                    title: category,
                    components: components,
                    saveFunction: saveFunction,
                    saveScope: saveScope
                } ) );
            } );

            var allComponentsItem = new Ext.ux.suncode.IntegrationComponentCategoryPanel( {
                title: getTranslation( 'Wszystkie' ),
                components: allComponents,
                saveFunction: saveFunction,
                saveScope: saveScope,
                destroyOnClose: destroyOnClose
            } );
            items.unshift( allComponentsItem );

            this.add( items );
            this.hideTabStripItem( allComponentsItem );
            this.setActiveTab( 1 );
        }
    },
    getCategories: function() {
    	var categories = new Object();
    	
        if ( !Ext.isEmpty( this.initialConfig.categories ) ) {
        	categories = this.initialConfig.categories;
        } else if ( Ext.isFunction( this.initialConfig.getCategoriesFunction ) ) {
            var getCategoriesFunction = this.initialConfig.getCategoriesFunction;
            var getCategoriesScope = !Ext.isEmpty( this.initialConfig.getCategoriesScope ) ? this.initialConfig.getCategoriesScope : window;
            categories = Ext.isFunction( getCategoriesFunction ) ? getCategoriesFunction.apply( getCategoriesScope, [] ) : new Object();
        }
        
        return Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDeprecated( categories );
    }
} );

Ext.ux.suncode.IntegrationComponentCategoryPanel = function( config ) {
	var components = config.components;
	var componentsCopy = [].concat( components );
    componentsCopy.sort( function( a, b ) {
        return a.name > b.name ? 1 : -1;
    } );
    
	var viewerTemplate = new Ext.XTemplate( '<div class="x-Module-integrationComponentCategory">', '<dl>', '<tpl for=".">',
    		'<dd>', '<div class="x-Module-integrationComponentThumbWrap" title="{name}">',
    		'<div class="x-Module-integrationComponentThumb">', '{image}', '</div>',
    		'<span>{name}</span>', '</div>', '</dd>', '</tpl>', '</dl>', '</div>' );
	viewerTemplate.compile();
	
	var detailsPanel = new Ext.ux.suncode.IntegrationComponentDetailsPanel( {
        ref: 'detailsPanel',
        region: 'east',
        split: true,
        bodyStyle: 'overflowY: scroll;'
    } );
	
    config = Ext.apply( {
        border: false,
        layout: 'border',
        bodyCssClass: 'x-Module-whiteBody',
        items: [ {
            xtype: 'panel',
            region: 'center',
            autoScroll: true,
            items: [ new Ext.ux.suncode.IntegrationComponentViewer( {
                ref: '../categoryViewer',
                region: 'center',
                tpl: viewerTemplate,
                components: componentsCopy,
                detailsPanel: detailsPanel,
                listeners: {
                	scope: this,
                	dblclick: this.chooseComponent
                }
            } ) ],
            tbar: new Ext.Toolbar( {
                style: 'border: none',
                items: [ {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'tick' ),
                    tooltip: getTranslation( 'Wybierz' ),
                    handler: this.chooseComponent,
                    scope: this
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'close' ),
                    tooltip: getTranslation( 'Zamknij' ),
                    handler: this.closeMenu,
                    scope: this
                } ]
            } )
        }, detailsPanel ]
    }, config );

    Ext.ux.suncode.IntegrationComponentCategoryPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentCategoryPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentCategoryPanel.superclass.initComponent.call( this );
    },
    chooseComponent: function() {
        var viewer = this.categoryViewer;
        var selections = viewer.getSelectedNodes();

        if ( !Ext.isEmpty( selections ) ) {
            var component = viewer.getRecord( selections[0] ).data;
            this.useChosenComponent( component );
        }
    },
    useChosenComponent: function( component ) {
    	var saveFunction = this.initialConfig.saveFunction;

        if ( Ext.isFunction( saveFunction ) ) {
            this.closeMenu();

            saveFunction.apply( this.initialConfig.saveScope, [ component ] );
        }
    },
    closeMenu: function() {
      if ( this.initialConfig.destroyOnClose ) {
        this.ownerCt.ownerCt.destroy();
      } else {
        this.ownerCt.ownerCt.hide();
      }
    }
} );

Ext.ux.suncode.EventTypeMenu = function( config ) {
  config = Ext.apply( {
    items: [ new Ext.ux.suncode.EventTypeGrid( config ) ]
  }, config );

  Ext.ux.suncode.EventTypeMenu.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.EventTypeMenu, Ext.menu.Menu, {
  initComponent: function() {
    Ext.ux.suncode.EventTypeMenu.superclass.initComponent.call( this );
  }
} );

Ext.ux.suncode.EventTypeGrid = function( config ) {
  var store = new Ext.data.Store( {
    data: config.eventTypes,
    reader : new Ext.data.JsonReader( {
      fields : Ext.data.Record.create( [ {
        name : 'name',
        type : 'string'
      }, {
        name : 'description',
        type : 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    ref: 'eventTypePanel',
    width: 500,
    height: 200,
    store: store,
    columnLines: true,
    autoScroll: true,
    border: false,
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: false,
        menuDisabled: true
      },
      columns: [ {
        id: 'name',
        header: getTranslation( 'Nazwa zdarzenia' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'description',
        header: getTranslation( 'Opis' ),
        dataIndex: 'description',
        align: 'left',
        renderer: wrapColumnValue
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak zdarzeń' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true
    } ),
    listeners: {
      scope: this,
      rowdblclick: this.onChooseEvent
    }
  }, config );

  Ext.ux.suncode.EventTypeGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.EventTypeGrid, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.EventTypeGrid.superclass.initComponent.call( this );
  },
  onChooseEvent: function( grid, rowIndex, e ) {
    var event = this.getSelectedEvent();

    if ( event ) {
      this.useChosenEvent( event );
    }
  },
  getSelectedEvent: function() {
    var event = this.getSelectionModel().getSelected();
    if ( !event ) {
      showWarn( getTranslation( 'Wybierz zdarzenie.' ) );
      return null;
    }
    return event;
  },
  useChosenEvent: function( event ) {
    var saveFunction = this.initialConfig.saveFunction;

    if ( Ext.isFunction( saveFunction ) ) {
      var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
      this.closeMenu();

      saveFunction.apply( saveScope, [ {
        name: event.get( 'name' )
      } ] );
    }
  },
  closeMenu: function() {
    this.ownerCt.hide();
  }
} );