Ext.ux.suncode.IntegrationComponentDestinationChooser = function( config ) {
  var store = new Ext.data.Store( {
    data: Ext.ux.suncode.IntegrationComponentService.getDestinationTypesWithTranslations(),
    reader : new Ext.data.JsonReader( {
      fields : Ext.data.Record.create( [ {
        name : 'value',
        type : 'string'
      }, {
        name : 'text',
        type : 'string'
      } ] )
    } )
  } );

  config = Ext.apply( {
    triggerAction : 'all',
    mode : 'local',
    store : store,
    valueField : 'value',
    displayField : 'text',
    resizable : true,
    editable: false
  }, config );

  Ext.ux.suncode.IntegrationComponentDestinationChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentDestinationChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.IntegrationComponentDestinationChooser.superclass.initComponent.call( this );
  }
} );

Ext.ux.suncode.IntegrationComponentPluginNameChooser = function( config ) {
  var data = new Array();
  var pluginNames = Ext.ux.suncode.IntegrationComponentService.getAllPluginNames();

  if ( !Ext.isEmpty( pluginNames ) ) {
    Ext.each( pluginNames, function( name, index, names ) {
      data.push( {
        name: name
      } );
    } );
  }

  var store = new Ext.data.Store( {
    data: data,
    reader : new Ext.data.JsonReader( {
      fields : Ext.data.Record.create( [ {
        name : 'name',
        type : 'string'
      } ] )
    } ),
    sortInfo: {
      field: 'name',
      direction: 'ASC'
    }
  } );

  config = Ext.apply( {
    triggerAction : 'all',
    mode : 'local',
    store : store,
    valueField : 'name',
    displayField : 'name',
    resizable : true
  }, config );

  Ext.ux.suncode.IntegrationComponentPluginNameChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentPluginNameChooser, Ext.form.ComboBox, {
  initComponent : function() {
    Ext.ux.suncode.IntegrationComponentPluginNameChooser.superclass.initComponent.call( this );
  }
} );