Ext.ux.suncode.I18NTranslatedField = function( config ) {
	var cache = config.cache;
	var items = new Array();
	items.push( Ext.apply( config.field, {
		flex: 1
	} ) );
	items.push( {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'translations' ),
        tooltip: getTranslation( 'Pokaż tłumaczenia' ),
        flex: 0,
        handler: this.showTranslations,
        scope: this
    } );
	
	config = Ext.apply( {
		anchor: '100%',
		cache: cache ? cache : new Object(),
		items: items
	}, config );

	Ext.ux.suncode.I18NTranslatedField.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.I18NTranslatedField, Ext.form.CompositeField, {
	initComponent: function() {
		Ext.ux.suncode.I18NTranslatedField.superclass.initComponent.call( this );
		
		this.on( 'afterrender', this.onAfterRender, this );
	},
	onAfterRender: function( field ) {
		var nameField = this.items.first();
        nameField.on( 'change', this.onNameFieldChange, this );
        
		var idField = this.getIdField();

        if ( !Ext.isEmpty( idField ) ) {
        	idField.on( 'valid', this.onIdFieldValid, this );
        }
	},
	onNameFieldChange: function( field, newValue, oldValue ) {
		this.replaceTranslationsInCache( newValue, oldValue );
		
		if ( Ext.isEmpty( this.cache.key ) ) {
			Ext.apply( this.cache, {
				key: 'no_key'
			} );
		}
	},
	replaceTranslationsInCache: function( newValue, oldValue ) {
		var translations = null;
		
		if ( this.saveToCache ) {
			translations = this.getTranslationsFromCache();
		} else {
			var id = this.getObjectId();
			
			if ( !Ext.isEmpty( id ) ) {
				var key = this.getKey( id );
				translations = Ext.ux.suncode.I18NService.getPackageTranslations( key );
			}
		}

		translations = translations ? translations : new Object();
		var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();
		
		if ( !Ext.isEmpty( supportedLanguages ) ) {
			Ext.each( supportedLanguages, function( language, index, languages ) {
				if ( Ext.isEmpty( translations[language] ) || translations[language] === oldValue ) {
					translations[language] = newValue;
				}
			} );
		}
		
		Ext.apply( this.cache, {
			translations: translations
		} );
	},
	onIdFieldValid: function( field ) {
		this.saveToCache = true;
		this.updateCacheKey( field.getValue() );
	},
	showTranslations: function() {
		var id = this.getObjectId();
        
        if ( !Ext.isEmpty( id ) ) {
        	var win = new Ext.ux.suncode.I18NTranslationWindow( {
        		windowTitle: this.initialConfig.windowTitle,
        		key: this.getKey( id ),
        		defaultTranslation: this.getValue(),
        		cache: this.cache,
        		saveToCache: this.saveToCache,
            multilineTranslationFields: this.initialConfig.multilineTranslationFields,
            maxTranslationLength: this.initialConfig.maxTranslationLength,
            maxTranslationLengthText: this.initialConfig.maxTranslationLengthText
        	} );
    		win.show();
        } else {
        	showWarn( this.initialConfig.emptyIdMessage );
        }
	},
	getInitialId: function() {
		return this.initialConfig.initialId;
	},
	getObjectId: function() {
		var idField = this.getIdField();

        if ( !Ext.isEmpty( idField ) ) {
            var id =  idField.getValue();
            var idReplacementStrategy = this.initialConfig.idReplacementStrategy;

            if ( Ext.isFunction( idReplacementStrategy ) ) {
                var idReplacementStrategyScope = !Ext.isEmpty( this.initialConfig.idReplacementStrategyScope ) ?
                    this.initialConfig.idReplacementStrategyScope : window;

                return idReplacementStrategy.apply( idReplacementStrategyScope, [ id ] );
            } else{
                return id;
            }
        } else {
        	return null;
        }
	},
	getIdField: function() {
		var getIdFieldFunction = this.initialConfig.getIdFieldFunction;

        if ( Ext.isFunction( getIdFieldFunction ) ) {
            var getIdFieldScope = !Ext.isEmpty( this.initialConfig.getIdFieldScope ) ? this.initialConfig.getIdFieldScope : window;
            
            return getIdFieldFunction.apply( getIdFieldScope, [] );
        } else {
        	return null;
        }
	},
	getValue: function() {
		return this.getTranslatedField().getValue();
	},
	setValue: function( value ) {
		this.getTranslatedField().setValue( value );
	},
	getTranslatedField: function() {
		return this.items.first();
	},
	getCache: function() {
		return this.cache;
	},
	updateCacheKey: function( id ) {
		if ( !Ext.isEmpty( this.cache.key ) ) {
			Ext.apply( this.cache, {
				key: this.getKey( id )
			} );
		} else {
			var initialId = this.getInitialId();
			
			if ( !Ext.isEmpty( initialId ) ) {
				var key = this.getKey( id );
				var oldKey = this.getKey( initialId );
				var translations = Ext.ux.suncode.I18NService.getPackageTranslations( oldKey );
				
				if ( !Ext.isEmpty( translations ) ) {
					Ext.apply( this.cache, {
	    				key: key,
	    				translations: translations
	    			} );
				}
			}
		}
	},
	getKey: function( id ) {
		return this.initialConfig.keyPrefix + id + this.initialConfig.keyPostfix;
	},
	getTranslationsFromCache: function() {
    	return this.cache.translations;
	}
} );

Ext.ux.suncode.I18NTranslationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;

    config = Ext.apply( {
    	modal: true,
    	title: config.windowTitle,
        width: windowWidth,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } ),
        items: [ new Ext.ux.suncode.I18NTranslationPanel( config ) ]
    }, config );

    Ext.ux.suncode.I18NTranslationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.I18NTranslationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.I18NTranslationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.translationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.I18NTranslationPanel = function( config ) {
	var items = new Array();
	var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();
	var multilineTranslationFields = config.multilineTranslationFields;
	
	if ( !Ext.isEmpty( supportedLanguages ) ) {
		Ext.each( supportedLanguages, function( language, index, languages ) {
			items.push( {
	            xtype: multilineTranslationFields ? 'textarea' : 'textfield',
	            name: language,
	            anchor: '100%',
              height: multilineTranslationFields ? 100 : undefined,
	            fieldLabel: language,
              maxLength: config.maxTranslationLength,
              maxLengthText: config.maxTranslationLengthText
	        } );
		} );
	}
	
	config = Ext.apply( {
        labelWidth: 200,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'translationPanel',
        items: items
    }, config );

    Ext.ux.suncode.I18NTranslationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.I18NTranslationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.I18NTranslationPanel.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
    	var key = this.getKey();
    	var cache = this.initialConfig.cache;
    	var translations = Ext.isEmpty( cache.key ) ? Ext.ux.suncode.I18NService.getPackageTranslations( key )
    			: this.getTranslationsFromCache();
    	translations = translations ? translations : new Object();
    	var defaultLanguage = Ext.ux.suncode.I18NService.getDefaultLanguage();
    	
    	if ( Ext.isEmpty( translations[defaultLanguage] ) ) {
    		translations[defaultLanguage] = this.initialConfig.defaultTranslation;
    	}
    	
    	var form = this.getForm();
    	form.setValues( translations );
    },
    saveForm: function() {
    	var form = this.getForm();
    	
    	if ( form.isValid() ) {
    		var key = this.getKey();
    		var translations = form.getValues();
    		var cache = this.initialConfig.cache;
    		
    		if ( this.initialConfig.saveToCache ) {
    			Ext.apply( cache, {
    				key: key,
    				translations: translations
    			} );
    		} else {
    			Ext.ux.suncode.I18NService.savePackageTranslations( key, translations );
    		}
    		
    		this.ownerCt.closeWindow();
    	}
    },
    getKey: function() {
    	return this.initialConfig.key;
    },
    getTranslationsFromCache: function() {
    	var cache = this.initialConfig.cache;
    	
    	return cache.translations;
    }
} );

Ext.ux.suncode.PackageI18NTranslationsWindow = function( config ) {
    config = Ext.apply( {
        modal: true,
        title: getTranslation( 'Tłumaczenia' ),
        closable: true,
        items: [ new Ext.ux.suncode.PackageI18NTranslationsPanel( config ) ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveTranslations,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.PackageI18NTranslationsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageI18NTranslationsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.PackageI18NTranslationsWindow.superclass.initComponent.call( this );
    },
    saveTranslations: function() {
    	this.translationsPanel.saveTranslations();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.PackageI18NTranslationsPanel = function( config ) {
    var viewSize = Ext.getBody().getViewSize();
    var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();
    var packageNode = config.packageNode;
    var data = this.buildInitialData( packageNode, supportedLanguages );
    var fields = new Array();
    var columns = new Array();

    fields.push( {
        name: 'key',
        type: 'string'
    } );
    fields.push( {
        name: 'keyType',
        type: 'string'
    } );
    fields.push( {
        name: 'defaultValue',
        type: 'string'
    } );
    fields.push( {
      name: 'local',
      type: 'boolean'
    } );
    fields.push( {
      name: 'multiline',
      type: 'boolean'
    } );
    fields.push( {
      name: 'globalType',
      type: 'string'
    } );

    columns.push( {
        id: 'key',
        header: getTranslation( 'Klucz' ),
        dataIndex: 'key',
        width: 400,
        hidden: true
    } );
    columns.push( {
        id: 'keyType',
        header: getTranslation( 'Typ klucza' ),
        dataIndex: 'keyType',
        width: 650
    } );
    columns.push( {
        id: 'defaultValue',
        header: getTranslation( 'Wartość domyślna' ),
        dataIndex: 'defaultValue',
        width: 250
    } );

    if ( !Ext.isEmpty( supportedLanguages ) ) {
        Ext.each( supportedLanguages, function( language, index, languages ) {
        	Ext.each( data, function( datum, index, allData ) {
            if ( Ext.isEmpty( datum.globalType ) ) {
              var translation = Ext.ux.suncode.I18NService.getPackageTranslation( datum.key, language );

              datum[language] = translation;
            }
        	} );
        	
            fields.push( {
                name: language,
                type: 'string'
            } );

            columns.push( {
                id: language,
                header: language,
                dataIndex: language,
                width: 250,
                editor: new Ext.form.TextField(),
                renderer: escapeHtmlRenderer
            } );
        } );
    }
    
    config = Ext.apply( {
        width: viewSize.width * 0.95,
        height: viewSize.height * 0.80,
        ref: 'translationsPanel',
        cls: 'x-Module-wrappedHeader',
        store: new Ext.data.Store( {
            data: data,
            reader: new Ext.data.JsonReader( {
                fields: Ext.data.Record.create( fields )
            } )
        } ),
        border: false,
        columnLines: true,
        autoScroll: true,
        enableColumnResize: true,
        enableColumnMove: true,
        stateful: true,
        stateId: 'package_translations_panel_state_id',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: columns
        } ),
        sm: new Ext.grid.CellSelectionModel(),
        view: new Ext.ux.grid.BufferView( {
        	rowHeight: 36,
		    scrollDelay: false
	    } ),
	    toSave: new Object(),
      globalsToSave: new Object(),
        bodyStyle: 'padding: 0 0 10px 10px;',
        tbar: new Ext.Toolbar( {
        	items: [ {
                xtype: 'compositefield',
                width: 300,
                ref: 'searchItem',
                items: [ {
                    xtype: 'textfield',
                    emptyText: getTranslation( 'Szukaj' ) + '...',
                    flex: 1,
                    style: {
                        textAlign: 'left'
                    },
                    listeners: {
                        scope: this,
                        afterrender: this.onFilterAfterRender
                    }
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'clear' ),
                    tooltip: getTranslation( 'Wyczyść filtr' ),
                    style: 'margin-top: 4px;',
                    flex: 0,
                    handler: this.clearFilter,
                    scope: this
                } ]
            }, '->', {
            	xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'import' ),
                tooltip: getTranslation( 'Importuj' ),
                handler: this.importTranslations,
                scope: this
            }, {
            	xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'export' ),
                tooltip: getTranslation( 'Eksportuj' ),
                handler: this.exportTranslations,
                scope: this
            } ]
        } ),
        listeners: {
        	scope: this,
          beforeedit: this.onBeforeEdit,
          afteredit: this.onSetTranslation
        }
    }, config );

    Ext.ux.suncode.PackageI18NTranslationsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageI18NTranslationsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackageI18NTranslationsPanel.superclass.initComponent.call( this );
    },
    KEY_TYPE_JOINER: ' -> ',
    TABLE_TITLE_GLOBAL_TYPE: 'TABLE_TITLE',
    DT_BUTTON_NAME_GLOBAL_TYPE: 'DT_BUTTON_NAME',
    DT_BUTTON_TOOLTIP_GLOBAL_TYPE: 'DT_BUTTON_TOOLTIP',
    saveTranslations: function() {
    	var maskId = 'save_translations_mask';
      var packagePanel = Ext.getCmp( 'package_panel' );
    	
    	try {
    		showLoadingMask( maskId, getTranslation( 'Trwa zapisywanie tłumaczeń...' ) );

        Ext.iterate( this.toSave, function( key, translations, allTranslations ) {
          Ext.each( translations, function( translation, index, all ) {
            Ext.ux.suncode.I18NService.savePackageTranslation( key, translation.language, translation.translation );
          } );
        } );

        Ext.iterate( this.globalsToSave, function( key, translations, allTranslations ) {
          var processDefIdTag = ')_PROC(';
          var tableTag = ')_TABLE(';
          var dtButtonTag = ')_DTBUTTON(';
          var processDefId = key.substring( key.indexOf( processDefIdTag ) + processDefIdTag.length, key.indexOf( tableTag ) );
          var tableIdStartIndex = key.indexOf( tableTag ) + tableTag.length;
          var tableId = key.substring( tableIdStartIndex, key.indexOf( ')', tableIdStartIndex ) );
          var processNode = packagePanel.findProcess( processDefId );
          var table = processNode.findTable( tableId );

          Ext.each( translations, function( translation, index, all ) {
            switch ( translation.globalType ) {
              case this.TABLE_TITLE_GLOBAL_TYPE:
                var tableTitleTranslations = table.translations[key];

                tableTitleTranslations[translation.language] = translation.translation;

                table.translations[key] = tableTitleTranslations;
                break;
              case this.DT_BUTTON_NAME_GLOBAL_TYPE:
              case this.DT_BUTTON_TOOLTIP_GLOBAL_TYPE:
                var keyDtButtonIdStartIndex = key.indexOf( dtButtonTag ) + dtButtonTag.length;
                var dtButtonId = key.substring( keyDtButtonIdStartIndex, key.indexOf( ')', keyDtButtonIdStartIndex ) );

                Ext.each( table.DTButtons, function( dtButton, idx, allDtButtons ) {
                  if ( dtButton.buttonId == dtButtonId ) {
                    var dtButtonTranslations = dtButton.translations[key];

                    dtButtonTranslations[translation.language] = translation.translation;

                    dtButton.translations[key] = dtButtonTranslations;
                    return false;
                  }
                } );
                break;
              default:
                break;
            }
          }, this );
        }, this );
    	} finally {
        removeLoadingMask( maskId );
      }

      updateXpdlTranslationsInEditor();

    	Ext.getCmp( 'main_panel' ).setSaved( false );
    	this.ownerCt.closeWindow();
    },
    buildInitialData: function( packageNode, supportedLanguages ) {
      var data = new Array();
      var packageId = packageNode.attributes.packageId;
      var packName = getTranslation( 'Nazwa pakietu' );
      var packDescription = getTranslation( 'Opis pakietu' );
      var name = getTranslation( 'Nazwa' );
      var description = getTranslation( 'Opis' );
      var process = getTranslation( 'Proces' );
      var maskName = getTranslation( 'Maska nazwy' );
      var participant = getTranslation( 'Uczestnik' );
      var globalTable = getTranslation( 'Globalna tabela' );
      var globalDtButton = getTranslation( 'Przycisk tabeli' );
      var variable = getTranslation( 'Zmienna' );
      var globalLabel = getTranslation( 'Etykieta' );
      var mapping = getTranslation( 'Mapowanie wartości' );
      var activity = getTranslation( 'Zadanie' );
      var variableSet = getTranslation( 'Tabela dynamiczna' );
      var title = getTranslation( 'Tytuł' );
      var dtButton = getTranslation( 'Przycisk tabeli dynamicznej' );
      var tooltip = getTranslation( 'Tooltip' );
      var httpLinkButton = getTranslation( 'Przycisk formularza' );
      var acceptButton = getTranslation( 'Przycisk akceptacji' );
      var generatePdfButton = getTranslation( 'Przycisk generowania PDF' );
      var addFileButton = getTranslation( 'Przycisk podłączania pliku' );

      data.push( {
        key: 'PACK(' + packageId + ')',
        keyType: packName,
        defaultValue: packageNode.attributes.packageName
      } );
      data.push( {
        key: 'PACK(' + packageId + ')_DESC',
        keyType: packDescription,
        defaultValue: packageNode.attributes.packageDescr,
        multiline: true
      } );

      Ext.each( packageNode.attributes.participants, function( role, index, roles ) {
        var participantName = ' (' + role.roleName + ')';

        data.push( {
          key: 'PACK(' + packageId + ')_PARTICIPANT(' + role.roleId + ')',
          keyType: this.buildKeyType( [ participant + participantName, name ] ),
          defaultValue: role.roleName
        } );
      }, this );

      packageNode.eachChild( function( processNode ) {
        var processDefId = processNode.attributes.processDefId;
        var processName = ' (' + processNode.attributes.processName + ')'

        data.push( {
          key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')',
          keyType: this.buildKeyType( [ process + processName, name ] ),
          defaultValue: processNode.attributes.processName
        } );
        data.push( {
          key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_PROCESS_NAME_MASK',
          keyType: this.buildKeyType( [ process + processName, maskName ] ),
          defaultValue: processNode.attributes.processName
        } );
        data.push( {
          key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DESC',
          keyType: this.buildKeyType( [ process + processName, description ] ),
          defaultValue: processNode.attributes.processDescr,
          multiline: true
        } );

        Ext.each( processNode.attributes.participants, function( role, index, roles ) {
          var participantName = ' (' + role.roleName + ')';

          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_PARTICIPANT(' + role.roleId + ')',
            keyType: this.buildKeyType( [ process + processName, participant + participantName, name ] ),
            defaultValue: role.roleName
          } );
        }, this );

        Ext.each( processNode.attributes.variables, function( processVariable, index, processVariables ) {
          var variableName = ' (' + processVariable.name + ')';

          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(' + processVariable.id + ')',
            keyType: this.buildKeyType( [ process + processName, variable + variableName, name ] ),
            defaultValue: processVariable.name
          } );
          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(' + processVariable.id + ')_DESC',
            keyType: this.buildKeyType( [ process + processName, variable + variableName, description ] ),
            defaultValue: processVariable.descr,
            multiline: true
          } );

          if ( processVariable.type == 'DATA_CHOOSER' ) {
            if ( Ext.isEmpty( processVariable.definition.id ) ) {
              Ext.each( processVariable.mappings, function( dcMapping, dcMappingIndex, dcMappings ) {
                var mappingName = ' (' + dcMapping.display + ')';

                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATACHOOSER(' + processVariable.id + ')_MAPPING('
                      + dcMapping.id + ')',
                  keyType: this.buildKeyType( [ process + processName, variable + variableName,
                    mapping + mappingName, name ] ),
                  defaultValue: dcMapping.display
                } );
              }, this );
            } else {
              Ext.iterate( processVariable.definition.mappings, function( id, dcMapping, dcMappings ) {
                var mappingName = ' (' + dcMapping.name + ')';

                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATACHOOSER(' + processVariable.id + ')_MAPPING('
                      + id + ')',
                  keyType: this.buildKeyType( [ process + processName, variable + variableName,
                    mapping + mappingName, name ] ),
                  defaultValue: dcMapping.name
                } );
              }, this );
            }
          }
        }, this );

        Ext.each( processNode.attributes.tables, function( table, index, tables ) {
          var tableTitleDatum = new Object();
          var tableTitle = ' (' + table.name + ')';
          var tableId = table.id;
          var tableTitleKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + tableId + ')';

          tableTitleDatum = Ext.apply( tableTitleDatum, {
            key: tableTitleKey,
            keyType: this.buildKeyType( [ process + processName, globalTable + tableTitle, title ] ),
            defaultValue: table.name,
            globalType: this.TABLE_TITLE_GLOBAL_TYPE
          } );

          Ext.each( supportedLanguages, function( language, index, languages ) {
            var translations = table.translations[tableTitleKey];
            var translation = translations[language];

            tableTitleDatum[language] = translation;
          } );

          data.push( tableTitleDatum );

          Ext.each( table.DTButtons, function( dtBtn, dtBtnIndex, dtBtns ) {
            var dtButtonNameDatum = new Object();
            var dtButtonTooltipDatum = new Object();
            var dtButtonName = ' (' + dtBtn.name + ')';
            var dtButtonNameKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + tableId
                + ')_DTBUTTON(' + dtBtn.buttonId + ')';
            var dtButtonTooltipKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_TABLE(' + tableId
                + ')_DTBUTTON(' + dtBtn.buttonId + ')_DESC';

            dtButtonNameDatum = Ext.apply( dtButtonNameDatum, {
              key: dtButtonNameKey,
              keyType: this.buildKeyType( [ process + processName, globalTable + tableTitle,
                globalDtButton + dtButtonName, name ] ),
              defaultValue: dtBtn.name,
              globalType: this.DT_BUTTON_NAME_GLOBAL_TYPE
            } );
            dtButtonTooltipDatum = Ext.apply( dtButtonTooltipDatum, {
              key: dtButtonTooltipKey,
              keyType: this.buildKeyType( [ process + processName, globalTable + tableTitle,
                globalDtButton + dtButtonName, tooltip ] ),
              defaultValue: dtBtn.tooltip,
              globalType: this.DT_BUTTON_TOOLTIP_GLOBAL_TYPE
            } );

            Ext.each( supportedLanguages, function( language, index, languages ) {
              var translations = dtBtn.translations[dtButtonNameKey];

              if ( !Ext.isEmpty( translations ) ) {
                var translation = translations[language];

                dtButtonNameDatum[language] = translation;
              } else {
                dtButtonNameDatum[language] = '';
              }
            } );

            Ext.each( supportedLanguages, function( language, index, languages ) {
              var translations = dtBtn.translations[dtButtonTooltipKey];

              if ( !Ext.isEmpty( translations ) ) {
                var translation = translations[language];

                dtButtonTooltipDatum[language] = translation;
              } else {
                dtButtonTooltipDatum[language] = '';
              }
            } );

            data.push( dtButtonNameDatum );
            data.push( dtButtonTooltipDatum );
          }, this );
        }, this );

        Ext.each( processNode.attributes.labels, function( label, index, labels ) {
          var labelName = ' (' + label.name + ')';

          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_LABEL(' + label.id + ')',
            keyType: this.buildKeyType( [ process + processName, globalLabel + labelName, name ] ),
            defaultValue: label.name
          } );
        }, this );

        processNode.eachChild( function( activityNode ) {
          var activityDefId = activityNode.attributes.activityDefId;
          var activityName = ' (' + activityNode.attributes.activityName + ')';

          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')',
            keyType: this.buildKeyType( [ process + processName, activity + activityName, name ] ),
            defaultValue: activityNode.attributes.activityName
          } );
          data.push( {
            key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_DESC',
            keyType: this.buildKeyType( [ process + processName, activity + activityName, description ] ),
            defaultValue: activityNode.attributes.activityDescr,
            multiline: true
          } );

          Ext.each( activityNode.attributes.form.variables, function( formVariable, index, formVariables ) {
            if ( formVariable.genre == 'VARIABLE_SET' ) {
              var variableSetTitle = ' (' + formVariable.name + ')';
              var variableSetId = formVariable.varId;

              data.push( {
                key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
                    + variableSetId + ')',
                keyType: this.buildKeyType( [ process + processName, activity + activityName,
                  variableSet + variableSetTitle, title ] ),
                defaultValue: formVariable.name,
                local: true
              } );

              Ext.each( formVariable.DTButtons, function( dtBtn, dtBtnIndex, dtBtns ) {
                var dtButtonName = ' (' + dtBtn.name + ')';

                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
                      + variableSetId + ')_DTBUTTON(' + dtBtn.buttonId + ')',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    variableSet + variableSetTitle, dtButton + dtButtonName, name ] ),
                  defaultValue: dtBtn.name,
                  local: true
                } );
                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_VARIABLESET('
                      + variableSetId + ')_DTBUTTON(' + dtBtn.buttonId + ')_DESC',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    variableSet + variableSetTitle, dtButton + dtButtonName, tooltip ] ),
                  defaultValue: dtBtn.tooltip,
                  local: true
                } );
              }, this );
            }
          }, this );

          Ext.each( activityNode.attributes.form.httpLinks, function( httpLink, index, httpLinks ) {
            var httpLinkButtonName = ' (' + httpLink.buttonName + ')';

            data.push( {
              key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_HTTPLINK('
                  + Ext.ux.suncode.I18NService.replaceHttpLinkId( httpLink.buttonName ) + ')',
              keyType: this.buildKeyType( [ process + processName, activity + activityName,
                httpLinkButton + httpLinkButtonName, name ] ),
              defaultValue: httpLink.buttonName
            } );
            data.push( {
              key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_HTTPLINK('
                  + Ext.ux.suncode.I18NService.replaceHttpLinkId( httpLink.buttonName ) + ')_DESC',
              keyType: this.buildKeyType( [ process + processName, activity + activityName,
                httpLinkButton + httpLinkButtonName, tooltip ] ),
              defaultValue: httpLink.tooltip
            } );
          }, this );

          Ext.each( activityNode.attributes.form.buttons, function( formButton, index, formButtons ) {
            var buttonName = ' (' + formButton.buttonName + ')';

            switch ( formButton.genre ) {
              case 'ACTION_ACCEPT_BUTTON':
                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_ACTIONBUTTON('
                      + formButton.actionName + ')',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    acceptButton + buttonName, name ] ),
                  defaultValue: formButton.buttonName
                } );
                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_ACTIONBUTTON('
                      + formButton.actionName + ')_DESC',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    acceptButton + buttonName, tooltip ] ),
                  defaultValue: formButton.tooltip
                } );
                break;
              case 'GENERATE_PDF_BUTTON':
                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_PDFBUTTON('
                      + formButton.actionName + ')',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    generatePdfButton + buttonName, name ] ),
                  defaultValue: formButton.buttonName
                } );
                break;
              case 'ADD_FILE_BUTTON':
                data.push( {
                  key: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_ADDFILEBUTTON('
                      + Ext.ux.suncode.I18NService.replaceAddFileButtonId( formButton.docClassName ) + ')',
                  keyType: this.buildKeyType( [ process + processName, activity + activityName,
                    addFileButton + buttonName, name ] ),
                  defaultValue: formButton.buttonName
                } );
                break;
              default:
                break;
            }
          }, this );
        }, this );
      }, this );

      return data;
    },
    buildKeyType: function( parts ) {
    	return parts.join( this.KEY_TYPE_JOINER );
    },
    onBeforeEdit: function( e ) {
      var record = e.record;

      if ( record.get( 'local' ) ) {
        showWarn( getTranslation( 'Lokalne tłumaczenie nie może być zmienione.' ) );
        return false;
      } else {
        var grid = e.grid;
        var columnModel = grid.getColumnModel();
        var multiline = record.get( 'multiline' );

        if ( multiline ) {
          columnModel.setEditor( e.column, new Ext.form.TextArea() );
        } else {
          columnModel.setEditor( e.column, new Ext.form.TextField() );
        }

        return true;
      }
    },
    onSetTranslation: function( e ) {
    	if ( e.value !== e.originalValue ) {
    		  var record = e.record;
          var key = record.get( 'key' );
          var language = e.field;
          var translation = e.value;
          var globalType = record.get( 'globalType' );
          var store = e.grid.getStore();

          if ( !Ext.isEmpty( globalType ) ) {
            this.setGlobalTranslation( globalType, key, language, translation );
          } else {
            this.storeTranslationToSave( key, {
              language: language,
              translation: translation
            } );
          }

        	store.commitChanges();
        	
        	this.storeParentWindowAsUnsaved();
    	}
    },
    setGlobalTranslation: function( globalType, key, language, translation ) {
      var store = this.getStore();
      var tableTag = ')_TABLE(';
      var dtButtonTag = ')_DTBUTTON(';
      var keyProcessPart = key.substring( 0, key.indexOf( tableTag ) ) + ')';
      var keyVariableSetIdStartIndex = key.indexOf( tableTag ) + tableTag.length;
      var keyVariableSetIdPart = ')_VARIABLESET('
          + key.substring( keyVariableSetIdStartIndex, key.indexOf( ')', keyVariableSetIdStartIndex ) ) + ')' ;

      switch ( globalType ) {
        case this.TABLE_TITLE_GLOBAL_TYPE:
          store.each( function( otherRecord ) {
            var otherKey = otherRecord.get( 'key' );

            if ( otherKey.includes( keyProcessPart )
                && otherKey.includes( keyVariableSetIdPart )
                && !otherKey.includes( ')_DTBUTTON(' )  ) {
              otherRecord.set( language, translation );

              this.storeTranslationToSave( otherKey, {
                language: language,
                translation: translation
              } );
            }
          }, this );
          break;
        case this.DT_BUTTON_NAME_GLOBAL_TYPE:
          var keyDtButtonIdStartIndex = key.indexOf( dtButtonTag ) + dtButtonTag.length;
          var keyDtButtonIdPart = dtButtonTag
              + key.substring( keyDtButtonIdStartIndex, key.indexOf( ')', keyDtButtonIdStartIndex ) ) + ')' ;

          store.each( function( otherRecord ) {
            var otherKey = otherRecord.get( 'key' );

            if ( otherKey.includes( keyProcessPart )
                && otherKey.includes( keyVariableSetIdPart )
                && otherKey.includes( keyDtButtonIdPart )
                && !otherKey.includes( '_DESC' )  ) {
              otherRecord.set( language, translation );

              this.storeTranslationToSave( otherKey, {
                language: language,
                translation: translation
              } );
            }
          }, this );
          break;
        case this.DT_BUTTON_TOOLTIP_GLOBAL_TYPE:
          var keyDtButtonIdStartIndex = key.indexOf( dtButtonTag ) + dtButtonTag.length;
          var keyDtButtonIdPart = dtButtonTag
              + key.substring( keyDtButtonIdStartIndex, key.indexOf( ')', keyDtButtonIdStartIndex ) ) + ')' ;

          store.each( function( otherRecord ) {
            var otherKey = otherRecord.get( 'key' );

            if ( otherKey.includes( keyProcessPart )
                && otherKey.includes( keyVariableSetIdPart )
                && otherKey.includes( keyDtButtonIdPart )
                && otherKey.includes( '_DESC' )  ) {
              otherRecord.set( language, translation );

              this.storeTranslationToSave( otherKey, {
                language: language,
                translation: translation
              } );
            }
          }, this );
          break;
        default:
          break;
      }

      this.storeGlobalTranslationToSave( key, {
        globalType: globalType,
        language: language,
        translation: translation
      } );
    },
    storeTranslationToSave: function( key, keyTranslation ) {
    	var translations = this.toSave[key];
    	
    	if ( Ext.isEmpty( translations ) ) {
    		translations = new Array();
    	}
    	
    	translations.push( keyTranslation );
    	
    	this.toSave[key] = translations;
    },
    storeGlobalTranslationToSave: function( key, keyTranslation ) {
      var translations = this.globalsToSave[key];

      if ( Ext.isEmpty( translations ) ) {
        translations = new Array();
      }

      translations.push( keyTranslation );

      this.globalsToSave[key] = translations;
    },
    onFilterAfterRender: function( field ) {
    	field.getEl().on( 'keyup', function() {
            this.filterTranslations( field );
        }, this, {
            buffer: 500
        } );
    },
    filterTranslations: function( field ) {
    	var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();
    	var value = field.getValue();
    	var regex = new RegExp( Ext.escapeRe( value ), 'i' );
    	
    	var store = this.getStore();
        store.filterBy( function( record, id ) {
        	var found = false;
        	var toTest = new Array();
        	toTest.push( record.get( 'key' ) );
        	toTest.push( record.get( 'keyType' ) );
        	toTest.push( record.get( 'defaultValue' ) );
        	
        	Ext.each( supportedLanguages, function( language, index, languages ) {
        		toTest.push( record.get( language ) );
            } ); 
        	
    		Ext.each( toTest, function( one, index, all ) {
    			if ( regex.test( one ) ) {
    				found = true;
    				return false;
    			}
            } );
    		
    		return found;
    	} );
    },
    clearFilter: function() {
    	var searchItem = this.getTopToolbar().searchItem;
        var field = searchItem.items.first();
        field.setValue( '' );
        this.filterTranslations( field );
    },
    importTranslations: function() {
    	var win = new Ext.ux.suncode.ImportPackageI18NTranslationsWindow( {
    		translationsTable: this
    	} );
    	win.show();
    },
    importTranslation: function( translation ) {
      var store = this.getStore();
      var key = translation.key;
      var index = store.findExact( 'key', key );

      if ( index !== -1 ) {
        var tableTag = ')_TABLE(';
        var record = store.getAt( index );
        var local = record.get( 'local' );

        if ( !local ) {
          Ext.each( translation.translations, function( keyTranslation, index, allKeyTranslations ) {
            record.set( keyTranslation.language, keyTranslation.translation );

            if ( key.includes( tableTag ) ) {
              var globalType = '';

              if ( key.includes( '_DESC' ) ) {
                globalType = this.DT_BUTTON_TOOLTIP_GLOBAL_TYPE;
              } else if ( key.includes( ')_DTBUTTON(' ) ) {
                globalType = this.DT_BUTTON_NAME_GLOBAL_TYPE
              } else {
                globalType = this.TABLE_TITLE_GLOBAL_TYPE;
              }

              this.setGlobalTranslation( globalType, key, keyTranslation.language, keyTranslation.translation );
            } else {
              this.storeTranslationToSave( key, keyTranslation );
            }
          }, this );
        }
      }

      store.commitChanges();
    },
    exportTranslations: function() {
    	var packageNode = this.initialConfig.packageNode;
      var packageId = packageNode.attributes.packageId;
      var packageName = packageNode.attributes.packageName;
      var packageNameTranslation = getXpdlPackageNameTranslation( packageId, packageName );
    	var translations = new Array();
    	var store = this.getStore();
    	
    	Ext.each( store.getRange(), function( record, index, records ) {
        var local = record.get( 'local' );

        if ( !local ) {
          translations.push( record.data );
        }
    	} );
    	
    	var form = jQuery( '<form/>', { action: 'api/xpdl/exportTranslations', method:'post' } );
      form.append( jQuery( '<input>', { type: 'text', name: Suncode.getCsrfParameterName(), value: Suncode.getCsrfToken() } ) );
      form.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: packageNameTranslation } ) );
      form.append( jQuery( '<input>', { type: 'text', name: 'translations',
        value: LZString.compressToBase64( Ext.util.JSON.encode( translations ) ) } ) );

      var iframe = jQuery( '#download-frame' );
      iframe.empty();
      iframe.append( form );

      mainPanel.setCheckSavedOnUnload( false );

      form.submit();

      var task = new Ext.util.DelayedTask( function() {
          mainPanel.setCheckSavedOnUnload( true );
      }, this );
      task.delay( 2000 );
    }
} );

Ext.ux.suncode.ImportPackageI18NTranslationsWindow = function( config ) {
	config = Ext.apply( {
		modal: true,
		width: 400,
		autoHeight: true,
		title: getTranslation( 'Import tłumaczeń' ),
		disableCloseValidation: true,
		items: [ {
			xtype: 'form',
			fileUpload: true,
			standardSubmit: false,
			frame: false,
			border: false,
			bodyCssClass: 'x-Module-container-padding',
			autoHeight: true,
			buttonAlign: 'center',
			ref: 'filePanel',
			items: [ {
				xtype: 'fileuploadfield',
				emptyText: getTranslation( 'Wybierz plik' ),
				fieldLabel: getTranslation( 'Plik' ),
				name: 'file',
				buttonText: getTranslation( 'Wybierz' ),
				width: '100%',
                height: 42,
				autoWidth: true,
				allowBlank: false,
				blankText: getTranslation( 'Wybierz plik' ),
				regex: new RegExp( '.xls$|.xlsx$', 'i' ),
				regexText: getTranslation( 'Wybrany plik nie jest plikiem Excel.' )
			} ],
			buttons: [ {
				cls: 'x-btn-text',
				text: getTranslation( 'Importuj' ),
				handler: this.openTranslations,
				scope: this
			} ]
		} ]
	}, config );

	Ext.ux.suncode.ImportPackageI18NTranslationsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ImportPackageI18NTranslationsWindow, Ext.Window, {
	initComponent: function() {
		Ext.ux.suncode.ImportPackageI18NTranslationsWindow.superclass.initComponent.call( this );
	},
	openTranslations: function() {
		var form = this.filePanel.getForm();

		if ( form.isValid() ) {
			form.submit( {
				url: 'api/xpdl/importTranslations',
				waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
				waitTitle: getTranslation( 'Proszę czekać' ),
				method: 'POST',
				timeout: 600,
				scope: this,
				success: function( form, action ) {
					if ( action.result.success ) {
						this.close();
						
						this.importTranslations( action.result.translations ); 
					} else {
						showWarn( getTranslation( 'Wystąpił błąd.' ) );
					}
				},
				failure: function( form, action ) {
					showServerFailure( action.response );
				}
			} );
		}
	},
	importTranslations: function( translations ) {
		if ( !Ext.isEmpty( translations ) ) {
			var maskId = 'import_translations_mask';
	    	
	    	try {
	    		showLoadingMask( maskId, getTranslation( 'Trwa importowanie tłumaczeń...' ) );
	    		var translationsTable = this.initialConfig.translationsTable;
			
				Ext.each( translations, function( translation, index, allTranslations ) {
					Ext.each( translation.translations, function( keyTranslation, index, allKeyTranslations ) {
						Ext.apply( keyTranslation, {
							translation: decodeXpdlTranslations( keyTranslation.translation )
						} );
					}, this );
					
					translationsTable.importTranslation( translation );
				} );
	    	} finally {
	            removeLoadingMask( maskId );
	        }
			
			translationsTable.storeParentWindowAsUnsaved();
		}
	}
} );