Ext.ux.suncode.GlobalSettingsService = {
  defaults: {
    formVariableLabel: {
      labelAlign: '',
      labelWidth: null,
      labelSeparator: '',
      labelFontSize: null,
      labelColor: '',
      textDecoration: ''
    },
    label: {
      fontSize: null,
      color: ''
    },
    variableSetFont: {
      headerFontSize: null,
      cellFontSize: null
    }
  },
  getFormVariableLabelDefaults: function() {
    return this.defaults.formVariableLabel;
  },
  getLabelDefaults: function() {
    return this.defaults.label;
  },
  getVariableSetFontDefaults: function() {
    return this.defaults.variableSetFont;
  },
  setGlobalSettings: function( processGlobalSettings ) {
    var packagePanel = Ext.getCmp( 'package_panel' );

    Ext.each( processGlobalSettings, function( globalSettings, length, all ) {
      var processDefId = globalSettings.id;
      var processNode = packagePanel.findProcess( processDefId );

      if ( !Ext.isEmpty( processNode ) ) {
        delete globalSettings.id;
        processNode.loadGlobalSettings( globalSettings );
      }
    }, this );
  },
  resetGlobalSettings: function() {
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();

    if ( packageNode.hasChildNodes() ) {
      packageNode.eachChild( function( processNode ) {
        processNode.loadGlobalSettings( this.defaults );
      }, this );
    }
  }
};