Ext.ux.suncode.FormVariableLabelGlobalSettingsWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: getTranslation( 'Ustawienia globalne etykiety zmiennej formularza' ),
        items: [ new Ext.ux.suncode.FormVariableLabelGlobalSettingsPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.FormVariableLabelGlobalSettingsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormVariableLabelGlobalSettingsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.FormVariableLabelGlobalSettingsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.FormVariableLabelGlobalSettingsPanel = function( config ) {
	var processNode = config.processNode;
	var globalSettings = processNode.attributes.globalSettings.formVariableLabel;
	
    config = Ext.apply( {
    	layout: 'form',
        labelWidth: 200,
        autoHeight: true,
        border: false,
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        buttonAlign: 'center',
        items: [ {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'alignmentItem',
            fieldLabel: getTranslation( 'Wyrównanie etykiety' ),
            items: [ new Ext.ux.suncode.LabelAlignmentsChooser( {
            	flex: 1,
                value: globalSettings.labelAlign
            } ), {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setAlignment( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'widthItem',
            fieldLabel: getTranslation( 'Długość etykiety' ),
            items: [ {
            	xtype: 'numberfield',
            	flex: 1,
            	allowDecimals: false,
            	allowNegative: false,
              emptyText: getTranslation( 'Domyślna' ),
                value: globalSettings.labelWidth
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setWidth( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'separatorItem',
            fieldLabel: getTranslation( 'Separator etykiety' ),
            items: [ {
            	xtype: 'textfield',
            	flex: 1,
              emptyText: getTranslation( 'Domyślny' ),
                value: globalSettings.labelSeparator
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setSeparator( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'fontSizeItem',
            fieldLabel: getTranslation( 'Rozmiar czcionki' ),
            items: [ {
            	xtype: 'numberfield',
            	flex: 1,
                allowDecimals: false,
                allowNegative: false,
                emptyText: getTranslation( 'Domyślny' ),
                value: globalSettings.labelFontSize
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setFontSize( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'colorItem',
            fieldLabel: getTranslation( 'Kolor' ),
            items: [ {
                xtype: 'textfield',
                emptyText: getTranslation( 'Domyślny' ),
                flex: 1,
                style: 'background: ' + globalSettings.labelColor + ';',
                color: globalSettings.labelColor,
                readOnly: true,
                value: !Ext.isEmpty( globalSettings.labelColor ) ? ' ' : ''
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'color_wheel' ),
                tooltip: getTranslation( 'Wybierz kolor' ),
                flex: 0,
                handler: this.chooseLabelColor,
                scope: this
            }, {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setColor( true );
                },
                scope: this
            } ]
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'textDecorationItem',
            fieldLabel: getTranslation( 'Dekoracja tekstu' ),
            items: [ new Ext.ux.suncode.TextDecorationsChooser( {
            	flex: 1,
                value: globalSettings.textDecoration
            } ), {
                xtype: 'button',
                cls: 'x-btn-text',
                text: getTranslation( 'Ustaw' ),
                flex: 0,
                handler: function() {
                	this.setTextDecoration( true );
                },
                scope: this
            } ]
        } ],
        buttons: [ {
        	cls: 'x-btn-text',
            text: getTranslation( 'Ustaw wszystkie' ),
            handler: this.setAll,
            scope: this
        }, {
        	cls: 'x-btn-text',
            text: getTranslation( 'Przywróć domyślne' ),
            handler: this.restoreDefaults,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.FormVariableLabelGlobalSettingsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormVariableLabelGlobalSettingsPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.FormVariableLabelGlobalSettingsPanel.superclass.initComponent.call( this );
    },
    setAlignment: function( showMsg ) {
    	var field = this.alignmentItem.items.first();
    	var value = field.getValue();
    	
    	this.setSetting( 'labelAlign', value, showMsg );
    },
    setWidth: function( showMsg ) {
    	var field = this.widthItem.items.first();
    	var value = field.getValue();
      value = !Ext.isEmpty( value ) ? value : null;
    	
    	this.setSetting( 'labelWidth', value, showMsg );
    },
    setSeparator: function( showMsg ) {
    	var field = this.separatorItem.items.first();
    	var value = field.getValue();
    	
    	this.setSetting( 'labelSeparator', value, showMsg );
    },
    setFontSize: function( showMsg ) {
    	var field = this.fontSizeItem.items.first();
    	var value = field.getValue();
      value = !Ext.isEmpty( value ) ? value : null;
    	
    	this.setSetting( 'labelFontSize', value, showMsg );
    },
    chooseLabelColor: function( button, e ) {
        closeColorChooser();

        var me = this;
        var labelColorField = this.colorItem.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor etykiety' ),
            e: e,
            color: labelColorField.color,
            saveFunction: function( choosenColor ) {
                labelColorField.getEl().setStyle( 'background', choosenColor );
                labelColorField.color = choosenColor;
                labelColorField.setValue(' ');
                me.storeParentWindowAsUnsaved();
            }
        } );
        colorChooser.show();
    },
    setColor: function( showMsg ) {
    	var field = this.colorItem.items.first();
    	var value = field.color;
    	
    	this.setSetting( 'labelColor', value, showMsg );
    },
    setTextDecoration: function( showMsg ) {
    	var field = this.textDecorationItem.items.first();
    	var value = field.getValue();
    	
    	this.setSetting( 'textDecoration', value, showMsg );
    },
    setSetting: function( settingName, settingValue, showMsg ) {
    	var processNode = this.initialConfig.processNode;
    	var globalSettings = processNode.attributes.globalSettings.formVariableLabel;

      globalSettings[settingName] = settingValue;
    	
    	processNode.eachChild( function( activityNode ) {
    		var template = activityNode.attributes.form.template;
            
    		if ( !Ext.isEmpty( template.rows ) ) {
    			Ext.each( template.rows, function( row, outerIndex, rows ) {
    				Ext.each( row.items, function( item, innerIndex, items ) {
    					if ( item.type !== 'LABEL' && Ext.isDefined( item[settingName] ) ) {
    						item[settingName] = settingValue;
    					}
        			} );
    			} );
    	    }
        } );
    	
    	if ( showMsg ) {
    		Ext.getCmp( 'main_panel' ).setSaved( false );
    		this.showSuccessMessage( getTranslation( 'Zmieniono ustawienie.' ) );
    	}
    },
    setAll: function() {
    	this.setAlignment( false );
    	this.setWidth( false );
    	this.setSeparator( false );
    	this.setFontSize( false );
    	this.setColor( false );
    	this.setTextDecoration( false );
    	Ext.getCmp( 'main_panel' ).setSaved( false );
    	this.showSuccessMessage( getTranslation( 'Zmieniono ustawienia.' ) );
    },
    showSuccessMessage: function( msg ) {
    	Ext.Msg.show( {
            title: getTranslation( 'Zmiana zakończona sukcesem' ),
            msg: msg,
            buttons: Ext.Msg.OK,
            icon: Ext.Msg.INFO
        } );
    },
    restoreDefaults: function() {
    	var defaults = Ext.ux.suncode.GlobalSettingsService.getFormVariableLabelDefaults();
    	this.alignmentItem.items.first().setValue( defaults.labelAlign );
    	this.widthItem.items.first().setValue( defaults.labelWidth );
    	this.separatorItem.items.first().setValue( defaults.labelSeparator );
    	this.fontSizeItem.items.first().setValue( defaults.labelFontSize );
    	this.colorItem.items.first().getEl().setStyle( 'background', defaults.labelColor );
    	this.colorItem.items.first().color = defaults.labelColor;
    	this.textDecorationItem.items.first().setValue( defaults.textDecoration );
    }
} );