Ext.ux.suncode.ProjectExclusionSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var projectExclusion = config.projectExclusion;
    var winTitle = projectExclusion ? getTranslation( 'Definicja wyłączenia z projektu' ) + ' ' + projectExclusion.name
                    : getTranslation( 'Kreator wyłączenia z projektu' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ProjectExclusionSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ProjectExclusionSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProjectExclusionSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProjectExclusionSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.projectExclusionSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ProjectExclusionSpecificationPanel = function( config ) {
    config = Ext.apply( {
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'projectExclusionSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Treść' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'contents',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ProjectExclusionSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProjectExclusionSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProjectExclusionSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var projectExclusion = this.initialConfig.projectExclusion;

        if ( !Ext.isEmpty( projectExclusion ) ) {
            this.getForm().setValues( projectExclusion );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var projectExclusion = panel.projectExclusion;

        if ( !Ext.isEmpty( projectExclusion ) && projectExclusion.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getProjectExclusion( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Wyłączenie z projektu już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var projectExclusion = this.initialConfig.projectExclusion;
            var def = form.getValues();

            if ( saveToObj && varRecord ) {
                if ( projectExclusion ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'contents', def.contents );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        contents: def.contents
                    } ) );
                    store.commitChanges();
                }
            }

            if ( projectExclusion ) {
                Ext.ux.suncode.DocumentationService.editProjectExclusion( processNode, projectExclusion.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addProjectExclusion( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );