Ext.ux.suncode.IntegrationSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var integration = config.integration;
    var winTitle = integration ? getTranslation( 'Definicja integracji' ) + ' ' + integration.name : getTranslation( 'Kreator integracji' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.IntegrationSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.integrationSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationSpecificationPanel = function( config ) {
    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'integrationSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
            xtype: 'textfield',
            name: 'systemName',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa systemu' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'textfield',
            name: 'purpose',
            anchor: '100%',
            fieldLabel: getTranslation( 'Cel' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'textfield',
            name: 'integrationMethod',
            anchor: '100%',
            fieldLabel: getTranslation( 'Metoda integracji' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.IntegrationSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var integration = this.initialConfig.integration;

        if ( !Ext.isEmpty( integration ) ) {
            this.getForm().setValues( integration );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var integration = panel.integration;

        if ( !Ext.isEmpty( integration ) && integration.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getIntegration( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Integracja już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var integration = this.initialConfig.integration;
            var def = form.getValues();

            if ( saveToObj && varRecord ) {
                if ( integration ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'systemName', def.systemName );
                    varRecord.set( 'integrationMethod', def.integrationMethod );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        systemName: def.systemName,
                        integrationMethod: def.integrationMethod
                    } ) );
                    store.commitChanges();
                }
            }

            if ( integration ) {
                Ext.ux.suncode.DocumentationService.editIntegration( processNode, integration.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addIntegration( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );