Ext.ux.suncode.DocumentLinkSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var documentLink = config.documentLink;
    var winTitle = documentLink ? getTranslation( 'Definicja zestawu dokumentów' ) + ' ' + documentLink.name
                    : getTranslation( 'Kreator zestawu dokumentów' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.DocumentLinkSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.DocumentLinkSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentLinkSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DocumentLinkSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.documentLinkSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.DocumentLinkSpecificationPanel = function( config ) {
    config = Ext.apply( {
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'documentLinkSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.DocumentLinkSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentLinkSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DocumentLinkSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var documentLink = this.initialConfig.documentLink;

        if ( !Ext.isEmpty( documentLink ) ) {
            this.getForm().setValues( documentLink );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var documentLink = panel.documentLink;

        if ( !Ext.isEmpty( documentLink ) && documentLink.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getDocumentLink( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Zestaw dokumentów już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var documentLink = this.initialConfig.documentLink;
            var def = form.getValues();

            if ( saveToObj && varRecord ) {
                if ( documentLink ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'description', def.description );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        description: def.description
                    } ) );
                    store.commitChanges();
                }
            }

            if ( documentLink ) {
                Ext.ux.suncode.DocumentationService.editDocumentLink( processNode, documentLink.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addDocumentLink( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );