Ext.ux.suncode.DocumentClassSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var documentClass = config.documentClass;
    var winTitle = documentClass ? getTranslation( 'Definicja klasy dokumentów' ) + ' ' + documentClass.name
                    : getTranslation( 'Kreator klasy dokumentów' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.DocumentClassSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.DocumentClassSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentClassSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DocumentClassSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.documentClassSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.DocumentClassSpecificationPanel = function( config ) {
    config = Ext.apply( {
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'documentClassSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.DocumentClassSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DocumentClassSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DocumentClassSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var documentClass = this.initialConfig.documentClass;

        if ( !Ext.isEmpty( documentClass ) ) {
            this.getForm().setValues( documentClass );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var documentClass = panel.documentClass;

        if ( !Ext.isEmpty( documentClass ) && documentClass.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getDocumentClass( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Klasa dokumentów już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var documentClass = this.initialConfig.documentClass;
            var def = form.getValues();

            if ( saveToObj && varRecord ) {
                if ( documentClass ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'description', def.description );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        description: def.description
                    } ) );
                    store.commitChanges();
                }
            }

            if ( documentClass ) {
                Ext.ux.suncode.DocumentationService.editDocumentClass( processNode, documentClass.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addDocumentClass( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );