Ext.ux.suncode.DatabaseTableSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var databaseTable = config.databaseTable;
    var winTitle = databaseTable ? getTranslation( 'Definicja tabeli' ) + ' ' + databaseTable.name : getTranslation( 'Kreator tabeli' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.DatabaseTableSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.DatabaseTableSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DatabaseTableSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DatabaseTableSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.databaseTableSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.DatabaseTableSpecificationPanel = function( config ) {
    var processNode = config.processNode;
    var databaseTable = config.databaseTable;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'databaseTableSpecificationPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, new Ext.ux.suncode.DatabaseTypesChooser(), {
            xtype: 'textfield',
            name: 'location',
            anchor: '100%',
            fieldLabel: getTranslation( 'Lokalizacja' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, {
            xtype: 'checkbox',
            name: 'addedFromAdministration',
            anchor: '100%',
            inputValue: 'true',
            height: 50,
            fieldLabel: getTranslation( 'Wprowadzana przez menu administratora systemu' )
        }, {
            xtype: 'panel',
            layout: 'accordion',
            layoutConfig: {
                animate: animationsOn,
                fill: false
            },
            style: {
                marginBottom: '5px'
            },
            bodyStyle: {
                border: 0
            },
            items: [ new Ext.ux.suncode.DatabaseTableColumnsPanel( config ), new Ext.ux.suncode.UtilizationInActivitiesPanel( {
                processNode: processNode,
                ref: '../utilizationInActivitiesPanel',
                utilizationInActivities: databaseTable ? databaseTable.utilizationInActivities : []
            } ) ]
        } ]
    }, config );

    Ext.ux.suncode.DatabaseTableSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DatabaseTableSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DatabaseTableSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var databaseTable = this.initialConfig.databaseTable;

        if ( !Ext.isEmpty( databaseTable ) ) {
            this.getForm().setValues( databaseTable );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var databaseTable = panel.databaseTable;

        if ( !Ext.isEmpty( databaseTable ) && databaseTable.name === value ) {
            return true;
        } else {
            var object = Ext.ux.suncode.DocumentationService.getDatabaseTable( processNode, value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Tabela już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();
        var isValid = form.isValid();

        if ( form.isValid() && this.columnsPanel.isValid() && this.utilizationInActivitiesPanel.isValid() ) {
            var processNode = this.initialConfig.processNode;
            var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var databaseTable = this.initialConfig.databaseTable;
            var def = form.getValues();
            if ( Ext.isEmpty( def.addedFromAdministration ) ) {
                def = Ext.apply( {
                    addedFromAdministration: 'false'
                }, def );
            }
            def = Ext.apply( {
                columns: this.columnsPanel.readColumns(),
                utilizationInActivities: this.utilizationInActivitiesPanel.readUtilizationInActivities()
            }, def );

            if ( saveToObj && varRecord ) {
                if ( databaseTable ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'databaseType', def.databaseType );
                    varRecord.set( 'location', def.location );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        databaseType: def.databaseType,
                        location: def.location
                    } ) );
                    store.commitChanges();
                }
            }

            if ( databaseTable ) {
                Ext.ux.suncode.DocumentationService.editDatabaseTable( processNode, databaseTable.name, def );
            } else {
                Ext.ux.suncode.DocumentationService.addDatabaseTable( processNode, def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );

Ext.ux.suncode.DatabaseTypesChooser = function() {
    var config = new Object();
    var types = [ [ 'PostgreSQL' ], [ 'Oracle' ], [ 'Microsoft SQL Server' ], [ 'MySQL' ], [ 'DB2' ], [ 'Firebird' ], [ 'H2' ], [ 'Sybase' ] ];

    config = Ext.apply( {
        name: 'databaseType',
        anchor: '100%',
        fieldLabel: getTranslation( 'Typ bazy danych' ),
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'type' ],
            data: types
        } ),
        valueField: 'type',
        displayField: 'type',
        resizable: true,
        allowBlank: false,
        blankText: getTranslation( 'Pole jest wymagane' )
    }, config );

    Ext.ux.suncode.DatabaseTypesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DatabaseTypesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.DatabaseTypesChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.DatabaseTableColumnsPanel = function( config ) {
    var databaseTable = config.databaseTable;

    var store = new Ext.data.Store( {
        data: databaseTable ? databaseTable.columns : [],
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            } ] )
        } )
    } );

    config = Ext.apply( {
        title: getTranslation( 'Kolumny' ),
        ref: '../columnsPanel',
        height: 200,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableColumnMove: true,
        collapsed: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                editor: {
                    xtype: 'textfield'
                }
            }, {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editor: {
                    xtype: 'textfield'
                }
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editor: {
                    xtype: 'textarea'
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak kolumn' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj kolumnę' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        name: '',
                        type: '',
                        description: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń kolumnę' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz kolumnę do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            validateedit: function( e ) {
                var grid = e.grid;
                var store = grid.getStore();
                var cm = grid.getColumnModel();
                var colIndex = e.column;
                var value = e.value;

                if ( cm.getColumnId( colIndex ) == 'name' && !Ext.isEmpty( value ) && store.findExact( 'name', value ) != -1 ) {
                    showWarn( getTranslation( 'Kolumna została już dodana.' ) );
                    return false;
                }
            },
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.DatabaseTableColumnsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DatabaseTableColumnsPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.DatabaseTableColumnsPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = true
        var store = this.getStore();

        if ( store.getCount() == 0 ) {
            showWarn( getTranslation( 'Zdefiniuj kolumny.' ) );
            valid = false;
        } else {
            store.each( function( rec ) {
                var name = rec.get( 'name' );
                var type = rec.get( 'type' );

                if ( Ext.isEmpty( name ) ) {
                    showWarn( getTranslation( 'Podaj nazwę wszystkich kolumn.' ) );
                    valid = false;
                    return false;
                } else if ( Ext.isEmpty( type ) ) {
                    showWarn( getTranslation( 'Określ typ dla kolumny o nazwie' ) + ': ' + name + '.' );
                    valid = false;
                    return false;
                }
            } );
        }

        return valid;
    },
    readColumns: function() {
        var columns = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            columns.push( {
                name: rec.get( 'name' ),
                type: rec.get( 'type' ),
                description: rec.get( 'description' )
            } );
        } );

        return columns;
    }
} );