Ext.ux.suncode.AttachmentSpecificationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var attachment = config.attachment;
    var winTitle = attachment ? getTranslation( 'Definicja załącznika' ) + ' ' + attachment.name
                    : getTranslation( 'Kreator załącznika' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.AttachmentSpecificationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.AttachmentSpecificationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AttachmentSpecificationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.AttachmentSpecificationWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.attachmentSpecificationPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.AttachmentSpecificationPanel = function( config ) {
    var processNode = config.processNode;
    var attachmentDirectory = processNode.attributes.attachmentDirectory;

    config = Ext.apply( {
        fileUpload: true,
        standardSubmit: false,
        labelWidth: 250,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'attachmentSpecificationPanel',
        items: [ {
          xtype: 'textfield',
          name: 'id',
          hidden: true
        }, {
          xtype: 'textfield',
          name: 'name',
          anchor: '100%',
          fieldLabel: getTranslation( 'Nazwa' ),
          allowBlank: false,
          blankText: getTranslation( 'Pole jest wymagane' ),
          validator: this.validateName,
          listeners: {
            scope: this,
            blur: function( field ) {
              var name = field.getValue();
              var id = generateId( name );

              var idField = this.getForm().findField( 'id' )
              idField.setValue( id );
            }
          }
        }, {
          xtype: 'fileuploadfield',
          emptyText: getTranslation( 'Wybierz plik' ),
          fieldLabel: getTranslation( 'Załącznik' ),
          name: 'file',
          buttonText: getTranslation( 'Wybierz' ),
          width: '100%',
          height: 42,
          autoWidth: true,
          allowBlank: false,
          blankText: getTranslation( 'Wybierz plik' ),
          validator: this.validateFileName
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        }, {
          xtype: 'textfield',
          name: 'attachmentDirectory',
          hidden: true,
          value: attachmentDirectory
        } ]
    }, config );

    Ext.ux.suncode.AttachmentSpecificationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AttachmentSpecificationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AttachmentSpecificationPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var attachment = this.initialConfig.attachment;

        if ( !Ext.isEmpty( attachment ) ) {
            this.getForm().setValues( attachment );
        }
    },
    validateName: function( value ) {
        var id = generateId( value );
        var panel = this.ownerCt;
        var processNode = panel.processNode;
        var attachment = panel.attachment;

        if ( !Ext.isEmpty( attachment ) && attachment.id === id ) {
          return true;
        } else {
          var object = Ext.ux.suncode.DocumentationService.getAttachment( processNode, id );

          if ( !Ext.isEmpty( object ) ) {
            return getTranslation( 'Załącznik już istnieje.' );
          } else {
            return true;
          }
        }
    },
    validateFileName: function( value ) {
      value = value.slice( value.lastIndexOf( '\\' ) + 1 );
      value = value.slice( value.lastIndexOf( '/' ) + 1 );

      var panel = this.ownerCt;
      var processNode = panel.processNode;
      var attachment = panel.attachment;

      if ( !Ext.isEmpty( attachment ) ) {
        if ( attachment.fileName === value ) {
          return true;
        } else {
          return getTranslation( 'Nazwa pliku nie może zostać zmieniona.' );
        }
      } else {
        var object = Ext.ux.suncode.DocumentationService.getAttachmentByFileName( processNode, value );

        if ( !Ext.isEmpty(object) ) {
          return getTranslation( 'Załącznik już istnieje.' );
        } else {
          return true;
        }
      }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
          form.submit( {
            url: 'api/documentation/addAttachment',
            waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
            waitTitle: getTranslation( 'Proszę czekać' ),
            method: 'POST',
            timeout: 600,
            scope: this,
            success: function( form, action ) {
              if ( action.result.success ) {
                var result = action.result;
                var processNode = this.initialConfig.processNode;
                var saveToObj = this.initialConfig.saveTo;
                var varRecord = this.initialConfig.varRecord;
                var attachment = this.initialConfig.attachment;

                if ( saveToObj && varRecord ) {
                  if ( attachment ) {
                    varRecord.set( 'id', result.id );
                    varRecord.set( 'name', result.name );
                    varRecord.set( 'fileName', result.fileName );
                    varRecord.set( 'description', result.description );
                    varRecord.commit();
                  } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                      id: result.id,
                      name: result.name,
                      fileName: result.fileName,
                      description: result.description
                    } ) );
                    store.commitChanges();
                  }
                }

                if ( attachment ) {
                  Ext.ux.suncode.DocumentationService.editAttachment( processNode, attachment.id, result );
                } else {
                  Ext.ux.suncode.DocumentationService.addAttachment( processNode, result );
                }

                this.ownerCt.closeWindow();
              } else {
                showWarn( getTranslation( 'Wystąpił błąd.' ) );
              }
            },
            failure: function( form, action ) {
              showServerFailure( action.response );
            }
          } );
        }
    }
} );

function downloadAttachment( attachmentDirectory, attachmentFileName ) {
  var form = jQuery( '<form/>', { action: 'api/documentation/downloadAttachment', method:'post' } );
  form.append( jQuery( '<input>', { type: 'text', name: Suncode.getCsrfParameterName(), value: Suncode.getCsrfToken() } ) );
  form.append( jQuery( '<input>', { type: 'text', name: 'attachmentDirectory', value: attachmentDirectory } ) );
  form.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: attachmentFileName } ) );

  var iframe = jQuery( '#download-frame' );
  iframe.empty();
  iframe.append( form );

  var mainPanel = Ext.getCmp( 'main_panel' );
  mainPanel.setCheckSavedOnUnload( false );

  form.submit();

  var task = new Ext.util.DelayedTask( function() {
    mainPanel.setCheckSavedOnUnload( true );
  }, this );
  task.delay( 1000 );
}