Ext.ux.suncode.FunctionPreviewMenu = function( config ) {
	var viewSize = Ext.getBody().getViewSize();
	
    config = Ext.apply( {
    	maxHeight: viewSize.height * 0.8,
        items: [ new Ext.ux.suncode.FunctionPreviewPanel( config ) ]
    }, config );

    Ext.ux.suncode.FunctionPreviewMenu.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionPreviewMenu, Ext.menu.Menu, {
    initComponent: function() {
        Ext.ux.suncode.FunctionPreviewMenu.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.FunctionPreviewPanel = function( config ) {
	var mainPanel = Ext.getCmp( 'main_panel' );
	var functionConfig = {
		getVariableNameFunction: config.getVariableNameFunction,
        getVariableNameScope: config.getVariableNameScope
    };
    
    config = Ext.apply( {
        useArrows: true,
        animate: mainPanel.getAnimationsOn(),
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-whiteBody x-Module-functionPreviewPanelPadding',
        root: new Ext.tree.AsyncTreeNode( this.buildFunctionChild( config.value, config.inArray, functionConfig ) )
    }, config );

    Ext.ux.suncode.FunctionPreviewPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FunctionPreviewPanel, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.FunctionPreviewPanel.superclass.initComponent.call( this );
    },
    FUNCTION_TYPE: 'function',
    VARIABLE_TYPE: 'variable',
    buildFunctionChild: function( value, inArray, functionConfig ) {
    	var parameters = value.value.parameters;
      var parameterTypes = value.value.parameterTypes;
    	var emptyParameters = Ext.isEmpty( parameters );
    	
    	return {
            text: value.value.name,
            icon: getPluginImgPath( 'function' ),
            expanded: !emptyParameters,
            leaf: emptyParameters,
            children: this.buildChildren( parameters, parameterTypes, functionConfig ),
            value: value,
            inArray: inArray,
            listeners: {
            	scope: this,
            	dblclick: this.editFunction
            }
        };
    },
    buildChildren: function( parameters, parameterTypes, functionConfig ) {
      var children = new Array();

      if ( Ext.isArray( parameters ) ) {
        Ext.each(parameters, function (parameter, index, allParameters) {
          var inArray = parameterTypes[index].array;
          var child = this.buildChild(parameter, inArray, functionConfig);
          children.push(child);
        }, this);
      }

      return children;
    },
    buildChild: function( parameter, inArray, functionConfig ) {
    	if ( Ext.isArray( parameter ) ) {
    	  var parameterTypes = new Array();

    	  for ( var i = 0; i < parameter.length; i++ ) {
          parameterTypes.push( {
            array: inArray
          } );
        }

    		return this.buildTableChild( parameter, parameterTypes, functionConfig );
    	} else {
    		switch ( parameter.type ) {
	        	case this.VARIABLE_TYPE:
	        		return this.buildLeafChild(
	        				this.getVariableName( parameter.value, functionConfig ), getPluginImgPath( 'variable' ) );
	            case this.FUNCTION_TYPE:
	            	return this.buildFunctionChild( parameter, inArray, functionConfig );
	            default:
	            	return this.buildLeafChild( parameter.value, getPluginImgPath( 'text' ) );
	    	}
    	}
    },
    buildTableChild: function( parameter, parameterType, functionConfig ) {
    	return {
            icon: getPluginImgPath( 'table' ),
            expanded: true,
            leaf: false,
            noIndent: true,
            children: this.buildChildren( parameter, parameterType, functionConfig )
        };
    },
    getVariableName: function( id, functionConfig ) {
    	var getVariableNameFunction = functionConfig.getVariableNameFunction;
		
      if ( Ext.isFunction( getVariableNameFunction ) ) {
        var getVariableNameScope = !Ext.isEmpty( functionConfig.getVariableNameScope ) ?
            functionConfig.getVariableNameScope : window;
        return getVariableNameFunction.apply( getVariableNameScope, [ id ] );
      } else {
        return '';
      }
    },
    buildLeafChild: function( text, icon ) {
    	return {
        	text: text,
        	icon: icon,
        	leaf: true
        };
    },
    editFunction: function( node, e ) {
    	if ( !node.isLeaf() ) {
    		var menu = this.ownerCt;
    		var menuPosition = menu.getPosition();
    		var value = node.attributes.value;
    		var functionName = value.value.name;
    		var functionParameterTypes = value.value.parameterTypes;
        var systemFunction = mainPanel.getSystemFunction( functionName, functionParameterTypes );

        if ( !Ext.isEmpty( systemFunction ) ) {
          var win = new Ext.ux.suncode.FunctionParametersWindow( {
            functionName: functionName,
            functionParameterTypes: functionParameterTypes,
            contextVariables: this.initialConfig.contextVariables,
            processNode: this.initialConfig.processNode,
            returnType: systemFunction.returnType,
            inArray: node.attributes.inArray,
            accessibility: this.initialConfig.accessibility,
            availableVariables: this.initialConfig.availableVariables,
            currentParameters: value.value.parameters,
            xPos: menuPosition[0],
            y: menuPosition[1],
            saveFunction: function( name, parameters, parameterTypes ) {
              value.value = Ext.apply( value.value, {
                name: name,
                parameters: parameters,
                parameterTypes: parameterTypes
              } );
              var customField = this.initialConfig.customField;
              var setFunctionFunc = customField.setFunction;

              if ( Ext.isFunction( setFunctionFunc ) ) {
                var initialValue = this.initialConfig.value;
                setFunctionFunc.apply( customField,
                    [ initialValue.value.name, initialValue.value.parameters, initialValue.value.parameterTypes ] );
              }
            },
            saveScope: this,
            listeners: {
              show: function( win ) {
                fitWindowToView( win, function( x ) {
                  return ( Ext.getBody().getWidth() - win.getWidth() );
                }, function( y ) {
                  return ( y - win.getHeight() - 25 );
                } );
              }
            }
          } );
          win.show();
        } else {
          showWarn( getTranslation( 'Funkcja nie jest dostępna w systemie.' ) );
        }

        menu.destroy();
    	}
    }
} );