Ext.ux.suncode.CustomFormBooleanChooser = function( config ) {
	var store = new Ext.data.Store( {
		data: [ {
			value: true,
			text: getTranslation( 'Tak' )
		}, {
			value: false,
			text: getTranslation( 'Nie' )
		} ],
		reader : new Ext.data.JsonReader( {
			fields : Ext.data.Record.create( [ {
				name : 'value',
				type : 'boolean'
			}, {
				name : 'text',
				type : 'string'
			} ] )
		} )
	} );

	config = Ext.apply( {
		triggerAction : 'all',
		mode : 'local',
		store : store,
		valueField : 'value',
		displayField : 'text',
		flex : 1,
		resizable : true
	}, config );

	Ext.ux.suncode.CustomFormBooleanChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CustomFormBooleanChooser, Ext.form.ComboBox, {
	initComponent : function() {
		Ext.ux.suncode.CustomFormBooleanChooser.superclass.initComponent.call( this );
	},
	setValue: function( v ) {
		var text = v;
		
		if ( v === false || v === true ) {
			if ( this.valueField ) {
	            var r = this.findRecord( this.valueField, v );
	            
	            if ( r ) {
	                text = r.data[this.displayField];
	            } else if ( Ext.isDefined( this.valueNotFoundText ) ) {
	                text = this.valueNotFoundText;
	            }
	        }
	        
			this.lastSelectionText = text;
	        
			if( this.hiddenField ){
	            this.hiddenField.value = Ext.value( v, '' );
	        }
		}
		
		Ext.form.ComboBox.superclass.setValue.call( this, text );
		this.value = v;
		
		return this;
    }
} );