Ext.ux.suncode.CodeEditor = function( config ) {
    config = Ext.apply( {
        height: Ext.getBody().getViewSize().height * 0.5,
        frame: false,
        html: '<div class="x-Module-codeEditor"/>',
        codeEditor: null,
        errorCode: null
    }, config );

    Ext.ux.suncode.CodeEditor.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CodeEditor, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.CodeEditor.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var me = this;
        me.getEl().on( 'contextmenu', me.onContextMenu, me );
        var div = this.getEl().child( 'div.x-Module-codeEditor' );
        var codeEditor = ace.edit( div.id );
        codeEditor.setTheme( "ace/theme/eclipse" );
        codeEditor.setShowPrintMargin( false );
        codeEditor.getSession().setMode( 'ace/mode/' + me.initialConfig.codeMode );
        codeEditor.setOptions( {
            enableBasicAutocompletion: true,
            enableSnippets: true,
            enableLiveAutocompletion: false
        } );
        codeEditor.on( 'focus', function( e ) {
            me.unmarkErrorCode();
        } );
        Ext.apply( me, {
            codeEditor: codeEditor
        } );
    },
    onContextMenu: function( e ) {
        e.stopEvent();
        showMenu( new Ext.ux.suncode.GlobalMenu( {
            valueUser: this
        } ), e );
    },
    handleGlobalMenuValue: function( value ) {
        this.codeEditor.insert( value );
    },
    getCode: function() {
        return this.codeEditor.getValue();
    },
    setCode: function( code ) {
        this.codeEditor.setValue( code );
    },
    markErrorCode: function( startRow, startColumn, endRow, endColumn ) {
        var Range = ace.require( 'ace/range' ).Range;
        var marker = new Range( startRow, startColumn, endRow, endColumn );
        this.errorCode = this.codeEditor.getSession().addMarker( marker, 'x-Module-codeEditorErrorCode' );
    },
    unmarkErrorCode: function() {
        if ( !Ext.isEmpty( this.errorCode ) ) {
            this.codeEditor.getSession().removeMarker( this.errorCode );
            this.errorCode = null;
        }
    }
} );