Ext.ux.suncode.AddPermissionWindow = function( config ) {
    config = config ? config : new Object();
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: getTranslation( 'Dodawanie uprawnienia' ),
        items: [ new Ext.ux.suncode.AddPermissionPanel( {
            windowWidth: windowWidth,
            permissionTable: config.permissionTable
        } ) ],
        closable: true,
        shadow: false,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                scope: this,
                handler: this.saveForm
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                scope: this,
                handler: this.closeWindow
            } ]
        } )
    }, config );

    Ext.ux.suncode.AddPermissionWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AddPermissionWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.AddPermissionWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.getComponent( 'add-permission-panel' ).saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.AddPermissionPanel = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        itemId: 'add-permission-panel',
        labelWidth: config.windowWidth * 0.4,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        items: [ new Ext.ux.suncode.PermissionScopesChooser( {
            hiddenName: 'scope',
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            listeners: {
                scope: this,
                select: this.addValueField
            }
        } ) ]
    }, config );

    Ext.ux.suncode.AddPermissionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AddPermissionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AddPermissionPanel.superclass.initComponent.call( this );
    },
    addValueField: function( combo, record, index ) {
        var scope = combo.getValue();

        if ( combo.isValid() && !Ext.isEmpty( scope ) ) {
            this.removeValueField();

            switch ( scope ) {
                case 'USER':
                    this.add( new Ext.ux.suncode.UsersChooser( {
                        hiddenName: 'value',
                        allowBlank: false,
                        blankText: getTranslation( 'Pole jest wymagane' ),
                        isValueField: true
                    } ) );
                    break;
                case 'GROUP':
                    this.add( new Ext.ux.suncode.UserGroupsChooser( {
                        hiddenName: 'value',
                        allowBlank: false,
                        blankText: getTranslation( 'Pole jest wymagane' ),
                        isValueField: true
                    } ) );
                    break;
                default:
                    break;
            }

            this.doLayout();
        }
    },
    removeValueField: function() {
        Ext.each( this.items.items, function( item, index, items ) {
            if ( item.isValueField === true ) {
                this.remove( item );
                this.doLayout();
                return false;
            }
        }, this );
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            form.submit( {
                url: Suncode.context( 'pwe' ).pluginContextPath + '/api/permission/add',
                method: 'POST',
                scope: this,
                success: function( form, action ) {
                    var result = Ext.util.JSON.decode( action.response.responseText ).data;

                    if ( result.executed ) {
                        var permissionTable = this.initialConfig.permissionTable;

                        if ( !Ext.isEmpty( permissionTable ) ) {
                            permissionTable.refresh();
                        }

                        this.ownerCt.closeWindow();
                    } else {
                        showWarn( getTranslation( result.executionError ) );
                    }
                },
                failure: function( form, action ) {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            } );
        }
    }
} );

Ext.ux.suncode.UsersChooser = function( config ) {
    config = config ? config : new Object();
    var record = Ext.data.Record.create( [ {
        name: 'userId',
        type: 'string'
    }, {
        name: 'firstName',
        type: 'string'
    }, {
        name: 'lastName',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: Suncode.context( 'pwe' ).pluginContextPath + '/api/user/get'
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        totalProperty: 'total',
        baseParams: {
            start: 0,
            limit: 20
        }
    } );

    var tpl = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font class="x-Module-comboTemplateFont"><b>'
                    + getTranslation( 'Login' ) + ': ' + '</b></font><span>{userId}</span></div>',
                    '<div><font class="x-Module-comboTemplateFont"><b>' + getTranslation( 'Imię' ) + ': '
                                    + '</b></font><span>{firstName}</span></div>', '<div><font class="x-Module-comboTemplateFont"><b>'
                                    + getTranslation( 'Nazwisko' ) + ': ' + '</b></font><span>{lastName}</span></div></div>',
                    '<tpl if="xindex !== xcount">', '<hr class="x-Module-comboTemplateHr">', '</tpl>', '</tpl>' );

    config = Ext.apply( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Użytkownik' ),
        triggerAction: 'all',
        mode: 'remote',
        tpl: tpl.compile(),
        itemSelector: 'div.x-Module-comboTemplateItem',
        minChars: 0,
        store: store,
        displayField: 'userId',
        valueField: 'userId',
        forceSelection: true,
        resizable: true,
        pageSize: 20
    }, config );

    Ext.ux.suncode.UsersChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.UsersChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.UsersChooser.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.UserGroupsChooser = function( config ) {
    config = config ? config : new Object();
    var record = Ext.data.Record.create( [ {
        name: 'name',
        type: 'string'
    }, {
        name: 'description',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: Suncode.context( 'pwe' ).pluginContextPath + '/api/usergroup/get'
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        totalProperty: 'total',
        baseParams: {
            start: 0,
            limit: 20
        }
    } );

    var tpl = new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font class="x-Module-comboTemplateFont"><b>'
                    + getTranslation( 'Nazwa' ) + ': ' + '</b></font><span>{name}</span></div>', '<div><font class="x-Module-comboTemplateFont"><b>'
                    + getTranslation( 'Opis' ) + ': ' + '</b></font><span>{description}</span></div></div>', '<tpl if="xindex !== xcount">',
                    '<hr class="x-Module-comboTemplateHr">', '</tpl>', '</tpl>' );

    config = Ext.apply( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Grupa' ),
        triggerAction: 'all',
        mode: 'remote',
        tpl: tpl.compile(),
        itemSelector: 'div.x-Module-comboTemplateItem',
        minChars: 0,
        store: store,
        displayField: 'name',
        valueField: 'name',
        forceSelection: true,
        resizable: true,
        pageSize: 20
    }, config );

    Ext.ux.suncode.UserGroupsChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.UserGroupsChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.UserGroupsChooser.superclass.initComponent.call( this );
    }
} );