Ext.ux.suncode.PermissionFiltersPanel = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        itemId: 'autorization-filters',
        region: 'west',
        width: 200,
        title: getTranslation( 'Filtry' ),
        collapsible: true,
        collapsed: true,
        split: true,
        labelAlign: 'top',
        bodyCssClass: 'x-Module-permissionFiltersPanel',
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść filtry' ),
                scope: this,
                handler: this.clearFilters
            } ]
        } ),
        items: [ new Ext.ux.suncode.PermissionScopesChooser( {
            hiddenName: 'scope',
            enableKeyEvents: true,
            clearFilter: function() {
                this.setValue( '' );
            },
            listeners: {
                scope: this,
                select: this.filter,
                keyup: this.onScopeChooserValueChange
            }
        } ), new Ext.ux.suncode.PermissionValue( {
            clearFilter: function() {
                this.setValue( '' );
            }
        } ) ]
    }, config );

    Ext.ux.suncode.PermissionFiltersPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PermissionFiltersPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.PermissionFiltersPanel.superclass.initComponent.call( this );
    },
    clearFilters: function() {
        Ext.each( this.items.items, function( item, index, items ) {
            if ( Ext.isFunction( item.clearFilter ) ) {
                item.clearFilter();
            }
        } );

        this.filter();
    },
    filter: function() {
        var table = this.ownerCt.getComponent( 'permission-table' );
        var filter = this.getForm().getValues();
        table.filter( filter );
    },
    onScopeChooserValueChange: function( field, e ) {
        var value = field.getRawValue();

        if ( Ext.isEmpty( value ) ) {
            field.setValue( '' );
            this.filter();
        }
    }
} );

Ext.ux.suncode.PermissionValue = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        name: 'value',
        fieldLabel: getTranslation( 'Wartość uprawnienia' ),
        anchor: '100%',
        enableKeyEvents: true,
        filterTask: new Ext.util.DelayedTask( this.startFiltering, this ),
        listeners: {
            scope: this,
            keyup: this.onValueChange
        }
    }, config );

    Ext.ux.suncode.PermissionValue.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PermissionValue, Ext.form.TextField, {
    initComponent: function() {
        Ext.ux.suncode.PermissionValue.superclass.initComponent.call( this );
    },
    startFiltering: function() {
        this.ownerCt.filter();
    },
    onValueChange: function( field, e ) {
        this.filterTask.cancel();
        this.filterTask.delay( 500 );
    }
} );