Ext.ux.suncode.PackageInfoPanel = function( config ) {
  config = config ? config : new Object();

  config = Ext.apply( {
    title: getTranslation( 'Informacje o pakiecie' ),
    layout: 'form',
    border: false,
    bodyCssClass: 'x-Module-container-padding',
    items: [ {
      xtype: 'label',
      anchor: '100%',
      cls: 'x-Module-sectionLabel',
      text: getTranslation( 'Szablon' )
    }, {
      xtype: 'box',
      autoEl: {
        tag: 'div',
        html: '<hr size="1" width="100%" color="#7F9DB9">',
        style: 'padding-bottom: 10px'
      }
    }, {
      xtype: 'textarea',
      fieldLabel: getTranslation( 'Zawartość' ),
      ref: 'contentItem',
      width: 400,
      height: 200
    }, {
      xtype: 'checkbox',
      fieldLabel: getTranslation( 'Walidacja' ),
      ref: 'validateItem',
      inputValue: 'true',
      checked: false
    }, {
      xtype: 'button',
      cls: 'x-btn-text-icon',
      icon: getPluginImgPath( 'save' ),
      tooltip: getTranslation( 'Zapisz' ),
      text: getTranslation( 'Zapisz' ),
      handler: this.saveTemplate,
      scope: this,
    } ]
  }, config );

  Ext.ux.suncode.PackageInfoPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageInfoPanel, Ext.Panel, {
  initComponent: function() {
    Ext.ux.suncode.PackageInfoPanel.superclass.initComponent.call( this );

    this.on( 'afterrender', this.onAfterRender, this );
  },
  onAfterRender : function() {
    Ext.Ajax.request( {
      url: Suncode.context( 'pwe' ).pluginContextPath + '/api/packageinfotemplate/get',
      method: 'GET',
      scope: this,
      success: function( response, opts ) {
        var packageInfoTemplate = Ext.util.JSON.decode( response.responseText );

        this.contentItem.setValue( packageInfoTemplate.content );
        this.validateItem.setValue( packageInfoTemplate.validate );
      },
      failure: function( response, opts ) {
        showWarn( getTranslation( 'Wystąpił błąd.' ) );
      }
    } );
  },
  saveTemplate: function() {
    var content = this.contentItem.getValue();
    var validate = this.validateItem.getValue();

    Ext.Ajax.request( {
      url: Suncode.context( 'pwe' ).pluginContextPath + '/api/packageinfotemplate/set',
      method: 'POST',
      params: {
        content: content,
        validate: validate
      },
      success: function( response, opts ) {
        Ext.Msg.show( {
          title: getTranslation( 'Sukces' ),
          msg: getTranslation( 'Szablon zapisany.' ),
          buttons: Ext.Msg.OK,
          icon: Ext.Msg.INFO
        } );
      },
      failure: function( response, opts ) {
        showWarn( getTranslation( 'Wystąpił błąd.' ) );
      }
    } );
  }
} );