/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder;

import com.plusmpm.util.form.datachooser.CustomKeys;
import com.plusmpm.util.form.datachooser.Definition;
import com.plusmpm.util.form.datachooser.FormCriteria;
import com.plusmpm.util.form.datachooser.Mappings;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.CustomKeyDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.FormCriterionDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.MappingDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.StandardDataChooserDefinitionDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.StandardDataChooserDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder.CustomKeyDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder.FormCriterionDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder.MappingDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder.StandardDataChooserDefinitionDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StandardDataChooserDtoBuilder {
    @Autowired
    private StandardDataChooserDefinitionDtoBuilder definitionDtoBuilder;
    @Autowired
    private FormCriterionDtoBuilder formCriterionDtoBuilder;
    @Autowired
    private MappingDtoBuilder mappingDtoBuilder;
    @Autowired
    private CustomKeyDtoBuilder customKeyDtoBuilder;

    public StandardDataChooserDto build(Long id, Definition definition, List<FormCriteria> formCriteria, List<Mappings> mappings, List<CustomKeys> customKeys) {
        StandardDataChooserDto dto = new StandardDataChooserDto();
        dto.setId(id);
        dto.setDefinition(this.buildDefinition(id, definition));
        dto.setFormCriteria(this.buildFormCriteria(formCriteria));
        dto.setMappings(this.buildMappings(mappings));
        dto.setCustomKeys(this.buildCustomKeys(customKeys));
        return dto;
    }

    private StandardDataChooserDefinitionDto buildDefinition(Long id, Definition definition) {
        return this.definitionDtoBuilder.build(id, definition);
    }

    private List<FormCriterionDto> buildFormCriteria(List<FormCriteria> formCriteria) {
        ArrayList<FormCriterionDto> dtos = new ArrayList<FormCriterionDto>();
        if (CollectionUtils.isNotEmpty(formCriteria)) {
            for (FormCriteria formCriterion : formCriteria) {
                dtos.add(this.buildFormCriterion(formCriterion));
            }
        }
        return dtos;
    }

    private FormCriterionDto buildFormCriterion(FormCriteria formCriterion) {
        return this.formCriterionDtoBuilder.build(formCriterion);
    }

    private List<MappingDto> buildMappings(List<Mappings> mappings) {
        ArrayList<MappingDto> dtos = new ArrayList<MappingDto>();
        if (CollectionUtils.isNotEmpty(mappings)) {
            for (Mappings mapping : mappings) {
                dtos.add(this.buildMapping(mapping));
            }
        }
        return dtos;
    }

    private MappingDto buildMapping(Mappings mapping) {
        return this.mappingDtoBuilder.build(mapping);
    }

    private List<CustomKeyDto> buildCustomKeys(List<CustomKeys> customKeys) {
        ArrayList<CustomKeyDto> dtos = new ArrayList<CustomKeyDto>();
        if (CollectionUtils.isNotEmpty(customKeys)) {
            for (CustomKeys customKey : customKeys) {
                dtos.add(this.buildCustomKey(customKey));
            }
        }
        return dtos;
    }

    private CustomKeyDto buildCustomKey(CustomKeys customKey) {
        return this.customKeyDtoBuilder.build(customKey);
    }
}

