/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.recentfile.builder;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.model.recentfile.RecentFile;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.RecentFileLocationName;
import com.suncode.plugin.pwe.web.support.dto.recentfile.RecentFileDto;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecentFileDtoBuilder {
    public static Logger log = Logger.getLogger(RecentFileDtoBuilder.class);
    @Autowired
    private PluginService pluginService;

    public List<RecentFileDto> build(List<RecentFile> recentFiles) {
        ArrayList<RecentFileDto> dtos = new ArrayList<RecentFileDto>();
        if (CollectionUtils.isNotEmpty(recentFiles)) {
            for (RecentFile recentFile : recentFiles) {
                dtos.add(this.build(recentFile));
            }
        }
        return dtos;
    }

    public RecentFileDto build(RecentFile recentFile) {
        RecentFileDto dto = new RecentFileDto();
        dto.setLocation(recentFile.getLocation());
        dto.setFileName(this.buildFileName(recentFile));
        dto.setLocationName(recentFile.getLocationName());
        dto.setSize(this.buildSize(recentFile));
        dto.setOpenTime(PweUtils.buildFormattedDate(recentFile.getOpenTime(), "yyyy-MM-dd HH:mm:ss"));
        return dto;
    }

    private String buildFileName(RecentFile recentFile) {
        if (this.isFromSystem(recentFile)) {
            String packageId = recentFile.getLocation();
            try {
                return XpdlPackageManager.getInstance().getFileNameByPackageId(packageId);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                return packageId;
            }
        }
        return FilenameUtils.getName((String)recentFile.getLocation());
    }

    private boolean isFromSystem(RecentFile recentFile) {
        return RecentFileLocationName.getByName(recentFile.getLocationName()).equals((Object)RecentFileLocationName.SYSTEM);
    }

    private String buildSize(RecentFile recentFile) {
        String path = this.getPath(recentFile);
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        return this.buildSize(path);
    }

    private String getPath(RecentFile recentFile) {
        if (this.isFromSystem(recentFile)) {
            try {
                return XpdlPackageManager.getInstance().getFilePathByPackageId(recentFile.getLocation());
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                return null;
            }
        }
        return recentFile.getLocation();
    }

    private String buildSize(String location) {
        File file = new File(location);
        if (file.exists()) {
            return this.buildSize(file);
        }
        return this.buildSizeForResource(location);
    }

    private String buildSize(File file) {
        return FileUtils.byteCountToDisplaySize((long)file.length());
    }

    private String buildSizeForResource(String location) {
        try {
            PluginStoreResource resource = this.pluginService.getSavedResource(location);
            if (resource != null) {
                return this.buildSize(this.getResourceSize(resource));
            }
            return "";
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    private int getResourceSize(PluginStoreResource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            int n = inputStream.available();
            return n;
        }
    }

    private String buildSize(int bytesCount) {
        return FileUtils.byteCountToDisplaySize((long)bytesCount);
    }

    public RecentFileDto build(String location, String locationName) {
        RecentFileDto dto = new RecentFileDto();
        dto.setLocation(location);
        dto.setLocationName(locationName);
        dto.setSize(this.buildSize(location));
        return dto;
    }

    public RecentFile extract(String userId, RecentFileDto dto) {
        RecentFile recentFile = new RecentFile();
        recentFile.setUserId(userId);
        recentFile.setLocation(dto.getLocation());
        recentFile.setLocationName(dto.getLocationName());
        recentFile.setOpenTime(System.currentTimeMillis());
        return recentFile;
    }
}

