/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.module.builder;

import com.suncode.plugin.pwe.web.support.dto.module.StyleDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class StyleDtoBuilder {
    public static Logger log = Logger.getLogger(StyleDtoBuilder.class);
    private static final String PATH_SUBSTRING = "/resources/";

    public List<StyleDto> build(Resource[] resources) {
        ArrayList<StyleDto> dtos = new ArrayList<StyleDto>();
        if (ArrayUtils.isNotEmpty((Object[])resources)) {
            for (Resource resource : resources) {
                if (!resource.exists()) continue;
                dtos.add(this.build(resource));
            }
        }
        return dtos;
    }

    public StyleDto build(Resource resource) {
        StyleDto dto = new StyleDto();
        dto.setLocation(this.buildLocation(resource));
        return dto;
    }

    private String buildLocation(Resource resource) {
        try {
            return StringUtils.substringAfter((String)resource.getURL().getPath(), (String)PATH_SUBSTRING);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }
}

