/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.module.builder;

import com.suncode.plugin.pwe.web.support.dto.module.ScriptDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class ScriptDtoBuilder {
    public static Logger log = Logger.getLogger(ScriptDtoBuilder.class);
    private static final String PATH_SUBSTRING = "/resources/";

    public List<ScriptDto> build(Resource[] resources) {
        ArrayList<ScriptDto> dtos = new ArrayList<ScriptDto>();
        if (ArrayUtils.isNotEmpty((Object[])resources)) {
            for (Resource resource : resources) {
                if (!resource.exists()) continue;
                dtos.add(this.build(resource));
            }
        }
        return dtos;
    }

    public ScriptDto build(Resource resource) {
        return this.build(this.buildLocation(resource));
    }

    private String buildLocation(Resource resource) {
        try {
            return StringUtils.substringAfter((String)resource.getURL().getPath(), (String)PATH_SUBSTRING);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    public ScriptDto build(String location) {
        ScriptDto dto = new ScriptDto();
        dto.setLocation(location);
        return dto;
    }
}

