/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.javacode.builder;

import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeCompilationErrorDto;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JavaCodeCompilationErrorDtoBuilder {
    public List<JavaCodeCompilationErrorDto> build(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        ArrayList<JavaCodeCompilationErrorDto> dtos = new ArrayList<JavaCodeCompilationErrorDto>();
        if (CollectionUtils.isNotEmpty(diagnostics)) {
            for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
                if (!this.isError(diagnostic)) continue;
                dtos.add(this.build(diagnostic));
            }
        }
        return dtos;
    }

    private boolean isError(Diagnostic<? extends JavaFileObject> diagnostic) {
        return diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    public JavaCodeCompilationErrorDto build(Diagnostic<? extends JavaFileObject> diagnostic) {
        JavaCodeCompilationErrorDto dto = new JavaCodeCompilationErrorDto();
        dto.setLineNumber(diagnostic.getLineNumber());
        dto.setColumnNumber(diagnostic.getColumnNumber());
        dto.setMessage(diagnostic.getMessage(LocaleContextHolder.getLocale()));
        dto.setStartPosition(diagnostic.getStartPosition());
        dto.setEndPosition(diagnostic.getEndPosition());
        return dto;
    }
}

