/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.acceptvalidator.builder;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.plugin.pwe.web.support.dto.acceptvalidator.AcceptValidatorDefinitionDto;
import com.suncode.plugin.pwe.web.support.dto.acceptvalidator.AcceptValidatorParameterDefinitionDto;
import com.suncode.plugin.pwe.web.support.dto.acceptvalidator.builder.AcceptValidatorParameterDefinitionDtoBuilder;
import com.suncode.pwfl.form.stereotype.CustomValidator;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AcceptValidatorDefinitionDtoBuilder {
    @Autowired
    private AcceptValidatorParameterDefinitionDtoBuilder acceptValidatorParameterDefinitionDtoBuilder;

    public AcceptValidatorDefinitionDto build(String classpath, CustomValidator validator) {
        AcceptValidatorDefinitionDto dto = new AcceptValidatorDefinitionDto();
        dto.setClasspath(classpath);
        dto.setDescription(this.buildDescription(validator));
        dto.setParameters(this.buildParameters(validator));
        return dto;
    }

    private String buildDescription(CustomValidator validator) {
        Locale locale = LocaleContextHolder.getLocale();
        switch (validator.translator()) {
            case I18N: {
                return MessageHelper.getOptionalMessage((String)validator.description(), (Locale)locale, (Object[])new Object[0]);
            }
            case I18NCUSTOM: {
                I18NCustom i18nCustom = new I18NCustom(locale);
                return i18nCustom.getString(validator.description());
            }
        }
        return validator.description();
    }

    private List<AcceptValidatorParameterDefinitionDto> buildParameters(CustomValidator validator) {
        return this.acceptValidatorParameterDefinitionDtoBuilder.build(validator);
    }
}

