/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.simulationconfig.SimulationConfigService;
import com.suncode.plugin.pwe.web.support.dto.simulationconfig.SimulationConfigDto;
import com.suncode.plugin.pwe.web.support.result.DataResult;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/simulationconfig"})
public class SimulationConfigController {
    @Autowired
    private SimulationConfigService simulationConfigService;

    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResult<SimulationConfigDto> get(HttpServletRequest request) {
        String userId = RestUtils.getUserIdFromSession(request);
        SimulationConfigDto dto = this.simulationConfigService.getForUser(userId);
        return new DataResult<SimulationConfigDto>(true, dto);
    }

    @RequestMapping(value={"set"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean set(HttpServletRequest request, SimulationConfigDto dto) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.simulationConfigService.setForUser(userId, dto);
    }
}

