/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XmlUtils {
    private static final int INDENT = 4;
    private static final String LINE_SEPARATOR = "\n";
    private static final String SPACE = " ";
    private static final String EMPTY = "";

    private XmlUtils() {
    }

    public static String convertToString(Document document, boolean prettyPrint) throws TransformerException {
        if (prettyPrint) {
            return XmlUtils.convertToPrettyString(document);
        }
        return XmlUtils.convertToString(document);
    }

    private static String convertToString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    private static String convertToPrettyString(Document document) throws TransformerException {
        String string = XmlUtils.convertToString(document);
        return XmlUtils.prettyPrint(string);
    }

    private static String prettyPrint(String string) {
        StringBuilder builder = new StringBuilder();
        int indent = 0;
        boolean shouldBuildWhitespace = true;
        for (int i = 0; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (currentChar == '<') {
                char nextChar = string.charAt(i + 1);
                if (nextChar == '/') {
                    indent -= INDENT;
                }
                if (shouldBuildWhitespace) {
                    builder.append(XmlUtils.buildWhitespace(indent));
                }
                if (nextChar != '?' && nextChar != '!' && nextChar != '/') {
                    indent += INDENT;
                }
                shouldBuildWhitespace = true;
            }
            builder.append(currentChar);
            if (currentChar != '>') continue;
            if (string.charAt(i - 1) == '/') {
                indent -= INDENT;
                builder.append(LINE_SEPARATOR);
                continue;
            }
            int nextStartElementPos = string.indexOf(60, i);
            if (nextStartElementPos > i + 1) {
                String textBetweenElements = string.substring(i + 1, nextStartElementPos);
                if (textBetweenElements.replaceAll(LINE_SEPARATOR, EMPTY).length() == 0) {
                    builder.append(textBetweenElements + LINE_SEPARATOR);
                } else {
                    builder.append(textBetweenElements);
                    shouldBuildWhitespace = false;
                }
                i = nextStartElementPos - 1;
                continue;
            }
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    private static String buildWhitespace(int numChars) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            builder.append(SPACE);
        }
        return builder.toString();
    }
}

