/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PweContentHandler
implements ContentHandler {
    private static final String ENTER = "\n";
    private static final String NODE_VALUE_TAG = "XPDLNODEVALUE";
    private static final String ENCODED_QUOTE = "@PWE_QOUTE@";
    private static final String ENCODED_AMPERSAND = "@PWE_AMP@";
    private JSONObject json = new JSONObject();
    private List<JSONArray> arrays = new ArrayList<JSONArray>();
    private StringBuilder builder = new StringBuilder();

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.arrays.add(new JSONArray());
        for (int i = 0; i < atts.getLength(); ++i) {
            this.handleAttribute(atts.getLocalName(i), atts.getValue(i));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.builder.length() > 0) {
            this.handleNodeValue(this.builder.toString());
            this.builder = new StringBuilder();
        }
        JSONArray array = this.arrays.remove(CollectionUtils.size(this.arrays) - 1);
        if (this.arrays.isEmpty()) {
            try {
                this.json.put(localName, (Object)array);
            }
            catch (JSONException exception) {
                throw new SAXException(exception.getMessage());
            }
        } else {
            this.addToLastArray(localName, array);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String nodeValue = new String(ch, start, length);
        if (this.shouldNotIgnoreCharacters(nodeValue)) {
            this.builder.append(nodeValue);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void handleAttribute(String attrName, String attrValue) throws SAXException {
        this.addToLastArray(attrName, this.encodeText(attrValue));
    }

    private void handleNodeValue(String nodeValue) throws SAXException {
        this.addToLastArray(NODE_VALUE_TAG, this.encodeText(nodeValue));
    }

    private String encodeText(String text) {
        return StringEscapeUtils.escapeHtml4((String)StringUtils.replace((String)text, (String)"\"", (String)ENCODED_QUOTE).replace("&", ENCODED_AMPERSAND));
    }

    private void addToLastArray(String key, Object value) throws SAXException {
        try {
            int arraysLastPos = CollectionUtils.size(this.arrays) - 1;
            JSONArray array = this.arrays.get(arraysLastPos);
            JSONObject object = new JSONObject();
            object.put(key, value);
            array.put((Object)object);
            this.arrays.set(arraysLastPos, array);
        }
        catch (Exception exception) {
            throw new SAXException(exception.getMessage());
        }
    }

    private boolean shouldNotIgnoreCharacters(String text) {
        text = StringUtils.stripStart((String)text, (String)ENTER);
        text = StringUtils.stripStart((String)text, null);
        return StringUtils.isNotBlank((CharSequence)text);
    }

    public JSONObject getResult() {
        return this.json;
    }
}

