/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.user;

import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.web.support.dto.user.UserDto;
import com.suncode.plugin.pwe.web.support.dto.user.builder.UserDtoBuilder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.util.SpringContext;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    private UserDtoBuilder userDtoBuilder;

    public PageResult<UserDto> get(String query, int offset, int limit) {
        DetachedCriteria criteria = DetachedCriteria.forClass(User.class);
        criteria = this.applyQuery(query, criteria);
        UserFinder userFinder = (UserFinder)SpringContext.getBean(UserFinder.class);
        long total = userFinder.count(criteria);
        criteria.setProjection(null);
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
        List users = userFinder.findByCriteria(criteria, Integer.valueOf(offset), Integer.valueOf(limit));
        List<UserDto> dtos = this.userDtoBuilder.build(users);
        return new PageResult<UserDto>(dtos, total);
    }

    private DetachedCriteria applyQuery(String query, DetachedCriteria criteria) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            Criterion userNameCriterion = this.buildIlikeCriterion("userName", query);
            Criterion firstNameCriterion = this.buildIlikeCriterion("firstName", query);
            Criterion lastNameCriterion = this.buildIlikeCriterion("lastName", query);
            criteria.add((Criterion)Restrictions.disjunction().add(userNameCriterion).add(firstNameCriterion).add(lastNameCriterion));
        }
        return criteria;
    }

    private Criterion buildIlikeCriterion(String property, String value) {
        return Restrictions.ilike((String)property, (Object)("%" + value + "%"));
    }
}

