/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.translator;

import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.AddFileButton;
import com.suncode.plugin.pwe.documentation.object.FormButton;
import com.suncode.plugin.pwe.documentation.object.GeneratePdfButton;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TranslatorService {
    private static final String DOCUMENTATION_MESSAGE_FOR_TEXT_PREFIX = "pwe.documentation.text.";
    @Autowired
    private MessageSource messageSource;

    public String translateMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, key, locale);
    }

    public String translateDocumentationMessageForText(String text) {
        StringBuilder key = new StringBuilder();
        key.append(DOCUMENTATION_MESSAGE_FOR_TEXT_PREFIX);
        key.append(text);
        return this.translateMessage(key.toString());
    }

    public String translateDocumentationChapterTitle(String key) {
        return this.translateMessage(key);
    }

    public String translateDocumentationChapterTitle(int chapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(chapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }

    public String translateDocumentationSubchapterTitle(int subchapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }

    public String translateDocumentationSubchapterTitle(int chapterNo, int subchapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(chapterNo);
        title.append(".");
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }

    public String translatePackageParticipantName(TranslationInfo translationInfo, Participant participant) {
        String key = this.buildPackageParticipantNameTranslationKey(translationInfo.getPackageId(), participant.getId());
        return translationInfo.getTranslations().getOrDefault(key, participant.getName());
    }

    public String translateProcessName(TranslationInfo translationInfo, WorkflowProcess process) {
        String key = this.buildProcessNameTranslationKey(translationInfo.getPackageId(), process.getId());
        return translationInfo.getTranslations().getOrDefault(key, process.getName());
    }

    public String translateProcessParticipantName(TranslationInfo translationInfo, WorkflowProcess process, Participant participant) {
        String key = this.buildProcessParticipantNameTranslationKey(translationInfo.getPackageId(), process.getId(), participant.getId());
        return translationInfo.getTranslations().getOrDefault(key, participant.getName());
    }

    public String translateActivityName(TranslationInfo translationInfo, WorkflowProcess process, Activity activity) {
        String key = this.buildActivityNameTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId());
        return translationInfo.getTranslations().getOrDefault(key, activity.getName());
    }

    public String translateVariableName(TranslationInfo translationInfo, WorkflowProcess process, DataField dataField) {
        String key = this.buildVariableNameTranslationKey(translationInfo.getPackageId(), process.getId(), dataField.getId());
        return translationInfo.getTranslations().getOrDefault(key, dataField.getName());
    }

    public String translateVariableName(TranslationInfo translationInfo, WorkflowProcess process, String variableId, String defaultName) {
        String key = this.buildVariableNameTranslationKey(translationInfo.getPackageId(), process.getId(), variableId);
        return translationInfo.getTranslations().getOrDefault(key, defaultName);
    }

    public String translateVariableSetTitle(TranslationInfo translationInfo, WorkflowProcess process, Activity activity, VariableSet variableSet) {
        String key = this.buildVariableSetTitleTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId(), variableSet.getId());
        return translationInfo.getTranslations().getOrDefault(key, variableSet.getTitle());
    }

    public String translateFormButtonName(TranslationInfo translationInfo, WorkflowProcess process, Activity activity, FormButton formButton) {
        String key = this.buildFormButtonNameTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId(), formButton.getButtonName());
        return translationInfo.getTranslations().getOrDefault(key, formButton.getButtonName());
    }

    public String translateAcceptButtonButtonName(TranslationInfo translationInfo, WorkflowProcess process, Activity activity, AcceptButton acceptButton) {
        String key = this.buildAcceptButtonNameTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId(), acceptButton.getActionName());
        return translationInfo.getTranslations().getOrDefault(key, acceptButton.getButtonName());
    }

    public String translateGeneratePdfButtonButtonName(TranslationInfo translationInfo, WorkflowProcess process, Activity activity, GeneratePdfButton generatePdfButton) {
        String key = this.buildGeneratePdfButtonNameTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId(), generatePdfButton.getActionName());
        return translationInfo.getTranslations().getOrDefault(key, generatePdfButton.getButtonName());
    }

    public String translateAddFileButtonButtonName(TranslationInfo translationInfo, WorkflowProcess process, Activity activity, AddFileButton addFileButton) {
        String key = this.buildAddFileButtonNameTranslationKey(translationInfo.getPackageId(), process.getId(), activity.getId(), addFileButton.getActionName());
        return translationInfo.getTranslations().getOrDefault(key, addFileButton.getButtonName());
    }

    private String buildPackageParticipantNameTranslationKey(String packageId, String participantId) {
        return "PACK(" + packageId + ")_PARTICIPANT(" + participantId + ")";
    }

    private String buildProcessNameTranslationKey(String packageId, String processDefId) {
        return "PACK(" + packageId + ")_PROC(" + processDefId + ")";
    }

    private String buildProcessParticipantNameTranslationKey(String packageId, String processDefId, String participantId) {
        return this.buildProcessNameTranslationKey(packageId, processDefId) + "_PARTICIPANT(" + participantId + ")";
    }

    private String buildActivityNameTranslationKey(String packageId, String processDefId, String activityDefId) {
        return this.buildProcessNameTranslationKey(packageId, processDefId) + "_ACTIVITY(" + activityDefId + ")";
    }

    private String buildVariableNameTranslationKey(String packageId, String processDefId, String variableId) {
        return this.buildProcessNameTranslationKey(packageId, processDefId) + "_DATAFIELD(" + variableId + ")";
    }

    private String buildVariableSetTitleTranslationKey(String packageId, String processDefId, String activityDefId, String variableSetId) {
        return this.buildActivityNameTranslationKey(packageId, processDefId, activityDefId) + "_VARIABLESET(" + variableSetId + ")";
    }

    private String buildFormButtonNameTranslationKey(String packageId, String processDefId, String activityDefId, String buttonName) {
        return this.buildActivityNameTranslationKey(packageId, processDefId, activityDefId) + "HTTPLINK(" + StringUtils.replace((String)buttonName, (String)" ", (String)"_") + ")";
    }

    private String buildAcceptButtonNameTranslationKey(String packageId, String processDefId, String activityDefId, String actionName) {
        return this.buildActivityNameTranslationKey(packageId, processDefId, activityDefId) + "ACTIONBUTTON(" + actionName + ")";
    }

    private String buildGeneratePdfButtonNameTranslationKey(String packageId, String processDefId, String activityDefId, String buttonName) {
        return this.buildActivityNameTranslationKey(packageId, processDefId, activityDefId) + "PDFBUTTON(" + StringUtils.replace((String)buttonName, (String)" ", (String)"_") + ")";
    }

    private String buildAddFileButtonNameTranslationKey(String packageId, String processDefId, String activityDefId, String buttonName) {
        return this.buildActivityNameTranslationKey(packageId, processDefId, activityDefId) + "PDFBUTTON(" + StringUtils.replace((String)buttonName, (String)" ", (String)"_") + ")";
    }
}

