/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.standarddatachooser;

import com.plusmpm.util.ClasspathScanner;
import com.plusmpm.util.form.datachooser.CustomKeys;
import com.plusmpm.util.form.datachooser.Definition;
import com.plusmpm.util.form.datachooser.FormCriteria;
import com.plusmpm.util.form.datachooser.Mappings;
import com.plusmpm.util.form.datachooser.StandardDataChooser;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.StandardDataChooserDto;
import com.suncode.plugin.pwe.web.support.dto.standarddatachooser.builder.StandardDataChooserDtoBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardDataChooserService {
    public static Logger log = Logger.getLogger(StandardDataChooserService.class);
    private static final Class<? extends Annotation> DATA_CHOOSER_ANNOTATION = StandardDataChooser.class;
    private static final String GET_IDS_METHOD_NAME = "getIds";
    private static final String GET_DEF_METHOD_NAME = "getDef";
    private static final String GET_FORM_CRITERIA_METHOD_NAME = "getFormCriteria";
    private static final String GET_MAPPINGS_METHOD_NAME = "getMappings";
    private static final String GET_CUSTOM_KEYS_METHOD_NAME = "getCustomKeys";
    @Autowired
    private StandardDataChooserDtoBuilder standardDataChooserDtoBuilder;

    public List<StandardDataChooserDto> findAll() {
        ArrayList<StandardDataChooserDto> dtos = new ArrayList<StandardDataChooserDto>();
        List clazzes = ClasspathScanner.getAllClassesWithAnnotation(DATA_CHOOSER_ANNOTATION);
        if (CollectionUtils.isNotEmpty((Collection)clazzes)) {
            String language = PweUtils.getLanguage();
            int counter = 0;
            for (Class clazz : clazzes) {
                try {
                    StandardDataChooser dataChooser = (StandardDataChooser)clazz.getAnnotation(DATA_CHOOSER_ANNOTATION);
                    Class configurationClass = dataChooser.conf();
                    if (configurationClass == null) continue;
                    dtos.addAll(this.buildDefinitions(language, counter, configurationClass));
                    ++counter;
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return dtos;
    }

    private List<StandardDataChooserDto> buildDefinitions(String language, int counter, Class<?> configurationClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        ArrayList<StandardDataChooserDto> dtos = new ArrayList<StandardDataChooserDto>();
        Object instance = configurationClass.newInstance();
        Method getIds = configurationClass.getMethod(GET_IDS_METHOD_NAME, new Class[0]);
        List ids = (List)getIds.invoke(instance, new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (String id : ids) {
                Method getDef = configurationClass.getMethod(GET_DEF_METHOD_NAME, String.class, String.class);
                Definition definition = (Definition)getDef.invoke(instance, id, language);
                if (!this.hasValidDefinition(definition)) continue;
                Method getFormCriteria = configurationClass.getMethod(GET_FORM_CRITERIA_METHOD_NAME, String.class, String.class);
                List formCriteria = (List)getFormCriteria.invoke(instance, id, language);
                Method getMappings = configurationClass.getMethod(GET_MAPPINGS_METHOD_NAME, String.class, String.class);
                List mappings = (List)getMappings.invoke(instance, id, language);
                Method getCustomKeys = configurationClass.getMethod(GET_CUSTOM_KEYS_METHOD_NAME, String.class, String.class);
                List customKeys = (List)getCustomKeys.invoke(instance, id, language);
                dtos.add(this.buildDefinition(counter, definition, formCriteria, mappings, customKeys));
            }
        }
        return dtos;
    }

    private boolean hasValidDefinition(Definition definition) {
        return definition != null && StringUtils.isNotBlank((CharSequence)definition.getClasspath()) && StringUtils.isNotBlank((CharSequence)definition.getName());
    }

    private StandardDataChooserDto buildDefinition(int counter, Definition definition, List<FormCriteria> formCriteria, List<Mappings> mappings, List<CustomKeys> customKeys) {
        return this.standardDataChooserDtoBuilder.build(Long.valueOf(counter), definition, formCriteria, mappings, customKeys);
    }
}

