/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.recentfile;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.recentfile.RecentFileDao;
import com.suncode.plugin.pwe.model.recentfile.RecentFile;
import com.suncode.plugin.pwe.service.recentfile.RecentFileService;
import com.suncode.plugin.pwe.util.RecentFileLocationName;
import com.suncode.plugin.pwe.util.comparator.RecentFileComparator;
import com.suncode.plugin.pwe.web.support.dto.recentfile.RecentFileDto;
import com.suncode.plugin.pwe.web.support.dto.recentfile.builder.RecentFileDtoBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={RecentFileService.class})
public class RecentFileServiceImpl
implements RecentFileService {
    public static Logger log = Logger.getLogger(RecentFileServiceImpl.class);
    private static final int MAX_RESULTS = 5;
    @Autowired
    private RecentFileDao recentFileDao;
    @Autowired
    private RecentFileDtoBuilder recentFileDtoBuilder;

    @Override
    public List<RecentFileDto> getForUser(String userId) {
        List<RecentFile> recentFiles = this.recentFileDao.getByUser(userId, MAX_RESULTS);
        return this.recentFileDtoBuilder.build(recentFiles);
    }

    @Override
    public RecentFileDto getForUser(String userId, String location) {
        try {
            RecentFile recentFile = this.recentFileDao.getByUserAndLocation(userId, location);
            return this.recentFileDtoBuilder.build(recentFile);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean setForDisc(String userId, String location) {
        return this.set(userId, location, RecentFileLocationName.DISC.getName(), this.getCurrentTime());
    }

    @Override
    public boolean setForDisc(String userId, String location, long openTime) {
        return this.set(userId, location, RecentFileLocationName.DISC.getName(), openTime);
    }

    @Override
    public boolean setForSystem(String userId, String location) {
        return this.set(userId, location, RecentFileLocationName.SYSTEM.getName(), this.getCurrentTime());
    }

    @Override
    public boolean setForSystem(String userId, String location, long openTime) {
        return this.set(userId, location, RecentFileLocationName.SYSTEM.getName(), openTime);
    }

    @Override
    public boolean setForSaved(String userId, String location) {
        return this.set(userId, location, RecentFileLocationName.SAVED.getName(), this.getCurrentTime());
    }

    @Override
    public boolean setForSaved(String userId, String location, long openTime) {
        return this.set(userId, location, RecentFileLocationName.SAVED.getName(), openTime);
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private boolean set(String userId, String location, String locationName, long openTime) {
        RecentFile recentFile = this.recentFileDao.getByUserAndLocation(userId, location);
        if (recentFile != null) {
            recentFile.setOpenTime(openTime);
            this.recentFileDao.update(recentFile);
            return true;
        }
        RecentFileDto dto = this.recentFileDtoBuilder.build(location, locationName);
        recentFile = this.recentFileDtoBuilder.extract(userId, dto);
        recentFile.setOpenTime(openTime);
        Long id = (Long)this.recentFileDao.save(recentFile);
        return id != null;
    }

    @Override
    public void updateForSystem() {
        List<RecentFile> recentFiles = this.recentFileDao.getByLocationName(RecentFileLocationName.SYSTEM.getName());
        if (CollectionUtils.isNotEmpty(recentFiles)) {
            Collections.sort(recentFiles, new RecentFileComparator());
            try {
                Map idNameMap = Shark.getInstance().getRepositoryManager().getPackagePathToIdMapping();
                HashSet<String> usedPackageIds = new HashSet<String>();
                for (RecentFile recentFile : recentFiles) {
                    String fileName = FilenameUtils.getName((String)recentFile.getLocation());
                    if (!idNameMap.containsKey(fileName)) continue;
                    String packageId = (String)idNameMap.get(fileName);
                    if (this.shouldDeleteForSystem(usedPackageIds, recentFiles, packageId, recentFile)) {
                        this.recentFileDao.delete(recentFile);
                        continue;
                    }
                    usedPackageIds.add(packageId);
                    recentFile.setLocation(packageId);
                    this.recentFileDao.save(recentFile);
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private boolean shouldDeleteForSystem(Set<String> usedPackageIds, List<RecentFile> recentFiles, String packageId, RecentFile currentRecentFile) {
        if (usedPackageIds.contains(packageId)) {
            return true;
        }
        for (RecentFile otherRecentFile : recentFiles) {
            if (otherRecentFile.getId().longValue() == currentRecentFile.getId().longValue() || !StringUtils.equals((CharSequence)otherRecentFile.getLocation(), (CharSequence)packageId) || !StringUtils.equals((CharSequence)otherRecentFile.getUserId(), (CharSequence)currentRecentFile.getUserId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteForSystem(String location) {
        List<RecentFile> recentFiles = this.recentFileDao.getByLocation(RecentFileLocationName.SYSTEM.getName(), location);
        if (CollectionUtils.isNotEmpty(recentFiles)) {
            for (RecentFile recentFile : recentFiles) {
                this.recentFileDao.delete(recentFile);
            }
        }
    }
}

