/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.processfile;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.json.JsonConverter;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.ProcessFile;
import com.suncode.plugin.pwe.util.PweUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ProcessFileService<T extends ProcessFile> {
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ZipService zipService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String path) throws Exception {
        T t;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            t = this.unmarshall(inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        return t;
    }

    public void save(String string, String additionalsFolderLocation) throws Exception {
        List<T> objects = this.buildObjects(string);
        if (CollectionUtils.isNotEmpty(objects)) {
            for (ProcessFile object : objects) {
                this.save(additionalsFolderLocation, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String additionalsFolderLocation, T object) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String objectLocation = "";
        String objectContent = "";
        try {
            this.marshall(outputStream, object);
            objectLocation = this.buildObjectLocation(additionalsFolderLocation, object);
            objectContent = outputStream.toString();
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
        this.pluginService.save(objectLocation, objectContent);
    }

    private List<T> buildObjects(String string) {
        JsonConverter<T> jsonConverter = this.getJsonConverter();
        return jsonConverter.convertToList(string);
    }

    private String buildObjectLocation(String additionalsFolderLocation, T object) {
        StringBuilder location = new StringBuilder();
        location.append(this.buildObjectFolder(additionalsFolderLocation, object));
        location.append("/");
        location.append(((ProcessFile)object).getId());
        location.append(".");
        location.append(this.getExtension());
        return location.toString();
    }

    private String buildObjectFolder(String additionalsFolderLocation, T object) {
        StringBuilder location = new StringBuilder();
        location.append(additionalsFolderLocation);
        location.append("/");
        location.append(((ProcessFile)object).getId());
        return location.toString();
    }

    public void addToZip(ZipOutputStream zipOutputStream, String strings) throws Exception {
        List<T> objects = this.buildObjects(strings);
        this.addToZip(zipOutputStream, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToZip(ZipOutputStream zipOutputStream, List<T> objects) throws Exception {
        if (CollectionUtils.isNotEmpty(objects)) {
            for (ProcessFile object : objects) {
                ByteArrayOutputStream outputStream = null;
                try {
                    outputStream = new ByteArrayOutputStream();
                    this.marshall(outputStream, object);
                    this.zipService.addToZip(zipOutputStream, this.buildObjectSublocation(object), outputStream.toByteArray());
                }
                finally {
                    IOUtils.closeQuietly((Closeable)outputStream);
                }
            }
        }
    }

    private String buildObjectSublocation(T object) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(((ProcessFile)object).getId());
        fileName.append(File.separator);
        fileName.append(((ProcessFile)object).getId());
        fileName.append(".");
        fileName.append(this.getExtension());
        return fileName.toString();
    }

    public void loadToSystem(String string, String additionalsFolderPath) throws Exception {
        List<T> objects = this.buildObjects(string);
        if (CollectionUtils.isNotEmpty(objects)) {
            for (ProcessFile object : objects) {
                this.loadToSystem(additionalsFolderPath, object);
            }
        }
    }

    private void loadToSystem(String additionalsFolderPath, T object) throws Exception {
        this.controlObjectFolderExistence(additionalsFolderPath, object);
        String objectLocation = this.buildObjectLocation(additionalsFolderPath, object);
        this.loadToSystemOnPath(objectLocation, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadToSystemOnPath(String objectLocation, T object) throws Exception {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(objectLocation);
            this.marshall(outputStream, object);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    public void loadToSystem(File file, T object) throws Exception {
        this.loadToSystemOnPath(file.getAbsolutePath(), object);
    }

    private void controlObjectFolderExistence(String additionalsFolderPath, T object) throws IOException {
        String objectFolderPath = this.buildObjectFolder(additionalsFolderPath, object);
        File objectFolder = new File(objectFolderPath);
        FileUtils.forceMkdir((File)objectFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T openFromDisc(byte[] bytes) throws Exception {
        T t;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            t = this.unmarshall(inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        return t;
    }

    public List<File> getForPackage(String packageId, String packageVersion) {
        return this.getFromFolder(this.buildAdditionalsFolderPath(packageId, packageVersion));
    }

    private String buildAdditionalsFolderPath(String packageId, String packageVersion) {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(packageId);
        path.append(File.separator);
        path.append("v");
        path.append(packageVersion);
        return path.toString();
    }

    private List<File> getFromFolder(String additionalsFolderPath) {
        File directory = new File(additionalsFolderPath);
        if (directory.exists()) {
            IOFileFilter fileFilter = this.buildObjectsFilter();
            return (List)FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE);
        }
        return new ArrayList<File>();
    }

    public List<T> openFromSystem(String additionalsFolderPath) throws Exception {
        ArrayList<T> objects = new ArrayList<T>();
        List<File> files = this.getFromFolder(additionalsFolderPath);
        if (CollectionUtils.isNotEmpty(files)) {
            for (File file : files) {
                objects.add(this.get(file.getAbsolutePath()));
            }
        }
        return objects;
    }

    private IOFileFilter buildObjectsFilter() {
        return FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, new SuffixFileFilter(this.getExtension(), IOCase.INSENSITIVE)});
    }

    public List<T> openFromSaved(String additionalsLocationPrefix) throws Exception {
        ArrayList<T> objects = new ArrayList<T>();
        List<PluginStoreResource> resources = this.getResourcesFromLocation(additionalsLocationPrefix);
        for (PluginStoreResource resource : resources) {
            T object = this.unmarshall(resource.getInputStream());
            objects.add(object);
        }
        return objects;
    }

    public List<File> getFromStored(String additionalsLocationPrefix) {
        return this.getResourcesFromLocation(additionalsLocationPrefix).stream().map(PluginStoreResource::getAbsolutePath).map(File::new).collect(Collectors.toList());
    }

    private List<PluginStoreResource> getResourcesFromLocation(String additionalsLocationPrefix) {
        ArrayList<PluginStoreResource> resources = new ArrayList<PluginStoreResource>();
        Map<String, PluginStoreResource> xpdls = this.pluginService.getSavedResources();
        if (MapUtils.isNotEmpty(xpdls)) {
            Pattern pattern = this.buildSavedObjectsLocationPattern(additionalsLocationPrefix);
            for (String location : xpdls.keySet()) {
                if (!this.doesSavedFormTemplateMatchPattern(pattern, location)) continue;
                PluginStoreResource resource = xpdls.get(location);
                resources.add(resource);
            }
        }
        return resources;
    }

    private Pattern buildSavedObjectsLocationPattern(String additionalsLocationPrefix) {
        StringBuilder regex = new StringBuilder();
        regex.append(PweUtils.buildSafePatternValue(additionalsLocationPrefix));
        regex.append("/.*[.]");
        regex.append(this.getExtension());
        return Pattern.compile(regex.toString());
    }

    private boolean doesSavedFormTemplateMatchPattern(Pattern pattern, String location) {
        Matcher matcher = pattern.matcher(location);
        return matcher.matches();
    }

    public abstract JsonConverter<T> getJsonConverter();

    public abstract String getExtension();

    public abstract void marshall(OutputStream var1, T var2) throws Exception;

    public abstract T unmarshall(InputStream var1) throws Exception;
}

