/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.plugin;

import com.suncode.plugin.framework.PluginContext;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.web.support.dto.plugin.PluginVersionDto;
import com.suncode.plugin.pwe.web.support.dto.plugin.builder.PluginVersionDtoBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
@Provides(value={PluginService.class})
public class PluginServiceImpl
implements PluginService {
    public static Logger log = Logger.getLogger(PluginServiceImpl.class);
    private static final String VERSION_PROPERTIES_FILE_CLASSPATH = "/version/pwe-version.properties";
    @Autowired
    private PluginContext pluginContext;
    @Autowired
    private PluginStore pluginStore;
    @Autowired
    private PluginVersionDtoBuilder pluginVersionDtoBuilder;

    @Override
    public String getServerPath() {
        String path = this.pluginContext.getServletContext().getRealPath("/");
        int lastSeparatorPos = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)File.separator);
        return StringUtils.substring((String)path, (int)0, (int)lastSeparatorPos);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.pluginContext.getClassLoader();
    }

    @Override
    public Resource getResource(String location) {
        return this.pluginContext.getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) {
        try {
            return this.pluginContext.getResources(locationPattern);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return new Resource[0];
        }
    }

    @Override
    public Map<String, PluginStoreResource> getSavedResources() {
        return this.pluginStore.getStoredResources();
    }

    @Override
    public void save(String location, String content) throws IOException {
        this.pluginStore.store(location, IOUtils.toInputStream((String)content, (String)"UTF-8"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String location, byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            this.save(location, inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public void save(String location, InputStream inputStream) throws IOException {
        this.pluginStore.store(location, inputStream, true);
    }

    @Override
    public PluginStoreResource getSavedResource(String location) throws IOException {
        return this.pluginStore.read(location);
    }

    @Override
    public void delete(String location) {
        this.pluginStore.delete(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginVersionDto getPluginVersion() {
        PluginVersionDto pluginVersionDto;
        InputStream inputStream;
        block5: {
            Properties properties = new Properties();
            inputStream = null;
            Resource resource = this.getResource(VERSION_PROPERTIES_FILE_CLASSPATH);
            if (!resource.exists()) break block5;
            inputStream = resource.getInputStream();
            properties.load(inputStream);
            PluginVersionDto pluginVersionDto2 = this.pluginVersionDtoBuilder.build(properties);
            IOUtils.closeQuietly((InputStream)inputStream);
            return pluginVersionDto2;
        }
        try {
            pluginVersionDto = new PluginVersionDto();
        }
        catch (IOException exception) {
            PluginVersionDto pluginVersionDto3;
            try {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                pluginVersionDto3 = new PluginVersionDto();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return pluginVersionDto3;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return pluginVersionDto;
    }
}

