/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.packageinfo;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.packageinfo.PackageInfoDao;
import com.suncode.plugin.pwe.model.packageinfo.PackageInfo;
import com.suncode.plugin.pwe.service.packageinfo.PackageInfoService;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.PackageInfoDto;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.builder.PackageInfoDtoBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={PackageInfoService.class})
public class PackageInfoServiceImpl
implements PackageInfoService {
    @Autowired
    private PackageInfoDao packageInfoDao;
    @Autowired
    private PackageInfoDtoBuilder packageInfoDtoBuilder;

    @Override
    public List<PackageInfoDto> getForPackage(String packageId) {
        List<PackageInfo> packageInfos = this.packageInfoDao.getForPackage(packageId);
        return this.packageInfoDtoBuilder.build(packageInfos);
    }

    @Override
    public PackageInfoDto getForPackageVersion(String packageId, String packageVersion) {
        PackageInfo packageInfo = this.packageInfoDao.getForPackageVersion(packageId, packageVersion);
        if (packageInfo != null) {
            return this.packageInfoDtoBuilder.build(packageInfo);
        }
        return null;
    }

    @Override
    public boolean set(String author, String packageId, String packageVersion, String info) {
        PackageInfo packageInfo = this.packageInfoDao.getForPackageVersion(packageId, packageVersion);
        if (packageInfo != null) {
            packageInfo.setPackageInfo(info);
            this.packageInfoDao.update(packageInfo);
            return true;
        }
        packageInfo = this.packageInfoDtoBuilder.extract(author, packageId, packageVersion, info);
        Long id = (Long)this.packageInfoDao.save(packageInfo);
        return id != null;
    }
}

