/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.jscode;

import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.util.JsCodeType;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.jscode.JsCodeOptionsDto;
import com.suncode.plugin.pwe.web.support.form.JsCodeForm;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class JsCodeTemplateService {
    private static final String ENTER = System.getProperty("line.separator");
    private static final String TAB = "\t";
    public static final String TODO_TEXT = "// TODO";
    private static final String TEMPLATE_LOCATION_PREFIX = "/templates/js/";
    private static final String FUNCTION_NAME_TAG = "@BPMN_JS_FUNCTION_NAME_TAG@";
    private static final String PARAMETERS_TAG = "@BPMN_JS_FUNCTION_PARAMS_TAG@";
    @Autowired
    private PluginService pluginService;

    public String generateEmptySourceCode(JsCodeForm form) {
        StringBuilder sourceCode = new StringBuilder();
        sourceCode.append("function ");
        sourceCode.append(form.getFunctionName());
        sourceCode.append("(");
        sourceCode.append(this.appendParameters(form));
        sourceCode.append(")");
        sourceCode.append(" {");
        sourceCode.append(ENTER);
        sourceCode.append(TAB);
        sourceCode.append(TODO_TEXT);
        sourceCode.append(ENTER);
        sourceCode.append("}");
        return sourceCode.toString();
    }

    private String appendParameters(JsCodeForm form) {
        StringBuilder parameters = new StringBuilder();
        if (form.getOptions() != null && CollectionUtils.isNotEmpty(form.getOptions().getParameters())) {
            parameters.append(" ");
            parameters.append(StringUtils.join(form.getOptions().getParameters(), (String)", "));
            parameters.append(" ");
        }
        return parameters.toString();
    }

    public String generateSourceCode(JsCodeForm form) {
        JsCodeType jsCodeType = JsCodeType.getByName(form.getSourceCodeType());
        String location = this.buildTemplateLocation(jsCodeType, form.getTemplateId());
        String sourceCode = this.getSourceCode(location);
        return this.fillSourceCode(form, sourceCode);
    }

    private String buildTemplateLocation(JsCodeType jsCodeType, String templateId) {
        StringBuilder location = new StringBuilder();
        location.append(TEMPLATE_LOCATION_PREFIX);
        location.append(jsCodeType.getSubType());
        location.append("/");
        location.append(PweUtils.getLanguage());
        location.append("/");
        location.append(templateId);
        return location.toString();
    }

    private String getSourceCode(String location) {
        Resource resource = this.pluginService.getResource(location);
        return PweUtils.readResourceAsString(resource);
    }

    private String fillSourceCode(JsCodeForm form, String sourceCode) {
        String filledSourceCode = new String(sourceCode);
        filledSourceCode = this.setFunctionName(form.getFunctionName(), filledSourceCode);
        filledSourceCode = this.setParameters(form.getOptions(), filledSourceCode);
        return filledSourceCode;
    }

    private String setFunctionName(String functionName, String sourceCode) {
        return StringUtils.replace((String)sourceCode, (String)FUNCTION_NAME_TAG, (String)functionName);
    }

    private String setParameters(JsCodeOptionsDto options, String sourceCode) {
        if (options != null && CollectionUtils.isNotEmpty(options.getParameters())) {
            return StringUtils.replace((String)sourceCode, (String)PARAMETERS_TAG, (String)StringUtils.join(options.getParameters(), (String)", "));
        }
        return StringUtils.replace((String)sourceCode, (String)PARAMETERS_TAG, (String)"");
    }
}

