/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.javacode;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.javacode.JavaCodeDao;
import com.suncode.plugin.pwe.model.javacode.JavaCode;
import com.suncode.plugin.pwe.service.javacode.JavaCodeService;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.template.JavaCodeTemplateService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.PweClassLoader;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.StringJavaFileObject;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeCompilationDto;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeDto;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeValidationDto;
import com.suncode.plugin.pwe.web.support.dto.javacode.builder.JavaCodeCompilationDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.javacode.builder.JavaCodeDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.javacode.builder.JavaCodeValidationDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.JavaCodeForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipOutputStream;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Provides(value={JavaCodeService.class})
public class JavaCodeServiceImpl
implements JavaCodeService {
    public static Logger log = Logger.getLogger(JavaCodeServiceImpl.class);
    @Autowired
    private JavaCodeDao javaCodeDao;
    @Autowired
    private JavaCodeDtoBuilder javaCodeDtoBuilder;
    @Autowired
    private JavaCodeTemplateService javaCodeTemplateService;
    @Autowired
    private JavaCodeValidationDtoBuilder javaCodeValidationDtoBuilder;
    @Autowired
    private JavaCodeCompilationDtoBuilder javaCodeCompilationDtoBuilder;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ZipService zipService;

    @Override
    public JavaCodeDto get(String userId, JavaCodeForm form) {
        JavaCode javaCode = this.javaCodeDao.getByQualifiedName(form.getQualifiedName());
        if (javaCode != null) {
            return this.javaCodeDtoBuilder.build(javaCode);
        }
        String sourceCode = this.javaCodeTemplateService.generateEmptySourceCode(userId, form);
        return this.javaCodeDtoBuilder.build(userId, form.getQualifiedName(), sourceCode);
    }

    @Override
    public JavaCodeValidationDto validate(JavaCodeDto dto) {
        boolean canAddToClasspath = this.canAddToClasspath(dto);
        if (canAddToClasspath) {
            JavaCodeCompilationDto compilationResult = this.compileSourceCode(dto);
            return this.buildValidationResult(canAddToClasspath, compilationResult);
        }
        return this.buildValidationResult(canAddToClasspath);
    }

    private boolean canAddToClasspath(JavaCodeDto dto) {
        String qualifiedName = dto.getQualifiedName();
        return !PweUtils.doesClassExistInClasspath(qualifiedName) || this.javaCodeDao.getByQualifiedName(qualifiedName) != null;
    }

    private JavaCodeCompilationDto compileSourceCode(JavaCodeDto dto) {
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        Locale locale = LocaleContextHolder.getLocale();
        JavaCompiler.CompilationTask task = this.buildCompilationTask(dto, diagnosticCollector, locale);
        if (BooleanUtils.isTrue((Boolean)task.call())) {
            return this.buildCorrectCompilationResult();
        }
        return this.buildIncorrectCompilationResult(diagnosticCollector);
    }

    private JavaCodeValidationDto buildValidationResult(boolean canAddToClasspath, JavaCodeCompilationDto compilationResult) {
        return this.javaCodeValidationDtoBuilder.build(canAddToClasspath, compilationResult);
    }

    private JavaCodeValidationDto buildValidationResult(boolean canAddToClasspath) {
        return this.javaCodeValidationDtoBuilder.build(canAddToClasspath);
    }

    private JavaCodeCompilationDto buildCorrectCompilationResult() {
        return this.javaCodeCompilationDtoBuilder.build(true);
    }

    private JavaCodeCompilationDto buildIncorrectCompilationResult(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        return this.javaCodeCompilationDtoBuilder.build(false, diagnosticCollector.getDiagnostics());
    }

    private JavaCompiler.CompilationTask buildCompilationTask(JavaCodeDto dto, DiagnosticCollector<JavaFileObject> diagnosticCollector, Locale locale) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticCollector, locale, Charset.forName("UTF-8"));
        List<String> options = this.buildBaseCompilerOptions();
        StringJavaFileObject javaFileObject = new StringJavaFileObject(dto.getQualifiedName(), dto.getSourceCode());
        List<StringJavaFileObject> compilationUnits = Arrays.asList(javaFileObject);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticCollector, options, null, compilationUnits);
        task.setLocale(locale);
        return task;
    }

    private List<String> buildBaseCompilerOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(Arrays.asList("-classpath", this.buildClasspath()));
        return options;
    }

    private String buildClasspath() {
        StringBuilder classpath = new StringBuilder();
        URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Object[] urls = classLoader.getURLs();
        if (ArrayUtils.isNotEmpty((Object[])urls)) {
            for (Object url : urls) {
                classpath.append(this.buildClasspath((URL)url));
            }
        }
        return classpath.toString();
    }

    private String buildClasspath(URL url) {
        try {
            StringBuilder classpath = new StringBuilder();
            classpath.append(URLDecoder.decode(url.getFile(), "UTF-8"));
            classpath.append(File.pathSeparator);
            return classpath.toString();
        }
        catch (UnsupportedEncodingException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    @Override
    @Transactional
    public boolean set(JavaCodeDto dto) {
        JavaCode javaCode = this.javaCodeDao.getByQualifiedName(dto.getQualifiedName());
        if (javaCode != null) {
            javaCode.setSourceCode(dto.getSourceCode());
            this.javaCodeDao.update(javaCode);
            return true;
        }
        javaCode = this.javaCodeDtoBuilder.extract(dto);
        Long id = (Long)this.javaCodeDao.save(javaCode);
        return id != null;
    }

    @Override
    @Transactional
    public boolean set(String userId, JavaCodeDto dto) {
        JavaCode javaCode = this.javaCodeDao.getByQualifiedName(dto.getQualifiedName());
        if (javaCode != null) {
            javaCode.setSourceCode(dto.getSourceCode());
            this.javaCodeDao.update(javaCode);
            return true;
        }
        javaCode = this.javaCodeDtoBuilder.extract(userId, dto);
        Long id = (Long)this.javaCodeDao.save(javaCode);
        return id != null;
    }

    @Override
    @Transactional
    public boolean delete(String qualifiedName) {
        JavaCode javaCode = this.javaCodeDao.getByQualifiedName(qualifiedName);
        if (javaCode != null) {
            this.javaCodeDao.delete(javaCode);
            return true;
        }
        return false;
    }

    @Override
    public String getSourceCodeFromTemplate(String userId, JavaCodeForm form) {
        return this.javaCodeTemplateService.generateSourceCode(userId, form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generate(String userId, String javaClasses) {
        Date started = new Date();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)bufferedOutputStream, Charset.forName("UTF-8"));
        try {
            ArrayList<String> qualifiedNames = new ArrayList<String>();
            this.addToZip(zipOutputStream, userId, javaClasses, qualifiedNames);
            zipOutputStream.finish();
            zipOutputStream.flush();
            this.logGenerateSourceCodesAudit(userId, started, true, qualifiedNames);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logGenerateSourceCodesAudit(userId, started, false, new ArrayList<String>());
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
    }

    private void logGenerateSourceCodesAudit(String userId, Date started, boolean success, List<String> qualifiedNames) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.sourcecodes.param.qualifiednames", StringUtils.joinWith((String)", ", (Object[])new Object[]{qualifiedNames}));
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_SOURCE_CODES.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    public void addToZip(ZipOutputStream zipOutputStream, String userId, String javaClasses, List<String> qualifiedNames) throws IOException {
        ArrayList<JavaCodeDto> dtos = new ArrayList<JavaCodeDto>();
        List forms = (List)new Gson().fromJson(javaClasses, new TypeToken<List<JavaCodeForm>>(){}.getType());
        if (CollectionUtils.isNotEmpty((Collection)forms)) {
            HashMap<String, JavaCodeForm> classesMap = new HashMap<String, JavaCodeForm>();
            for (JavaCodeForm form : forms) {
                String qualifiedName = form.getQualifiedName();
                qualifiedNames.add(qualifiedName);
                classesMap.put(qualifiedName, form);
            }
            List<JavaCode> javaCodes = this.javaCodeDao.getAllByQualifiedName(qualifiedNames);
            for (JavaCode javaCode : javaCodes) {
                String qualifiedName = javaCode.getQualifiedName();
                classesMap.remove(qualifiedName);
                dtos.add(this.javaCodeDtoBuilder.build(javaCode));
            }
            for (String qualifiedName : classesMap.keySet()) {
                JavaCodeForm form = (JavaCodeForm)classesMap.get(qualifiedName);
                dtos.add(this.javaCodeDtoBuilder.build(userId, form.getQualifiedName(), this.javaCodeTemplateService.generateEmptySourceCode(userId, form)));
            }
        }
        this.zipService.addToZip(zipOutputStream, dtos);
    }

    @Override
    public void addToZip(ZipOutputStream zipOutputStream, String userId, String javaClasses) throws IOException {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        this.addToZip(zipOutputStream, userId, javaClasses, qualifiedNames);
    }

    @Override
    public void loadToSystem(String userId, String javaClasses) {
        Date started = new Date();
        ArrayList<String> loadedQualifiedNames = new ArrayList<String>();
        List forms = (List)new Gson().fromJson(javaClasses, new TypeToken<List<JavaCodeForm>>(){}.getType());
        if (CollectionUtils.isNotEmpty((Collection)forms)) {
            ArrayList<String> qualifiedNames = new ArrayList<String>();
            for (JavaCodeForm form : forms) {
                qualifiedNames.add(form.getQualifiedName());
            }
            List<JavaCode> javaCodes = this.javaCodeDao.getAllByQualifiedName(qualifiedNames);
            if (CollectionUtils.isNotEmpty(javaCodes)) {
                String classesRepositoryPath = this.getClassesRepositoryPath();
                List<String> options = this.buildBaseCompilerOptions();
                options.addAll(Arrays.asList("-d", classesRepositoryPath));
                for (JavaCode javaCode : javaCodes) {
                    if (!this.loadToSystem(classesRepositoryPath, options, javaCode)) {
                        log.warn((Object)("Nie udalo sie zaladowac do systemu klasy " + javaCode.getQualifiedName()));
                        continue;
                    }
                    loadedQualifiedNames.add(javaCode.getQualifiedName());
                }
            }
        }
        this.logSourceCodesLoadAudit(userId, started, loadedQualifiedNames);
    }

    private void logSourceCodesLoadAudit(String userId, Date started, List<String> qualifiedNames) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.sourcecodes.load.param.qualifiednames", StringUtils.joinWith((String)", ", (Object[])new Object[]{qualifiedNames}));
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_LOAD_SOURCE_CODES.getValue()).username(userId).success(!qualifiedNames.isEmpty()).params(params).started(started).stopped(new Date()).build().log();
    }

    private String getClassesRepositoryPath() {
        URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Object[] urls = classLoader.getURLs();
        if (ArrayUtils.isNotEmpty((Object[])urls)) {
            for (Object url : urls) {
                try {
                    String path = URLDecoder.decode(((URL)url).getPath(), "UTF-8");
                    File file = new File(path);
                    if (file.isDirectory()) {
                        return file.getAbsolutePath();
                    }
                }
                catch (UnsupportedEncodingException exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return "";
    }

    private boolean loadToSystem(String classesRepositoryPath, List<String> options, JavaCode javaCode) {
        String qualifiedName = javaCode.getQualifiedName();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StringJavaFileObject javaFileObject = new StringJavaFileObject(qualifiedName, javaCode.getSourceCode());
        List<StringJavaFileObject> compilationUnits = Arrays.asList(javaFileObject);
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, null, options, null, compilationUnits);
        if (BooleanUtils.isTrue((Boolean)task.call())) {
            this.loadJavaClass(classesRepositoryPath, qualifiedName);
            return true;
        }
        return false;
    }

    private boolean loadJavaClass(String classesRepositoryPath, String qualifiedName) {
        PweClassLoader classLoader = new PweClassLoader(this.pluginService.getClassLoader());
        Class<?> clazz = classLoader.loadClass(classesRepositoryPath, qualifiedName);
        return clazz != null;
    }
}

