/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.icon;

import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.web.support.dto.icon.IconDto;
import com.suncode.plugin.pwe.web.support.dto.icon.builder.IconDtoBuilder;
import com.suncode.pwfl.web.ui.DivanteIcon;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IconService {
    @Autowired
    private IconDtoBuilder iconDtoBuilder;

    public PageResult<IconDto> getSystemIcons(String query, int offset, int limit) {
        List<String> systemIcons = IconService.getFilteredSystemIcons(query);
        List<String> iconsOnPage = systemIcons.subList(offset, Math.min(systemIcons.size(), offset + limit));
        long total = systemIcons.size();
        return new PageResult<IconDto>(this.iconDtoBuilder.build(iconsOnPage), total);
    }

    private static List<String> getFilteredSystemIcons(String query) {
        boolean queryBlank = StringUtils.isBlank((CharSequence)query);
        return Stream.of(DivanteIcon.values()).map(DivanteIcon::getCode).sorted().filter(icon -> IconService.filterIcon(icon, query, queryBlank)).collect(Collectors.toList());
    }

    private static boolean filterIcon(String icon, String query, boolean queryBlank) {
        return queryBlank || icon.contains(query);
    }
}

