/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.globalconfig;

import com.plusmpm.util.CoreTools;
import com.suncode.plugin.pwe.web.support.dto.globalconfig.GlobalConfigDto;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GlobalConfigService {
    private static final String DECIMAL_SEPARATOR_SHARK_PROPERTY_NAME = "DecimalSeparator";
    private static final String DECIMAL_SEPARATOR_DEFAULT_VALUE = ",";
    private static final String ENABLE_DATA_CHOOSER_AUTO_MAPPING_SHARK_PROPERTY_NAME = "Form.DataChooser.AutoMapping.Enabled";
    private static final Boolean ENABLE_DATA_CHOOSER_AUTO_MAPPING_DEFAULT_VALUE = false;

    public GlobalConfigDto get(String userId) {
        GlobalConfigDto dto = new GlobalConfigDto();
        dto.setDecimalSeparator(this.getDecimalSeparator());
        dto.setEnableDataChooserAutoMapping(this.getEnableDataChooserAutoMapping());
        dto.setUserName(this.getUserName(userId));
        return dto;
    }

    private String getDecimalSeparator() {
        String sharkDecimalSeparator = SystemProperties.getString((String)DECIMAL_SEPARATOR_SHARK_PROPERTY_NAME);
        if (StringUtils.isNotBlank((CharSequence)sharkDecimalSeparator)) {
            return String.valueOf(sharkDecimalSeparator.charAt(0));
        }
        return DECIMAL_SEPARATOR_DEFAULT_VALUE;
    }

    private Boolean getEnableDataChooserAutoMapping() {
        return SystemProperties.getBoolean((String)ENABLE_DATA_CHOOSER_AUTO_MAPPING_SHARK_PROPERTY_NAME, (Boolean)ENABLE_DATA_CHOOSER_AUTO_MAPPING_DEFAULT_VALUE);
    }

    private String getUserName(String userId) {
        return CoreTools.GetRealUserName((String)userId);
    }
}

