/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formtemplate;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.framework.PluginStoreResource;
import com.suncode.plugin.pwe.divante.DivanteTransformer;
import com.suncode.plugin.pwe.service.plugin.PluginService;
import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.util.VariableSetConfig;
import com.suncode.plugin.pwe.util.VariableSetDefinition;
import com.suncode.plugin.pwe.util.exception.ReloadActivityFormException;
import com.suncode.plugin.pwe.web.support.dto.formtemplate.ActivityFormReloadDto;
import com.suncode.plugin.pwe.web.support.dto.formtemplate.builder.ActivityFormReloadDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.ActivityFormReloadForm;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Service
public class FormTemplateService {
    public static Logger log = Logger.getLogger(FormTemplateService.class);
    @Autowired
    private XmlService xmlService;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ZipService zipService;
    @Autowired
    private ActivityFormReloadDtoBuilder activityFormReloadDtoBuilder;
    @Autowired
    private DivanteTransformer divanteTransformer;

    public void save(String formTemplates, String additionalsFolderLocation) throws IOException, JSONException {
        JSONArray array = new JSONArray(formTemplates);
        if (array.length() > 0) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                this.save(additionalsFolderLocation, object);
            }
        }
    }

    private void save(String additionalsFolderLocation, JSONObject object) throws IOException, JSONException {
        JSONObject formTemplate = object.getJSONObject("Template");
        String formTemplateLocation = this.buildFormTemplateLocation(additionalsFolderLocation, object);
        String formTemplateContent = this.xmlService.getAsString(formTemplate, "", true);
        this.pluginService.save(formTemplateLocation, formTemplateContent);
    }

    private String buildFormTemplateLocation(String additionalsFolderLocation, JSONObject object) throws JSONException {
        StringBuilder location = new StringBuilder();
        location.append(additionalsFolderLocation);
        location.append("/");
        location.append(this.buildFormTemplateSublocation(object));
        return location.toString();
    }

    private String buildFormTemplateSublocation(JSONObject object) throws JSONException {
        StringBuilder sublocation = new StringBuilder();
        sublocation.append(object.getString("ProcessDefId"));
        sublocation.append("/");
        sublocation.append(object.getString("ActivityDefId"));
        sublocation.append(".xml");
        return sublocation.toString();
    }

    public void addToZip(ZipOutputStream zipOutputStream, String formTemplates) throws IOException, JSONException {
        JSONArray array = new JSONArray(formTemplates);
        if (array.length() > 0) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                JSONObject formTemplate = object.getJSONObject("Template");
                String fileName = this.buildFormTemplateSublocation(object);
                String content = this.xmlService.getAsString(formTemplate, "", true);
                this.zipService.addToZip(zipOutputStream, fileName, content.getBytes(Charset.forName("UTF-8")));
            }
        }
    }

    public void addToZip(ZipOutputStream zipOutputStream, List<File> formTemplates) throws IOException, JSONException {
        if (CollectionUtils.isNotEmpty(formTemplates)) {
            for (File formTemplate : formTemplates) {
                String content = FileUtils.readFileToString((File)formTemplate, (String)"UTF-8");
                String fileName = formTemplate.getParentFile().getName() + "/" + formTemplate.getName();
                this.zipService.addToZip(zipOutputStream, fileName, content.getBytes(Charset.forName("UTF-8")));
            }
        }
    }

    public void loadToSystem(String formTemplates, String additionalsFolderPath) throws IOException, JSONException {
        JSONArray array = new JSONArray(formTemplates);
        if (array.length() > 0) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                this.loadToSystem(additionalsFolderPath, object);
            }
        }
    }

    private void loadToSystem(String additionalsFolderPath, JSONObject object) throws IOException, JSONException {
        JSONObject formTemplate = object.getJSONObject("Template");
        String formTemplateLocation = this.buildFormTemplateLocation(additionalsFolderPath, object);
        String formTemplateContent = this.xmlService.getAsString(formTemplate, "", true);
        FileUtils.writeStringToFile((File)new File(formTemplateLocation), (String)formTemplateContent, (String)"UTF-8");
    }

    public ActivityFormReloadDto reloadActivityForm(ActivityFormReloadForm form) {
        try {
            Package pack = XpdlPackageManager.getInstance().getPackage(form.getPackageId());
            JSONObject formTemplate = new JSONObject(form.getFormTemplate());
            JSONObject activityDefinition = new JSONObject(form.getActivityDefinition());
            this.validateFormTemplateChanges(pack, formTemplate, activityDefinition);
            String additionalsFolderPath = this.buildAdditionalsFolderPath(pack.getId(), pack.getInternalVersion());
            this.loadToSystem(additionalsFolderPath, formTemplate);
            return this.buildActivityFormReloadSuccess();
        }
        catch (ReloadActivityFormException exception) {
            return this.buildActivityFormReloadError(exception.getMessage(), exception.getIncorrectVariableId());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return this.buildActivityFormReloadError("Wyst\u0105pi\u0142 b\u0142\u0105d podczas prze\u0142adowania formularza.");
        }
    }

    private void validateFormTemplateChanges(Package pack, JSONObject formTemplate, JSONObject activityDefinition) throws Exception {
        if (pack == null) {
            throw new ReloadActivityFormException("Zmieniono identyfikator pakietu.");
        }
        String processDefId = formTemplate.getString("ProcessDefId");
        WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefId);
        if (workflowProcess == null) {
            throw new ReloadActivityFormException("Zmieniono identyfikator definicji procesu.");
        }
        String activityDefId = formTemplate.getString("ActivityDefId");
        Activity activity = workflowProcess.getActivity(activityDefId);
        if (activity == null) {
            throw new ReloadActivityFormException("Zmieniono identyfikator definicji zadania.");
        }
        ArrayList xpdlExtAttrs = activity.getExtendedAttributes().toElements();
        Set<String> xpdlVariableIds = this.getActivityVariableIds(xpdlExtAttrs);
        Map<String, VariableSetDefinition> xpdlVariableSetDefinitions = this.getActivityVariableSetDefinitions(xpdlExtAttrs);
        Document activityDefinitionXml = this.getActivityDefinitionXml(activityDefinition);
        NodeList currentExtAttrs = activityDefinitionXml.getElementsByTagName("xpdl:ExtendedAttribute");
        if (currentExtAttrs != null && currentExtAttrs.getLength() > 0) {
            for (int i = 0; i < currentExtAttrs.getLength(); ++i) {
                Element currentExtAttr = (Element)currentExtAttrs.item(i);
                String extAttrName = currentExtAttr.getAttribute("Name");
                String extAttrValue = currentExtAttr.getAttribute("Value");
                if (this.isVariable(extAttrName)) {
                    String variableId = this.getVariableIdFromExtendedAttributeValue(extAttrValue);
                    this.validateVariable(variableId, xpdlVariableIds);
                    continue;
                }
                if (!this.isVariableSet(extAttrName)) continue;
                VariableSetDefinition variableSetDefinition = this.getActivityVariableSetDefinition(extAttrValue);
                this.validateVariableSet(variableSetDefinition, xpdlVariableSetDefinitions);
            }
        }
        if (!xpdlVariableIds.isEmpty()) {
            throw new ReloadActivityFormException("Usuni\u0119to zmienn\u0105 z formularza.", xpdlVariableIds.iterator().next());
        }
        if (!xpdlVariableSetDefinitions.isEmpty()) {
            throw new ReloadActivityFormException("Usuni\u0119to tabel\u0119 dynamiczn\u0105 z formularza.");
        }
    }

    private Set<String> getActivityVariableIds(List<ExtendedAttribute> extAttrs) {
        HashSet<String> variableIds = new HashSet<String>();
        for (ExtendedAttribute extAttr : extAttrs) {
            String extAttrName = extAttr.getName();
            if (!this.isVariable(extAttrName)) continue;
            String extAttrValue = extAttr.getVValue();
            String variableId = this.getVariableIdFromExtendedAttributeValue(extAttrValue);
            variableIds.add(variableId);
        }
        return variableIds;
    }

    private String getVariableIdFromExtendedAttributeValue(String extAttrValue) {
        String[] extAttrSplit = extAttrValue.split("\n");
        return extAttrSplit[0];
    }

    private boolean isVariable(String extAttrName) {
        return StringUtils.equals((CharSequence)extAttrName, (CharSequence)"VariableToProcess_VIEW") || StringUtils.equals((CharSequence)extAttrName, (CharSequence)"VariableToProcess_UPDATE") || StringUtils.equals((CharSequence)extAttrName, (CharSequence)"VariableToProcess_HIDDEN");
    }

    private Map<String, VariableSetDefinition> getActivityVariableSetDefinitions(List<ExtendedAttribute> extAttrs) {
        HashMap<String, VariableSetDefinition> definitions = new HashMap<String, VariableSetDefinition>();
        for (ExtendedAttribute extAttr : extAttrs) {
            String extAttrName = extAttr.getName();
            if (!this.isVariableSet(extAttrName)) continue;
            String extAttrValue = extAttr.getVValue();
            VariableSetDefinition definition = this.getActivityVariableSetDefinition(extAttrValue);
            definitions.put(definition.getId(), definition);
        }
        return definitions;
    }

    private VariableSetDefinition getActivityVariableSetDefinition(String extAttrValue) {
        VariableSetDefinition definition = new VariableSetDefinition();
        HashSet<String> columnIds = new HashSet<String>();
        block4: for (String oneExtAttr : extAttrValue.split("\n")) {
            String[] oneExtAttrSplit = oneExtAttr.split("=", 2);
            String oneExtAttrName = oneExtAttrSplit[0];
            switch (VariableSetConfig.getByName(oneExtAttrName)) {
                case DT_TABLE_ID: {
                    definition.setId(oneExtAttrSplit[1]);
                    continue block4;
                }
                case COLUMN: {
                    columnIds.add(oneExtAttrName);
                    continue block4;
                }
            }
        }
        definition.setColumnIds(columnIds);
        return definition;
    }

    private boolean isVariableSet(String extAttrName) {
        return StringUtils.equals((CharSequence)extAttrName, (CharSequence)"VARIABLE_SET") || StringUtils.equals((CharSequence)extAttrName, (CharSequence)"VARIABLE_SET_VIEW");
    }

    private Document getActivityDefinitionXml(JSONObject activityDefinition) throws Exception {
        return this.xmlService.write(activityDefinition, "xpdl");
    }

    private void validateVariable(String variableId, Set<String> xpdlVariableIds) throws ReloadActivityFormException {
        this.validateVariablePresence(variableId, xpdlVariableIds, "Dodano now\u0105 zmienn\u0105 do formularza.");
    }

    private void validateVariablePresence(String variableId, Set<String> variableIds, String errorMessage) throws ReloadActivityFormException {
        if (!variableIds.contains(variableId)) {
            throw new ReloadActivityFormException(errorMessage, variableId);
        }
        variableIds.remove(variableId);
    }

    private void validateVariableSet(VariableSetDefinition variableSetDefinition, Map<String, VariableSetDefinition> xpdlVariableSetDefinitions) throws ReloadActivityFormException {
        String variableSetId = variableSetDefinition.getId();
        if (xpdlVariableSetDefinitions.containsKey(variableSetId)) {
            VariableSetDefinition xpdlDefinition = xpdlVariableSetDefinitions.remove(variableSetId);
            Set<String> xpdlColumnIds = xpdlDefinition.getColumnIds();
            for (String columnId : variableSetDefinition.getColumnIds()) {
                this.validateVariablePresence(columnId, xpdlColumnIds, "Dodano now\u0105 kolumn\u0119 do tabeli dynamicznej.");
            }
            if (!xpdlColumnIds.isEmpty()) {
                throw new ReloadActivityFormException("Usuni\u0119to kolumn\u0119 z tabeli dynamicznej.", xpdlColumnIds.iterator().next());
            }
        } else {
            throw new ReloadActivityFormException("Dodano now\u0105 tabel\u0119 dynamiczn\u0105 do formularza.");
        }
    }

    private String buildAdditionalsFolderPath(String packageId, String packageVersion) {
        StringBuilder path = new StringBuilder();
        path.append(XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH);
        path.append(File.separator);
        path.append(packageId);
        path.append(File.separator);
        path.append("v");
        path.append(packageVersion);
        return path.toString();
    }

    private ActivityFormReloadDto buildActivityFormReloadSuccess() {
        return this.activityFormReloadDtoBuilder.buildSuccess();
    }

    private ActivityFormReloadDto buildActivityFormReloadError(String errorMessage) {
        return this.activityFormReloadDtoBuilder.buildError(errorMessage);
    }

    private ActivityFormReloadDto buildActivityFormReloadError(String errorMessage, String incorrectVariableId) {
        return this.activityFormReloadDtoBuilder.buildError(errorMessage, incorrectVariableId);
    }

    public JSONObject openFromDisc(byte[] bytes) throws SAXException, IOException {
        return this.transform(this.xmlService.read(bytes));
    }

    public JSONArray openFromSystem(String additionalsFolderPath) throws SAXException, IOException {
        JSONArray formTemplates = new JSONArray();
        List<File> files = this.getFormTemplatesInFolder(additionalsFolderPath);
        if (CollectionUtils.isNotEmpty(files)) {
            for (File file : files) {
                formTemplates.put((Object)this.transform(this.xmlService.read(file.getAbsolutePath())));
            }
        }
        return formTemplates;
    }

    public List<File> getFormTemplates(String packageId, String packageVersion) {
        String additionalsFolderPath = this.buildAdditionalsFolderPath(packageId, packageVersion);
        return this.getFormTemplatesInFolder(additionalsFolderPath);
    }

    private List<File> getFormTemplatesInFolder(String additionalsFolderPath) {
        File directory = new File(additionalsFolderPath);
        if (directory.exists()) {
            IOFileFilter fileFilter = this.buildFormTemplatesFilter();
            return (List)FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE);
        }
        return new ArrayList<File>();
    }

    private IOFileFilter buildFormTemplatesFilter() {
        return FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.FILE, new SuffixFileFilter("xml", IOCase.INSENSITIVE)});
    }

    public List<File> getFormTemplatesFromStored(String additionalsLocationPrefix) {
        return this.getResourcesFromLocation(additionalsLocationPrefix).stream().map(PluginStoreResource::getAbsolutePath).map(File::new).collect(Collectors.toList());
    }

    public JSONArray openFromSaved(String additionalsLocationPrefix) throws SAXException, IOException {
        JSONArray formTemplates = new JSONArray();
        List<PluginStoreResource> resources = this.getResourcesFromLocation(additionalsLocationPrefix);
        for (PluginStoreResource resource : resources) {
            formTemplates.put((Object)this.transform(this.xmlService.read(resource.getInputStream())));
        }
        return formTemplates;
    }

    private List<PluginStoreResource> getResourcesFromLocation(String additionalsLocationPrefix) {
        ArrayList<PluginStoreResource> resources = new ArrayList<PluginStoreResource>();
        Map<String, PluginStoreResource> xpdls = this.pluginService.getSavedResources();
        if (MapUtils.isNotEmpty(xpdls)) {
            Pattern pattern = this.buildSavedFormTemplatesLocationPattern(additionalsLocationPrefix);
            for (String location : xpdls.keySet()) {
                if (!this.doesSavedFormTemplateMatchPattern(pattern, location)) continue;
                PluginStoreResource formTemplate = xpdls.get(location);
                resources.add(formTemplate);
            }
        }
        return resources;
    }

    private Pattern buildSavedFormTemplatesLocationPattern(String additionalsLocationPrefix) {
        StringBuilder regex = new StringBuilder();
        regex.append(PweUtils.buildSafePatternValue(additionalsLocationPrefix));
        regex.append("/.*[.]xml");
        return Pattern.compile(regex.toString());
    }

    private boolean doesSavedFormTemplateMatchPattern(Pattern pattern, String location) {
        Matcher matcher = pattern.matcher(location);
        return matcher.matches();
    }

    private JSONObject transform(JSONObject formTemplate) {
        return this.divanteTransformer.transformFormTemplate(formTemplate);
    }
}

