/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formpreview;

import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.exception.FormPreviewPreparationException;
import com.suncode.plugin.pwe.web.support.dto.formpreview.FormPreviewDto;
import com.suncode.plugin.pwe.web.support.dto.formpreview.builder.FormPreviewDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.FormPreviewForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.LzStringUtils;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormPreviewService {
    public static Logger log = Logger.getLogger(FormPreviewService.class);
    @Autowired
    private XmlService xmlService;
    @Autowired
    private FormPreviewDtoBuilder formPreviewDtoBuilder;

    public FormPreviewDto prepare(String userId, FormPreviewForm form) {
        Date started = new Date();
        try {
            String xpdl = LzStringUtils.decompressFromBase64((String)form.getXpdl());
            String preparedXpdl = this.xmlService.getAsString(xpdl, "xpdl", false);
            String preparedFormTemplate = this.prepareFormTemplate(form);
            FormPreviewDto formPreview = this.formPreviewDtoBuilder.build(preparedXpdl, preparedFormTemplate);
            this.logDisplayFormPreviewAudit(userId, started, true, form.getPackageId(), form.getProcessDefId(), form.getActivityDefId());
            return formPreview;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.logDisplayFormPreviewAudit(userId, started, false, form.getPackageId(), form.getProcessDefId(), form.getActivityDefId());
            throw new FormPreviewPreparationException(exception);
        }
    }

    private String prepareFormTemplate(FormPreviewForm form) throws Exception {
        String formTemplateString = LzStringUtils.decompressFromBase64((String)form.getFormTemplate());
        JSONObject object = new JSONObject(formTemplateString);
        JSONObject formTemplate = object.getJSONObject("Template");
        return this.xmlService.getAsString(formTemplate, "", false);
    }

    private void logDisplayFormPreviewAudit(String userId, Date started, boolean success, String packageId, String processDefId, String activityDefId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.formpreview.display.param.packageid", packageId);
        params.put("pwe.audit.formpreview.display.param.processdefid", processDefId);
        params.put("pwe.audit.formpreview.display.param.activitydefid", activityDefId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_DISPLAY_FORM_PREVIEW.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }
}

