/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formpreview;

import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.FormPreviewDataSet;
import com.suncode.plugin.pwe.util.FormPreviewProcessDataSets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
public class FormPreviewProcessDataSetsUnmarshaller {
    @Autowired
    private XmlService xmlService;

    public FormPreviewProcessDataSets unmarshall(InputStream inputStream) throws Exception {
        Document document = this.xmlService.get(inputStream);
        Element root = document.getDocumentElement();
        FormPreviewProcessDataSets formPreviewProcessDataSets = new FormPreviewProcessDataSets();
        formPreviewProcessDataSets.setId(this.xmlService.getElementAttributeText(root, "id"));
        formPreviewProcessDataSets.setDataSets(this.unmarshallDataSets(root));
        return formPreviewProcessDataSets;
    }

    private List<FormPreviewDataSet> unmarshallDataSets(Element element) throws XPathExpressionException {
        ArrayList<FormPreviewDataSet> dataSets = new ArrayList<FormPreviewDataSet>();
        NodeList dataSetsList = this.xmlService.getNodeList(element, "DataSets/DataSet");
        for (Element dataSetElement : this.xmlService.convertToElementsList(dataSetsList)) {
            dataSets.add(this.unmarshallDataSet(dataSetElement));
        }
        return dataSets;
    }

    private FormPreviewDataSet unmarshallDataSet(Element element) throws XPathExpressionException {
        FormPreviewDataSet dataSet = new FormPreviewDataSet();
        dataSet.setName(this.xmlService.getElementText(element, "Name"));
        dataSet.setDescription(this.xmlService.getElementText(element, "Description"));
        dataSet.setIsDefault(this.xmlService.getElementLogical(element, "IsDefault"));
        dataSet.setVariablesValues(this.unmarshallVariablesValues(element));
        return dataSet;
    }

    private Map<String, String> unmarshallVariablesValues(Element element) throws XPathExpressionException {
        HashMap<String, String> variablesValues = new HashMap<String, String>();
        NodeList variablesValuesList = this.xmlService.getNodeList(element, "VariablesValues/VariableValue");
        for (Element variableValueElement : this.xmlService.convertToElementsList(variablesValuesList)) {
            String id = this.xmlService.getElementAttributeText(variableValueElement, "id");
            String value = this.xmlService.getElementText(variableValueElement, "Value");
            variablesValues.put(id, value);
        }
        return variablesValues;
    }
}

