/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.formpreview;

import com.suncode.plugin.pwe.service.xml.XmlService;
import com.suncode.plugin.pwe.util.FormPreviewDataSet;
import com.suncode.plugin.pwe.util.FormPreviewProcessDataSets;
import com.suncode.plugin.pwe.util.XmlAttribute;
import java.io.OutputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class FormPreviewProcessDataSetsMarshaller {
    @Autowired
    private XmlService xmlService;

    public void marshall(OutputStream outputStream, FormPreviewProcessDataSets formPreviewProcessDataSets) throws Exception {
        Document document = this.xmlService.create();
        Element root = FormPreviewProcessDataSetsMarshaller.marshallRoot(document);
        document.appendChild(root);
        this.xmlService.setElementAttribute(root, new XmlAttribute("id", formPreviewProcessDataSets.getId()));
        Element dataSetsElement = this.marshallDataSets(document, formPreviewProcessDataSets.getDataSets());
        root.appendChild(dataSetsElement);
        this.xmlService.writeToOutputStream(outputStream, document);
    }

    private static Element marshallRoot(Document document) {
        return document.createElement("ProcessDataSets");
    }

    private Element marshallDataSets(Document document, List<FormPreviewDataSet> dataSets) {
        Element element = document.createElement("DataSets");
        dataSets.stream().forEach(dataSet -> {
            Element dataSetElement = this.marshallDataSet(document, (FormPreviewDataSet)dataSet);
            element.appendChild(dataSetElement);
        });
        return element;
    }

    private Element marshallDataSet(Document document, FormPreviewDataSet dataSet) {
        Element element = document.createElement("DataSet");
        this.xmlService.appendTextElement(document, element, "Name", dataSet.getName());
        this.xmlService.appendTextElement(document, element, "Description", dataSet.getDescription());
        this.xmlService.appendTextElement(document, element, "IsDefault", dataSet.getIsDefault());
        Element variablesValuesElement = document.createElement("VariablesValues");
        dataSet.getVariablesValues().entrySet().stream().forEach(entry -> {
            Element variableValueElement = this.marshallVariableValue(document, (String)entry.getKey(), (String)entry.getValue());
            variablesValuesElement.appendChild(variableValueElement);
        });
        element.appendChild(variablesValuesElement);
        return element;
    }

    private Element marshallVariableValue(Document document, String id, String value) {
        Element element = document.createElement("VariableValue");
        this.xmlService.setElementAttribute(element, new XmlAttribute("id", id));
        this.xmlService.appendTextElement(document, element, "Value", value);
        return element;
    }
}

