/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.documentationconfig;

import com.suncode.plugin.pwe.dao.documentationconfig.DocumentationConfigDao;
import com.suncode.plugin.pwe.model.documentationconfig.DocumentationConfig;
import com.suncode.plugin.pwe.util.DocumentationType;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.SetDocumentationConfigDto;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.builder.DocumentationConfigDtoBuilder;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocumentationConfigService {
    @Autowired
    private DocumentationConfigDao documentationConfigDao;
    @Autowired
    private DocumentationConfigDtoBuilder documentationConfigDtoBuilder;

    public DocumentationConfigDto getDefaultForUser(String userId) {
        DocumentationConfig config = this.documentationConfigDao.getDefaultForUser(userId);
        if (config != null) {
            return this.documentationConfigDtoBuilder.build(config);
        }
        return DocumentationConfigService.buildDefaultBusinessConfig();
    }

    public DocumentationConfigDto getForUser(String userId, String type) {
        DocumentationConfig config = this.documentationConfigDao.getForUser(userId, type);
        if (config != null) {
            return this.documentationConfigDtoBuilder.build(config);
        }
        switch (DocumentationType.getByName(type)) {
            case TECHNICAL: {
                return DocumentationConfigService.buildDefaultTechnicalConfig();
            }
        }
        return DocumentationConfigService.buildDefaultBusinessConfig();
    }

    public SetDocumentationConfigDto setForUser(String userId, DocumentationConfigDto dto) {
        List<DocumentationConfig> configs = this.documentationConfigDao.getAllForUser(userId);
        configs.forEach(this::unsetAsDefault);
        Optional<DocumentationConfig> configForType = configs.stream().filter(config -> StringUtils.equals((CharSequence)config.getDocumentationType(), (CharSequence)dto.getDocumentationType())).findFirst();
        if (configForType.isPresent()) {
            DocumentationConfig config2 = configForType.get();
            config2.setIsDefault(true);
            config2.setSystemLink(BooleanUtils.isTrue((Boolean)dto.getSystemLink()));
            config2.setRolesList(BooleanUtils.isTrue((Boolean)dto.getRolesList()));
            config2.setShowManualTasks(BooleanUtils.isTrue((Boolean)dto.getShowManualTasks()));
            config2.setShowSystemTasks(BooleanUtils.isTrue((Boolean)dto.getShowSystemTasks()));
            config2.setShowRoutes(BooleanUtils.isTrue((Boolean)dto.getShowRoutes()));
            config2.setScheduledTasks(BooleanUtils.isTrue((Boolean)dto.getScheduledTasks()));
            config2.setDatabaseTables(BooleanUtils.isTrue((Boolean)dto.getDatabaseTables()));
            config2.setIntegrations(BooleanUtils.isTrue((Boolean)dto.getIntegrations()));
            config2.setProjectExclusions(BooleanUtils.isTrue((Boolean)dto.getProjectExclusions()));
            config2.setAttachments(BooleanUtils.isTrue((Boolean)dto.getAttachments()));
            this.documentationConfigDao.update(config2);
            return DocumentationConfigService.buildSetDocumentationConfig(true);
        }
        DocumentationConfig config3 = this.documentationConfigDtoBuilder.extract(userId, dto);
        config3.setIsDefault(true);
        Long id = (Long)this.documentationConfigDao.save(config3);
        return DocumentationConfigService.buildSetDocumentationConfig(id != null);
    }

    private static SetDocumentationConfigDto buildSetDocumentationConfig(boolean success) {
        SetDocumentationConfigDto dto = new SetDocumentationConfigDto();
        dto.setSuccess(success);
        return dto;
    }

    private static DocumentationConfigDto buildDefaultBusinessConfig() {
        DocumentationConfigDto dto = new DocumentationConfigDto();
        dto.setDocumentationType(DocumentationType.BUSINESS.getName());
        dto.setSystemLink(false);
        dto.setRolesList(true);
        dto.setShowManualTasks(true);
        dto.setShowSystemTasks(true);
        dto.setShowRoutes(false);
        dto.setScheduledTasks(false);
        dto.setDatabaseTables(false);
        dto.setIntegrations(true);
        dto.setProjectExclusions(false);
        dto.setAttachments(false);
        return dto;
    }

    private static DocumentationConfigDto buildDefaultTechnicalConfig() {
        DocumentationConfigDto dto = new DocumentationConfigDto();
        dto.setDocumentationType(DocumentationType.TECHNICAL.getName());
        dto.setSystemLink(true);
        dto.setRolesList(true);
        dto.setShowManualTasks(true);
        dto.setShowSystemTasks(true);
        dto.setShowRoutes(true);
        dto.setScheduledTasks(true);
        dto.setDatabaseTables(true);
        dto.setIntegrations(true);
        dto.setProjectExclusions(true);
        dto.setAttachments(true);
        return dto;
    }

    private void unsetAsDefault(DocumentationConfig config) {
        config.setIsDefault(false);
        this.documentationConfigDao.update(config);
    }
}

