/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.reader.excel;

import com.suncode.plugin.pwe.util.CellData;
import com.suncode.plugin.pwe.util.FileData;
import com.suncode.plugin.pwe.util.RowData;
import com.suncode.plugin.pwe.util.exception.WrongFileFormatException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Component;

@Component
public class ExcelReader {
    public FileData read(InputStream inputStream) throws Exception {
        Workbook workbook = this.createWorkbook(inputStream);
        Iterator<Row> rows = this.getRows(workbook);
        if (rows.hasNext()) {
            Row header = rows.next();
            short noOfCells = header.getLastCellNum();
            return new FileData(this.readRow(header, noOfCells), this.readRows(rows, noOfCells));
        }
        return FileData.empty();
    }

    private Workbook createWorkbook(InputStream inputStream) throws Exception {
        BufferedInputStream wrappedStream = new BufferedInputStream(inputStream);
        return WorkbookFactory.create((InputStream)wrappedStream);
    }

    private Iterator<Row> getRows(Workbook workbook) throws WrongFileFormatException {
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null) {
            return sheet.rowIterator();
        }
        throw new WrongFileFormatException();
    }

    private RowData readRow(Row row, int noOfCells) {
        ArrayList<CellData> cellsData = new ArrayList<CellData>();
        IntStream.range(0, noOfCells).mapToObj(i -> this.getCellValue(row, i)).map(CellData::new).forEach(cellsData::add);
        return new RowData(cellsData);
    }

    private String getCellValue(Row row, int cellNum) {
        return Optional.ofNullable(row.getCell(cellNum)).map(c -> c.getStringCellValue()).orElse("");
    }

    private List<RowData> readRows(Iterator<Row> rows, int noOfCells) {
        ArrayList<RowData> rowsData = new ArrayList<RowData>();
        while (rows.hasNext()) {
            Row row = rows.next();
            rowsData.add(this.readRow(row, noOfCells));
        }
        return rowsData;
    }
}

